<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use App\Models\Auth\UserNotification;
use App\Models\Auth\Reminders;
use App\Mail\MailSend;
use App\Recipients\AdminRecipient;
use App\Notifications\Frontend\AdminAlert;
use Illuminate\Support\Facades\Mail;
use Log;

/**
 * Send a email notification to the concerned staff with leads to followup in next 1 hour
 * This job to execute at 55th minute hourly.
 */

class ApplicationActivityReminder extends Command
{

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'ApplicationActivityReminder';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'application activity reminder';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $subject = "Application Activity Reminder";

        echo "\n" . date('Y-m-d H:i:s') . ": ApplicationActivityReminder: start";
        
        $today = date('Y-m-d');
        $plus_2d = date("Y-m-d", strtotime("2 days"));
        $plus_1d = date("Y-m-d", strtotime("1 days"));
        echo "\n" . $today . ": Find Applications with activity reminders";
        $app_reminders = Reminders::where("deadline", '=', $plus_2d)
            ->orwhere("deadline", '=', $plus_1d)
            ->get();

        $reminderData = array();
        foreach($app_reminders as $reminders){
            if($reminders->entity == "university_application"){
                $reminderData[] = Reminders::join('university_application', 'university_application.id', '=', 'reminders.entity_id')
                ->join('users', 'users.id', '=', 'university_application.userid')
                // ->whereIn('assign_to', $this->related_reporting_ids)  
                ->where('reminders.id', $reminders->id)
                ->where('reminders.done', 0)
                ->first(['university_application.appl_id','university_application.id','university_application.assign_to','users.gender','users.first_name','users.last_name','reminders.deadline','reminders.activity','reminders.entity']);
            }
            if($reminders->entity == "service_application"){
                $reminderData[] = Reminders::join('service_applications', 'service_applications.id', '=', 'reminders.entity_id')
                    ->join('users', 'users.id', '=', 'service_applications.user_id')
                //  ->whereIn('service_applications.assigned_to', $this->related_reporting_ids)  
                    ->where('reminders.id', $reminders->id)
                    ->where('reminders.done', 0)
                    ->first(['service_applications.appl_id','service_applications.id','service_applications.assigned_to as assign_to','users.gender','users.first_name','users.last_name','reminders.deadline','reminders.activity','reminders.entity']);
                }
        }

        if (count($reminderData)) {
            foreach ($reminderData as $app) {
                if(!empty($app)){
                echo "\n" . date('Y-m-d H:i:s') . ": Application: #" . $app->id. " Assigned-to:" . $app->assign_to;
                //Email Subject: Application Activity Reminder

                //Application Activity Reminder: #appl_id Due Date: $due_date
                //Activity message
                if($app->deadline){
                    $deadline = date('d-m-Y',strtotime($app->deadline));
                }else{
                    $deadline = "--";
                }
                $app_type = "";
                if($app->entity == "university_application"){
                    $message = "University Application Activity Reminder: Application #".$app->appl_id."<br> Due Date: ".$deadline."<br>Activity: ".$app->activity;
                    $app_type = "university";
                }else{
                    $message = "Visa Application Activity Reminder: Application #".$app->appl_id."<br> Due Date: ".$deadline."<br>Activity: ".$app->activity;
                    $app_type = "visa";
                }
                
                if ($app->assign_to) {
                    $noti = new UserNotification;
                    $noti->user_id = $app->assign_to;
                    $noti->application_id = $app->id;
                    $noti->application_type = $app_type;
                    $noti->message = $message;
                    $noti->from_user = 1;
                    $noti->save();

                    $staff_mail = get_user_email_by_id($app->assign_to);
                    echo "\n In-App notification saved! Message: ".$app_type." Application Activity Reminder email sent to: " . $staff_mail." Message:".$message;

                    try {
                        //Mail::to($staff_mail)->send(new MailSend($subject, $message));
                        user_notify($staff_mail,$subject, $message);
                        echo "\n" . date('Y-m-d H:i:s').": ".$app_type." Application Activity Reminder email sent to: " . $staff_mail." Message:".$message;
                    } catch (\Exception $e) {
                        $err_message = $e->getMessage();
                        //\Log::debug("Mail Error: (Application Activity Reminder email) ".$err_message);   
                        echo "\n" . "Mail Error: Staff- (".$app_type." Application Activity Reminder email) ".$err_message;
                    }

                    if($app->assign_to !=1){
                        $recipient = new AdminRecipient();
                        try {
                            //$recipient->notify(new AdminAlert($subject, $message));
                            user_notify($recipient, $subject, $message);
                            echo "\n" . date('Y-m-d H:i:s').": ".$app_type." Application Activity Reminder email sent to Admin for: " . $staff_mail." Message:".$message;
                        } catch (\Exception $e) {
                            $message = $e->getMessage();
                            //\Log::debug("Mail Error: Admin- ($subject) " . $message);
                            echo "\n" . "Mail Error: Admin- ($subject) " . $message; 
                        }
                    }
                }
            }
        }
        } else {
            echo "\n" . date('Y-m-d H:i:s') . ": No Applications with activity reminders found!";
        }
        echo "\n" . date('Y-m-d H:i:s') . ": ApplicationActivityReminder: end";
    }
}
