<?php

// This file is not used

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Auth\User;
use Illuminate\Support\Facades\DB;
use App\Notifications\Backend\UserAlert;
use App\Models\MailTemplates;
use App\Models\Auth\UserNotification;
use App\Models\Auth\ReferralReward;
use App\Mail\MailSend;
use App\Recipients\AdminRecipient;
use App\Notifications\Frontend\AdminAlert;
use Illuminate\Support\Facades\Mail;
use Log;

/**
 * Send a email notification to the concerned staff with leads to followup in next 1 hour
 * This job to execute at 55th minute hourly.
 */

class ApplicationTaskNotification extends Command
{

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'ApplicationTaskNotification';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'application task notification';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $subject = "Application Task Reminder";

        echo "\n" . date('Y-m-d H:i:s') . ": ApplicationTaskNotification: start";
        
        $today = date('Y-m-d');
        $minus_2d = date("Y-m-d", strtotime("-2 days"));
        $minus_1d = date("Y-m-d", strtotime("-1 days"));

        echo "\n" . $today . ": Find Applications with task";
        $applications = DB::table('university_application')
        ->where("deadline", '>', $minus_2d)
        ->orwhere("deadline", '>', $minus_1d)
        ->get();
        if (count($applications)) {
            $to_notify = array();
            foreach ($applications as $app) {
                echo "\n" . date('Y-m-d H:i:s') . ": Application: #" . $app->id. " Assigned-to:" . $app->assign_to;
                //Email Subject: Application Task Reminder

                //Application Task Reminder: #appl_id Due Date: $due_date
                //Task message
                if($app->deadline){
                    $deadline = date('d-m-Y',strtotime($app->deadline));
                }else{
                    $deadline = "--";
                }
                $message = "Application Task Reminder: Application #".$app->appl_id."<br> Due Date: ".$deadline."<br>Task: ".$app->task;

                if ($app->assign_to) {

                    $noti = new UserNotification;
                    $noti->user_id = $app->assign_to;
                    $noti->application_id = $app->id;
                    $noti->application_type = 'university';
                    $noti->message = $message;
                    $noti->from_user = 1;
                    $noti->save();

                    $staff_mail = get_user_email_by_id($app->assign_to);
                    echo "\n In-App notification saved! Message: Application Task Reminder email sent to: " . $staff_mail." Message:".$message;

                    try {
                        //Mail::to($staff_mail)->send(new MailSend($subject, $message));
                        user_notify($staff_mail,$subject, $message);
                        echo "\n" . date('Y-m-d H:i:s').": Application Task Reminder email sent to: " . $staff_mail." Message:".$message;
                    } catch (\Exception $e) {
                        $err_message = $e->getMessage();
                        //\Log::debug("Mail Error: (Application Task Reminder email) ".$err_message);   
                        echo "\n" . "Mail Error: Staff- (Application Task Reminder email) ".$err_message;
                    }

                    if($app->assign_to !=1){
                        $recipient = new AdminRecipient();
                        try {
                            //$recipient->notify(new AdminAlert($subject, $message));
                            user_notify($recipient, $subject, $message);
                            echo "\n" . date('Y-m-d H:i:s').": Application Task Reminder email sent to Admin for: " . $staff_mail." Message:".$message;
                        } catch (\Exception $e) {
                            $message = $e->getMessage();
                            //\Log::debug("Mail Error: Admin- ($subject) " . $message);
                            echo "\n" . "Mail Error: Admin- ($subject) " . $message; 
                        }
                    }
                }
            }

        } else {
            echo "\n" . date('Y-m-d H:i:s') . ": No Application Task found!";
        }
        echo "\n" . date('Y-m-d H:i:s') . ": ApplicationTaskNotification: end";
    }
}
