<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Auth\User;
use Illuminate\Support\Facades\DB;
use App\Notifications\Backend\UserAlert;
use App\Models\MailTemplates;
use App\Mail\MailSend;
use Illuminate\Support\Facades\Mail;
use App\Jobs\EmailJob;
use App\Models\UserActivity;
use App\Mail\BroadcastMailSend;
use Log;
use Illuminate\Support\Carbon;
use Spatie\Activitylog\Models\Activity;

class AutomationCampaign extends Command
{

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'AutomationCampaign';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Automation Campaign';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // echo "\n-------------" . date('Y-m-d H:i:s') . ": Automation Campaign Cron Start -------------";
        $currentdatetime = date('Y-m-d H:i');
        // echo "\nCurrent Date Time: " . $currentdatetime;

        $data = DB::table('automation_campaign')->where('status', "queued")
            ->where('run_at', $currentdatetime)
            ->get();
        if (count($data)) {
            echo "\nCampaign Found!";
            foreach ($data as $campaign) {

                //echo "\n".$campaign->title;
                //\DB::enableQueryLog();


                if ($campaign->target == "leads") {

                    if ($campaign->lead_status) {
                        $statusArray = explode(',', $campaign->lead_status);
                    } else {
                        $statusArray = "";
                    }
                    if ($campaign->lead_filters != "") {
                        $filter_vals = json_decode($campaign->lead_filters);
                    } else {
                        $filter_vals = "";
                    }
                    //if filter_condition
                    if ($campaign->filter_condition) {
                        $filter_condition = $campaign->filter_condition;
                    } else {
                        $filter_condition = "";
                    }
                    $audience = User::where('is_lead', '1')
                        ->join('user_details', 'user_details.userid', 'users.id')
                        ->when(!empty($statusArray) && count($statusArray), function ($query) use ($statusArray) {
                            return $query->WhereIn('lead_status', $statusArray);
                        })
                        ->when(!empty($filter_vals), function ($query) use ($filter_vals, $filter_condition) {
                            return $query->Where(function ($query) use ($filter_vals, $filter_condition) {
                                foreach ($filter_vals as $filters => $vals) {
                                    $filters = strtolower(str_replace(' ', '_', $filters));
                                    if($filters == "intake"){
                                        $intk = explode("|",$vals);
                                        foreach($intk as $intk_vals){
                                            $intatake_arr =  explode(" ", $intk_vals);
                                            $query->orwhere('intake_year', 'LIKE', "%$intatake_arr[1]%");
                                            $query->orwhere('intake_month', 'LIKE', "%$intatake_arr[0]%");
                                        } 
                                    }
                                    else if ($filters == "interested_study_level") {
                                        $cond_vals = explode("|",$vals);
                                        if($filter_condition == "and"){
                                            $query->whereIn('overseas_study_level_selection',$cond_vals);
                                        }
                                        else if($filter_condition == "OR"){
                                            $query->orwhereIn('overseas_study_level_selection',$cond_vals);
                                        }
                                        else{
                                            $query->orwhereIn('overseas_study_level_selection',$cond_vals);
                                        }
                                    } else if ($filters == "course_interested_to_study") {
                                        $cond_vals = explode("|",$vals);
                                        if($filter_condition == "and"){
                                            $query->whereIn('overseas_course_intersted',$cond_vals);
                                        }
                                        else if($filter_condition == "OR"){
                                            $query->orwhereIn('overseas_course_intersted',$cond_vals);
                                        }else{
                                            $query->orwhereIn('overseas_course_intersted',$cond_vals);
                                        }
                                    } else if ($filters == "country_of_residence") {
                                        $cond_vals = explode("|",$vals);
                                        if($filter_condition == "and"){
                                            $query->whereIn('country',$cond_vals);
                                        }
                                        else if($filter_condition == "OR"){
                                            $query->orwhereIn('country',$cond_vals);
                                        }else{
                                            $query->orwhereIn('country',$cond_vals);
                                        }
                                    } else if ($filters == "qualification") {
                                        $cond_vals = explode("|",$vals);
                                        if($filter_condition == "and"){
                                            $query->whereIn('highest_level_education',$cond_vals);
                                        } 
                                        else if($filter_condition == "OR"){
                                            $query->orwhereIn('highest_level_education',$cond_vals);
                                        }else{
                                            $query->orwhereIn('highest_level_education',$cond_vals);
                                        }
                                    } else if ($filters == "other_services_interested") {
                                        $cond_vals = explode("|",$vals);
                                        if($filter_condition == "and"){
                                            $query->whereIn('services',$cond_vals);
                                        }
                                        else if($filter_condition == "OR"){
                                            $query->orwhereIn('services',$cond_vals);
                                        }else{
                                            $query->orwhereIn('services',$cond_vals);
                                        }
                                    } else {
                                        $cond_vals = explode("|",$vals);
                                        if($filter_condition == "and"){
                                            $query->whereIn($filters,$cond_vals);
                                        }
                                        else if($filter_condition == "OR"){
                                            $query->orwhereIn($filters,$cond_vals);
                                        }else{
                                            $query->orwhereIn($filters,$cond_vals);
                                        }
                                    }
                                }
                            });
                        })
                        ->get(['users.*']);
                    $seq_indx = 0;

                    if (count($audience)) {
                        $sent_count = 0;
                        DB::table('automation_campaign')->where('id', $campaign->id)->update(["status" => "running", "send_start" => now()]);
                        $user_ids = array();
                        foreach ($audience as $lead) {
                            echo "\n-- Lead ID: " . $lead->id . "-" . $lead->email . " Name: " . $lead->first_name . "--\n";
                            $sent_count++;
                            $user_ids[] = $lead->id;
                        }
                        $msg_temp = $campaign->message_template;
                        echo "\nUser Count: " . $sent_count . " Campaign: " . $campaign->id . "\n";
                        $users = implode(',', $user_ids);
                        echo $users . "---Template: " . $msg_temp;
                        echo "\n-----------------";
                        $seq_indx++;
                        foreach ($user_ids as $send_to_id) {
                            if ($campaign->communication_mode == "email") {
                                $lead_data = DB::table('users')->select('id', 'email', 'first_name', 'last_name')->where('id', $send_to_id)->first();
                                $emailTemplate = get_email_template($msg_temp);
                                if ($emailTemplate) {
                                    $email_msg = str_replace('#first_name#', $lead_data->first_name, $emailTemplate->message);
                                    $email_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $email_msg);
                                    $email_msg = str_replace('#sitename#', app_name(), $email_msg);
                                    $email_msg = str_replace('#siteurl#', config('app.url'), $email_msg);
                                    if ($lead->email) {
                                        //\Log::debug("AutomationCampaign:send email to:" . $lead_data->email."\n".$email_msg);
                                        echo "AutomationCampaign:send email to:" . $lead_data->email . "\n";
                                        $this->queueEmail($lead_data->email, $emailTemplate->subject, $email_msg);
                                        //store event in lead activity
                                        UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $campaign->id, 'detail' => "Email Sent: Subject:" . $emailTemplate->subject . "<br>Message:" . $email_msg]);
                                    }
                                }
                                else {
                                    $email_msg = str_replace('#first_name#', $lead_data->first_name, $campaign->message_content);
                                    $email_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $email_msg);
                                    $email_msg = str_replace('#sitename#', app_name(), $email_msg);
                                    $email_msg = str_replace('#siteurl#', config('app.url'), $email_msg);
                                    if ($lead->email) {
                                        //\Log::debug("AutomationCampaign:send email to:" . $lead_data->email."\n".$email_msg);
                                        echo "AutomationCampaign:send email to:" . $lead_data->email . "\n";
                                        $this->queueEmail($lead_data->email, $campaign->message_subject, $email_msg);
                                        //store event in lead activity
                                        UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $campaign->id, 'detail' => "Email Sent: Subject:" . $campaign->message_subject . "<br>Message:" . $email_msg]);
                                    }
                                }
                                DB::table('automation_campaign')->where('id', $campaign->id)->update(["sent_count" => $sent_count, "sent_to" => $users]);
                            }
                            if ($campaign->communication_mode == "sms") {
                                $lead_data = DB::table('users')->select('id', 'dialcode', 'mobile', 'first_name', 'last_name')->where('id', $send_to_id)->first();
                                $smsTemplate = get_sms_template($msg_temp);
                                if ($smsTemplate) {
                                    $sms_msg = str_replace('#first_name#', $lead_data->first_name, $smsTemplate->message);
                                    $sms_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $sms_msg);
                                    $sms_msg = str_replace('#sitename#', app_name(), $sms_msg);
                                    $sms_msg = str_replace('#siteurl#', config('app.url'), $sms_msg);

                                    if (User::find($lead_data->id)->sms($sms_msg, $smsTemplate->template_id)) {
                                        //\Log::debug("AutomationCampaign:send sms to:" . $lead_data->id."\n".$sms_msg);
                                        echo "AutomationCampaign:send sms to:" . $lead_data->id . "\n";
                                        //store event in lead activity
                                        UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $campaign->id, 'detail' => "SMS Sent: " . $sms_msg]);
                                    } else {
                                        //\Log::debug("AutomationCampaign: SMS Error- Lead ID:".$lead_data->id);
                                        echo "AutomationCampaign: SMS Error- Lead ID:" . $lead_data->id;
                                    }
                                } else {
                                    $sms_msg = str_replace('#first_name#', $lead_data->first_name, $campaign->message_content);
                                    $sms_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $sms_msg);
                                    $sms_msg = str_replace('#sitename#', app_name(), $sms_msg);
                                    $sms_msg = str_replace('#siteurl#', config('app.url'), $sms_msg);

                                    if (User::find($lead_data->id)->sms($sms_msg, "0")) {
                                        //\Log::debug("AutomationCampaign:send sms to:" . $lead_data->id."\n".$sms_msg);
                                        echo "AutomationCampaign:send sms to:" . $lead_data->id . "\n";
                                        //store event in lead activity
                                        UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $campaign->id, 'detail' => "SMS Sent: " . $sms_msg]);
                                    } else {
                                        //\Log::debug("AutomationCampaign: SMS Error- Lead ID:".$lead_data->id);
                                        echo "AutomationCampaign: SMS Error- Lead ID:" . $lead_data->id;
                                    }
                                }
                                DB::table('automation_campaign')->where('id', $campaign->id)->update(["sent_count" => $sent_count, "sent_to" => $users]);
                            }
                            if ($campaign->communication_mode == "whatsapp") {
                                $lead_data = DB::table('users')->select('id', 'dialcode', 'whatsapp', 'first_name', 'last_name')->where('id', $send_to_id)->first();
                                $whtspTemplate = get_whatsapp_template($msg_temp);
                                if ($whtspTemplate) {
                                    $whtsp_msg = str_replace('#first_name#', $lead_data->first_name, $whtspTemplate->message);
                                    $whtsp_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $whtsp_msg);
                                    $whtsp_msg = str_replace('#sitename#', app_name(), $whtsp_msg);
                                    $whtsp_msg = str_replace('#siteurl#', config('app.url'), $whtsp_msg);

                                    $whtsp_msg = str_replace('{{first_name}}', $lead_data->first_name, $whtspTemplate->message);
                                    $whtsp_msg = str_replace('{{full_name}}', $lead_data->first_name . " " . $lead_data->last_name, $whtsp_msg);
                                    $whtsp_msg = str_replace('{{sitename}}', app_name(), $whtsp_msg);
                                    $whtsp_msg = str_replace('{{siteurl}}', config('app.url'), $whtsp_msg);

                                    if (User::find($lead_data->id)->whatsapp($whtspTemplate->message, $whtspTemplate->hook)) {
                                        //\Log::debug("AutomationCampaign:send whatsapp to:" . $lead_data->id."\n".$whtsp_msg);
                                        echo "AutomationCampaign:send whatsapp to:" . $lead_data->id . "\n";
                                        //store event in lead activity
                                        UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $campaign->id, 'detail' => "Whatsapp Sent: " . $whtsp_msg]);
                                    } else {
                                        //\Log::debug("AutomationCampaign: Whatsapp Error- Lead ID:".$lead_data->id);
                                        echo "AutomationCampaign: Whatsapp Error- Lead ID:" . $lead_data->id;
                                    }
                                }
                                DB::table('automation_campaign')->where('id', $campaign->id)->update(["sent_count" => $sent_count, "sent_to" => $users]);
                            }
                        }
                        DB::table('automation_campaign')->where('id', $campaign->id)->update(["status" => "sent", "send_end" => now()]);
                    }
                } else if ($campaign->target == "students") {

                    if ($campaign->student_status) {
                        $statusArray = explode(',', $campaign->student_status);
                    } else {
                        $statusArray = "";
                    }
                    if ($campaign->student_filters != "") {
                        $filter_vals = json_decode($campaign->student_filters);
                    } else {
                        $filter_vals = "";
                    }

                    //if filter_condition
                    if ($campaign->filter_condition) {
                        $filter_condition = $campaign->filter_condition;
                    } else {
                        $filter_condition = "";
                    }
                    $audience = User::where('is_lead', '0')
                        ->join('user_details', 'user_details.userid', 'users.id')
                        ->when(!empty($statusArray) && count($statusArray), function ($query) use ($statusArray) {
                            return $query->WhereIn('overseas_status', $statusArray);
                        })
                        ->when(!empty($filter_vals), function ($query) use ($filter_vals, $filter_condition) {
                            return $query->Where(function ($query) use ($filter_vals, $filter_condition) {
                                foreach ($filter_vals as $filters => $vals) {
                                    $filters = strtolower(str_replace(' ', '_', $filters));
                                    if($filters == "intake"){
                                        $intk = explode("|",$vals);
                                        foreach($intk as $intk_vals){
                                            $intatake_arr =  explode(" ", $intk_vals);
                                            $query->orwhere('intake_year', 'LIKE', "%$intatake_arr[1]%");
                                            $query->orwhere('intake_month', 'LIKE', "%$intatake_arr[0]%");
                                        } 
                                    }
                                    else if ($filters == "interested_study_level") {
                                        $cond_vals = explode("|",$vals);
                                        if($filter_condition == "and"){
                                            $query->whereIn('overseas_study_level_selection',$cond_vals);
                                        }
                                        else if($filter_condition == "OR"){
                                            $query->orwhereIn('overseas_study_level_selection',$cond_vals);
                                        }
                                        else{
                                            $query->orwhereIn('overseas_study_level_selection',$cond_vals);
                                        }
                                    } else if ($filters == "course_interested_to_study") {
                                        $cond_vals = explode("|",$vals);
                                        if($filter_condition == "and"){
                                            $query->whereIn('overseas_course_intersted',$cond_vals);
                                        }
                                        else if($filter_condition == "OR"){
                                            $query->orwhereIn('overseas_course_intersted',$cond_vals);
                                        }else{
                                            $query->orwhereIn('overseas_course_intersted',$cond_vals);
                                        }
                                    } else if ($filters == "country_of_residence") {
                                        $cond_vals = explode("|",$vals);
                                        if($filter_condition == "and"){
                                            $query->whereIn('country',$cond_vals);
                                        }
                                        else if($filter_condition == "OR"){
                                            $query->orwhereIn('country',$cond_vals);
                                        }else{
                                            $query->orwhereIn('country',$cond_vals);
                                        }
                                    } else if ($filters == "qualification") {
                                        $cond_vals = explode("|",$vals);
                                        if($filter_condition == "and"){
                                            $query->whereIn('highest_level_education',$cond_vals);
                                        } 
                                        else if($filter_condition == "OR"){
                                            $query->orwhereIn('highest_level_education',$cond_vals);
                                        }else{
                                            $query->orwhereIn('highest_level_education',$cond_vals);
                                        }
                                    } else if ($filters == "other_services_interested") {
                                        $cond_vals = explode("|",$vals);
                                        if($filter_condition == "and"){
                                            $query->whereIn('services',$cond_vals);
                                        }
                                        else if($filter_condition == "OR"){
                                            $query->orwhereIn('services',$cond_vals);
                                        }else{
                                            $query->orwhereIn('services',$cond_vals);
                                        }
                                    } else {
                                        $cond_vals = explode("|",$vals);
                                        if($filter_condition == "and"){
                                            $query->whereIn($filters,$cond_vals);
                                        }
                                        else if($filter_condition == "OR"){
                                            $query->orwhereIn($filters,$cond_vals);
                                        }else{
                                            $query->orwhereIn($filters,$cond_vals);
                                        }
                                    }
                                }
                            });
                        })
                        ->get(['users.*']);
                    $seq_indx = 0;

                    if (count($audience)) {
                        $sent_count = 0;
                        DB::table('automation_campaign')->where('id', $campaign->id)->update(["status" => "running", "send_start" => now()]);
                        $user_ids = array();
                        foreach ($audience as $lead) {
                            echo "\n-- Lead ID: " . $lead->id . "-" . $lead->email . " Name: " . $lead->first_name . "--\n";
                            $sent_count++;
                            $user_ids[] = $lead->id;
                        }
                        $msg_temp = $campaign->message_template;
                        echo "\nUser Count: " . $sent_count . " Campaign: " . $campaign->id . "\n";
                        $users = implode(',', $user_ids);
                        echo $users . "---Template: " . $msg_temp;
                        echo "\n-----------------";
                        $seq_indx++;
                        foreach ($user_ids as $send_to_id) {
                            if ($campaign->communication_mode == "email") {
                                $lead_data = DB::table('users')->select('id', 'email', 'first_name', 'last_name')->where('id', $send_to_id)->first();
                                $emailTemplate = get_email_template($msg_temp);
                                if ($emailTemplate) {

                                    $email_msg = str_replace('#first_name#', $lead_data->first_name, $emailTemplate->message);
                                    $email_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $email_msg);
                                    $email_msg = str_replace('#sitename#', app_name(), $email_msg);
                                    $email_msg = str_replace('#siteurl#', config('app.url'), $email_msg);
                                    if ($lead->email) {
                                        //\Log::debug("AutomationCampaign:send email to:" . $lead_data->email."\n".$email_msg);
                                        echo "AutomationCampaign:send email to:" . $lead_data->email . "\n";
                                        $this->queueEmail($lead_data->email, $emailTemplate->subject, $email_msg);
                                        //store event in lead activity
                                        UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $campaign->id, 'detail' => "Email Sent: Subject:" . $emailTemplate->subject . "<br>Message:" . $email_msg]);
                                    }
                                }
                                DB::table('automation_campaign')->where('id', $campaign->id)->update(["sent_count" => $sent_count, "sent_to" => $users]);
                            }
                            if ($campaign->communication_mode == "sms") {
                                $lead_data = DB::table('users')->select('id', 'dialcode', 'mobile', 'first_name', 'last_name')->where('id', $send_to_id)->first();
                                $smsTemplate = get_sms_template($msg_temp);
                                if ($smsTemplate) {
                                    $sms_msg = str_replace('#first_name#', $lead_data->first_name, $smsTemplate->message);
                                    $sms_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $sms_msg);
                                    $sms_msg = str_replace('#sitename#', app_name(), $sms_msg);
                                    $sms_msg = str_replace('#siteurl#', config('app.url'), $sms_msg);

                                    if (User::find($lead_data->id)->sms($sms_msg, $smsTemplate->template_id)) {
                                        //\Log::debug("AutomationCampaign:send sms to:" . $lead_data->id."\n".$sms_msg);
                                        echo "AutomationCampaign:send sms to:" . $lead_data->id . "\n";
                                        //store event in lead activity
                                        UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $campaign->id, 'detail' => "SMS Sent: " . $sms_msg]);
                                    } else {
                                        //\Log::debug("AutomationCampaign: SMS Error- Lead ID:".$lead_data->id);
                                        echo "AutomationCampaign: SMS Error- Lead ID:" . $lead_data->id;
                                    }
                                } else {
                                    $sms_msg = str_replace('#first_name#', $lead_data->first_name, $campaign->message_content);
                                    $sms_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $sms_msg);
                                    $sms_msg = str_replace('#sitename#', app_name(), $sms_msg);
                                    $sms_msg = str_replace('#siteurl#', config('app.url'), $sms_msg);

                                    if (User::find($lead_data->id)->sms($sms_msg, "0")) {
                                        //\Log::debug("AutomationCampaign:send sms to:" . $lead_data->id."\n".$sms_msg);
                                        echo "AutomationCampaign:send sms to:" . $lead_data->id . "\n";
                                        //store event in lead activity
                                        UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $campaign->id, 'detail' => "SMS Sent: " . $sms_msg]);
                                    } else {
                                        //\Log::debug("AutomationCampaign: SMS Error- Lead ID:".$lead_data->id);
                                        echo "AutomationCampaign: SMS Error- Lead ID:" . $lead_data->id;
                                    }
                                }
                                DB::table('automation_campaign')->where('id', $campaign->id)->update(["sent_count" => $sent_count, "sent_to" => $users]);
                            }
                            if ($campaign->communication_mode == "whatsapp") {
                                $lead_data = DB::table('users')->select('id', 'dialcode', 'whatsapp', 'first_name', 'last_name')->where('id', $send_to_id)->first();
                                $whtspTemplate = get_whatsapp_template($msg_temp);
                                if ($whtspTemplate) {
                                    $whtsp_msg = str_replace('#first_name#', $lead_data->first_name, $whtspTemplate->message);
                                    $whtsp_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $whtsp_msg);
                                    $whtsp_msg = str_replace('#sitename#', app_name(), $whtsp_msg);
                                    $whtsp_msg = str_replace('#siteurl#', config('app.url'), $whtsp_msg);

                                    $whtsp_msg = str_replace('{{first_name}}', $lead_data->first_name, $whtspTemplate->message);
                                    $whtsp_msg = str_replace('{{full_name}}', $lead_data->first_name . " " . $lead_data->last_name, $whtsp_msg);
                                    $whtsp_msg = str_replace('{{sitename}}', app_name(), $whtsp_msg);
                                    $whtsp_msg = str_replace('{{siteurl}}', config('app.url'), $whtsp_msg);

                                    if (User::find($lead_data->id)->whatsapp($whtspTemplate->message, $whtspTemplate->hook)) {
                                        //\Log::debug("AutomationCampaign:send whatsapp to:" . $lead_data->id."\n".$whtsp_msg);
                                        echo "AutomationCampaign:send whatsapp to:" . $lead_data->id . "\n";
                                        //store event in lead activity
                                        UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $campaign->id, 'detail' => "Whatsapp Sent: " . $whtsp_msg]);
                                    } else {
                                        //\Log::debug("AutomationCampaign: Whatsapp Error- Lead ID:".$lead_data->id);
                                        echo "AutomationCampaign: Whatsapp Error- Lead ID:" . $lead_data->id;
                                    }
                                }
                                DB::table('automation_campaign')->where('id', $campaign->id)->update(["sent_count" => $sent_count, "sent_to" => $users]);
                            }
                        }
                        DB::table('automation_campaign')->where('id', $campaign->id)->update(["status" => "sent", "send_end" => now()]);
                    }
                } else if ($campaign->target == "staff") {

                    $audience = User::with('roles')
                        ->whereHas('roles', function ($q) {
                            $q->whereNotIn('name', ['user', 'trainer', 'agent']);
                        })
                        ->get(['users.*']);
                    $seq_indx = 0;

                    if (count($audience)) {
                        $sent_count = 0;
                        DB::table('automation_campaign')->where('id', $campaign->id)->update(["status" => "running", "send_start" => now()]);
                        $user_ids = array();
                        foreach ($audience as $lead) {
                            echo "\n-- Lead ID: " . $lead->id . "-" . $lead->email . " Name: " . $lead->first_name . "--\n";
                            $sent_count++;
                            $user_ids[] = $lead->id;
                        }
                        $msg_temp = $campaign->message_template;
                        echo "\nUser Count: " . $sent_count . " Campaign: " . $campaign->id . "\n";
                        $users = implode(',', $user_ids);
                        echo $users . "---Template: " . $msg_temp;
                        echo "\n-----------------";
                        $seq_indx++;
                        foreach ($user_ids as $send_to_id) {
                            if ($campaign->communication_mode == "email") {
                                $lead_data = DB::table('users')->select('id', 'email', 'first_name', 'last_name')->where('id', $send_to_id)->first();
                                $emailTemplate = get_email_template($msg_temp);
                                if ($emailTemplate) {

                                    $email_msg = str_replace('#first_name#', $lead_data->first_name, $emailTemplate->message);
                                    $email_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $email_msg);
                                    $email_msg = str_replace('#sitename#', app_name(), $email_msg);
                                    $email_msg = str_replace('#siteurl#', config('app.url'), $email_msg);
                                    if ($lead->email) {
                                        //\Log::debug("AutomationCampaign:send email to:" . $lead_data->email."\n".$email_msg);
                                        echo "AutomationCampaign:send email to:" . $lead_data->email . "\n";
                                        $this->queueEmail($lead_data->email, $emailTemplate->subject, $email_msg);
                                        //store event in lead activity
                                        UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $campaign->id, 'detail' => "Email Sent: Subject:" . $emailTemplate->subject . "<br>Message:" . $email_msg]);
                                    }
                                }
                                DB::table('automation_campaign')->where('id', $campaign->id)->update(["sent_count" => $sent_count, "sent_to" => $users]);
                            }
                            if ($campaign->communication_mode == "sms") {
                                $lead_data = DB::table('users')->select('id', 'dialcode', 'mobile', 'first_name', 'last_name')->where('id', $send_to_id)->first();
                                $smsTemplate = get_sms_template($msg_temp);
                                if ($smsTemplate) {
                                    $sms_msg = str_replace('#first_name#', $lead_data->first_name, $smsTemplate->message);
                                    $sms_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $sms_msg);
                                    $sms_msg = str_replace('#sitename#', app_name(), $sms_msg);
                                    $sms_msg = str_replace('#siteurl#', config('app.url'), $sms_msg);

                                    if (User::find($lead_data->id)->sms($sms_msg, $smsTemplate->template_id)) {
                                        //\Log::debug("AutomationCampaign:send sms to:" . $lead_data->id."\n".$sms_msg);
                                        echo "AutomationCampaign:send sms to:" . $lead_data->id . "\n";
                                        //store event in lead activity
                                        UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $campaign->id, 'detail' => "SMS Sent: " . $sms_msg]);
                                    } else {
                                        //\Log::debug("AutomationCampaign: SMS Error- Lead ID:".$lead_data->id);
                                        echo "AutomationCampaign: SMS Error- Lead ID:" . $lead_data->id;
                                    }
                                } else {
                                    $sms_msg = str_replace('#first_name#', $lead_data->first_name, $campaign->message_content);
                                    $sms_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $sms_msg);
                                    $sms_msg = str_replace('#sitename#', app_name(), $sms_msg);
                                    $sms_msg = str_replace('#siteurl#', config('app.url'), $sms_msg);

                                    if (User::find($lead_data->id)->sms($sms_msg, "0")) {
                                        //\Log::debug("AutomationCampaign:send sms to:" . $lead_data->id."\n".$sms_msg);
                                        echo "AutomationCampaign:send sms to:" . $lead_data->id . "\n";
                                        //store event in lead activity
                                        UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $campaign->id, 'detail' => "SMS Sent: " . $sms_msg]);
                                    } else {
                                        //\Log::debug("AutomationCampaign: SMS Error- Lead ID:".$lead_data->id);
                                        echo "AutomationCampaign: SMS Error- Lead ID:" . $lead_data->id;
                                    }
                                }
                                DB::table('automation_campaign')->where('id', $campaign->id)->update(["sent_count" => $sent_count, "sent_to" => $users]);
                            }
                            if ($campaign->communication_mode == "whatsapp") {
                                $lead_data = DB::table('users')->select('id', 'dialcode', 'whatsapp', 'first_name', 'last_name')->where('id', $send_to_id)->first();
                                $whtspTemplate = get_whatsapp_template($msg_temp);
                                if ($whtspTemplate) {
                                    $whtsp_msg = str_replace('#first_name#', $lead_data->first_name, $whtspTemplate->message);
                                    $whtsp_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $whtsp_msg);
                                    $whtsp_msg = str_replace('#sitename#', app_name(), $whtsp_msg);
                                    $whtsp_msg = str_replace('#siteurl#', config('app.url'), $whtsp_msg);

                                    $whtsp_msg = str_replace('{{first_name}}', $lead_data->first_name, $whtspTemplate->message);
                                    $whtsp_msg = str_replace('{{full_name}}', $lead_data->first_name . " " . $lead_data->last_name, $whtsp_msg);
                                    $whtsp_msg = str_replace('{{sitename}}', app_name(), $whtsp_msg);
                                    $whtsp_msg = str_replace('{{siteurl}}', config('app.url'), $whtsp_msg);

                                    if (User::find($lead_data->id)->whatsapp($whtspTemplate->message, $whtspTemplate->hook)) {
                                        //\Log::debug("AutomationCampaign:send whatsapp to:" . $lead_data->id."\n".$whtsp_msg);
                                        echo "AutomationCampaign:send whatsapp to:" . $lead_data->id . "\n";
                                        //store event in lead activity
                                        UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $campaign->id, 'detail' => "Whatsapp Sent: " . $whtsp_msg]);
                                    } else {
                                        //\Log::debug("AutomationCampaign: Whatsapp Error- Lead ID:".$lead_data->id);
                                        echo "AutomationCampaign: Whatsapp Error- Lead ID:" . $lead_data->id;
                                    }
                                }
                                DB::table('automation_campaign')->where('id', $campaign->id)->update(["sent_count" => $sent_count, "sent_to" => $users]);
                            }
                        }
                        DB::table('automation_campaign')->where('id', $campaign->id)->update(["status" => "sent", "send_end" => now()]);
                    }
                } else if ($campaign->target == "agents") {
                    $audience =  User::with('roles')
                        ->whereHas('roles', function ($q) {
                            $q->whereIn('name', ['agent']);
                        })
                        ->get(['users.*']);
                    $seq_indx = 0;

                    if (count($audience)) {
                        $sent_count = 0;
                        DB::table('automation_campaign')->where('id', $campaign->id)->update(["status" => "running", "send_start" => now()]);
                        $user_ids = array();
                        foreach ($audience as $lead) {
                            echo "\n-- Lead ID: " . $lead->id . "-" . $lead->email . " Name: " . $lead->first_name . "--\n";
                            $sent_count++;
                            $user_ids[] = $lead->id;
                        }
                        $msg_temp = $campaign->message_template;
                        echo "\nUser Count: " . $sent_count . " Campaign: " . $campaign->id . "\n";
                        $users = implode(',', $user_ids);
                        echo $users . "---Template: " . $msg_temp;
                        echo "\n-----------------";
                        $seq_indx++;
                        foreach ($user_ids as $send_to_id) {
                            if ($campaign->communication_mode == "email") {
                                $lead_data = DB::table('users')->select('id', 'email', 'first_name', 'last_name')->where('id', $send_to_id)->first();
                                $emailTemplate = get_email_template($msg_temp);
                                if ($emailTemplate) {

                                    $email_msg = str_replace('#first_name#', $lead_data->first_name, $emailTemplate->message);
                                    $email_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $email_msg);
                                    $email_msg = str_replace('#sitename#', app_name(), $email_msg);
                                    $email_msg = str_replace('#siteurl#', config('app.url'), $email_msg);
                                    if ($lead->email) {
                                        //\Log::debug("AutomationCampaign:send email to:" . $lead_data->email."\n".$email_msg);
                                        echo "AutomationCampaign:send email to:" . $lead_data->email . "\n";
                                        $this->queueEmail($lead_data->email, $emailTemplate->subject, $email_msg);
                                        //store event in lead activity
                                        UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $campaign->id, 'detail' => "Email Sent: Subject:" . $emailTemplate->subject . "<br>Message:" . $email_msg]);
                                    }
                                }
                                DB::table('automation_campaign')->where('id', $campaign->id)->update(["sent_count" => $sent_count, "sent_to" => $users]);
                            }
                            if ($campaign->communication_mode == "sms") {
                                $lead_data = DB::table('users')->select('id', 'dialcode', 'mobile', 'first_name', 'last_name')->where('id', $send_to_id)->first();
                                $smsTemplate = get_sms_template($msg_temp);
                                if ($smsTemplate) {
                                    $sms_msg = str_replace('#first_name#', $lead_data->first_name, $smsTemplate->message);
                                    $sms_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $sms_msg);
                                    $sms_msg = str_replace('#sitename#', app_name(), $sms_msg);
                                    $sms_msg = str_replace('#siteurl#', config('app.url'), $sms_msg);

                                    if (User::find($lead_data->id)->sms($sms_msg, $smsTemplate->template_id)) {
                                        //\Log::debug("AutomationCampaign:send sms to:" . $lead_data->id."\n".$sms_msg);
                                        echo "AutomationCampaign:send sms to:" . $lead_data->id . "\n";
                                        //store event in lead activity
                                        UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $campaign->id, 'detail' => "SMS Sent: " . $sms_msg]);
                                    } else {
                                        //\Log::debug("AutomationCampaign: SMS Error- Lead ID:".$lead_data->id);
                                        echo "AutomationCampaign: SMS Error- Lead ID:" . $lead_data->id;
                                    }
                                } else {
                                    $sms_msg = str_replace('#first_name#', $lead_data->first_name, $campaign->message_content);
                                    $sms_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $sms_msg);
                                    $sms_msg = str_replace('#sitename#', app_name(), $sms_msg);
                                    $sms_msg = str_replace('#siteurl#', config('app.url'), $sms_msg);

                                    if (User::find($lead_data->id)->sms($sms_msg, "0")) {
                                        //\Log::debug("AutomationCampaign:send sms to:" . $lead_data->id."\n".$sms_msg);
                                        echo "AutomationCampaign:send sms to:" . $lead_data->id . "\n";
                                        //store event in lead activity
                                        UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $campaign->id, 'detail' => "SMS Sent: " . $sms_msg]);
                                    } else {
                                        //\Log::debug("AutomationCampaign: SMS Error- Lead ID:".$lead_data->id);
                                        echo "AutomationCampaign: SMS Error- Lead ID:" . $lead_data->id;
                                    }
                                }
                                DB::table('automation_campaign')->where('id', $campaign->id)->update(["sent_count" => $sent_count, "sent_to" => $users]);
                            }
                            if ($campaign->communication_mode == "whatsapp") {
                                $lead_data = DB::table('users')->select('id', 'dialcode', 'whatsapp', 'first_name', 'last_name')->where('id', $send_to_id)->first();
                                $whtspTemplate = get_whatsapp_template($msg_temp);
                                if ($whtspTemplate) {
                                    $whtsp_msg = str_replace('#first_name#', $lead_data->first_name, $whtspTemplate->message);
                                    $whtsp_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $whtsp_msg);
                                    $whtsp_msg = str_replace('#sitename#', app_name(), $whtsp_msg);
                                    $whtsp_msg = str_replace('#siteurl#', config('app.url'), $whtsp_msg);

                                    $whtsp_msg = str_replace('{{first_name}}', $lead_data->first_name, $whtspTemplate->message);
                                    $whtsp_msg = str_replace('{{full_name}}', $lead_data->first_name . " " . $lead_data->last_name, $whtsp_msg);
                                    $whtsp_msg = str_replace('{{sitename}}', app_name(), $whtsp_msg);
                                    $whtsp_msg = str_replace('{{siteurl}}', config('app.url'), $whtsp_msg);

                                    if (User::find($lead_data->id)->whatsapp($whtspTemplate->message, $whtspTemplate->hook)) {
                                        //\Log::debug("AutomationCampaign:send whatsapp to:" . $lead_data->id."\n".$whtsp_msg);
                                        echo "AutomationCampaign:send whatsapp to:" . $lead_data->id . "\n";
                                        //store event in lead activity
                                        UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $campaign->id, 'detail' => "Whatsapp Sent: " . $whtsp_msg]);
                                    } else {
                                        //\Log::debug("AutomationCampaign: Whatsapp Error- Lead ID:".$lead_data->id);
                                        echo "AutomationCampaign: Whatsapp Error- Lead ID:" . $lead_data->id;
                                    }
                                }
                                DB::table('automation_campaign')->where('id', $campaign->id)->update(["sent_count" => $sent_count, "sent_to" => $users]);
                            }
                        }
                        DB::table('automation_campaign')->where('id', $campaign->id)->update(["status" => "sent", "send_end" => now()]);
                    }
                }
            }
        } else {
            // echo "\nNo Active Campaign Found at: " . $currentdatetime;
        }
        // echo "\n-------------" . date('Y-m-d H:i:s') . ": Automation Campaign Cron End -------------";
    }


    private function queueEmail($email, $subject, $message)
    {

        if(env('SAAS_MAIL_SERVER') && Activity::where('event', 'email')->where('created_at', 'like', date("Y-m-").'%')->count() >= env('MONTHLY_EMAIL_LIMIT')) {
            \Log::error("ERROR!!!!! MONTHLY_EMAIL_LIMIT Reached!");
            return;
        }

        try {
            if (env('QUEUE_CONNECTION') == 'redis') {
                //Mail::to($email)->queue(new MailSend($subject, $message));
                //\Log::debug("Queue Mail: (BROADCAST MESSAGE) [redis] " . $message);
                EmailJob::dispatch(new BroadcastMailSend($email, $subject, $message));
                activity()->event('email')->log('Email sent To: '.$email. ' Subject: '.$subject);
            } elseif (env('QUEUE_CONNECTION') == 'database') {
                //\Log::debug("Queue Mail: (BROADCAST MESSAGE) [database] " . $message);
                
                // $delay = round(DB::table('jobs')->count() * (1 / env('EMAILS_PER_SEC', 0.13)));
                $delay = email_delay();

                if(get_site_config('bulk_smtp_host') && get_site_config('bulk_smtp_port') && get_site_config('bulk_smtp_email') && get_site_config('bulk_smtp_password') && get_site_config('bulk_smtp_connection') && get_site_config('bulk_smtp_type')== 'smtp_server'){
                    //\Log::debug("Queue Mail: (BROADCAST MESSAGE) sending through- BROADCAST_SMTP");
                    Mail::mailer('broadcast_smtp')->to($email)->later(now()->addSeconds($delay), new MailSend($subject, $message));
                } 
                elseif(get_site_config('bulk_smtp_type')== 'google'){
                    //\Log::debug("Queue Mail: (BROADCAST MESSAGE) sending through- User_notify");
                    user_notify($email,$subject, $message);
                }
                else{
                    //\Log::debug("Queue Mail: (BROADCAST MESSAGE) sending through- SMTP");
                    Mail::mailer('smtp')->to($email)->later(now()->addSeconds($delay), new MailSend($subject, $message));
                }
                activity()->event('email')->log('Email sent To: '.$email. ' Subject: '.$subject);
            } else {
                //Mail::mailer('smtp')->to($email)->send(new MailSend($subject, $message));
                user_notify($email,$subject, $message);
            }
        } catch (\Exception $e) {
            $message = $e->getMessage();
            echo "Queue Mail Error: (BROADCAST MESSAGE) " . $message;
        }
    }
}
