<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Auth\User;
use Illuminate\Support\Facades\DB;
use App\Notifications\Backend\UserAlert;
use App\Models\MailTemplates;
use App\Models\Auth\AutomationWorkflowActivity;
use App\Mail\MailSend;
use Illuminate\Support\Facades\Mail;
use App\Jobs\EmailJob;
use App\Models\UserActivity;
use App\Mail\BroadcastMailSend;
use Log;
use Illuminate\Support\Carbon;
use Spatie\Activitylog\Models\Activity;

class AutomationWorkflow extends Command
{

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'AutomationWorkflow';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Automation Workflow';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // echo "\n-------------" . date('Y-m-d H:i:s') . ": Automation Workflow Cron Start";
        //echo ".";
        $currenttime = date('H:i');
        // echo "\nCurrent Time: " . $currenttime;

        $data = DB::table('automation_workflow')->where('status', 1)
            ->where('run_at', $currenttime)
            ->get();
        if (count($data)) {
            echo "\nWorkflow Found!";
            foreach ($data as $workflow) {
                if ($workflow->workflow_type == 'lead_nurture_sequence') {
                    echo "\n-----------------Workflow:" . $workflow->id . " Type: lead_nurture_sequence------------------";
                    $message_values = json_decode($workflow->message_details);
                    if ($message_values != "") {
                        $seq_indx = 0;
                        foreach ($message_values as $messages => $msg_vals) {

                            //getting leads data
                            if ($workflow->lead_status) {
                                $statusArray = explode(',', $workflow->lead_status);
                            } else {
                                $statusArray = "";
                            }

                            if ($workflow->lead_filters != "") {
                                $filter_vals = json_decode($workflow->lead_filters);
                            } else {
                                $filter_vals = "";
                            }
                            //if filter_condition
                            if ($workflow->filter_condition) {
                                $filter_condition = $workflow->filter_condition;
                            } else {
                                $filter_condition = "";
                            }
                            // DB::enableQueryLog();
                            $lead_age = date("Y-m-d", strtotime("-$messages days"));
                            $leadData = User::where('is_lead', 1)
                                ->join('user_details', 'user_details.userid', 'users.id')
                                ->when(!empty($statusArray) && count($statusArray), function ($query) use ($statusArray) {
                                    return $query->WhereIn('lead_status', $statusArray);
                                })
                                ->whereDate("users.created_at", '=', $lead_age)
                                ->when(!empty($filter_vals), function ($query) use ($filter_vals, $filter_condition) {
                                    return $query->Where(function ($query) use ($filter_vals, $filter_condition) {
                                        foreach ($filter_vals as $filters => $vals) {
                                            $filters = strtolower(str_replace(' ', '_', $filters));
                                            // if ($filters == "intake") {
                                            //     $intatake_arr =  explode(" ", $vals);
                                            //     $query->where('intake_year', 'LIKE', "%$intatake_arr[1]%");
                                            //     $query->where('intake_month', 'LIKE', "%$intatake_arr[0]%");
                                            // } 
                                            if($filters == "intake"){
                                                $intk = explode("|",$vals);
                                                foreach($intk as $intk_vals){
                                                    $intatake_arr =  explode(" ", $intk_vals);
                                                    $query->orwhere('intake_year', 'LIKE', "%$intatake_arr[1]%");
                                                    $query->orwhere('intake_month', 'LIKE', "%$intatake_arr[0]%");
                                                } 
                                            }
                                            else if ($filters == "interested_study_level") {
                                                $cond_vals = explode("|",$vals);
                                                if($filter_condition == "and"){
                                                    $query->whereIn('overseas_study_level_selection',$cond_vals);
                                                }
                                                else if($filter_condition == "OR"){
                                                    $query->orwhereIn('overseas_study_level_selection',$cond_vals);
                                                }
                                                else{
                                                    $query->orwhereIn('overseas_study_level_selection',$cond_vals);
                                                }
                                            } else if ($filters == "course_interested_to_study") {
                                                $cond_vals = explode("|",$vals);
                                                if($filter_condition == "and"){
                                                    $query->whereIn('overseas_course_intersted',$cond_vals);
                                                }
                                                else if($filter_condition == "OR"){
                                                    $query->orwhereIn('overseas_course_intersted',$cond_vals);
                                                }else{
                                                    $query->orwhereIn('overseas_course_intersted',$cond_vals);
                                                }
                                            } else if ($filters == "country_of_residence") {
                                                $cond_vals = explode("|",$vals);
                                                if($filter_condition == "and"){
                                                    $query->whereIn('country',$cond_vals);
                                                }
                                                else if($filter_condition == "OR"){
                                                    $query->orwhereIn('country',$cond_vals);
                                                }else{
                                                    $query->orwhereIn('country',$cond_vals);
                                                }
                                            } else if ($filters == "qualification") {
                                                $cond_vals = explode("|",$vals);
                                                if($filter_condition == "and"){
                                                    $query->whereIn('highest_level_education',$cond_vals);
                                                } 
                                                else if($filter_condition == "OR"){
                                                    $query->orwhereIn('highest_level_education',$cond_vals);
                                                }else{
                                                    $query->orwhereIn('highest_level_education',$cond_vals);
                                                }
                                            } else if ($filters == "other_services_interested") {
                                                $cond_vals = explode("|",$vals);
                                                if($filter_condition == "and"){
                                                    $query->whereIn('services',$cond_vals);
                                                }
                                                else if($filter_condition == "OR"){
                                                    $query->orwhereIn('services',$cond_vals);
                                                }else{
                                                    $query->orwhereIn('services',$cond_vals);
                                                }
                                            } else {
                                                $cond_vals = explode("|",$vals);
                                                if($filter_condition == "and"){
                                                    $query->whereIn($filters,$cond_vals);
                                                }
                                                else if($filter_condition == "OR"){
                                                    $query->orwhereIn($filters,$cond_vals);
                                                }else{
                                                    $query->orwhereIn($filters,$cond_vals);
                                                }
                                            }
                                        }
                                    });
                                })
                                ->get(['users.*']);
                            if (count($leadData)) {
                                $user_count = 0;
                                $user_ids = array();
                                foreach ($leadData as $lead) {
                                    echo "\n-- Lead ID: " . $lead->id . "-" . $lead->email . " Name: " . $lead->first_name . "--\n";
                                    $user_count++;
                                    $user_ids[] = $lead->id;
                                }
                                $msg_temp = $msg_vals;
                                echo "\nUser Count: " . $user_count . " Workflow: " . $workflow->id . "\n";
                                $users = implode(',', $user_ids);
                                echo $users . "---Template: " . $msg_temp;
                                echo "\n-----------------";
                                $seq_indx++;
                                foreach ($user_ids as $send_to_id) {
                                    if ($workflow->communication_mode == "email") {
                                        $lead_data = DB::table('users')->select('id', 'email', 'first_name', 'last_name')->where('id', $send_to_id)->first();
                                        $emailTemplate = get_email_template($msg_vals);
                                        if ($emailTemplate) {
                                            $email_msg = str_replace('#first_name#', $lead_data->first_name, $emailTemplate->message);
                                            $email_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $email_msg);
                                            $email_msg = str_replace('#sitename#', app_name(), $email_msg);
                                            $email_msg = str_replace('#siteurl#', config('app.url'), $email_msg);
                                            if ($lead->email) {
                                                // \Log::debug("AutomationWorkflow:send email to:" . $lead_data->email."\n".$email_msg);
                                                echo "\nAutomationWorkflow:send email to:" . $lead_data->email . "\n";
                                                $this->queueEmail($lead_data->email, $emailTemplate->subject, $email_msg);
                                                //store event in lead activity
                                                UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $workflow->id, 'title' => $emailTemplate->subject, 'detail' => $email_msg]);
                                            }
                                        }
                                    }
                                    if ($workflow->communication_mode == "sms") {
                                        $lead_data = DB::table('users')->select('id', 'dialcode', 'mobile', 'first_name', 'last_name')->where('id', $send_to_id)->first();
                                        $smsTemplate = get_sms_template($msg_vals);
                                        if ($smsTemplate) {
                                            $sms_msg = str_replace('#first_name#', $lead_data->first_name, $smsTemplate->message);
                                            $sms_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $sms_msg);
                                            $sms_msg = str_replace('#sitename#', app_name(), $sms_msg);
                                            $sms_msg = str_replace('#siteurl#', config('app.url'), $sms_msg);

                                            if (User::find($lead_data->id)->sms($sms_msg, $smsTemplate->template_id)) {
                                                //\Log::debug("AutomationWorkflow:send sms to:" . $lead_data->id."\n".$sms_msg);
                                                echo "\nAutomationWorkflow:send sms to:" . $lead_data->id . "\n";
                                                //store event in lead activity
                                                UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $workflow->id, 'detail' => $sms_msg]);
                                            } else {
                                                echo "\nAutomationWorkflow: SMS Error- Lead ID:" . $lead_data->id;
                                            }
                                        }
                                    }
                                    if ($workflow->communication_mode == "whatsapp") {
                                        $lead_data = DB::table('users')->select('id', 'dialcode', 'whatsapp', 'first_name', 'last_name')->where('id', $send_to_id)->first();
                                        $whtspTemplate = get_whatsapp_template($msg_vals);
                                        if ($whtspTemplate) {
                                            $whtsp_msg = str_replace('#first_name#', $lead_data->first_name, $whtspTemplate->message);
                                            $whtsp_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $whtsp_msg);
                                            $whtsp_msg = str_replace('#sitename#', app_name(), $whtsp_msg);
                                            $whtsp_msg = str_replace('#siteurl#', config('app.url'), $whtsp_msg);

                                            $whtsp_msg = str_replace('{{first_name}}', $lead_data->first_name, $whtspTemplate->message);
                                            $whtsp_msg = str_replace('{{full_name}}', $lead_data->first_name . " " . $lead_data->last_name, $whtsp_msg);
                                            $whtsp_msg = str_replace('{{sitename}}', app_name(), $whtsp_msg);
                                            $whtsp_msg = str_replace('{{siteurl}}', config('app.url'), $whtsp_msg);

                                            if (User::find($lead_data->id)->whatsapp($whtspTemplate->message, $whtspTemplate->hook)) {
                                                //\Log::debug("AutomationWorkflow:send whatsapp to:" . $lead_data->id."\n".$whtsp_msg);
                                                echo "\nAutomationWorkflow:send whatsapp to:" . $lead_data->id . "\n";
                                                //store event in lead activity
                                                UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $workflow->id, 'detail' => $whtsp_msg]);
                                            } else {
                                                echo "\nAutomationWorkflow: Whatsapp Error- Lead ID:" . $lead_data->id;
                                            }
                                        }
                                    }
                                }
                                 AutomationWorkflowActivity::create(['workflow_id' => $workflow->id, 'matched_audience' => $users, 'matched_count' => $user_count, 'message_template' => $msg_vals, 'sequence_index' => $seq_indx]);
                            }
                        }
                    }
                }
                if ($workflow->workflow_type == 'message_sequence') {
                    echo "\n-----------------------Workflow Type: message_sequence--------------------------";
                    $message_values = json_decode($workflow->message_details);
                    if ($message_values != "") {
                        $seq_indx = 0;
                        foreach ($message_values as $messages => $msg_vals) {

                            $target = $workflow->target;
                            //getting leads data

                            if ($workflow->lead_status) {
                                $leadStatusArray = explode(',', $workflow->lead_status);
                            } else {
                                $leadStatusArray = "";
                            }
                            if ($workflow->lead_filters != "") {
                                $filter_vals = json_decode($workflow->lead_filters);
                            } else {
                                $filter_vals = "";
                            }

                            if ($workflow->student_status) {
                                $stuStatusArray = explode(',', $workflow->student_status);
                            } else {
                                $stuStatusArray = "";
                            }
                            if ($workflow->student_filters != "") {
                                $filter_vals = json_decode($workflow->student_filters);
                            } else {
                                $filter_vals = "";
                            }

                            //if filter_condition
                            if ($workflow->filter_condition) {
                                $filter_condition = $workflow->filter_condition;
                            } else {
                                $filter_condition = "";
                            }
                            if ($messages == "00" &&  $workflow->start_date == date("Y-m-d")) {
                                echo "\n On Date :" . $workflow->start_date;
                                //For On Date
                                $start_date = $workflow->start_date;
                                $leadData = User::join('user_details', 'user_details.userid', 'users.id')
                                    ->when($target == "students", function ($query) {
                                        return $query->where('is_lead', 0);
                                    })
                                    ->when($target == "leads", function ($query) {
                                        return $query->where('is_lead', 1);
                                    })
                                    ->when($target == "all_leads_and_students", function ($query) {
                                    })
                                    ->when($target == "staff", function ($query) {
                                        return $query->whereHas('roles', function ($query) {
                                            $query->whereNotIn('name', ['user', 'trainer', 'agent']);
                                        });
                                    })
                                    ->when($target == "agents", function ($query) {
                                        return $query->whereHas('roles', function ($query) {
                                            $query->whereIn('name', ['agent']);
                                        });
                                    })
                                    ->when(!empty($leadStatusArray) && count($leadStatusArray), function ($query) use ($leadStatusArray) {
                                        return $query->WhereIn('lead_status', $leadStatusArray);
                                    })
                                    ->when(!empty($stuStatusArray) && count($stuStatusArray), function ($query) use ($stuStatusArray) {
                                        return $query->WhereIn('overseas_status', $stuStatusArray);
                                    })
                                    // ->whereDate("users.created_at",'=', $lead_age)
                                    ->when(!empty($filter_vals), function ($query) use ($filter_vals, $filter_condition) {
                                        return $query->Where(function ($query) use ($filter_vals, $filter_condition) {
                                            foreach ($filter_vals as $filters => $vals) {
                                                $filters = strtolower(str_replace(' ', '_', $filters));
                                                // if ($filters == "intake") {
                                                //     $intatake_arr =  explode(" ", $vals);
                                                //     $query->where('intake_year', 'LIKE', "%$intatake_arr[1]%");
                                                //     $query->where('intake_month', 'LIKE', "%$intatake_arr[0]%");
                                                // } 
                                                if($filters == "intake"){
                                                    $intk = explode("|",$vals);
                                                    foreach($intk as $intk_vals){
                                                        $intatake_arr =  explode(" ", $intk_vals);
                                                        $query->orwhere('intake_year', 'LIKE', "%$intatake_arr[1]%");
                                                        $query->orwhere('intake_month', 'LIKE', "%$intatake_arr[0]%");
                                                    }
                                                }
                                                else if ($filters == "interested_study_level") {
                                                    $cond_vals = explode("|",$vals);
                                                    if($filter_condition == "and"){
                                                    $query->whereIn('overseas_study_level_selection',$cond_vals);
                                                    }
                                                    else if($filter_condition == "OR"){
                                                        $query->orwhereIn('overseas_study_level_selection',$cond_vals);
                                                    }
                                                    else{
                                                        $query->orwhereIn('overseas_study_level_selection',$cond_vals);
                                                    }
                                                } 
                                                else if ($filters == "course_interested_to_study") {
                                                    $cond_vals = explode("|",$vals);
                                                    if($filter_condition == "and"){
                                                        $query->whereIn('overseas_course_intersted',$cond_vals);
                                                    }
                                                    else if($filter_condition == "OR"){
                                                        $query->orwhereIn('overseas_course_intersted',$cond_vals);
                                                    }else{
                                                        $query->orwhereIn('overseas_course_intersted',$cond_vals);
                                                    }
                                                } 
                                                else if ($filters == "country_of_residence") {
                                                    $cond_vals = explode("|",$vals);
                                                    if($filter_condition == "and"){
                                                        $query->whereIn('country',$cond_vals);
                                                    }
                                                    else if($filter_condition == "OR"){
                                                        $query->orwhereIn('country',$cond_vals);
                                                    }else{
                                                        $query->orwhereIn('country',$cond_vals);
                                                    }
                                                } 
                                                else if ($filters == "qualification") {
                                                    $cond_vals = explode("|",$vals);
                                                    if($filter_condition == "and"){
                                                        $query->whereIn('highest_level_education',$cond_vals);
                                                    } 
                                                    else if($filter_condition == "OR"){
                                                        $query->orwhereIn('highest_level_education',$cond_vals);
                                                    }else{
                                                        $query->orwhereIn('highest_level_education',$cond_vals);
                                                    }
                                                } 
                                                else if ($filters == "other_services_interested") {
                                                    $cond_vals = explode("|",$vals);
                                                    if($filter_condition == "and"){
                                                        $query->whereIn('services',$cond_vals);
                                                    }
                                                    else if($filter_condition == "OR"){
                                                        $query->orwhereIn('services',$cond_vals);
                                                    }else{
                                                        $query->orwhereIn('services',$cond_vals);
                                                    }
                                                } else {
                                                    $cond_vals = explode("|",$vals);
                                                    if($filter_condition == "and"){
                                                        $query->whereIn($filters,$cond_vals);
                                                    }
                                                    else if($filter_condition == "OR"){
                                                        $query->orwhereIn($filters,$cond_vals);
                                                    }else{
                                                        $query->orwhereIn($filters,$cond_vals);
                                                    }
                                                }
                                            }
                                        });
                                    })
                                    ->get(['users.*']);
                                if (count($leadData)) {
                                    $user_count = 0;
                                    $user_ids = array();
                                    foreach ($leadData as $lead) {
                                        echo "\n-- Lead ID: " . $lead->id . "-" . $lead->email . " Name: " . $lead->first_name . "--\n";
                                        $user_count++;
                                        $user_ids[] = $lead->id;
                                    }
                                    $msg_temp = $msg_vals;
                                    echo "\nUser Count: " . $user_count . " Workflow: " . $workflow->id . "\n";
                                    $users = implode(',', $user_ids);
                                    echo $users . "---Template: " . $msg_temp;
                                    echo "\n-----------------";
                                    $seq_indx++;
                                    foreach ($user_ids as $send_to_id) {
                                        if ($workflow->communication_mode == "email") {
                                            $lead_data = DB::table('users')->select('id', 'email', 'first_name', 'last_name')->where('id', $send_to_id)->first();
                                            $emailTemplate = get_email_template($msg_vals);
                                            if ($emailTemplate) {
                                                $email_msg = str_replace('#first_name#', $lead_data->first_name, $emailTemplate->message);
                                                $email_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $email_msg);
                                                $email_msg = str_replace('#sitename#', app_name(), $email_msg);
                                                $email_msg = str_replace('#siteurl#', config('app.url'), $email_msg);
                                                if ($lead->email) {
                                                    // \Log::debug("AutomationWorkflow:send email to:" . $lead_data->email."\n".$email_msg);
                                                    echo "\nAutomationWorkflow:send email to:" . $lead_data->email . "\n";
                                                    $this->queueEmail($lead_data->email, $emailTemplate->subject, $email_msg);
                                                    //store event in lead activity
                                                    UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $workflow->id, 'title' => $emailTemplate->subject, 'detail' => $email_msg]);
                                                }
                                            }
                                        }
                                        if ($workflow->communication_mode == "sms") {
                                            $lead_data = DB::table('users')->select('id', 'dialcode', 'mobile', 'first_name', 'last_name')->where('id', $send_to_id)->first();
                                            $smsTemplate = get_sms_template($msg_vals);
                                            if ($smsTemplate) {
                                                $sms_msg = str_replace('#first_name#', $lead_data->first_name, $smsTemplate->message);
                                                $sms_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $sms_msg);
                                                $sms_msg = str_replace('#sitename#', app_name(), $sms_msg);
                                                $sms_msg = str_replace('#siteurl#', config('app.url'), $sms_msg);

                                                if (User::find($lead_data->id)->sms($sms_msg, $smsTemplate->template_id)) {
                                                    //\Log::debug("AutomationWorkflow:send sms to:" . $lead_data->id."\n".$sms_msg);
                                                    echo "\nAutomationWorkflow:send sms to:" . $lead_data->id . "\n";
                                                    //store event in lead activity
                                                    UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $workflow->id, 'detail' => $sms_msg]);
                                                } else {
                                                    //\Log::debug("AutomationWorkflow: SMS Error- Lead ID:".$lead_data->id);
                                                    echo "\nAutomationWorkflow: SMS Error- Lead ID:" . $lead_data->id;
                                                }
                                            }
                                        }
                                        if ($workflow->communication_mode == "whatsapp") {
                                            $lead_data = DB::table('users')->select('id', 'dialcode', 'whatsapp', 'first_name', 'last_name')->where('id', $send_to_id)->first();
                                            $whtspTemplate = get_whatsapp_template($msg_vals);
                                            if ($whtspTemplate) {
                                                $whtsp_msg = str_replace('#first_name#', $lead_data->first_name, $whtspTemplate->message);
                                                $whtsp_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $whtsp_msg);
                                                $whtsp_msg = str_replace('#sitename#', app_name(), $whtsp_msg);
                                                $whtsp_msg = str_replace('#siteurl#', config('app.url'), $whtsp_msg);

                                                $whtsp_msg = str_replace('{{first_name}}', $lead_data->first_name, $whtspTemplate->message);
                                                $whtsp_msg = str_replace('{{full_name}}', $lead_data->first_name . " " . $lead_data->last_name, $whtsp_msg);
                                                $whtsp_msg = str_replace('{{sitename}}', app_name(), $whtsp_msg);
                                                $whtsp_msg = str_replace('{{siteurl}}', config('app.url'), $whtsp_msg);

                                                if (User::find($lead_data->id)->whatsapp($whtspTemplate->message, $whtspTemplate->hook)) {
                                                    //\Log::debug("AutomationWorkflow:send whatsapp to:" . $lead_data->id."\n".$whtsp_msg);
                                                    echo "\nAutomationWorkflow:send whatsapp to:" . $lead_data->id . "\n";
                                                    //store event in lead activity
                                                    UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $workflow->id, 'detail' => $whtsp_msg]);
                                                } else {
                                                    //\Log::debug("AutomationWorkflow: Whatsapp Error- Lead ID:".$lead_data->id);
                                                    echo "\nAutomationWorkflow: Whatsapp Error- Lead ID:" . $lead_data->id;
                                                }
                                            }
                                        }
                                        
                                    }
                                } else {
                                    echo "\n No users found for On(Date)";
                                }
                                AutomationWorkflowActivity::create(['workflow_id' => $workflow->id, 'matched_audience' => $users, 'matched_count' => $user_count, 'message_template' => $msg_vals, 'sequence_index' => $seq_indx]);
                            } else if ($messages != "00" &&  $workflow->start_date == date("Y-m-d", strtotime("-$messages days"))) {
                                echo "\nAfter :" . $messages . " Days";
                                //For After Days
                                //$after_days = date("Y-m-d", strtotime("-$messages days"));
                                DB::enableQueryLog();
                                $leadData = User::join('user_details', 'user_details.userid', 'users.id')
                                    ->when($target == "students", function ($query) {
                                        return $query->where('is_lead', 0);
                                    })
                                    ->when($target == "leads", function ($query) {
                                        return $query->where('is_lead', 1);
                                    })
                                    ->when($target == "all_leads_and_students", function ($query) {
                                        // return $query->where('is_lead',1);
                                    })
                                    ->when($target == "staff", function ($query) {
                                        return $query->whereHas('roles', function ($query) {
                                            $query->whereNotIn('name', ['user', 'trainer', 'agent']);
                                        });
                                    })
                                    ->when($target == "agents", function ($query) {
                                        return $query->whereHas('roles', function ($query) {
                                            $query->whereIn('name', ['agent']);
                                        });
                                    })

                                    ->when(!empty($leadStatusArray) && count($leadStatusArray), function ($query) use ($leadStatusArray) {
                                        return $query->WhereIn('lead_status', $leadStatusArray);
                                    })
                                    ->when(!empty($stuStatusArray) && count($stuStatusArray), function ($query) use ($stuStatusArray) {
                                        return $query->WhereIn('overseas_status', $stuStatusArray);
                                    })
                                    ->when(!empty($filter_vals), function ($query) use ($filter_vals, $filter_condition) {
                                        return $query->Where(function ($query) use ($filter_vals, $filter_condition) {
                                            foreach ($filter_vals as $filters => $vals) {
                                                $filters = strtolower(str_replace(' ', '_', $filters));
                                                // if ($filters == "intake") {
                                                //     $intatake_arr =  explode(" ", $vals);
                                                //     $query->where('intake_year', 'LIKE', "%$intatake_arr[1]%");
                                                //     $query->where('intake_month', 'LIKE', "%$intatake_arr[0]%");
                                                // } 
                                                if($filters == "intake"){
                                                    $intk = explode("|",$vals);
                                                    foreach($intk as $intk_vals){
                                                        $intatake_arr =  explode(" ", $intk_vals);
                                                        $query->orwhere('intake_year', 'LIKE', "%$intatake_arr[1]%");
                                                        $query->orwhere('intake_month', 'LIKE', "%$intatake_arr[0]%");
                                                    }
                                                }
                                                else if ($filters == "interested_study_level") {
                                                    $cond_vals = explode("|",$vals);
                                                    if($filter_condition == "and"){
                                                    $query->whereIn('overseas_study_level_selection',$cond_vals);
                                                    }
                                                    else if($filter_condition == "OR"){
                                                        $query->orwhereIn('overseas_study_level_selection',$cond_vals);
                                                    }
                                                    else{
                                                        $query->orwhereIn('overseas_study_level_selection',$cond_vals);
                                                    }
                                                } 
                                                else if ($filters == "course_interested_to_study") {
                                                    $cond_vals = explode("|",$vals);
                                                    if($filter_condition == "and"){
                                                        $query->whereIn('overseas_course_intersted',$cond_vals);
                                                    }
                                                    else if($filter_condition == "OR"){
                                                        $query->orwhereIn('overseas_course_intersted',$cond_vals);
                                                    }else{
                                                        $query->orwhereIn('overseas_course_intersted',$cond_vals);
                                                    }
                                                } 
                                                else if ($filters == "country_of_residence") {
                                                    $cond_vals = explode("|",$vals);
                                                    if($filter_condition == "and"){
                                                        $query->whereIn('country',$cond_vals);
                                                    }
                                                    else if($filter_condition == "OR"){
                                                        $query->orwhereIn('country',$cond_vals);
                                                    }else{
                                                        $query->orwhereIn('country',$cond_vals);
                                                    }
                                                } 
                                                else if ($filters == "qualification") {
                                                    $cond_vals = explode("|",$vals);
                                                    if($filter_condition == "and"){
                                                        $query->whereIn('highest_level_education',$cond_vals);
                                                    } 
                                                    else if($filter_condition == "OR"){
                                                        $query->orwhereIn('highest_level_education',$cond_vals);
                                                    }else{
                                                        $query->orwhereIn('highest_level_education',$cond_vals);
                                                    }
                                                } 
                                                else if ($filters == "other_services_interested") {
                                                    $cond_vals = explode("|",$vals);
                                                    if($filter_condition == "and"){
                                                        $query->whereIn('services',$cond_vals);
                                                    }
                                                    else if($filter_condition == "OR"){
                                                        $query->orwhereIn('services',$cond_vals);
                                                    }else{
                                                        $query->orwhereIn('services',$cond_vals);
                                                    }
                                                } 
                                                else {
                                                    $cond_vals = explode("|",$vals);
                                                    if($filter_condition == "and"){
                                                        $query->whereIn($filters,$cond_vals);
                                                    }
                                                    else if($filter_condition == "OR"){
                                                        $query->orwhereIn($filters,$cond_vals);
                                                    }else{
                                                        $query->orwhereIn($filters,$cond_vals);
                                                    }
                                                }
                                            }
                                        });
                                    })
                                    ->get(['users.*']);
                                //dd(\DB::getQueryLog());
                                if (count($leadData)) {
                                    $user_count = 0;
                                    $user_ids = array();
                                    foreach ($leadData as $lead) {
                                        echo "\n-- Lead ID: " . $lead->id . "-" . $lead->email . " Name: " . $lead->first_name . "--\n";
                                        $user_count++;
                                        $user_ids[] = $lead->id;
                                    }
                                    $msg_temp = $msg_vals;
                                    echo "\nUser Count: " . $user_count . " Workflow: " . $workflow->id . "\n";
                                    $users = implode(',', $user_ids);
                                    echo $users . "---Template: " . $msg_temp;
                                    echo "\n-----------------";
                                    $seq_indx++;
                                    foreach ($user_ids as $send_to_id) {
                                        if ($workflow->communication_mode == "email") {
                                            $lead_data = DB::table('users')->select('id', 'email', 'first_name', 'last_name')->where('id', $send_to_id)->first();
                                            $emailTemplate = get_email_template($msg_vals);
                                            if ($emailTemplate) {
                                                $email_msg = str_replace('#first_name#', $lead_data->first_name, $emailTemplate->message);
                                                $email_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $email_msg);
                                                $email_msg = str_replace('#sitename#', app_name(), $email_msg);
                                                $email_msg = str_replace('#siteurl#', config('app.url'), $email_msg);
                                                if ($lead->email) {
                                                    // \Log::debug("AutomationWorkflow:send email to:" . $lead_data->email."\n".$email_msg);
                                                    echo "\nAutomationWorkflow:send email to:" . $lead_data->email . "\n";
                                                    $this->queueEmail($lead_data->email, $emailTemplate->subject, $email_msg);
                                                    //store event in lead activity
                                                    UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $workflow->id, 'title' => $emailTemplate->subject, 'detail' => $email_msg]);
                                                }
                                            }
                                        }
                                        if ($workflow->communication_mode == "sms") {
                                            $lead_data = DB::table('users')->select('id', 'dialcode', 'mobile', 'first_name', 'last_name')->where('id', $send_to_id)->first();
                                            $smsTemplate = get_sms_template($msg_vals);
                                            if ($smsTemplate) {
                                                $sms_msg = str_replace('#first_name#', $lead_data->first_name, $smsTemplate->message);
                                                $sms_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $sms_msg);
                                                $sms_msg = str_replace('#sitename#', app_name(), $sms_msg);
                                                $sms_msg = str_replace('#siteurl#', config('app.url'), $sms_msg);

                                                if (User::find($lead_data->id)->sms($sms_msg, $smsTemplate->template_id)) {
                                                    //\Log::debug("AutomationWorkflow:send sms to:" . $lead_data->id."\n".$sms_msg);
                                                    echo "\nAutomationWorkflow:send sms to:" . $lead_data->id . "\n";
                                                    //store event in lead activity
                                                    UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $workflow->id, 'detail' => $sms_msg]);
                                                } else {
                                                    //\Log::debug("AutomationWorkflow: SMS Error- Lead ID:".$lead_data->id);
                                                    echo "\nAutomationWorkflow: SMS Error- Lead ID:" . $lead_data->id;
                                                }
                                            }
                                        }
                                        if ($workflow->communication_mode == "whatsapp") {
                                            $lead_data = DB::table('users')->select('id', 'dialcode', 'whatsapp', 'first_name', 'last_name')->where('id', $send_to_id)->first();
                                            $whtspTemplate = get_whatsapp_template($msg_vals);
                                            if ($whtspTemplate) {
                                                $whtsp_msg = str_replace('#first_name#', $lead_data->first_name, $whtspTemplate->message);
                                                $whtsp_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $whtsp_msg);
                                                $whtsp_msg = str_replace('#sitename#', app_name(), $whtsp_msg);
                                                $whtsp_msg = str_replace('#siteurl#', config('app.url'), $whtsp_msg);

                                                $whtsp_msg = str_replace('{{first_name}}', $lead_data->first_name, $whtspTemplate->message);
                                                $whtsp_msg = str_replace('{{full_name}}', $lead_data->first_name . " " . $lead_data->last_name, $whtsp_msg);
                                                $whtsp_msg = str_replace('{{sitename}}', app_name(), $whtsp_msg);
                                                $whtsp_msg = str_replace('{{siteurl}}', config('app.url'), $whtsp_msg);

                                                if (User::find($lead_data->id)->whatsapp($whtspTemplate->message, $whtspTemplate->hook)) {
                                                    //\Log::debug("AutomationWorkflow:send whatsapp to:" . $lead_data->id."\n".$whtsp_msg);
                                                    echo "\nAutomationWorkflow:send whatsapp to:" . $lead_data->id . "\n";
                                                    //store event in lead activity
                                                    UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $workflow->id, 'detail' => $whtsp_msg]);
                                                } else {
                                                    //\Log::debug("AutomationWorkflow: Whatsapp Error- Lead ID:".$lead_data->id);
                                                    echo "\nAutomationWorkflow: Whatsapp Error- Lead ID:" . $lead_data->id;
                                                }
                                            }
                                        }
                                    }
                                } else {
                                    echo "\n No users found for After(Days)";
                                }
                                AutomationWorkflowActivity::create(['workflow_id' => $workflow->id, 'matched_audience' => $users, 'matched_count' => $user_count, 'message_template' => $msg_vals, 'sequence_index' => $seq_indx]);
                            }
                        }
                    }
                }
                if ($workflow->workflow_type == 'specific_event') {
                    echo "\n-----------------------Workflow Type: specific_event--------------------------";
                    $message_values = json_decode($workflow->message_details);
                    if ($message_values != "") {
                        $seq_indx = 0;
                        foreach ($message_values as $messages => $msg_vals) {
                            $target = $workflow->target;
                            //getting leads data
                            if ($workflow->lead_status) {
                                $leadStatusArray = explode(',', $workflow->lead_status);
                            } else {
                                $leadStatusArray = "";
                            }
                            if ($workflow->lead_filters != "") {
                                $filter_vals = json_decode($workflow->lead_filters);
                            } else {
                                $filter_vals = "";
                            }

                            if ($workflow->student_status) {
                                $stuStatusArray = explode(',', $workflow->student_status);
                            } else {
                                $stuStatusArray = "";
                            }
                            if ($workflow->student_filters != "") {
                                $filter_vals = json_decode($workflow->student_filters);
                            } else {
                                $filter_vals = "";
                            }

                            //if filter_condition
                            if ($workflow->filter_condition) {
                                $filter_condition = $workflow->filter_condition;
                            } else {
                                $filter_condition = "";
                            }
                            // dd(date_format(date_create('2023-10-05'), 'Y-m-d'));
                            $recc_date = array();
                            if ($workflow->repeats && $workflow->repeats == "monthly") {
                                $endDate = now()->addMonth();
                                //$endDate = Carbon::createFromFormat('Y-m-d', '2023-09-30')->addMonth();
                                $startDate = Carbon::createFromFormat('Y-m-d', $workflow->start_date);
                                $diffInMonths = $startDate->diffInMonths($endDate);
                                for ($i = 0; $i < $diffInMonths; $i++) {
                                    $newStartDate = $startDate->addMonthWithNoOverflow();
                                    $recc_date[] = $newStartDate->toDateString();
                                }
                            }
                            if ($workflow->repeats && $workflow->repeats == "yearly") {
                                $endDate = now()->addMonth();
                                $startDate = Carbon::createFromFormat('Y-m-d', $workflow->start_date);
                                $diffInMonths = $startDate->diffInMonths($endDate);
                                for ($i = 0; $i < $diffInMonths; $i++) {
                                    $newStartDate = $startDate->addYearWithNoOverflow();
                                    $recc_date[] = $newStartDate->toDateString();
                                }
                            }
                            if (($messages == "00" && $workflow->start_date == date("Y-m-d")) || ($messages == "00" && in_array(date("Y-m-d"), $recc_date))) {
                                echo "\n On Date :" . $workflow->start_date;
                                //For On Date
                                $start_date = $workflow->start_date;
                                $leadData = User::join('user_details', 'user_details.userid', 'users.id')
                                    ->when($target == "students", function ($query) {
                                        return $query->where('is_lead', 0);
                                    })
                                    ->when($target == "leads", function ($query) {
                                        return $query->where('is_lead', 1);
                                    })
                                    ->when($target == "all_leads_and_students", function ($query) {
                                    })
                                    ->when($target == "staff", function ($query) {
                                        return $query->whereHas('roles', function ($query) {
                                            $query->whereNotIn('name', ['user', 'trainer', 'agent']);
                                        });
                                    })
                                    ->when($target == "agents", function ($query) {
                                        return $query->whereHas('roles', function ($query) {
                                            $query->whereIn('name', ['agent']);
                                        });
                                    })
                                    ->when(!empty($leadStatusArray) && count($leadStatusArray), function ($query) use ($leadStatusArray) {
                                        return $query->WhereIn('lead_status', $leadStatusArray);
                                    })
                                    ->when(!empty($stuStatusArray) && count($stuStatusArray), function ($query) use ($stuStatusArray) {
                                        return $query->WhereIn('overseas_status', $stuStatusArray);
                                    })
                                    ->when(!empty($filter_vals), function ($query) use ($filter_vals, $filter_condition) {
                                        return $query->Where(function ($query) use ($filter_vals, $filter_condition) {
                                            foreach ($filter_vals as $filters => $vals) {
                                                $filters = strtolower(str_replace(' ', '_', $filters));
                                                // if ($filters == "intake") {
                                                //     $intatake_arr =  explode(" ", $vals);
                                                //     $query->where('intake_year', 'LIKE', "%$intatake_arr[1]%");
                                                //     $query->where('intake_month', 'LIKE', "%$intatake_arr[0]%");
                                                // } 
                                                if($filters == "intake"){
                                                    $intk = explode("|",$vals);
                                                    foreach($intk as $intk_vals){
                                                        $intatake_arr =  explode(" ", $intk_vals);
                                                        $query->orwhere('intake_year', 'LIKE', "%$intatake_arr[1]%");
                                                        $query->orwhere('intake_month', 'LIKE', "%$intatake_arr[0]%");
                                                    }
                                                }
                                                else if ($filters == "interested_study_level") {
                                                    $cond_vals = explode("|",$vals);
                                                    if($filter_condition == "and"){
                                                    $query->whereIn('overseas_study_level_selection',$cond_vals);
                                                    }
                                                    else if($filter_condition == "OR"){
                                                        $query->orwhereIn('overseas_study_level_selection',$cond_vals);
                                                    }
                                                    else{
                                                        $query->orwhereIn('overseas_study_level_selection',$cond_vals);
                                                    }
                                                } 
                                                else if($filters == "course_interested_to_study"){
                                                    $cond_vals = explode("|",$vals);
                                                    if($filter_condition == "and"){
                                                        $query->whereIn('overseas_course_intersted',$cond_vals);
                                                    }
                                                    else if($filter_condition == "OR"){
                                                        $query->orwhereIn('overseas_course_intersted',$cond_vals);
                                                    }else{
                                                        $query->orwhereIn('overseas_course_intersted',$cond_vals);
                                                    }
                                                }
                                                else if($filters == "country_of_residence"){
                                                    $cond_vals = explode("|",$vals);
                                                    if($filter_condition == "and"){
                                                        $query->whereIn('country',$cond_vals);
                                                    }
                                                    else if($filter_condition == "OR"){
                                                        $query->orwhereIn('country',$cond_vals);
                                                    }else{
                                                        $query->orwhereIn('country',$cond_vals);
                                                    }
                                                }
                                                else if($filters == "qualification"){
                                                    $cond_vals = explode("|",$vals);
                                                    if($filter_condition == "and"){
                                                        $query->whereIn('highest_level_education',$cond_vals);
                                                    } 
                                                    else if($filter_condition == "OR"){
                                                        $query->orwhereIn('highest_level_education',$cond_vals);
                                                    }else{
                                                        $query->orwhereIn('highest_level_education',$cond_vals);
                                                    }
                                                }
                                                else if($filters == "other_services_interested"){
                                                    $cond_vals = explode("|",$vals);
                                                    if($filter_condition == "and"){
                                                        $query->whereIn('services',$cond_vals);
                                                    }
                                                    else if($filter_condition == "OR"){
                                                        $query->orwhereIn('services',$cond_vals);
                                                    }else{
                                                        $query->orwhereIn('services',$cond_vals);
                                                    }
                                                }
                                                else{
                                                    $cond_vals = explode("|",$vals);
                                                    if($filter_condition == "and"){
                                                        $query->whereIn($filters,$cond_vals);
                                                    }
                                                    else if($filter_condition == "OR"){
                                                        $query->orwhereIn($filters,$cond_vals);
                                                    }else{
                                                        $query->orwhereIn($filters,$cond_vals);
                                                    }
                                                }
                                            }
                                        });
                                    })
                                    ->get(['users.*']);
                                if (count($leadData)) {
                                    $user_count = 0;
                                    $user_ids = array();
                                    foreach ($leadData as $lead) {
                                        echo "\n-- Lead ID: " . $lead->id . "-" . $lead->email . " Name: " . $lead->first_name . "--\n";
                                        $user_count++;
                                        $user_ids[] = $lead->id;
                                    }
                                    $msg_temp = $msg_vals;
                                    echo "\nUser Count: " . $user_count . " Workflow: " . $workflow->id . "\n";
                                    $users = implode(',', $user_ids);
                                    echo $users . "---Template: " . $msg_temp;
                                    echo "\n-----------------";
                                    $seq_indx++;
                                    foreach ($user_ids as $send_to_id) {
                                        if ($workflow->communication_mode == "email") {
                                            $lead_data = DB::table('users')->select('id', 'email', 'first_name', 'last_name')->where('id', $send_to_id)->first();
                                            $emailTemplate = get_email_template($msg_vals);
                                            if ($emailTemplate) {
                                                $email_msg = str_replace('#first_name#', $lead_data->first_name, $emailTemplate->message);
                                                $email_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $email_msg);
                                                $email_msg = str_replace('#sitename#', app_name(), $email_msg);
                                                $email_msg = str_replace('#siteurl#', config('app.url'), $email_msg);
                                                if ($lead->email) {
                                                    // \Log::debug("AutomationWorkflow:send email to:" . $lead_data->email."\n".$email_msg);
                                                    echo "\nAutomationWorkflow:send email to:" . $lead_data->email . "\n";
                                                    $this->queueEmail($lead_data->email, $emailTemplate->subject, $email_msg);
                                                    //store event in lead activity
                                                    UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $workflow->id, 'title' => $emailTemplate->subject, 'detail' => $email_msg]);
                                                }
                                            }
                                        }
                                        if ($workflow->communication_mode == "sms") {
                                            $lead_data = DB::table('users')->select('id', 'dialcode', 'mobile', 'first_name', 'last_name')->where('id', $send_to_id)->first();
                                            $smsTemplate = get_sms_template($msg_vals);
                                            if ($smsTemplate) {
                                                $sms_msg = str_replace('#first_name#', $lead_data->first_name, $smsTemplate->message);
                                                $sms_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $sms_msg);
                                                $sms_msg = str_replace('#sitename#', app_name(), $sms_msg);
                                                $sms_msg = str_replace('#siteurl#', config('app.url'), $sms_msg);

                                                if (User::find($lead_data->id)->sms($sms_msg, $smsTemplate->template_id)) {
                                                    //\Log::debug("AutomationWorkflow:send sms to:" . $lead_data->id."\n".$sms_msg);
                                                    echo "\nAutomationWorkflow:send sms to:" . $lead_data->id . "\n";
                                                    //store event in lead activity
                                                    UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $workflow->id, 'detail' => $sms_msg]);
                                                } else {
                                                    //\Log::debug("AutomationWorkflow: SMS Error- Lead ID:".$lead_data->id);
                                                    echo "\nAutomationWorkflow: SMS Error- Lead ID:" . $lead_data->id;
                                                }
                                            }
                                        }
                                        if ($workflow->communication_mode == "whatsapp") {
                                            $lead_data = DB::table('users')->select('id', 'dialcode', 'whatsapp', 'first_name', 'last_name')->where('id', $send_to_id)->first();
                                            $whtspTemplate = get_whatsapp_template($msg_vals);
                                            if ($whtspTemplate) {
                                                $whtsp_msg = str_replace('#first_name#', $lead_data->first_name, $whtspTemplate->message);
                                                $whtsp_msg = str_replace('#full_name#', $lead_data->first_name . " " . $lead_data->last_name, $whtsp_msg);
                                                $whtsp_msg = str_replace('#sitename#', app_name(), $whtsp_msg);
                                                $whtsp_msg = str_replace('#siteurl#', config('app.url'), $whtsp_msg);

                                                $whtsp_msg = str_replace('{{first_name}}', $lead_data->first_name, $whtspTemplate->message);
                                                $whtsp_msg = str_replace('{{full_name}}', $lead_data->first_name . " " . $lead_data->last_name, $whtsp_msg);
                                                $whtsp_msg = str_replace('{{sitename}}', app_name(), $whtsp_msg);
                                                $whtsp_msg = str_replace('{{siteurl}}', config('app.url'), $whtsp_msg);

                                                if (User::find($lead_data->id)->whatsapp($whtspTemplate->message, $whtspTemplate->hook)) {
                                                    //\Log::debug("AutomationWorkflow:send whatsapp to:" . $lead_data->id."\n".$whtsp_msg);
                                                    echo "\nAutomationWorkflow:send whatsapp to:" . $lead_data->id . "\n";
                                                    //store event in lead activity
                                                    UserActivity::create(['user_id' => $lead_data->id, 'workflow_campaign_id' => $workflow->id, 'detail' => $whtsp_msg]);
                                                } else {
                                                    //\Log::debug("AutomationWorkflow: Whatsapp Error- Lead ID:".$lead_data->id);
                                                    echo "\nAutomationWorkflow: Whatsapp Error- Lead ID:" . $lead_data->id;
                                                }
                                            }
                                        }
                                    }
                                } else {
                                    echo "\n No users found for specific event";
                                }
                                AutomationWorkflowActivity::create(['workflow_id' => $workflow->id, 'matched_audience' => $users, 'matched_count' => $user_count, 'message_template' => $msg_vals, 'sequence_index' => $seq_indx]);
                            }
                        }
                    }
                }
            }
        } else {
            // echo "\nNo Active Workflow Found at: " . $currenttime;
        }
    }


    private function queueEmail($email, $subject, $message)
    {

        if(env('SAAS_MAIL_SERVER') && Activity::where('event', 'email')->where('created_at', 'like', date("Y-m-").'%')->count() >= env('MONTHLY_EMAIL_LIMIT')) {
            \Log::error("ERROR!!!!! MONTHLY_EMAIL_LIMIT Reached!");
            return;
        }

        try {
            if (env('QUEUE_CONNECTION') == 'redis') {
                //Mail::to($email)->queue(new MailSend($subject, $message));
                //\Log::debug("Queue Mail: (BROADCAST MESSAGE) [redis] " . $message);
                EmailJob::dispatch(new BroadcastMailSend($email, $subject, $message));
                activity()->event('email')->log('Email sent To: '.$email. ' Subject: '.$subject);
            } elseif (env('QUEUE_CONNECTION') == 'database') {
                //\Log::debug("Queue Mail: (BROADCAST MESSAGE) [database] " . $message);
                //$delay = round(DB::table('jobs')->count() * (1 / env('EMAILS_PER_SEC', 0.13)));
                $delay = email_delay();
                if(get_site_config('bulk_smtp_host') && get_site_config('bulk_smtp_port') && get_site_config('bulk_smtp_email') && get_site_config('bulk_smtp_password') && get_site_config('bulk_smtp_connection') && get_site_config('bulk_smtp_type')== 'smtp_server'){
                    //\Log::debug("Queue Mail: (BROADCAST MESSAGE) sending through- BROADCAST_SMTP");
                    Mail::mailer('broadcast_smtp')->to($email)->later(now()->addSeconds($delay), new MailSend($subject, $message));
                } 
                elseif(get_site_config('bulk_smtp_type')== 'google'){
                    //\Log::debug("Queue Mail: (BROADCAST MESSAGE) sending through- User_notify");
                    user_notify($email,$subject, $message);
                }
                else{
                    //\Log::debug("Queue Mail: (BROADCAST MESSAGE) sending through- SMTP");
                    Mail::mailer('smtp')->to($email)->later(now()->addSeconds($delay), new MailSend($subject, $message));
                }
                activity()->event('email')->log('Email sent To: '.$email. ' Subject: '.$subject);
            } else {
                //Mail::mailer('smtp')->to($email)->send(new MailSend($subject, $message));
                user_notify($email,$subject, $message);
            }
        } catch (\Exception $e) {
            $message = $e->getMessage();
            //\Log::debug("Queue Mail Error: (BROADCAST MESSAGE) " . $message);
            echo "\nQueue Mail Error: (BROADCAST MESSAGE) " . $message;
        }
    }
}
