<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Auth\User;
use Illuminate\Support\Facades\DB;
use App\Notifications\Backend\UserAlert;
use App\Models\MailTemplates;
use App\Mail\MailSend;
use Illuminate\Support\Facades\Mail;
use Log;

class BirthdayWishes extends Command
{

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'BirthdayWishes';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Birthday Wishes';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        echo "\n-------------" . date('Y-m-d H:i:s') . ": Birthday Wishes Cron Start";
        $currentmonth = date('m');
        $currentdate = date('d');
        $data = DB::table('users')->select('id')->whereNull('deleted_at')->whereRaw('extract(day from birthday) = ?', $currentdate)->whereRaw('extract(month from birthday) = ?', $currentmonth)->get();

        $mail_tpl = MailTemplates::find("BIRTHDAY_WISHES");

        foreach ($data as $sendto) {
            $user = User::find($sendto->id);
            echo "\nProcess User:" . $user->full_name;

            $notify_sms = get_sms_template('BIRTHDAY_WISHES');
            if ($notify_sms && $notify_sms->status) {
                $notify_sms->message = str_replace("#sitename#", app_name(), $notify_sms->message);
                $notify_sms->message = str_replace("#siteurl#", url('/'), $notify_sms->message);
                $notify_sms->message = str_replace("#first_name#", $user->first_name, $notify_sms->message);
                $notify_sms->message = str_replace("#full_name#", $user->full_name, $notify_sms->message);
                $user->sms($notify_sms->message, $notify_sms->template_id);
                echo "\n" . date('Y-m-d H:i:s') . ": Birthday SMS sent";
            }

            if ($mail_tpl && $mail_tpl->status) {
                $email_message = $mail_tpl->message;
                $email_message = str_ireplace("#sitename#", app_name(), $email_message);
                $email_message = str_ireplace("#siteurl#", url(''), $email_message);
                $email_message = str_ireplace("#full_name#", $user->full_name, $email_message);
                $email_message = str_ireplace("#first_name#", $user->first_name, $email_message);
                //$user->notify(new UserAlert($mail_tpl->subject, $email_message));
                user_notify($user, $mail_tpl->subject, $email_message);
                echo "\n" . date('Y-m-d H:i:s') . ": Birthday Email sent";
            }
        }
        echo "\n-------------" . date('Y-m-d H:i:s') . ": Birthday Wishes Cron End";
    }
}
