<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Webklex\IMAP\Facades\Client as ClientFacade;
use Webklex\PHPIMAP\Exceptions\ConnectionFailedException;
use Webklex\PHPIMAP\Exceptions\FolderFetchingException;
use Webklex\PHPIMAP\Folder;
use Illuminate\Support\Facades\DB;
use App\Models\Auth\User;
use App\Models\UserActivity;
use App\Models\Auth\UserDetails;
use App\Models\Auth\ImapMessage;
use Webklex\PHPIMAP\Message;
use Illuminate\Support\Carbon;

class EmailSyncCommand extends Command
{

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'EmailSyncCommand';


    /**
     * Name of the used folder
     *
     * @var string $folder_name
     */
    protected $folder_name = "INBOX";


    /**
     * Holds the account information
     *
     * @var string|array $account
     */
    protected $account = "default";



    public function handle()
    {
        echo "\n" . date('Y-m-d H:i:s') . ": Processing EmailSync Command";

        //checking imap accounts
        $imapData = DB::table('mail_sync_accounts')->where('status', 1)->get();
        if (count($imapData)) {
            foreach ($imapData as $imap) {
                echo "\n====" . date('Y-m-d H:i:s') . ": Processing ACCOUNT: ".$imap->imap_email." ====";
                $account = [
                    'host'  => $imap->imap_host,
                    'port'  => $imap->imap_port,
                    'protocol'  => 'imap',
                    'encryption'    => $imap->imap_connection,
                    'validate_cert' => 'false',
                    'username' => $imap->imap_email,
                    'password' => $imap->imap_password,
                    'authentication' => null,
                    'proxy' => [
                        'socket' => null,
                        'request_fulluri' => false,
                        'username' => null,
                        'password' => null,
                    ],
                    "timeout" => 30,
                ];
                $client = ClientFacade::make($account);
                try {
                    $client->connect();
                } catch (ConnectionFailedException $e) {
                    echo "\n" . date('Y-m-d H:i:s') . ": ERROR: " . $e->getMessage();
                    DB::table('mail_sync_accounts')->where('id', $imap->id)->update(['last_sync_datetime' => now(), 'last_sync_notes' => "<span style='color:red;'>Connection Error</span>: " . $e->getMessage()]);
                    return 1;
                }
                try {
                    $folder = $client->getFolder($this->folder_name);
                } catch (FolderFetchingException $e) {
                    echo "\n" . date('Y-m-d H:i:s') . ": ERROR: " . $e->getMessage();
                    DB::table('mail_sync_accounts')->where('id', $imap->id)->update(['last_sync_datetime' => now(), 'last_sync_notes' => "<span style='color:red;'>Read INBOX Error</span>: " . $e->getMessage()]);
                    return 1;
                }
                try {

                    $fetched_cnt = 0;
                    //$messages = $folder->messages()->since(Carbon::now()->subMinutes(6)->format('Y-m-d H:i:s'))->get();
                    //only date is accepted, not time. still we will do subminutes so that we don't miss any emails
                    $messages = $folder->messages()->since(Carbon::now()->subMinutes(6)->format('Y-m-d'))->get();
                
                    if (count($messages) > 0) {
                        echo "\n" . date('Y-m-d H:i:s') . ": Found Messages: " . count($messages) . " Since: " . Carbon::now()->subMinutes(6)->format('Y-m-d');
                        foreach ($messages as $message) {
                            echo "\n" . date('Y-m-d H:i:s') . ": --- Processing Message ID: " . $message->getMessageId()[0] . " From:" . $message->getFrom()[0]->mail;

                            //check message ID already processed
                            if (ImapMessage::where('message_id', $message->getMessageId()[0])->exists()) {
                                echo " : Message already processed";
                                continue;
                            }
                            $fetched_cnt++;
                            ImapMessage::create([
                                'message_id' => $message->getMessageId()[0],
                            ]);

                            //Checking lead is unique or not
                            $chkUser = User::where('email', $message->getFrom()[0]->mail)->first();
                            if ($chkUser && ($chkUser->hasRole('user') || $chkUser->is_lead)) {
                                echo "\n" . date('Y-m-d H:i:s') . ": Message from a Student";
                                echo '\nAttachments: '.$message->getAttachments()->count()."\n";
                                $att_string = array();
                                foreach($message->getAttachments() as $attach){
                                    $attachment_name = microtime()."_".$attach->name;
                                    $attachment_name = str_replace(" ", "_", $attachment_name);
                                    $attach->save($path = storage_path()."/app/public/email_attachments/", $filename = $attachment_name);
                                    echo "\n--------------------------\ndump: ";
                                    $att_string[] = $attachment_name;
                                }
                                $att_string = implode(",",$att_string);
                                $email_body = $message->getHTMLBody();
                                // $email_body = str_replace(["\r\n","\r","\n"],"",$email_body);
                                UserActivity::create([
                                    'user_id' => $chkUser->id, 
                                    'type' => 'email_received', 
                                    'title' => "Email Received", 
                                    'detail' => "Subject: " . $message->getSubject() . "<br>Message: " . $email_body, 
                                    'staff' => 0,
                                    'attachment'=>$att_string
                                ]);

                                // Send Push App Notification
                                $subject = $message->getSubject();
                                $message = "Subject: " . $message->getSubject() . "<br>Message: " . $email_body;
                                send_in_app_notification(
                                    $chkUser->id, 
                                    $chkUser->id,
                                    "STUDENT_PROFILE_UPDATED", 
                                    $subject, 
                                    $message,
                                    "lead"
                                );
                                
                                echo "\n" . date('Y-m-d H:i:s') . ": Added to User Activity: " . $message->getFrom()[0]->mail . " MSG ID: " . $message->getMessageId()[0];
                            }

                            //Create lead
                            if (!$chkUser && $imap->create_lead == 1) {

                                echo "\n" . date('Y-m-d H:i:s') . ": Checking for Email2Lead";
                                if ($imap->filter_subject_type == "equals" && $imap->filter_subject_value == $message->getSubject()) {

                                    $name = explode(" ", $message->getFrom()[0]->personal);
                                    if (isset($name[1])) {
                                        $last_name = $name[1];
                                    } else {
                                        $last_name = "";
                                    }
                                    $lead = User::create([
                                        'first_name' => $name[0],
                                        'last_name' => $last_name,
                                        'email' => $message->getFrom()[0]->mail,
                                        'lead_status' => get_default_lead_status(),
                                        'lead_source' => 'Email',
                                        'next_followup' => now(),
                                        'is_lead'   => 1
                                    ]);
                                    $userdetails = new UserDetails([
                                        'userid'    => $lead->id,
                                        'lead_notes' => "EMAIL2LEAD<br>Subject: " . $message->getSubject() . "<br>Message:<br>" . $email_body
                                    ]);
                                    $userdetails->save();
                                    echo "\n" . date('Y-m-d H:i:s') . ":[filter_subject_type=equals] Lead generated for " . $message->getFrom()[0]->mail;

                                } elseif ($imap->filter_subject_type == "contains" && str_contains($message->getSubject(), $imap->filter_subject_value)) {

                                    $name = explode(" ", $message->getFrom()[0]->personal);
                                    if (isset($name[1])) {
                                        $last_name = $name[1];
                                    } else {
                                        $last_name = "";
                                    }
                                    $lead = User::create([
                                        'first_name' => $name[0],
                                        'last_name' => $last_name,
                                        'email' => $message->getFrom()[0]->mail,
                                        'lead_status' => get_default_lead_status(),
                                        'lead_source' => 'Email',
                                        'next_followup' => now(),
                                        'is_lead'   => 1
                                    ]);
                                    $userdetails = new UserDetails([
                                        'userid'    => $lead->id,
                                        'lead_notes' => "EMAIL2LEAD<br>Subject: " . $message->getSubject() . "<br>Message:<br>" . $email_body
                                    ]);
                                    $userdetails->save();
                                    echo "\n" . date('Y-m-d H:i:s') . ":[filter_subject_type=contains] Lead generated for " . $message->getFrom()[0]->mail;

                                } elseif ($imap->filter_subject_type == "all") {
                                    //create all
                                    echo "\n" . date('Y-m-d H:i:s') . ": Message ID: " . $message->getMessageId()[0];
                                    $name = explode(" ", $message->getFrom()[0]->personal);
                                    if (isset($name[1])) {
                                        $last_name = $name[1];
                                    } else {
                                        $last_name = "";
                                    }
                                    $lead = User::create([
                                        'first_name' => $name[0],
                                        'last_name' => $last_name,
                                        'email' => $message->getFrom()[0]->mail,
                                        'lead_status' => get_default_lead_status(),
                                        'lead_source' => 'Email',
                                        'next_followup' => now(),
                                        'is_lead'   => 1
                                    ]);
                                    $userdetails = new UserDetails([
                                        'userid'    => $lead->id,
                                        'lead_notes' => "EMAIL2LEAD<br>Subject: " . $message->getSubject() . "<br>Message:<br>" . $email_body
                                    ]);
                                    $userdetails->save();
                                    echo "\n" . date('Y-m-d H:i:s') . ":[filter_subject_type=all] Lead generated for " . $message->getFrom()[0]->mail;
                                }
                            }
                        }
                    } else {
                        echo "\n" . date('Y-m-d H:i:s') . ": No new Emails";
                    }
                    DB::table('mail_sync_accounts')->where('id', $imap->id)->update(['last_sync_datetime' => now(), 'last_sync_notes' => $fetched_cnt . " emails fetched"]);
                } catch (\Exception $e) {
                    echo "\n" . date('Y-m-d H:i:s') . ": ERROR: " . $e->getMessage();
                    DB::table('mail_sync_accounts')->where('id', $imap->id)->update(['last_sync_datetime' => now(), 'last_sync_notes' => "<span style='color:red;'>Error</span>: " . $e->getMessage()]);
                    return 1;
                }
            }
        }
        echo "\n" . date('Y-m-d H:i:s') . ": EmailSync Command End";
        return 0;
    }
}
