<?php
namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Webklex\IMAP\Facades\Client as ClientFacade;
use Webklex\PHPIMAP\Exceptions\ConnectionFailedException;
use Webklex\PHPIMAP\Exceptions\FolderFetchingException;
use Webklex\PHPIMAP\Folder;
use Illuminate\Support\Facades\DB;
use App\Models\Auth\User;
use App\Models\Auth\UserDetails;
use App\Models\Auth\ImapMessage;
use Webklex\PHPIMAP\Message;

class EmailToLeadCommand extends Command {

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'EmailToLeadCommand';


    /**
     * Name of the used folder
     *
     * @var string $folder_name
     */
    protected $folder_name = "INBOX";


    /**
     * Holds the account information
     *
     * @var string|array $account
     */
    protected $account = "default";

       public function handle() {
        echo "\n".date('Y-m-d H:i:s').": Processing Email to Lead";
        if (is_array($this->account)) {
            $client = ClientFacade::make($this->account);
        }else{
            $client = ClientFacade::account($this->account);
        }

        try {
            $client->connect();
        } catch (ConnectionFailedException $e) {
            Log::error($e->getMessage());
            return 1;
        }

        /** @var Folder $folder */
        try {
            $folder = $client->getFolder($this->folder_name);
        } catch (ConnectionFailedException $e) {
            Log::error($e->getMessage());
            return 1;
        } catch (FolderFetchingException $e) {
            Log::error($e->getMessage());
            return 1;
        }

        try {

            $messages = $folder->messages()->since(now())->get();
            if(count($messages)>0){
                echo "\n".date('Y-m-d H:i:s').": Found Messages: ".count($messages);

               foreach($messages as $message){
                    //Checking lead is unique or not
                    $chklead = DB::table('users')->where('email',$message->getFrom()[0]->mail)->first();
                    if(!$chklead){
                        // echo $message->getFrom()[0]->personal;
                        // echo $message->getFrom()[0]->mail.'<br />';
                        // //echo $message->getSubject().'<br />';
                        // //echo 'Attachments: '.$message->getAttachments()->count().'<br />';
                        // echo $message->getTextBody();

                        echo "\n".date('Y-m-d H:i:s').": Message ID: ".$message->getMessageId()[0];

                        $name = explode(" ", $message->getFrom()[0]->personal);

                        if(isset($name[1])){
                            $last_name = $name[1];
                        }
                        else{
                            $last_name = "";
                        }
                        $imap = ImapMessage::create([
                            'message_id' => $message->getMessageId()[0],
                        ]);
                        // $lead = Lead::create([
                        //     'first_name' => $name[0],
                        //     'last_name' => $last_name,
                        //     'email' => $message->getFrom()[0]->mail,
                        //     'status' => get_default_lead_status(),
                        //     'lead_source' => 'Email',
                        //     'next_followup' => now(),
                        //     'description' => "Subject: ".$message->getSubject()."\n Message:\n".$message->getTextBody()
                        // ]);
                        $lead = User::create([
                            'first_name' => $name[0],
                            'last_name' => $last_name,
                            'email' => $message->getFrom()[0]->mail,
                            'lead_status' => get_default_lead_status(),
                            'lead_source' => 'Email',
                            'next_followup' => now(),
                            'is_lead'   => 1
                        ]);
                        $userdetails = new UserDetails([
                            'userid'    => $lead->id,
                            'lead_notes' => "Subject: ".$message->getSubject()."\n Message:\n".$message->getTextBody()
                        ]);
                        $userdetails->save();
                        
                        echo "\n".date('Y-m-d H:i:s').": Lead generated for ".$message->getFrom()[0]->mail;
                    }                    
                }
            }else{
                echo "\n".date('Y-m-d H:i:s').": No new Emails";
            }

        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return 1;
        }
        echo "\n".date('Y-m-d H:i:s').": Email to Lead End";
        return 0;
    }

}