<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Webklex\IMAP\Facades\Client as ClientFacade;
use Webklex\PHPIMAP\Exceptions\ConnectionFailedException;
use Webklex\PHPIMAP\Exceptions\FolderFetchingException;
use Webklex\PHPIMAP\Folder;
use Illuminate\Support\Facades\DB;
use App\Models\Auth\User;
use App\Models\Auth\UserDetails;
use App\Helpers\General\HtmlHelper;

class IvrToLeadCommand extends Command
{

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'IvrToLeadCommand';
    protected $description = 'Ivr to Lead Conversion';

    public function handle()
    {
        echo "\n" . date('Y-m-d H:i:s') . ": Processing IVR to Lead";

        try {
            $TWILIO_ACCOUNT_SID = env('IVR_TWILIO_SENDERID');
            $TWILIO_AUTH_TOKEN = env('IVR_TWILIO_AUTH_TOKEN');
            $TWILIO_PHONE = get_site_config('IVR_TWILIO_PHONE');
            $today = date('Y-m-d');
            $url = "https://api.twilio.com/2010-04-01/Accounts/$TWILIO_ACCOUNT_SID/Calls.json?StartTime=$today";
            $from = $TWILIO_PHONE;
            $data = array(
                'DateCreated' => $from,
            );
            //$post = http_build_query($data);
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_POST, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
            curl_setopt($ch, CURLOPT_USERPWD, "$TWILIO_ACCOUNT_SID:$TWILIO_AUTH_TOKEN");
            //curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
            $resp = curl_exec($ch);
            curl_close($ch);
            \Log::debug("IVR Response :  " . $resp);
            $obj = json_decode($resp);
            echo "\n Numbers found: " . count($obj->calls);
            if ($obj->calls) {
                foreach ($obj->calls as $call_data) {
                    //Checking lead is unique or not
                    $chklead = DB::table('leads')->where('mobile', $call_data->from)->first();
                    if (!$chklead) {
                        //echo "\n".$call_data->from;
                        $lead = User::create([
                            'status' => get_default_lead_status(),
                            'lead_source' => 'IVR',
                            'mobile' => $call_data->from,
                            'email'  => microtime() . "@demo.com",
                            'next_followup' => now()
                        ]);
                        $userdetails = new UserDetails([
                            'userid'    => $lead->id
                        ]);                        
                        echo "\n" . date('Y-m-d H:i:s') . ": Lead generated for " . $call_data->from;
                    }
                }
            } else {
                echo "\n No new numbers today.";
            }
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return 1;
        }
        echo "\n" . date('Y-m-d H:i:s') . ": IVR to Lead End";
        return 0;
    }
}
