<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Auth\User;
use Illuminate\Support\Facades\DB;
use App\Notifications\Backend\UserAlert;
use App\Models\MailTemplates;
use App\Models\Auth\ReferralReward;
use App\Mail\MailSend;
use App\Recipients\AdminRecipient;
use App\Notifications\Frontend\AdminAlert;
use Illuminate\Support\Facades\Mail;
use Log;

/**
 * Send a email notification to the concerned staff with leads to followup in next 1 hour
 * This job to execute at 55th minute hourly.
 */

class LeadFollowupMissedNotification extends Command
{

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'LeadFollowupMissedNotification';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Lead Follow up missed notification';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $subject = "Follow-ups missed";

        echo "\n" . date('Y-m-d H:i:s') . ": LeadFollowupMissedNotification: start";
        //Log::debug("Cron LeadFollowupMissedNotification: start");

        $today = date('Y-m-d');
        echo "\n" . $today . ": Find leads with missed followup for: " . $today;
        $leads = DB::table('users')->where("next_followup", 'like', '%'.$today.'%')->get();
    if(get_site_config('lead_followup_missed_notification')) {
        if (count($leads)) {

            $to_notify = array();
            foreach ($leads as $lead) {
                echo "\n" . date('Y-m-d H:i:s') . ": Lead: " . $lead->id . ', ' . $lead->first_name . " " . $lead->last_name . " Assigned-to:" . $lead->assigned_to;
                if ($lead->assigned_to) {
                    if (isset($to_notify[$lead->assigned_to])) {
                        $to_notify[$lead->assigned_to] .= "<br><a href=\"" . url("admin/leads?lead_info=" . $lead->id) . "\">".$lead->first_name . " " . $lead->last_name ."</a> Scheduled Follow-up time: " . \Carbon\Carbon::parse($lead->next_followup)->format('d M Y g:i A');
                    } else {
                        $to_notify[$lead->assigned_to] = "<a href=\"" . url("admin/leads?lead_info=" . $lead->id) . "\">".$lead->first_name . " " . $lead->last_name ."</a> Scheduled Follow-up time: " . \Carbon\Carbon::parse($lead->next_followup)->format('d M Y g:i A');
                    }
                }
            }

            //Send notifications
            if (count($to_notify)) {

                foreach ($to_notify as $staff_id => $message) {
                    $staff = User::find($staff_id);

                    if ($staff) {
                        $staff_reporting_to_mail = get_user_email_by_id($staff->reporting_to);
                        // $email_message = "Hi $staff->name,<br><br>Follow-up is missed:<br><br>".$message;
                        $email_message = "Hi,<br><br>Follow-up is missed:<br><br>".$message;
                        try {
                            //Mail::to($staff->email)->cc($staff_reporting_to_mail)->send(new MailSend($subject, $email_message));
                            user_notify($staff->email,$subject, $email_message, $staff_reporting_to_mail);
                            echo "\n" . date('Y-m-d H:i:s') . ": Followup missed Notification email sent to: " . $staff->email." Message:".$email_message;
                        } catch (\Exception $e) {
                            $err_message = $e->getMessage();
                            echo "\n" . "Mail Error: (Lead Followup missed) ".$err_message;
                            //\Log::debug("Mail Error: (Lead Followup missed) ".$err_message);   
                        }

                        if($staff->reporting_to !=1 && $staff->assigned_to !=1){
                            $recipient = new AdminRecipient();
                            try {
                                //$recipient->notify(new AdminAlert($subject, $email_message));
                                user_notify($recipient, $subject, $email_message);
                                echo "\n" . date('Y-m-d H:i:s') . ": Followup missed Notification email sent to Admin for: " . $staff->email." Message:".$email_message;
                            } catch (\Exception $e) {
                                $message = $e->getMessage();
                                //\Log::debug("Mail Error: Admin- ($subject) " . $message);
                                echo "\n" . "Mail Error: Admin- ($subject) " . $message;
                                
                            }
                        }

                    }
                }
            }
        } else {
            echo "\n" . date('Y-m-d H:i:s') . ": No leads found!";
        }
        }
        else {
            echo "\n" . date('Y-m-d H:i:s') . ": lead_followup_missed_notification not enabled";
        }
        echo "\n" . date('Y-m-d H:i:s') . ": LeadFollowupMissedNotification: end";
        // Log::debug("Cron LeaFdFollowupNotification: end");
    }
}
