<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Auth\User;
use Illuminate\Support\Facades\DB;
use App\Notifications\Backend\UserAlert;
use App\Models\MailTemplates;
use App\Models\Auth\ReferralReward;
use App\Mail\MailSend;
use Illuminate\Support\Facades\Mail;
use Log;

/**
 * Send a email notification to the concerned staff with leads to followup in next 1 hour
 * This job to execute at 55th minute hourly.
 */

class LeadFollowupNotification extends Command
{

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'LeadFollowupNotification';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Lead Follow up notification';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $subject = "Follow-ups";

        echo "\n" . date('Y-m-d H:i:s') . ": LeadFollowupNotification: start";
        // Log::debug("Cron LeadFollowupNotification: start");
        $next_hour = \Carbon\Carbon::now()->addMinutes(5)->format('Y-m-d H:');
        // dd($next_hour);
        echo "\n" . date('Y-m-d H:i:s') . ": Find leads with Next followup time like: " . $next_hour;
        $leads = DB::table('users')->where("next_followup", 'like', $next_hour . '%')->get();
    if(get_site_config('lead_followup_reminder_notification')) {
        if (count($leads)) {

            $to_notify = array();
            foreach ($leads as $lead) {
                echo "\n" . date('Y-m-d H:i:s') . ": Lead: " . $lead->id . ', ' . $lead->first_name . " " . $lead->last_name . " Assigned-to:" . $lead->assigned_to;
                if ($lead->assigned_to) {
                    if (isset($to_notify[$lead->assigned_to])) {
                        $to_notify[$lead->assigned_to] .= "<br>Time:" . \Carbon\Carbon::parse($lead->next_followup)->format('g:i a') . " Name:" . $lead->first_name . " " . $lead->last_name . ", Email:" . $lead->email . ", Ph:" . $lead->mobile . " <a href=\"" . url("admin/leads?lead_info=" . $lead->id) . "\">View Details</a>";
                    } else {
                        $to_notify[$lead->assigned_to] = "Time:" . \Carbon\Carbon::parse($lead->next_followup)->format('g:i a') . " Name:" . $lead->first_name . " " . $lead->last_name . ", Email:" . $lead->email . ", Ph:" . $lead->mobile . " <a href=\"" . url("admin/leads?lead_info=" . $lead->id) . "\">View Details</a>";
                    }
                }
            }

            //Send notifications
            if (count($to_notify)) {

                foreach ($to_notify as $staff_id => $message) {
                    $staff = User::find($staff_id);

                    if ($staff) {
                        $email_message = "Dear $staff->name,<br><br>Follow-ups for next hour:<br><br>".$message;
                        try {
                            //Mail::to($staff->email)->send(new MailSend($subject, $email_message));
                            user_notify($staff->email,$subject, $email_message);
                            echo "\n" . date('Y-m-d H:i:s') . ": Notification email sent to: " . $staff->email." Message:".$message;
                        } catch (\Exception $e) {
                            $err_message = $e->getMessage();
                            //\Log::debug("Mail Error: (Lead to follow-up) ".$err_message);  
                            echo "\n" . "Mail Error: (Lead to follow-up) ".$err_message; 
                        }

                        $notify_sms = get_sms_template('STAFF_LEAD_FOLLOWUP');
                        if ($notify_sms && $notify_sms->status) {
                            $notify_sms->message = str_replace("#sitename#", app_name(), $notify_sms->message);
                            $notify_sms->message = str_replace("#siteurl#", url('/'), $notify_sms->message);
                            $notify_sms->message = str_replace("#first_name#", $staff->first_name, $notify_sms->message);
                            $notify_sms->message = str_replace("#full_name#", $staff->full_name, $notify_sms->message);
                            $notify_sms->message .= $message;
                            $staff->sms($notify_sms->message, $notify_sms->template_id);
                            echo "\n" . date('Y-m-d H:i:s') . ": Notification SMS sent to: ".$staff->name;
                        }
                    }
                }
            }
        } else {
            echo "\n" . date('Y-m-d H:i:s') . ": No leads found!";
        }
        }
        else {
            echo "\n" . date('Y-m-d H:i:s') . ": lead_followup_reminder_notification not enabled";
        }
        echo "\n" . date('Y-m-d H:i:s') . ": LeadFollowupNotification: end";
        // Log::debug("Cron LeaFdFollowupNotification: end");
    }
}
