<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Auth\User;
use App\Models\Auth\LeadStatus;
use Illuminate\Support\Facades\DB;
use App\Notifications\Backend\UserAlert;
use App\Models\MailTemplates;
use App\Models\Auth\ReferralReward;
use App\Mail\MailSend;
use App\Recipients\AdminRecipient;
use App\Notifications\Frontend\AdminAlert;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Carbon;
use Log;

/**
 * Send a email notification to the concerned staff & manager with leads that missed the lead funnel deadline
 * This job to execute daily evening.
 */

class LeadStageDeadlineMissedNotification extends Command
{

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'LeadStageDeadlineMissedNotification';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Lead stage deadline missed notification';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

        echo "\n------------------" . date('Y-m-d H:i:s') . ": LeadStageDeadlineMissedNotification: start" . "\n";

        $LeadStatus = DB::table('lead_status')->orderBy("deadline", 'asc')->get();

        if (get_site_config('lead_stage_deadline_missed_notification')) {

            if (count($LeadStatus)) {
                $all_leads = [];
                foreach ($LeadStatus as $status) {
                    if ($status->deadline) {
                        echo "\n\n---------Processing Deadline status:" . $status->status;
                        $check_lead_id = array();
                        $aboveLeadStatus = DB::table('lead_status')->where('display_order', '<', $status->display_order)->orderBy("display_order", 'asc')->get();

                        foreach ($aboveLeadStatus as $aboveStatus) {
                            echo "\n--Check lead status leads:" . $aboveStatus->status;
                            $chk_above_leads = DB::table('users')
                                ->where('is_lead', 1)
                                ->whereRaw('now() > DATE_ADD(created_at, INTERVAL ' . $status->deadline . ' DAY)')
                                ->where("lead_status", $aboveStatus->status)->get();
                            foreach ($chk_above_leads as $chk_above_lead) {
                                if (!in_array($chk_above_lead->id, $all_leads)) {

                                    echo "\nFound Match:" . $chk_above_lead->first_name . " " . $chk_above_lead->last_name . "(" . $chk_above_lead->id . ")";
                                    $all_leads[] = $chk_above_lead->id;
                                    if ($chk_above_lead->assigned_to) {
                                        $check_lead_id[$chk_above_lead->assigned_to]['lead'][] = $chk_above_lead->id;
                                        $la = Carbon::parse($chk_above_lead->created_at)->diffInDays();
                                        $check_lead_id[$chk_above_lead->assigned_to]['lead_details'][] = $chk_above_lead->first_name . " " . $chk_above_lead->last_name . " (" . $chk_above_lead->email . ") (Status: " . $aboveStatus->status . ") (LA: " . $la . " Days)";
                                        // $check_lead_id[$chk_above_lead->assigned_to]['lead_email'][] = $chk_above_lead->email;
                                        $check_lead_id[$chk_above_lead->assigned_to]['status'] = $status->status;
                                        //$check_lead_id[$chk_above_lead->assigned_to]['reporting_to'] = get_user_email_by_id($chk_above_lead->reporting_to);
                                        $check_lead_id[$chk_above_lead->assigned_to]['deadline'] = $status->deadline;
                                    } else {
                                        echo " - NOT ASSIGNED TO STAFF!!";
                                    }
                                }
                            }
                        }

                        //print_r($check_lead_id);
                        echo "\n\n---Send notification emails";
                        foreach ($check_lead_id as $staff_id => $lead) {

                            echo "\nProcess staff id:" . $staff_id;
                            $staffData = User::where('id', $staff_id)->first();
                            if ($staffData) {
                                if($staffData->id == 1) {
                                    //Superadmin. avoid double email
                                    $staff_reporting_to_mail = "";
                                } else {
                                    $staff_reporting_to_mail = get_user_email_by_id($staffData->reporting_to);
                                }
                                $lead_details = "";
                                if (count($lead['lead_details'])) {
                                    $lead_details = "<ol>";
                                    foreach ($lead['lead_details'] as $lead_detail) {
                                        $lead_details .= "<li>" . $lead_detail . "</li>";
                                    }
                                    $lead_details .= "</ol>";
                                }

                                $subject = count($lead['lead']) . " Leads missed deadline for leads stage: " . $lead['status'];
                                $email_message = "Hi, <br><br>The following leads did not reach the stage: <strong>" . $lead['status'] . "</strong>, in the deadline(" . $lead['deadline'] . "days):<br><br>" . $lead_details;
                                try {
                                    //Mail::to($staffData->email)->cc($staff_reporting_to_mail)->send(new MailSend($subject, $email_message));
                                    user_notify($staffData->email,$subject, $email_message, $staff_reporting_to_mail);
                                    echo "\n" . date('Y-m-d H:i:s') . ": Leads missed deadline notification email sent to: " . $staffData->email . " (CC)" . $staff_reporting_to_mail . " Message:" . $email_message;
                                } catch (\Exception $e) {
                                    $err_message = $e->getMessage();
                                    echo "\nMail Error: (Leads missed deadline notification) " . $err_message;
                                }
                                if($staffData->reporting_to !=1 && $staffData->assigned_to !=1){
                                    $recipient = new AdminRecipient();
                                    try {
                                        //$recipient->notify(new AdminAlert($subject, $email_message));
                                        user_notify($recipient, $subject, $email_message);
                                        echo "\n" . date('Y-m-d H:i:s') . ": Leads missed deadline notification email sent to Admin for: " . $staffData->email." Message:".$email_message;
                                    } catch (\Exception $e) {
                                        $message = $e->getMessage();
                                        echo "\n" . "Mail Error: Admin- ($subject) " . $message;
                                        //\Log::debug("Mail Error: Admin- ($subject) " . $message);
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                echo "\n" . date('Y-m-d H:i:s') . ": No leads found!";
            }
        } else {
            echo "\n" . date('Y-m-d H:i:s') . ": lead_stage_deadline_missed_notification not enabled";
        }
        echo "\n\n---------------------" . date('Y-m-d H:i:s') . ": LeadStageDeadlineMissedNotification: end";
    }
}
