<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Auth\User;
use Illuminate\Support\Facades\DB;
use App\Notifications\Backend\UserAlert;
use App\Models\MailTemplates;
use App\Models\Auth\ReferralCommission;
use App\Repositories\Backend\Auth\UserRepository;

class MonthlyReferralReport extends Command {

//----- Student referring other Students ------//
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'MonthlyReferralReport';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Monthly Referral Report';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct() {
        parent::__construct();
    }
    /**
     * Execute the console command.
     *
     * @return int
     */
public function handle() {
    $proc_mth = date("Y-m", strtotime("last month"));
    echo "\n---PROCESSING REFERRAL REPORT ON: ".date("Y-m-d")." Of month: ".$proc_mth;

    $users = User::where('active', 1)->orderBy('created_at')->get();
    if (count($users)) {
        $reff_count = "";
        foreach ($users as $user) {
            $referred_users = User::where('ref_by', $user->id)
                        ->when(!empty($proc_mth), function ($query) use ($proc_mth) {
                            $month = explode("-", $proc_mth);
                            $year = $month[0];
                            $month = $month[1];
                            $query->whereYear('created_at', '=', $year)
                            ->whereMonth('created_at', '=', $month);
                            return $query;
                        })->get();

            if (count($referred_users)) {
                $reff_count = count($referred_users);
                $tableData = "";
                $tableData .= "<table border=1 style='width:100%;border-collapse: collapse;text-align:center;'><thead><tr><th>Signup Date</th><th>Student</th><th>Status</th></tr></thead><tbody>";
                foreach($referred_users as $referred_user){
                    if(check_referral($user->id, $referred_user->id)){
                            $ref_status = "Verified";
                    }else{
                        $ref_status = "Pending";
                    }     
                    $tableData .= "<tr><td>".get_date_formated($referred_user->created_at)."<td>".$referred_user->first_name." ".$referred_user->last_name."<td>".$ref_status."</tr>";
                }
                $tableData .= "</tbody></table>";
            //\Log::debug("REFERRAL REPORT: sending mail to referer");
                //Notify referer
                $month = explode("-", $proc_mth);
                $year = $month[0];
                $month = $month[1];
                $user = (new UserRepository())->where('id', $user->id)->first();
                $mail_tpl = MailTemplates::find("MONTHLY_REFERRALS_REPORT");
                if ($mail_tpl && $mail_tpl->status) {
                    $email_message = $mail_tpl->message;                     
                    $email_message = str_ireplace("#sitename#", app_name(), $email_message);
                    $email_message = str_ireplace("#siteurl#", url(''), $email_message);
                    $email_message = str_ireplace("#first_name#", $user->first_name, $email_message);
                    $email_message = str_ireplace("#full_name#", $user->full_name, $email_message);
                    $email_message = str_ireplace("#month_year#", date("F", mktime(0, 0, 0, $month, 10)).' '.$year, $email_message);
                    $email_message = str_ireplace("#referral_table#", $tableData, $email_message);
                    $email_message = str_ireplace("#referral_count#", $reff_count, $email_message);
                    $email_message = str_ireplace("#affiliate_url#", config('app.url')."/?ref=".$user->refcode, $email_message);
                    if ($mail_tpl && $mail_tpl->status) {
                        try{
                            user_notify($user,$mail_tpl->subject, $email_message);
                            echo "\n" . date('Y-m-d H:i:s') . ": REFERRAL REPORT - Notify Referer email sent to ".$user->id." Message:".$email_message;
                        }catch (\Exception $e) {
                            $message = $e->getMessage();
                            //\Log::debug("Mail Error: (REFERRAL REPORT - Notify Referer) ".$message);
                            echo "\n Mail Error: (REFERRAL REPORT - Notify Referer) ".$message;
                        }
                    }
                }
            }
        }
    }
        echo "\n---PROCESSING REFERRAL REPORT End";
    }

}
