<?php
namespace App\Console\Commands;

use App\Models\Auth\User;
use Google\Service\Sheets;
use App\Models\UserActivity;
use Illuminate\Console\Command;
use App\Models\Auth\UserDetails;
use Google\Client as GoogleClient;
use App\Http\Controllers\GoogleSheetSyncController;
use Illuminate\Support\Facades\Log;

class SyncSheets extends Command{
    protected $signature = 'SyncSheets';
    /* ====== Old Function =======*/
    /*
        public function handle(){
            try {
                \Log::debug("Creating Lead from Google Sheet....");
                $GoogleController = new GoogleSheetSyncController();
                User::whereNotNull('google_token')->get()->each(function($user) use ($GoogleController){
                    $token = $user->google_token;
                    if (!$token) return;
                    
                    \Log::debug("User token found!!");
                    $GoogleController->getGoogleClientFromUser($user);

                    try {
                        $client = new GoogleClient();
                        $client->setAuthConfig(storage_path('app/google-sheet/credentials.json'));
                        $client->setAccessToken($token);
                        $sheetsService = new Sheets($client);
                    } catch (\Throwable $e) {
                        \Log::error("Google Client Init Error: " . $e->getMessage());
                        return; // or continue
                    }

                    $this->line('sheets message'.count($user->sheets));
                    \Log::debug("Executing foreach loop....");
                    foreach ($user->sheets as $sheet) {
                        \Log::debug("Inside first foreach loop....");
                        $response = $sheetsService->spreadsheets_values->get($sheet->sheet_id, 'Sheet1');
                        $rows = $response->getValues() ?? [];

                        $this->line('Regular message'.count($rows));
                        $id = $created_time = $ad_id = $ad_name = $adset_id = $adset_name = $campaign_id = $campaign_name = $form_id = $form_name = 
                        $is_organic = $platform = $whatsapp_number = $college = $year_of_graduation = $city = $full_name = $email = $phone_number = 
                        $is_qualified = $is_quality = $is_converted = null;
                        $i = 0;
                        $headers = $rows[0]; // First row contains column names
                        $dataRows = array_slice($rows, 1); // Remaining rows are data
                        foreach ($rows as $row) {
                            \Log::debug("Inside second foreach loop....", ["data" => $row]);
                            try {
                                $i++;
                                
                                if($i <= 1){
                                    \Log::debug("Skipping Header Row");
                                    continue;
                                } 

                                // Now access each column safely
                                $id = $row[0] ?? "";
                                $created_time = $row[1] ?? "";
                                $ad_id = $row[2] ?? "";
                                $ad_name = $row[3] ?? "";
                                $adset_id = $row[4] ?? "";
                                $adset_name = $row[5] ?? "";
                                $campaign_id = $row[6] ?? "";
                                $campaign_name = $row[7] ?? "";
                                $form_id = $row[8] ?? "";
                                $form_name = $row[9] ?? "";
                                $is_organic = $row[10] ?? "";
                                $platform = $row[11] ?? "";
                                $whatsapp_number = $row[12] ? substr($row[12], 0, config('app.USER_MOBILE_MAX_LENGTH')) : "";
                                $college = $row[13] ?? "";
                                $year_of_graduation = $row[14] ?? "";
                                $city = $row[15] ?? "";
                                $full_name = $row[16] ?? "";
                                $email = $row[17] ?? "";
                                $phone_number = $row[18] ? substr($row[18], 0, config('app.USER_MOBILE_MAX_LENGTH')) : "";
                                $is_qualified = $row[19] ?? "";
                                $is_quality = $row[20] ?? "";
                                $is_converted = $row[21] ?? "";

                                if (!$email && !$phone_number){
                                    \Log::debug("Mobile and Email are Empty!!....");
                                    continue;
                                } 

                                if($email && !User::where('email', $email)->exists()){
                                    \Log::debug("Email is unique and creating the Lead....");
                                    $notes = "Meta ID: " . $id . ", College: " . $college . ", Year of graduation: " . $year_of_graduation;
                                    $leaddetails = new User([
                                        'first_name' => $full_name,
                                        'email' => $email,
                                        'dialcode' => env('USER_DEFAULT_DIALCODE'),
                                        'mobile' => $phone_number,
                                        'whatsapp_dialcode' => env('USER_DEFAULT_DIALCODE'),
                                        'whatsapp' => $whatsapp_number,
                                        'city' => $city,
                                        'student_type' => 'course',
                                        'lead_status' => get_default_lead_status(),
                                        'confirmed' => 1,
                                        'is_lead'   => 1
                                    ]);
                                    $leaddetails->save();
                                    \Log::debug("Lead created, now creating Lead details....");

                                    $userdetails = new UserDetails([
                                        'userid'    => $leaddetails->id,
                                        'lead_source_detail' => $form_name,
                                        'campaign_id' => $campaign_id,
                                        'lead_campaign_name' => $campaign_name,
                                        'lead_notes' => $notes
                                    ]);
                                    $userdetails->save();
                                    \Log::debug("Lead Details created, now creating User Activity....");

                                    $followup = new UserActivity;
                                    $followup->user_id = $leaddetails->id;
                                    $followup->type = 'others';
                                    $followup->staff = 0;
                                    $followup->detail = "LEAD CREATED BY GOOGLE SHEET.";
                                    $followup->save();
                                } elseif($phone_number && !User::where('mobile', $phone_number)->exists()){
                                    \Log::debug("Email is empty and mobile is unique and creating the Lead....");
                                    $notes = "Meta ID: " . $id . ", College: " . $college . ", Year of graduation: " . $year_of_graduation;
                                    $leaddetails = new User([
                                        'first_name' => $full_name,
                                        'email' => $email,
                                        'dialcode' => env('USER_DEFAULT_DIALCODE'),
                                        'mobile' => $phone_number,
                                        'whatsapp_dialcode' => env('USER_DEFAULT_DIALCODE'),
                                        'whatsapp' => $whatsapp_number,
                                        'city' => $city,
                                        'student_type' => 'course',
                                        'lead_status' => get_default_lead_status(),
                                        'confirmed' => 1,
                                        'is_lead'   => 1
                                    ]);
                                    $leaddetails->save();
                                    \Log::debug("Email is empty and mobile is unique. Lead created now creating Lead Details....");

                                    $userdetails = new UserDetails([
                                        'userid'    => $leaddetails->id,
                                        'lead_source_detail' => $form_name,
                                        'campaign_id' => $campaign_id,
                                        'lead_campaign_name' => $campaign_name,
                                        'lead_notes' => $notes
                                    ]);
                                    $userdetails->save();
                                    \Log::debug("Email is empty and mobile is unique. Lead Details created now creating User Activity....");

                                    $followup = new UserActivity;
                                    $followup->user_id = $leaddetails->id;
                                    $followup->type = 'others';
                                    $followup->staff = 0;
                                    $followup->detail = "LEAD CREATED BY GOOGLE SHEET.";
                                    $followup->save();
                                } else{
                                    \Log::debug("Mobile OR Email is already present....");
                                    continue;
                                }
                            } catch (\Throwable $e) {
                                \Log::error("Error processing lead row: " . $e->getMessage(), [
                                    'row_data' => $row,
                                    'trace' => $e->getTraceAsString()
                                ]);
                            }
                        }
                    }
                });
            } catch (\Throwable $e) {
                \Log::error("Global Error in GoogleSheet Sync: " . $e->getMessage(), [
                    'trace' => $e->getTraceAsString()
                ]);
            }
        }
    */

    public function handle()
    {
        try {
            \Log::debug("Creating Lead from Google Sheet....");

            $GoogleController = new GoogleSheetSyncController();

            User::whereNotNull('google_token')->get()->each(function ($user) use ($GoogleController) {
                try {
                    $GoogleController->getGoogleClientFromUser($user);

                    $client = new GoogleClient();
                    $client->setAuthConfig(storage_path('app/google-sheet/credentials.json'));
                    $client->setAccessToken($user->google_token);
                    $sheetsService = new Sheets($client);

                } catch (\Throwable $e) {
                    \Log::error("Google Client Init Error: " . $e->getMessage());
                    return;
                }

                foreach ($user->sheets as $sheet) {

                    try {
                        $response = $sheetsService->spreadsheets_values->get($sheet->sheet_id, 'Sheet1');
                        $rows     = $response->getValues() ?? [];

                        if (count($rows) <= 1) continue; 
                        foreach (array_slice($rows, 1) as $row) {

                            \Log::debug("Processing row", ['data' => $row]);

                            $full_name      = $row[0] ?? '';
                            $email          = $row[1] ?? '';
                            $mobile         = isset($row[2]) ? substr($row[2], 0, config('app.USER_MOBILE_MAX_LENGTH')) : '';
                            $whatsappNumber = isset($row[3]) ? substr($row[3], 0, config('app.USER_MOBILE_MAX_LENGTH')) : '';
                            $lead_source    = $row[4] ?? '';
                            $notes          = $row[5] ?? '';

                            if (!$email && !$mobile) {
                                \Log::debug("Skipping: no Email or Mobile");
                                continue;
                            }

                            $exists = false;
                            if ($email && User::where('email', $email)->exists())  $exists = true;
                            if ($mobile && User::where('mobile', $mobile)->exists()) $exists = true;

                            if ($exists) {
                                \Log::debug("Lead already exists (email/mobile duplicate).");
                                continue;
                            }

                            $lead = new User([
                                'first_name'       => $full_name,
                                'email'            => $email,
                                'dialcode'         => env('USER_DEFAULT_DIALCODE'),
                                'mobile'           => $mobile,
                                'whatsapp_dialcode'=> env('USER_DEFAULT_DIALCODE'),
                                'whatsapp'         => $whatsappNumber,
                                'student_type'     => 'course',
                                'lead_status'      => get_default_lead_status(),
                                'confirmed'        => 1,
                                'is_lead'          => 1,
                            ]);
                            $lead->save();

                            UserDetails::create([
                                'userid'             => $lead->id,
                                'lead_source_detail'  => $lead_source,
                                'lead_notes'          => $notes,
                            ]);

                            UserActivity::create([
                                'user_id' => $lead->id,
                                'type'    => 'others',
                                'staff'   => 0,
                                'detail'  => 'LEAD CREATED BY GOOGLE SHEET.',
                            ]);

                            \Log::debug("Lead created successfully", ['lead_id' => $lead->id]);
                        }

                    } catch (\Throwable $e) {
                        \Log::error("Error processing sheet: " . $e->getMessage(), [
                            'sheet_id' => $sheet->sheet_id,
                            'trace'    => $e->getTraceAsString()
                        ]);
                    }
                }
            });

        } catch (\Throwable $e) {
            \Log::error("Global Error in GoogleSheet Sync: " . $e->getMessage(), [
                'trace' => $e->getTraceAsString()
            ]);
        }
    }

}
