<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Auth\User;
use App\Models\Auth\LeadStatus;
use Illuminate\Support\Facades\DB;
use App\Notifications\Backend\UserAlert;
use App\Models\MailTemplates;
use App\Models\Auth\ReferralReward;
use App\Mail\MailSend;
use App\Recipients\AdminRecipient;
use App\Notifications\Frontend\AdminAlert;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Carbon;
use Log;

/**
 * Send a email notification to the concerned staff & manager with leads that missed the lead funnel deadline
 * This job to execute daily evening.
 */

class UnassignedLeadsNotification extends Command
{

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'UnassignedLeadsNotification';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Lead unassigned notification to super admin';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle(){

        echo "\n------------------" . date('Y-m-d H:i:s') . ": UnassignedLeadsNotification: start" . "\n";
        //Log::debug("Cron UnassignedLeadsNotification: start");
        $subject = "Unassigned Leads Notification";
        $today = date('Y-m-d');

        if(get_site_config('unassigned_lead_notification_lead_age') > 0) {
            $config_lead_age = get_site_config('unassigned_lead_notification_lead_age');
            
            echo "\n" . $today . ": Finding leads with age more than: " .$config_lead_age . " days.";
            
            $leads = DB::table('users')->where("created_at",'>', $config_lead_age)->where('assigned_to',0)->where('is_lead',1)->where('deleted_at', NULL)->get();
            if (count($leads)) {
                $to_notify = "";
                foreach ($leads as $lead) {
                    echo "\n" . date('Y-m-d H:i:s') . ": Lead: " . $lead->id . ', ' . $lead->first_name . " " . $lead->last_name;
                    $to_notify .= "<p><a href=\"" . url("admin/leads?lead_info=" . $lead->id) . "\">".$lead->first_name . " " . $lead->last_name ."</a> Created at: " . \Carbon\Carbon::parse($lead->created_at)->format('d M Y g:i A')."</p>"; 
                }
                
                //Send notifications
                if ($to_notify !="") {
                    $email_message = "Hi,<br><br>The following leads are not assigned to any staff after lead age of ".$config_lead_age." Days.<br><br>".$to_notify;
                    $recipient = new AdminRecipient();
                    try {
                        //$recipient->notify(new AdminAlert($subject, $email_message));
                        user_notify($recipient, $subject, $email_message);
                        echo "\n" . date('Y-m-d H:i:s') . ": Unassigned Lead Notification email sent to Admin. Message:".$email_message;
                    } catch (\Exception $e) {
                        $message = $e->getMessage();
                        echo "\nMail Error UnassignedLeadsNotification: Admin- ($subject) " . $message;
                    }
                
                }
            } else {
                echo "\n" . date('Y-m-d H:i:s') . ": unassigned_lead_notification_lead_age not enabled or config days less than 0";
            }
            echo "\n" . date('Y-m-d H:i:s') . ": UnassignedLeadsNotification: end";
            //Log::debug("Cron UnassignedLeadsNotification: end");
        }
    }
}