<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

/**
 * Class Kernel.
 */
class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        //Commands\DemoData::class,
        Commands\LeadFollowupNotification::class,
        Commands\BirthdayWishes::class,
        Commands\EmailSyncCommand::class,
        Commands\IvrToLeadCommand::class,
        Commands\LeadStageDeadlineMissedNotification::class,
        Commands\LeadFollowupMissedNotification::class,
        Commands\AutomationWorkflow::class,
        Commands\AutomationCampaign::class,
	    //Commands\ApplicationTaskNotification::class,
        Commands\ApplicationActivityReminder::class,
        Commands\UnassignedLeadsNotification::class,
        Commands\MonthlyReferralReport::class,
        Commands\SyncSheets::class,
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        //$schedule->command('demodatareset')->daily()->appendOutputTo(storage_path('logs/crons.log'));

        $schedule->command('LeadFollowupNotification')->hourlyAt(55)->appendOutputTo(storage_path('logs/crons.log'));
        $schedule->command('ApplicationActivityReminder')->dailyAt('09:00')->appendOutputTo(storage_path('logs/crons.log'));
        $schedule->command('UnassignedLeadsNotification')->dailyAt('10:00')->appendOutputTo(storage_path('logs/crons.log'));
        $schedule->command('LeadStageDeadlineMissedNotification')->dailyAt('18:00')->appendOutputTo(storage_path('logs/crons.log'));
        $schedule->command('LeadFollowupMissedNotification')->dailyAt('20:00')->appendOutputTo(storage_path('logs/crons.log'));
        $schedule->command('AutomationCampaign')->everyMinute()->appendOutputTo(storage_path('logs/crons.log'));
        $schedule->command('BirthdayWishes')->dailyAt('07:01')->appendOutputTo(storage_path('logs/crons.log'));

        if(env('MARKETING_AUTOMATION_ENABLE')) {
            $schedule->command('AutomationWorkflow')->everyMinute()->appendOutputTo(storage_path('logs/crons.log'));
        }
        
        if(env('STUDENT_REFERRAL_ENABLE')) {
            $schedule->command('MonthlyReferralReport')->monthly('09:02')->appendOutputTo(storage_path('logs/crons.log'));
        }

        if(env('EMAIL_SYNC_ENABLE')) {
            $schedule->command('EmailSyncCommand')->everyFiveMinutes()->appendOutputTo(storage_path('logs/crons.log'));
        }
	
        if(env('GOOGLE_SHEET_LEADS_SYNC_ENABLE')) {
            $schedule->command('SyncSheets')->everyFiveMinutes()->appendOutputTo(storage_path('logs/crons.log'));
        }

        if(env('IVR_TWILIO_SENDERID')){
            $schedule->command('IvrToLeadCommand')->everyFiveMinutes()->appendOutputTo(storage_path('logs/crons.log'));
        }

        if(!env('QUEUE_SUPERVISOR')){
            $schedule->command('queue:work --stop-when-empty')
                ->everyMinute()
                ->withoutOverlapping();            
        }
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
