<?php

namespace App\Helpers;

use App\Models\Auth\User;
use Illuminate\Http\Request;
use App\Models\Auth\Orders;
use App\Models\Auth\Products;
use App\Models\Auth\OrderItems;
use App\Models\Auth\OrderStatus;
use App\Models\Auth\PaymentGatewayTrans;
use App\Models\Auth\InvoicePayment;
use Illuminate\Support\Facades\DB;
use App\Models\Auth\Invoice;
use PDF;
use Illuminate\Support\Facades\Mail;

use Illuminate\Support\HtmlString;
use Illuminate\Contracts\Routing\UrlGenerator;
use Dacastro4\LaravelGmail\Services\Message\Mail as Gmail;

/**
 * Class OrderHelper.
 */

class OrderHelper {
    public static  function paid($id){
        $order = Orders::find($id);
        $item = OrderItems::where('order_id', '=', $order->id)->get();
        $total_amt = $order->total;
        
        //1
        if(isset($item[0])){
            $product = Products::where('id', '=', $item[0]['product_id'])->first();
            if ($item[0]->price_base != 0) {
                $price = ($item[0]->price_base * $item[0]->qty) + $item[0]->setup_cost;
            } else {
                $price = "0.00";
            }
            $item1_qty = $item[0]['qty'];
            $item1 = $product->title;
            $item1_amount = $price;
        }else{
            $item1 = $item1_amount = $item1_qty= NULL;
        }
        //2
        if(isset($item[1])){
            $product = Products::where('id', '=', $item[1]['product_id'])->first();
            if ($item[1]->price_base != 0) {
                $price = ($item[1]->price_base * $item[1]->qty) + $item[1]->setup_cost;
            } else {
                $price = "0.00";
            }
            $item2_qty = $item[1]['qty'];
            $item2 = $product->title;
            $item2_amount = $price;
        }else{
            $item2 = $item2_amount = $item2_qty= NULL;
        }
        //3
        if(isset($item[2])){
            $product = Products::where('id', '=', $item[2]['product_id'])->first();
            if ($item[2]->price_base != 0) {
                $price = ($item[2]->price_base * $item[2]->qty) + $item[2]->setup_cost;
            } else {
                $price = "0.00";
            }
            $item3_qty = $item[2]['qty'];
            $item3 = $product->title;
            $item3_amount = $price;
        }else{
            $item3 = $item3_amount = $item3_qty= NULL;
        }
        //4
        if(isset($item[3])){
            $product = Products::where('id', '=', $item[3]['product_id'])->first();
            if ($item[3]->price_base != 0) {
                $price = ($item[3]->price_base * $item[3]->qty) + $item[3]->setup_cost;
            } else {
                $price = "0.00";
            }
            $item4_qty = $item[3]['qty'];
            $item4 = $product->title;
            $item4_amount = $price;
        }else{
            $item4 = $item4_amount = $item4_qty= NULL;
        }
        //5
        if(isset($item[4])){
            $product = Products::where('id', '=', $item[4]['product_id'])->first();
            if ($item[4]->price_base != 0) {
                $price = ($item[4]->price_base * $item[4]->qty) + $item[4]->setup_cost;
            } else {
                $price = "0.00";
            }
            $item5_qty = $item[4]['qty'];
            $item5 = $product->title;
            $item5_amount = $price;
        }else{
            $item5 = $item5_amount = $item5_qty= NULL;
        }
        //6
        if(isset($item[5])){
            $product = Products::where('id', '=', $item[5]['product_id'])->first();
            if ($item[5]->price_base != 0) {
                $price = ($item[5]->price_base * $item[5]->qty) + $item[5]->setup_cost;
            } else {
                $price = "0.00";
            }
            $item6_qty = $item[5]['qty'];
            $item6 = $product->title;
            $item6_amount = $price;
        }else{
            $item6 = $item6_amount = $item6_qty= NULL;
        }

        $invoice_num = "";
        while(1){
            $invoice_num = rand(100000, 999999);
            $allInvoice = DB::table('invoice')->where('invoice_num', $invoice_num)->first();
            if($allInvoice){
                continue;
            } else{
                break;
            }
        }

        $record = new Invoice([
            'invoice_num' => $invoice_num,
            'student_id' => $order->user_id,
            'item1' => $item1,
            'item2' => $item2,
            'item3' => $item3,
            // 'item4' => $item4,
            // 'item5' => $item5,
            // 'item6' => $item6,
            'item1_amount' => $item1_amount,
            'item2_amount' => $item2_amount,
            'item3_amount' => $item3_amount,
            // 'item4_amount' => $item4_amount,
            // 'item5_amount' => $item5_amount,
            // 'item6_amount' => $item6_amount,
            'sub_total' => $total_amt,
            'cart_total' => $total_amt
        ]);
        $record->save();
        $invoice = Invoice::find($record->id);
        $stuData = User::find($invoice->student_id);
        $payments = InvoicePayment::where('invoice_id', $invoice->id)->get();
        $total_payment = InvoicePayment::where('invoice_id', $invoice->id)->sum('amount');

        $filename = "Invoice_" . $invoice->invoice_num;

        if ($stuData->email) {
            $user['to'] = $stuData->email;
            $user['subject'] = "Invoice";
            $data = ['item' => $item, 'order' => $order, 'invoice' => $invoice, 'stuData' => $stuData, 'payments' => $payments, 'total_payment' => $total_payment];
            $pdf = PDF::loadView('backend.invoice_pdf', $data)->setOptions(['defaultFont' => 'sans-serif', 'isRemoteEnabled' => true]);
            try{
                if(get_site_config('smtp_type')== 'google'){
                    $mail = new Gmail(null, false, 1);
                    $mail->to($user['to'], $name = null );
                    $mail->from(get_site_config('google_email_id'), get_site_config('google_email_from_name'));
                    $mail->subject($user['subject']);
                    $path = storage_path()."/app/public/email_attachments/";
                    $pdf->save($path.'/'.$filename);
                    $mail->attach(storage_path()."/app/public/email_attachments/".$filename);
                    $mail->view('email.invoice',['item' => $item, 'order' => $order, 'invoice' => $invoice, 'stuData' => $stuData, 'payments' => $payments, 'total_payment' => $total_payment]);
                    $mail->send();
                    \Log::debug("user_notify - Sending Mail from Gmail API. TO:".$user['to']." SUBJECT:".$user['subject']); 
                }
                if(get_site_config('smtp_type')== 'smtp_server'){
                    Mail::send('email.invoice', $data, function ($messages) use ($user, $filename, $pdf) {
                        $messages->to($user['to']);
                        $messages->subject($user['subject']);
                        $messages->attachData($pdf->output(), $filename . ".pdf");
                        \Log::debug("Mail Success: (Email Invoice) ");   
                    });
                }
            }catch (\Exception $e) {
                $message = $e->getMessage();
                \Log::debug("Mail Error: (Email Invoice) ".$message);   
            }
        } 
    }
}
