<?php

namespace App\Http\Controllers\API;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Auth\User;
use App\Models\Auth\Country;
use App\Models\Auth\City;
use App\Models\Auth\LeadStatus;
use Log;
use App\Http\Requests\Backend\Auth\User\LeadRequest;
use App\Services\LeadsService;
use Illuminate\Validation\Rule;


class APILeadsController
{
    public function test() {
        return response()->json(['status' => 1, 'message' => 'Hello!']);
    }

    /**
    * Input parameters:
    * first_name (mandatory)
    * last_name
    * email (mandatory)
    * dialcode - without + sign
    * mobile - without dialcode
    * whatsapp - without dialcode
    * gender - (male,female)
    * birthday - DD-MM-YYYY
    * country - Residence Country Name
    * city 
    * country_interested - Country interested to study in
    * course_interested - Overseas Course Interested
    * note
    **/
    public function create(Request $request) {
        \Log::debug("APILeadsController create:");
        \Log::debug($request->all());

        //Validation
        $validator =  \Validator::make($request->all(), [
            'first_name' => ['required', 'max:50','regex:/^[\pL\s]+$/u'],
            'last_name' => ['nullable', 'max:50','regex:/^[\pL\s]+$/u'],
            // 'email' => 'required|email|unique:users|max:100',
            //'mobile' => ['nullable', Rule::unique('users'), 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH')],
            //'whatsapp' => ['nullable', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH')],
            'gender' => 'nullable|in:male,female',
            //'date_of_birth' => 'nullable|date|before:'.now()->subYears(16)->toDateString(),
            'date_of_birth' => 'nullable|date',
            //'country' => ['nullable', 'exists:countries,title_en', 'max:100','regex:/^[\pL\s]+$/u'],
            'city' => ['nullable', 'max:50','regex:/^[\pL\s]+$/u'],
            'course_interested' => ['nullable', 'max:100','regex:/^[\pL\s]+$/u'],
            // 'country_interested' => ['nullable', 'exists:countries,title_en', 'max:100','regex:/^[\pL\s]+$/u'],
        ],[
            'first_name.regex' => 'Only letters and space is allowed in First name',
            'last_name.regex' => 'Only letters and space is allowed in Last name',
        ]);

        if(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email'){
            $validator =  \Validator::make($request->all(), [
                'email' => 'required|email|unique:users|max:100',
                'mobile' => ['nullable', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH'), 'unique:users,mobile'],
            ]);
        } elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_and_mobile'){
            $validator =  \Validator::make($request->all(), [
                'email' => 'required|email|unique:users|max:100',
                'mobile' => ['required', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH'), 'unique:users,mobile'],
            ]);
        } elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_or_mobile'){
            if($request->get('email') == "" && $request->get('mobile') == ""){
                return redirect()->back()->withFlashDanger('Email or Mobile is Required');
            } else{
                $validator =  \Validator::make($request->all(), [
                    'email' => 'nullable|email|unique:users|max:100',
                    'mobile' => ['nullable', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH'), 'unique:users,mobile'],
                ]);
            }
        } elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'mobile'){
            $validator =  \Validator::make($request->all(), [
                'email' => 'nullable|email|unique:users|max:100',
                'mobile' => ['required', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH'), 'unique:users,mobile'],
            ]);            
        }
        if ($validator->fails()) {
            $message = $validator->getMessageBag()->toArray();
            if(isset($message['email'][0])){
                return response()->json(['status' => 0, 'error' => $message['email'][0]]);
            }
            else if(isset($message['mobile'][0])){
                return response()->json(['status' => 0, 'error' => $message['mobile'][0]]);
            }
            else{
                return response()->json(['status' => 0, 'errors' => $message]);
            }
            
    
        }

        $country_interested = "";
        if (!empty($request->country_interested)) {
            $country_interested = explode(",", $request->country_interested);
            $i = 0;
            foreach($country_interested as $countries){
                if($countries == 'United States of America') {
                    $countries = 'USA';
                    $country_interested[$i] = 'USA';
                }elseif($countries == 'United States America') {
                    $countries = 'USA';
                    $country_interested[$i] = 'USA';
                }elseif($countries == 'United States') {
                    $countries = 'USA';
                    $country_interested[$i] = 'USA';
                }elseif($countries == 'UAE') {
                    $countries = 'United Arab Emirates';
                    $country_interested[$i] = 'United Arab Emirates';
                }elseif($countries == 'UK') {
                    $countries = 'United Kingdom';
                    $country_interested[$i] = 'United Kingdom';
                }

                $country = DB::table('countries')->where('title_en', '=', $countries)->first(['id','title_en']);
                if(!$country){
                    return response()->json(['status' => 0, 'error' => "Country $countries Not Found in DB!"]);
                }
                $i++;
            }
        }
        //$request->country_interested = implode(",",$country_interested);
        
        $leadCreate = new LeadsService();
        $data = $leadCreate->create($request);
        $filterData = array();
        foreach($data as $key => $value){
            if($key == 'id' || $key == 'first_name' || $key == 'last_name' || $key == 'email' || $key == 'mobile' || $key == 'whatsapp' || $key == 'birthday' || $key == 'country' || $key == 'city' || $key == 'country_interested' || $key == 'overseas_study_level_selection' || $key == 'overseas_course_intersted' || $key == 'lead_source' || $key == 'lead_campaign_name' || $key == 'lead_ad_name' || $key == 'lead_form_name' || $key == 'lead_id'){
                if($key == 'country' && $value > 0) {
                    $value = get_country_name($value);
                }
                if(!$value) {
                    $value = "";
                }
                $filterData[$key] = $value;
            }
        }
        if(!empty($filterData)){
            return response()->json(['status' => 1, 'message' => 'Lead Created Successfully', 'data' => $filterData]);
        }else{
            return response()->json(['status' => 0, 'error' => 'Something Went Wrong!']);
        }

        //['status' => 1, 'message' => 'Hello!', 'data'=> $data]
    }

    /**
    * Input parameters :
    * email (mandatory)
    *
    * Fields to update:
    *
    * first_name
    * last_name
    * dialcode - without + sign
    * mobile - without dialcode
    * whatsapp - without dialcode
    * gender - (male,female)
    * birthday - DD-MM-YYYY
    * country - Residence Country Name
    * city 
    * country_interested - Country interested to study in
    * course_interested - Overseas Course Interested
    * note
    **/

    public function update(Request $request){
        \Log::debug("APILeadsController create:");
        \Log::debug($request->all());
        $lead = User::where('email', $request->email)->first();
        //Validation
        $request->validate([
            'first_name' => ['nullable', 'max:50','regex:/^[\pL\s]+$/u'],
            'last_name' => ['nullable', 'max:50','regex:/^[\pL\s]+$/u'],
            // 'email' => 'required|email|max:100',
            // 'mobile' => 'nullable|numeric|digits_between:'.config("app.USER_MOBILE_MIN_LENGTH").','.config("app.USER_MOBILE_MAX_LENGTH").'|unique:users,mobile,' . $lead->id,
            'whatsapp' => ['nullable', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH')],
            'gender' => 'in:male,female',
            'date_of_birth' => 'nullable|date|before:'.now()->subYears(16)->toDateString(),
            'country' => ['nullable', 'exists:countries,title_en',' max:100','regex:/^[\pL\s]+$/u'],
            'city' => ['nullable', 'max:50','regex:/^[\pL\s]+$/u'],
            'course_interested' => ['nullable', 'max:100','regex:/^[\pL\s]+$/u'],
        ],[
            'first_name.regex' => 'Only letters and space is allowed in First Name',
        ]);

        if(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email'){
            $request->validate([
                'email' => 'required|email|max:100|unique:users,email,' . $lead->id,
                'mobile' => ['nullable', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH'), 'unique:users,mobile,' . $lead->id],
            ]);
        } elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_and_mobile'){
            $request->validate([
                'email' => 'required|email|max:100|unique:users,email,' . $lead->id,
                'mobile' => ['required', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH'), 'unique:users,mobile,' . $lead->id],
            ]);
        } elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_or_mobile'){
            if($request->get('email') == "" && $request->get('mobile') == ""){
                return redirect()->back()->withFlashDanger('Email or Mobile is Required');
            } else{
                $request->validate([
                    'email' => 'nullable|email|max:100|unique:users,email,' . $lead->id,
                    'mobile' => ['nullable', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH'), 'unique:users,mobile,' . $lead->id],
                ]);
            }
        } elseif(get_site_config('lead_create_web2lead_api_import_mandatory') == 'mobile'){
            $request->validate([
                'email' => 'nullable|email|max:100|unique:users,email,' . $lead->id,
                'mobile' => ['required', 'numeric', 'digits_between:'.config('app.USER_MOBILE_MIN_LENGTH').','.config('app.USER_MOBILE_MAX_LENGTH'), 'unique:users,mobile,' . $lead->id],
            ]);            
        }

        $country_interested = "";
        if (!empty($request->country_interested)) {
            $country_interested = explode(",", $request->country_interested);
            $i = 0;
            foreach($country_interested as $countries){
                if($countries == 'United States of America') {
                    $countries = 'USA';
                    $country_interested[$i] = 'USA';
                }elseif($countries == 'United States America') {
                    $countries = 'USA';
                    $country_interested[$i] = 'USA';
                }elseif($countries == 'United States') {
                    $countries = 'USA';
                    $country_interested[$i] = 'USA';
                }elseif($countries == 'UAE') {
                    $countries = 'United Arab Emirates';
                    $country_interested[$i] = 'United Arab Emirates';
                }elseif($countries == 'UK') {
                    $countries = 'United Kingdom';
                    $country_interested[$i] = 'United Kingdom';
                }

                $country = DB::table('countries')->where('title_en', '=', $countries)->first(['id','title_en']);
                if(!$country){
                    return response()->json(['status' => 0, 'error' => "Country $countries Not Present!"]);
                }
                $i++;
            }
        }
        $request->country_interested = implode(",",$country_interested);

        $leadUpdate = new LeadsService();
        $data = $leadUpdate->update($request);

        $filterData = array();
        foreach($data as $key => $value){
            if($key == 'id' || $key == 'first_name' || $key == 'last_name' || $key == 'email' || $key == 'mobile' || $key == 'whatsapp' || $key == 'birthday' || $key == 'country' || $key == 'city' || $key == 'country_interested' || $key == 'overseas_study_level_selection' || $key == 'overseas_course_intersted'){
                $filterData[$key] = $value;
            }
        }
        if(!empty($filterData)){
            return response()->json(['status' => 1, 'message' => 'Lead Updated Successfully', 'data' => $filterData]);
        }else{
            return response()->json(['status' => 0, 'error' => 'Lead Not Found!']);
        }

    }

    public function getNewLeads(){
        $recentLead = new LeadsService();
        $data = $recentLead->fetchRecentLead();

        $filterData = array();
        $i = 0;
        foreach($data as $singleData){
            foreach($singleData as $key => $value){
                if($key == 'id' || $key == 'first_name' || $key == 'last_name' || $key == 'email' 
                || $key == 'mobile' || $key == 'whatsapp' 
                || $key == 'country' || $key == 'city' || $key == 'country_interested' 
                || $key == 'overseas_study_level_selection' || $key == 'overseas_course_intersted'
                || $key == 'created_at'){

                    if($key == 'country') {
                        $value = get_country_name($value);
                    }
                    $filterData[$i][$key] = $value;
                }
            }
            $i++;
        }
        if(!empty($filterData)){
            //return response()->json(['status' => 1, 'message' => 'Latest Leads', 'data' => $filterData]);
            return response()->json($filterData);
        }else{
            //return response()->json(['status' => 0, 'error' => 'No Leads Found!']);
            return response()->json([]);
        }
    }
}