<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Auth\User;
use App\Models\Auth\LeadStatus;
use App\Models\Banners;
use App\Models\Configs;
use App\Models\Auth\Posts;
use App\Models\Auth\AdditionalDocsConfigs;
use App\Models\ContentBlocks;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\Auth\CountryStudy;
use App\Repositories\Backend\Auth\UserRepository;
use Illuminate\Support\Arr;

/**
 * Class AdditionalDocsController.
 */
class AdditionalDocsController extends Controller
{

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!\Auth::user()->isAdmin()) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }
            return $next($request);
        });
    }

    public function index()
    {
        $content_pages = Posts::where('type', 'content_page')->where('status', 1)->select('id', 'title')->get();
        $branches = DB::table('branch')->get();
        return view('backend.settings', compact('content_pages','branches'));
    }


   public function additionalDocs(Request $request)
    {
        $docs = DB::table('additional_docs_configs')
            ->orderBy('display_order', 'asc')
            ->get();
        $sections = DB::table('additional_docs_sections')->orderBy('display_order', 'asc')->get();
        return view('backend.settings.additional_docs_settings', compact('docs','sections'));
    }


    public function saveAdditionalDocs(Request $request)
    {
        $request->validate([
            'document_title' => 'required|unique:additional_docs_configs,title',
            'file_types_allowed' => 'required',
            'number_of_files' => 'required',
            'section' => 'required',
            'country_specific' => 'required',
            // 'display_order' => 'required',
        ]);

        if($request->document_title){
            $request->validate([
                'doc_notes' => 'max:300',
            ]);
        }

        $document_title = $request->document_title;
        $doc_notes = $request->doc_notes;
        $file_types_allowed = implode(', ',$request->file_types_allowed);
        $number_of_files = $request->number_of_files;
        $country_specific = $request->country_specific;
        $section = $request->section;

        if ($country_specific == '1') {
                $countries = implode(', ',$request->countries);
        }
        else{
            $countries = "all"; 
        }
        $doc_type = preg_replace(
            '/[^a-zA-Z0-9 ]/m', // 1. regex to apply
            '',                 // 2. replacement for regex matches 
            $document_title             // 3. the original string
        );
        $doc_type = strtolower(str_replace(" ","_",$doc_type));

        $addDocConData = DB::table('additional_docs_configs')->select()->first();
        if(!$addDocConData){
            DB::table('additional_docs_configs')->insert(["title" => $document_title, "doc_type" => $doc_type, "file_count" => $number_of_files, "file_types" => $file_types_allowed, "country_specific" => $country_specific, "countries" => $countries, "display_order" => 1, "doc_notes" => $doc_notes,"section_id" => $section] );
        }else{
            DB::table('additional_docs_configs')->insert(["title" => $document_title, "doc_type" => $doc_type, "file_count" => $number_of_files, "file_types" => $file_types_allowed, "country_specific" => $country_specific, "countries" => $countries, "doc_notes" => $doc_notes,"section_id" => $section, "display_order" => DB::raw('(select max(display_order) from additional_docs_configs as display_order) + 1')]);
        }       

        return redirect()->route('admin.additional-docs')->withFlashSuccess('Document added successfully');
    }

    
    public function updateAdditionalDocs(Request $request)
    {
        $request->validate([
            'document_title' => 'required|unique:additional_docs_configs,title,'.$request->doc_id,
            'file_types_allowed' => 'required',
            'number_of_files' => 'required',
            'section' => 'required',
            'country_specific' => 'required',
        ]);

        if($request->document_title){
            $request->validate([
                'doc_notes' => 'max:300',
            ]);
        }

        if ($request->doc_id == '') {
            return redirect()->route('admin.additional-docs')->withFlashDanger('Something went wrong!');
        }

        $document_title = $request->document_title;
        $doc_notes = $request->doc_notes;
        $file_types_allowed = implode(', ',$request->file_types_allowed);
        $number_of_files = $request->number_of_files;
        $country_specific = $request->country_specific;
        $section = $request->section;
        if ($country_specific == '1') {
                $countries = implode(', ',$request->countries);
        }
        else{
            $countries = "all"; 
        }
        DB::table('additional_docs_configs')->where('id', $request->doc_id)->update(["title" => $document_title, "file_count" => $number_of_files, "file_types" => $file_types_allowed, "country_specific" => $country_specific, "countries" => $countries, "doc_notes" => $doc_notes,"section_id" => $section]);

        return redirect()->route('admin.additional-docs')->withFlashSuccess('Document updated successfully');
    }

    public function changeStatus($id, $status) {
        $stat = AdditionalDocsConfigs::findOrFail($id);
        $stat->status = $status;
        $stat->save();
        return redirect()->route('admin.additional-docs')->withFlashSuccess('Status Updated!');
    }

    public function updateOrder(Request $request)
    {
      if ($request->id && $request->order) {
        $order = AdditionalDocsConfigs::findOrFail($request->id);
        $order->display_order = $request->order;
        $order->save();
        return response(["status" => 200, "message"=>"Display order updated successfully"]); 
      }
    }
  

    public function deleteDocConfig($id)
    {
        $doc = AdditionalDocsConfigs::find($id);
        $doc->delete();
        return redirect()->route('admin.additional-docs')->withFlashSuccess('Document deleted successfully');
    }
}
