<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Repositories\Backend\Auth\UserRepository;
use App\Models\Auth\CountryStudy;
use App\Models\Auth\User;
use App\Models\Auth\AgentCommission;
use App\Models\Auth\UniversityApplication;
use Yajra\DataTables\DataTables;
use App\Http\Requests\Backend\Auth\User\ManageUserRequest;
use App\Events\Backend\Auth\User\UserDeleted;
use Log;
use PDF;
class AgentCommissionController extends Controller
{

  public function __construct()
  {
    $this->middleware(function ($request, $next) {
      $user = \Auth::user();
      if (\Auth::user()->isAdmin() || !\Auth::user()->isAgent()) {
        return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
      }
      return $next($request);
    });
  }


  public function myCommission()
  {
    $search = "";
    $filters = array("search" => $search, "status" => "");
    $userRepo = new UserRepository();
    // $statuses = get_agent_application_statuses();
    
        $total_pay = 0;
        $paydata = AgentCommission::where('agent_id',\Auth::user()->id)->get(['agent_commission.*']);
        $agent_currency_symbol = get_currency_symbol(get_currency_by_user_country(\Auth::user()->id));
        foreach($paydata as $data){
          $total_pay += currency_convert($data->net_pay, $data->currency, get_currency_by_user_country(\Auth::user()->id));
        }
    return view('backend.my-commission', compact('filters','total_pay','agent_currency_symbol'));
  }

  public function mycommissiondata(Request $request)
  {

    // \Log::debug("mycommissiondata:".var_export($request->all(), true));
    // DB::enableQueryLog();

    $columns = array(
      0 => 'created_at',
      1 => 'appl_id',
      4 => 'amount',
      5 => 'deduction',
      6 => 'net_pay',
      7 => 'notes',
      8 => 'paid_date',
      9 => 'paid',
    );

    $totalData = AgentCommission::count();

    $totalFiltered = $totalData;

    $agent = $request->input('agent');
    $limit = $request->input('length');
    $start = $request->input('start');
    $order = $columns[$request->input('order.0.column')];
    $status = $request->input('status');
    $dir = $request->input('order.0.dir');

    if (empty($request->input('search.value')) && empty($agent) && empty($status)) {
      $users = AgentCommission::select('agent_commission.*')
        ->where('agent_id', \Auth::user()->id)
        ->offset($start)
        ->limit($limit)
        ->orderBy($order, $dir)
        ->get();

        //$queries = DB::getQueryLog();
        //\Log::debug($queries);
        
    } else {
      $get_search = $request->input('search.value');
      $users = AgentCommission::select('agent_commission.*')
      ->when(!empty($get_search), function ($query) use ($get_search) {
          return $query->where('appl_id', '=', "$get_search");
        })
        ->where('agent_id', \Auth::user()->id)
        ->when(!empty($status), function ($query) use ($status) {
                    return  $query->Where('paid','=', "$status");
        })        
        ->offset($start)
        ->limit($limit)
        ->orderBy($order, $dir)
        ->get();

        // \Log::debug("Hello Pending Users=>".$users);
        //  $queries = DB::getQueryLog();
        //     \Log::debug($queries);

      $totalFiltered = AgentCommission::select('agent_commission.*')
      ->when(!empty($get_search), function ($query) use ($get_search) {
          return $query->where('appl_id', '=', "$get_search");
        })
        ->where('agent_id', \Auth::user()->id)
        ->when(!empty($status), function ($query) use ($status) {
                    return  $query->Where('paid', '=', "$status");
        })       
        ->count();
    }

    $data = array();
    if (!empty($users)) {
      foreach ($users as $page) {

        $universityApplication = UniversityApplication::where("id", $page->appl_id)->first();
        $currency = $university_name = $course_name = "";
        if($universityApplication){ 
          if($universityApplication->fees_currency){
            $currency = $universityApplication->fees_currency ." ". get_currency_symbol($universityApplication->fees_currency);
          }
          if ($universityApplication->university) {
            $university_name = $universityApplication->university;
          }
          if ($universityApplication->course) {
              $course_name = $universityApplication->course;
          }
        }
        $customResult['payment_id'] = $page->id;
        $customResult['created_at'] = date("d-M-Y", strtotime($page->created_at));
        $customResult['applId'] = get_application_id($page->appl_id)."<br>".$university_name . '<br>' . $course_name;
        $customResult['student'] = $universityApplication ? get_user_full_name_by_id($universityApplication->userid) ."<br>".get_user_email_by_id($universityApplication->userid) : "--";
        $customResult['commission_notes'] = $page->agent_commission_notes;
        $customResult['commission'] = $currency ." ". $page->amount;
        $customResult['deduction'] = $currency ." ". $page->deduction;
        $customResult['net_pay'] = get_currency_symbol(get_currency_by_user_country(\Auth::user()->id)).' '.currency_convert($page->net_pay, $page->currency, get_currency_by_user_country(\Auth::user()->id));
        $customResult['trans_details'] = $page->notes;
        $customResult['date_paid'] = get_date_formated($page->paid_date);
        $download_route = route('admin.agents.download-invoice',$page->id);
        $customResult['status'] = ($page->paid=='1')? 'Paid'." <a target='_blank' title='Download Invoice' href='$download_route' class='ms-2'><i class='fa fa-download' aria-hidden='true'></i></a>": 'Pending';

        $data[] = $customResult;
      }
    }

    $json_data = array(
      "draw"            => intval($request->input('draw')),
      "recordsTotal"    => intval($totalData),
      "recordsFiltered" => intval($totalFiltered),
      "data"            => $data,
      "status"          =>  $status
    );

    echo json_encode($json_data);
  }

  public function download_invoice($id)
  {
      $invoice = AgentCommission::join('university_application', 'agent_commission.appl_id', '=', 'university_application.id')
      ->where('agent_commission.id',$id)
      ->select('agent_commission.*','university_application.university','university_application.course','university_application.userid')
      ->first();

      $agentData = User::join('agent_details', 'users.id','=','agent_details.agent_id')
      ->where('users.id',$invoice->agent_id)
      ->first(['agent_details.business_name','agent_details.agent_panel_logo','users.first_name', 'users.last_name', 'users.email', 'users.address_1', 'users.city', 'users.state', 'users.country', 'users.post_code']);

      $filename = "Invoice_" . $invoice->id;
      $pdf = PDF::loadView('frontend.payout_invoice_pdf', ['invoice' => $invoice, 'agentData' => $agentData]);
      return $pdf->stream($filename . ".pdf");
  }

}
