<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Models\Auth\Products;
use App\Models\Auth\ProductCategories;
use App\Models\Auth\Categories;
use App\Models\Auth\ProductImages;
use App\Models\Auth\CurrencyRate;
use App\Models\Auth\ProductDownloads;
use App\Models\Auth\UserShippingAddress;
use App\Models\Auth\Orders;
use App\Models\Auth\Invoice;
use App\Models\Auth\InvoicePayment;
use App\Models\Auth\OrderItems;
use App\Models\Auth\OrderStatus;
use App\Models\Auth\PaymentGatewayTrans;
use App\Models\Auth\User;
use App\Models\Auth\OnlineCourse;
use App\Models\Auth\Course;
use App\Models\Auth\Country;
use App\Models\Auth\Shipping;
use App\Models\Auth\Downloads;
use App\Models\Auth\State;
use App\Models\Auth\City;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use PDF;

class AgentInvoiceController extends Controller
{
  public function index()
  {
    return view('backend.agent_invoice.index');
  }

  public function invoices_list()
  {
    $id = auth()->user()->id;

    $data = Invoice::where('student_id', '=', $id)->latest()->get();
    return Datatables::of($data)
      ->editColumn('invoice_id', function ($data) {
        return $data->id;
      })
      ->editColumn('date', function ($data) {
        $date = strtotime($data->created_at);
        $new_date = date('d/m/Y', $date);
        return $new_date;
      })
      ->editColumn('invoice', function ($data) {
        return $data->invoice_num;
      })
      ->editColumn('amount', function ($data) {
        if(get_total_invoice_payment($data->id)){
            $amt = config('app.currency_symbol').' '.$data->cart_total - get_total_invoice_payment($data->id);
        }
        else{
            $amt = config('app.currency_symbol').' '.$data->cart_total;
        }
        return $amt;
      })
      ->editColumn('status', function ($data) {
          if($data->status=='due'){
            return '<span class="text-danger">'.ucfirst($data->status).'</span>';
          }else{
            return ucfirst($data->status);
          }
      })
      ->addColumn('action', function ($data) {
        $type = "all-orders";
        return view("backend.agent_invoice.btn", compact('data', 'type'));
      })
      ->rawColumns(['status','action'])
      ->make(true);
  }

    public function view_invoice($id)
    {
        $invoice = Invoice::find($id);
        $stuData = User::find(auth()->user()->id);
        $payments = InvoicePayment::where('invoice_id', $invoice->id)->get();

        $total_payment = InvoicePayment::where('invoice_id', $invoice->id)->sum('amount');

        return view('backend.agent_invoice.invoice-detail', compact('invoice', 'stuData', 'payments', 'total_payment'));
    }

    public function download_invoice($id)
    {
        $invoice = Invoice::find($id);
        $stuData = User::find($invoice->student_id);
        $payments = InvoicePayment::where('invoice_id', $invoice->id)->get();
        $total_payment = InvoicePayment::where('invoice_id', $invoice->id)->sum('amount');

        $filename = "Invoice_" . $invoice->invoice_num;

        $pdf = PDF::loadView('frontend.invoice_pdf', ['invoice' => $invoice, 'stuData' => $stuData, 'payments' => $payments, 'total_payment' => $total_payment]);
        return $pdf->stream($filename . ".pdf");
    }
}
