<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Auth\FileUpload;
use App\Models\Auth\Category;
use App\Models\Auth\AgentFileUpload;
use App\Models\Auth\AgentResourceCategory;
use App\Models\Auth\Country;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;

class AgentResourceController extends Controller {

    public function __construct(){
      $this->middleware(function ($request, $next) {
        $user = \Auth::user();
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('file uploads'))) {
          return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        return $next($request);
      });
    }

    public function index() {
        $pages = DB::table('agent_file_upload')
            ->select('agent_resource_category.category', 'agent_file_upload.title', 'agent_file_upload.filename', 'agent_file_upload.id', 'agent_file_upload.country')
            ->join('agent_resource_category', 'agent_resource_category.id', '=', 'agent_file_upload.category')
            ->get();

        $categorys = AgentResourceCategory::all();
        $country_list = Country::pluck('title_en', 'id');
        return view('backend.agent_resource_upload.upload_documents', ['pages' => $pages, 'categorys' => $categorys, 'country_list' => $country_list]);
    }

    public function createCategory() {
        return view('backend.agent_resource_upload.create-category');
    }

    public function categoryStore(Request $request) {
        $request->validate([
            'category' => 'required'
        ]);
        $category = new AgentResourceCategory([
            'category' => $request->get('category'),
        ]);
        $category->save();

        return redirect()->route('admin.agent-resources.upload.show.category')->withFlashSuccess('Category Added Successfully');
    }

    public function uploaddoc(Request $request) {
        $max_allowed = get_php_max_upload_size_kb();
        $request->validate([
            'file' => 'required|mimes:jpg,jpeg,png,docx,pdf,ppt,xlsx,doc,mp4,mov,ogg,mp3,3gp,mpeg,zip|max:'.$max_allowed
        ],[
            'file.required' => 'Please select a file',
            'file.mimes' => 'Only jpg, jpeg, png, docx, pdf, xlsx, ppt, doc, mp4, mov, ogg, mp3, 3gp, zip mpeg files are allowed',
        ]);
        // if (!$request->file('file')) {
        //     return redirect()->route('admin.upload')->withFlashDanger("Please select a file");
        // }

        $file = $request->file->getClientOriginalName();
        $filename = pathinfo($file, PATHINFO_FILENAME);
        if (strlen($filename) > 125){
            $filename = substr($filename, 0, 125);
        }

        $filename = $filename . Str::random(20) . "." . $request->file->getClientOriginalExtension();
        $path = $request->file('file')->storeAs('/agent_resources', $filename, 'public');
        //Log::debug("::countryinfo doc savedpath::$path");
        DB::table('agent_file_upload')
            ->insert(
                ['title' => $request->input('title'),'country' => $request->input('country'), 'category' => $request->input('category'), 'filename' => $path]
            );

        return redirect()->route('admin.upload.agent-resources')->withFlashSuccess("File Uploaded successfully");
    }

    public function deletedoc($id) {
        if (DB::table('agent_file_upload')->where('id', $id)->exists()) {
            $row = DB::table('agent_file_upload')->where('id', $id)->first();
            $file_path = storage_path() . '/app/public/' . $row->filename;
            DB::table('agent_file_upload')->where('id', $id)->delete();
            //Storage::delete($file);
            unlink($file_path);

            return redirect()->route('admin.upload.agent-resources')->withFlashSuccess("File removed successfully");
        }
    }

    public function showCategory(){
        $categories = AgentResourceCategory::all();
        return view('backend.agent_resource_upload.show_category', ["categories" => $categories]);
    }
    
    public function editCategory($id){
        $category = AgentResourceCategory::where("id", $id)->first();
        return view('backend.agent_resource_upload.edit_category', ["category" => $category]);
    }
    
    public function editCategoryStore(Request $request) {
        $request->validate([
            'category' => 'required'
        ]);

        $category = AgentResourceCategory::where("id", $request->category_id)->first();
        $category->category = $request->get('category');
        $category->save();

        return redirect()->route('admin.agent-resources.upload.show.category')->withFlashSuccess('Category Updated Successfully');
    }

    public function delete(Request $request){
        $id = $request->get('application_id');
        $uploadCategory = AgentResourceCategory::where('id', $id)->first();
        if($uploadCategory) {
            $uploadCategory->delete();
            return redirect()->route('admin.agent-resources.upload.show.category')->withFlashSuccess('Category Deleted Successfully');
        } else {
            return redirect()->route('admin.agent-resources.upload.show.category')->withFlashDanger('Category Not Found');
        }
    }
}
