<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\Announcements;
use Illuminate\Http\Request;
use App\Models\Auth\UserDetails;
use Illuminate\Support\Facades\DB;



class AnnouncementsController extends Controller
{

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            //if (!(\Auth::user()->isAdmin() || \Auth::user()->can('annoucements'))) {
            //    return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            //}
            return $next($request);
        });
    }

    public function index()
    {
        // $templates = MailTemplates::orderByDesc('created_at')->get();
        $templates = Announcements::orderBy('created_at', 'DESC')->get();
        return view('backend.announcements.index', compact('templates'));
    }


    public function create()
    {
        return view('backend.announcements.create');
        
    }
    
    public function ajaxannouncementslist(Request $request) {
    
        return $this->getDatatableAnnouncements($request);
    }
    
    public function getDatatableAnnouncements(Request $request) {
        $columns = [
            0 => 'title',
            1 => 'area',
            2 => 'created_by',
            3 => 'published_at',
        ];
    
        $totalData = DB::table('announcements_site')->count();
        $totalFiltered = $totalData; 
        $limit = $request->input('length');
        $start = $request->input('start');
        $orderColumnIndex = $request->input('order.0.column');
        $orderColumnName = $columns[$orderColumnIndex];
        $dir = $request->input('order.0.dir');
        $searchValue = $request->input('search.value');
    
        $query = DB::table('announcements_site')
            ->select('announcements_site.title', 'area', 'announcements_site.created_by', 'published_at','announcements_site.id','users.first_name','users.last_name')
            ->leftJoin('users', 'announcements_site.created_by', '=', 'users.id')
            ->offset($start)
            ->limit($limit)
            ->orderBy($orderColumnName, $dir);
    
        if (!empty($searchValue)) {
            $query->where(function($query) use ($searchValue) {
                $query->where('announcements_site.title', 'like', "%$searchValue%")
                    ->orWhere('announcements_site.area', 'like', "%$searchValue%");
                    
                     
            });
    
            $totalFiltered = DB::table('announcements_site')
                ->leftJoin('users', 'announcements_site.created_by', '=', 'users.id')
                ->where(function($query) use ($searchValue) {
                    $query->where('announcements_site.title', 'like', "%$searchValue%")
                        ->orWhere('announcements_site.area', 'like', "%$searchValue%");
                        
                        
                })
                ->count();
        
            }
        $ann = $query->get();
    
        $data = [];
        foreach ($ann as $announcement) {
            $data[] = [
                'title' => $announcement->title,
                'area' => $announcement->area,
                'created_by' => $announcement->first_name.' '.$announcement->last_name,
                'published_at' => date("d M Y H:i A", strtotime($announcement->published_at)),
                'actions' => '<a href="'. route('admin.announcements.edit',  $announcement->id). '" class="btn btn-outline-primary"><i class="fas fa-edit" style="font-size:17px"></i>Edit</a>
                <a href="' . route('admin.announcements.delete', $announcement->id). '" class="btn btn-sm btn-outline-danger ms-1" data-method="delete"
                data-trans-button-cancel="Cancel"
                data-trans-button-confirm="Delete"
                data-html="true"
                data-trans-title="Are you sure want to delete this?"><i class="fa fa-trash" aria-hidden="true"></i> Delete</i> </a>'

            ];
        }
    
        $json_data = [
            "draw" => intval($request->input('draw')),  
            "recordsTotal" => intval($totalData),  
            "recordsFiltered" => intval($totalFiltered), 
            "data" => $data,
        ];
    
        return response()->json($json_data);
    }
    

    public function store(Request $request)
    {
        
        $request->validate([
            'area' => 'required|in:public,student,agent,admin',
            'title' => 'required|max:200',
            'message' => 'required',
            'published_at' => 'required',
        ]);

        $published_at = empty($request->published_at) ? date('Y-m-d H:i:s') : date('Y-m-d H:i:s', strtotime($request->published_at));
        $message = strip_tags($request->get('message'));

        $announce_crt = Announcements::create([
            'area' => $request->get('area'),
            'title' => $request->get('title'),
            'message' => $message,
            'created_by' => Auth::id(), 
            'published_at' => $published_at,
        ]);
        


        // Redirect back with a success message
        return redirect()->route('admin.announcements')->with('Announcement created successfully.');
    }

    public function edit($id) {
        
        $ann = Announcements::findOrFail($id);
        // $ann->published_at = date('d-M-Y H:i',strtotime($article_det->published_at));
        
                
        return view("backend.announcements.edit",compact("ann"));
    }

   

    public function update(Request $request, $id)
    {
        $request->validate([
            'area' => 'required|in:public,student,agent,admin',
            'title' => 'required|max:200',
            'message' => 'required',
            'published_at' => 'required',
        ]);
        $ann = Announcements::findOrFail($id);
        $ann->area = $request->get('area');
        $ann->title = $request->get('title');
        $ann->published_at = empty($request->published_at) ? date('Y-m-d H:i:s') : date('Y-m-d H:i:s', strtotime($request->published_at));
        $ann->message = strip_tags($request->get('message'));
        $ann-> created_by = Auth::id();
        $ann->save();
        return redirect()->route('admin.announcements')->withFlashSuccess('Announcements Updated!');
        
    }

    public function destroy($id)
    {
        
        $ann = Announcements::findOrFail($id);

        
        $ann->delete();
        return redirect()->route('admin.announcements')->with('success', 'Announcement deleted successfully');

    }

   
}
