<?php

namespace App\Http\Controllers\Backend;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Auth\User;
use App\Models\Auth\ApplicationStages;
use Illuminate\Http\Request;
use Log;

class ApplicationStagesController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $stages = DB::table('application_stages')->OrderBy('stage_order')->get();
        return view('backend.settings.application_stages', compact('stages'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|unique:application_stages,status_name',
            'file_upload' => 'required',
            'notes_required' => 'required',
            'can_go_back' => 'required',
            'color' => 'required',
        ]);

        $status_name = $request->name;
        $file_upload = $request->file_upload;
        $number_of_files = $request->number_of_files;
        $file_upload_required = $request->file_upload_required;
        $notes_required = $request->notes_required;
        $can_go_back = $request->can_go_back;
        $case_close = $request->case_close;
        $case_close_type = $request->case_close_type;
        $stage_order = $request->stage_order;
        $color = $request->color;

        if (isset($request->countries) && count($request->countries)) {
            $countries = implode(', ',$request->countries);
        }else{
            $countries = NULL; 
        }

        if ($case_close == '1' && $case_close_type == '1') {
            $case_close_success = '1';
            $case_close_rejected = '0';
        }
        else if ($case_close == '1' && $case_close_type == '0') {
            $case_close_success = '0';
            $case_close_rejected = '1';
        }
        else{
            $case_close_success = '-1';
            $case_close_rejected = '-1';
        }

      
        DB::table('application_stages')->insert(["status_name" => $status_name, "file_upload" => $file_upload, "file_upload_max" => $number_of_files, "file_upload_required" => $file_upload_required, "notes_required" => $notes_required, "can_go_back" => $can_go_back, "case_close_success"=> $case_close_success, "case_close_rejected" => $case_close_rejected, "stage_order" => $stage_order, "color" => $color, "country_applicable" => $countries] );

        return redirect()->route("admin.settings.application-stages")->withFlashSuccess("University Applications Stage Added!");
    }

    public function update(Request $request, $id)
    {
        $stage = ApplicationStages::findOrFail($id);
        $request->validate([
            'edit_name' => 'required|unique:application_stages,status_name,'.$id,
            'edit_file_upload' => 'required',
            'edit_notes_required' => 'required',
            'edit_can_go_back' => 'required',
            'edit_color' => 'required',
        ]);
        $status_name = $request->edit_name;
        $file_upload = $request->edit_file_upload;
        $number_of_files = $request->edit_number_of_files;
        $file_upload_required = $request->edit_file_upload_required;
        $notes_required = $request->edit_notes_required;
        $can_go_back = $request->edit_can_go_back;
        $case_close = $request->edit_case_close;
        $case_close_type = $request->edit_case_close_type;
        $stage_order = $request->edit_stage_order;
        $color = $request->edit_color;

        if (isset($request->countries) && count($request->countries)) {
            $countries = implode(', ',$request->countries);
        }else{
            $countries = NULL; 
        }

        if ($case_close == '1' && $case_close_type == '1') {
            $case_close_success = '1';
            $case_close_rejected = '0';
        }
        else if ($case_close == '1' && $case_close_type == '0') {
            $case_close_success = '0';
            $case_close_rejected = '1';
        }
        else{
            $case_close_success = '-1';
            $case_close_rejected = '-1';
        }

        $stage->status_name = $status_name;
        $stage->file_upload = $file_upload;
        $stage->file_upload_max = $number_of_files;
        $stage->file_upload_required = $file_upload_required;
        $stage->notes_required = $notes_required;
        $stage->can_go_back = $can_go_back;
        $stage->case_close_success= $case_close_success;
        $stage->case_close_rejected = $case_close_rejected;
        $stage->stage_order = $stage_order;
        $stage->country_applicable = $countries;
        $stage->color = $color;
        $stage->save();

        return redirect()->route("admin.settings.application-stages")->withFlashSuccess("Application Stage Updated!");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $stage = ApplicationStages::findOrFail($id);
        $stage->delete();
        DB::table('university_application')->where('status', $stage->status_name)->update(['status' => ""]);

        return redirect()->route("admin.settings.application-stages")->withFlashSuccess("University Applications Stage Deleted!");
    }
}
