<?php

namespace App\Http\Controllers\Backend;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

use App\Models\Auth\Posts;
use Carbon\Carbon;
use Flash;
use Illuminate\Http\Request;
use Log;
use Auth;
use File;

//use Yajra\DataTables\DataTables;

class ArticlesController extends Controller {


    public function __construct()
    {

        $this->article_types = array(
            'content_page' => 'Content Page',
            'module_page' => 'Module Page'
        );

        $this->module_types = array(
            'home' => 'Home',
            //'coaching' => 'Coaching Classes',
            //'courses' => 'Online Courses',
            'country' => 'Country',
            //'webinar_events' => 'Webinar Events',
            //'demo_classes' => 'Demo Classes'
        );

        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('cms-articles'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }
            return $next($request);
        });
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function articles() {
        $module_title = "Articles";
        $page_heading = $module_title;

        Log::info("'$module_title' viewed by User:" . auth()->user()->name . '(ID:' . auth()->user()->id . ')');
        
        return view(
                "backend.articles.articlesindex",
                compact('module_title', 'page_heading')
        );
    }

    public function ajaxarticleslist(Request $request) {
        
        if (!$request->ajax()) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this page.');
        }
        echo $this->getDatatableArticles($request);
        
        
        //$data = Posts::latest()->get();
        //return Datatables::of($data)
        //                ->addIndexColumn()
        //                ->editColumn('type', function($data) {
        //                    return ucfirst($data->type);
        //                })
        //                ->editColumn('status', function($data) {
        //                    if ($data->status == 1) {
        //                        $status = "Published";
        //                    } else if ($data->status == 0) {
        //                        $status = "Unpublished";
        //                    } else {
        //                        $status = "Draft";
        //                    }
        //                    return $status;
        //                })
        //                ->addColumn('action', function($data) {
        //                    return view('backend.articles.btn', compact('data'));
        //                })
        //                ->rawColumns(['action'])
        //                ->make(true);
    }
    
    
    public function getDatatableArticles($request){
        $columns = array( 
                            0 =>'id', 
                            1=> 'title',
                            2=> 'type',
                            3=> 'status',
                            4=>'actions',
                            5=>'created_at'
                        );
                
        $totalData = DB::table('posts')->count();
        $totalFiltered = $totalData; 
        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');
          
        if(empty($request->input('search.value')))
        {                                
            $users = DB::table('posts')
                    ->select('id','title', 'type', 'module_type', 'status','created_at')
                    ->offset($start)
                    ->limit($limit)
                    ->orderBy($order, $dir)
                    ->get();
                            
        }
        else {
            $get_search = $request->input('search.value');                                                             
            $users = DB::table('posts')
                    ->select('id','title', 'type', 'module_type', 'status', 'created_at')
                    ->where(function($query) use ($get_search){
                        $query->Where('title', 'like', "%$get_search%")
                        ->orWhere('type', 'like', "%$get_search%");
                    })
                    ->offset($start)
                    ->limit($limit)
                    ->orderBy($order, $dir)
                    ->get();
            
            $totalFiltered = DB::table('posts')
                    ->where(function($query) use ($get_search){
                        $query->Where('title', 'like', "%$get_search%")
                        ->orWhere('type', 'like', "%$get_search%");
                    })
                    ->count();
            
        }

        $data = $customResult = array();
        if(!empty($users))
        {
            $count=1;
            foreach ($users as $page)
            {
                $customResult['id'] = $count++;
                $customResult['title'] = $page->title;
                $customResult['type'] = isset($this->article_types[$page->type]) ? $this->article_types[$page->type] : '';
                $customResult['type'] = (isset($page->module_type) && $page->module_type != '') ? $customResult['type'].' - '.$page->module_type : $customResult['type'];
                
                $customResult['status'] = $page->status == 1 ? 'Published' : 'Unpublished';
                if( $page->type== 'module_page'){
                    $customResult['actions'] = '
                                    <a href="'.route('admin.articles.edit',['id'=>$page->id]).'"
                                                class="btn btn-primary btn-sm"><i class="fas fa-edit" style="font-size:17px"></i> Edit</a>';
                }
                else{
                    
                    $customResult['actions'] = '
                                    <a href="'.route('admin.articles.edit',['id'=>$page->id]).'"
                                                class="btn btn-primary btn-sm"><i class="fas fa-edit" style="font-size:17px"></i> Edit</a>
                                    <a href="'.route('admin.articles.delete',['id'=>$page->id]).'"
                                   data-method="delete"
                                   class="btn btn-danger btn-sm" ><i Class="fa fa-trash"></i></a>';
                }
                $customResult['created_at'] = $page->created_at;
                                                   
                $data[] = $customResult;
            }
        }
           
        $json_data = array(
                    "draw"            => intval($request->input('draw')),  
                    "recordsTotal"    => intval($totalData),  
                    "recordsFiltered" => intval($totalFiltered), 
                    "data"            => $data   
                    );
           
        return json_encode($json_data); 
    }
    

    public function articles_create() {
        
        $module_types_created = Posts::Select('module_type')->groupBy('module_type')->get();
        $module_types = $this->module_types;
        foreach($module_types_created as $each_data){
            if(isset($module_types[$each_data->module_type])){
                unset($module_types[$each_data->module_type]);
            }
        }
        
        return view("backend.articles.create", ['article_types' => $this->article_types, 'module_types'=> $module_types]);
    }


    public function storeimage(Request $request) {
        $request->validate([
            'upload' => 'image|mimes:jpg,jpeg,jfif,pjpeg,pjp,png,gif,dib,bmp,webp,tif,tiff,svg,avif',
        ]);
        //------------File upload-------------------------
        
        if ($request->hasFile('upload')) {
            $file = $request->file('upload');
            $filename = $file->getClientOriginalName();
            if($file->getSize() > 0){
                \Log::debug("cms image uploading:" . $filename);
                $filename = str_replace(" ", "-", $filename);
                $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
                if (strlen($filename) > 60) {
                    $filename = substr($filename, 0, 60);
                }
                $filename = $filename . Str::random(20) . "." . $file->getClientOriginalExtension();

                if ($path = $request->upload->storeAs('/images/cms', $filename, 'public')) {
                    \Log::debug("::savedpath::$path");
                    $response_data = array("url" => asset('storage/images/cms/' . $filename));
                    return json_encode($response_data);
                } else {
                  $response_data = array("error"=>array("message"=>"The image upload failed"));
                  return json_encode($response_data);
                }
            }
        }
        else{
            $response_data = array("error"=>array("message"=>"Could not find a file"));
            return json_encode($response_data);
        }
        //-----------------------------------------------
    }


    public function store(Request $request) {
        
        
        $total_slug_count = Posts::where('slug', '=', $request->slug)->count();
        if($total_slug_count > 0){
            return redirect()->route('admin.articles')->withErrors('Error updating data. Slug already exists');
        }
        if(isset($request->show_in_main_menu) && $request->show_in_main_menu ==1 && trim($request->menu_title == '')){
            return redirect()->route('admin.articles')->withErrors('Error updating data. Please enter Menu Title');
        }
        
        
        //menu_title

        $request->validate([
            'title' => 'required',
            'slug' => 'required',
            'type' => 'required',
            'status' => 'required',
            'order' => 'numeric|min:0|not_in:0',
        ]);

        $data['created_by_name'] = auth()->user()->name;

        //if ($request->hasFile('featured_image')) {
        //    $filenameWithExt = $request->file('featured_image')->getClientOriginalName();
        //    // Get Filename
        //    $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        //    // Get just Extension
        //    $extension = $request->file('featured_image')->getClientOriginalExtension();
        //    // Filename To store
        //    $fileNameToStore = $filename . '_' . time() . '.' . $extension;
        //    $request->featured_image->move('images/cms', $fileNameToStore);
        //}
        
        $cms = new Posts;
        $cms->title = $request->title;
        $cms->menu_title = $request->menu_title;
        $cms->slug = $this->generateUrlPart($request->slug);
        $cms->intro = $request->intro;
        $cms->content = $request->content;
        $cms->type = $request->type;
        //$cms->module_type = (isset($request->module_type) && $request->module_type!= '') ? $request->module_type : NULL;
        $cms->module_type = (isset($request->module_type) && $request->module_type!= '' && $request->type == 'module_page') ? $request->module_type : NULL;
        $cms->created_by = auth()->user()->name;
        $cms->status = $request->status;
        $cms->published_at = empty($request->published_at) ? date('Y-m-d H:i:s') : date('Y-m-d H:i:s', strtotime($request->published_at));
        $cms->meta_title = $request->meta_title;
        $cms->meta_keywords = $request->meta_keywords;
        $cms->order = $request->order;
        $cms->meta_description = $request->meta_description;
        $cms->show_in_main_menu = !isset($request->show_in_main_menu) ? 0 : 1;
        
        
        if($cms->save())
            return redirect()->route('admin.articles')->withFlashSuccess("New Article Added");
        else
            return redirect()->route('admin.articles-create')->withErrors('Error Saving data');
    }
    
    public function ajaxValidateData(Request $request){
        $field = $request->field;
        $value = $request->value;
        $article_id = $request->article_id;
        
        if($field != '' && $value != ''){
            if($article_id == '')
                $total_count = Posts::where($field, '=', $value)->count();
            else
                $total_count = Posts::where($field, '=', $value)->where('id', '<>', $article_id)->count();
            
            if($total_count > 0){
                echo 0;
            }
            else{
                echo 1;
            }
        }
        else{
            echo 0;
        }
    }
    

    public function edit($id) {
        $module_title = "Edit Article";
        $article_det = Posts::findOrFail($id);
        $article_det->published_at = date('d-M-Y H:i',strtotime($article_det->published_at));

        Log::info($module_title . " | '" . $article_det->name . '(ID:' . $article_det->id . ") ' by User:" . Auth::user()->name . '(ID:' . Auth::user()->id . ')');
        $edi = "edit";
        $article_types = $this->article_types;
        $module_types = $this->module_types;
        $module_types_created = Posts::Select('module_type')->where('id','<>',$id)->groupBy('module_type')->get();
        
        foreach($module_types_created as $each_data){
            if(isset($module_types[$each_data->module_type])){
                unset($module_types[$each_data->module_type]);
            }
        }
                
        return view("backend.articles.edit",compact("article_det", 'edi','article_types','module_types'));
    }

    //public function removeimg($id) {
    //    $fimg = Posts::where('id', '=', $id)->first();
    //
    //    File::delete("images/cms/" . $fimg->featured_image);
    //
    //    Posts::where('id', '=', $id)->update(['featured_image' => '']);
    //
    //    Flash::success("<i class='fas fa-check'></i>Image is Removed Successfully")->important();
    //
    //    return redirect("admin/articles-edit/" . $id);
    //}

    public function update(Request $request, $id) {
        $total_slug_count = Posts::where('slug', '=', $request->slug)->where('id', '<>', $id)->count();
        if($total_slug_count > 0){
            return redirect()->route('admin.articles')->withErrors('Error updating data. Slug already exists');
        }
        if(isset($request->show_in_main_menu) && $request->show_in_main_menu ==1 && trim($request->menu_title == '')){
            return redirect()->route('admin.articles')->withErrors('Error updating data. Please enter Menu Title');
        }

        $request->validate([
            'title' => 'required',
            'slug' => 'required',
            'type' => 'required',
            'status' => 'required',
            'order' => 'numeric|min:0|not_in:0',
        ]);

        $cms_title = $request->title;
        $cms_menu_title = $request->menu_title;
        $cms_slug = $this->generateUrlPart($request->slug);
        $cms_intro = $request->intro;
        $cms_content = $request->content;
        $cms_type = $request->type;
        $cms_module_type = (isset($request->module_type) && $request->module_type!= '' && $request->type == 'module_page') ? $request->module_type : NULL;
        $cms_created_by = auth()->user()->name;
        $cms_status = $request->status;
        $r_published_at = $request->published_at; //str_replace('-','/',$request->published_at);
        $cms_published_at = empty($r_published_at) ? date('Y-m-d H:i:s') : date('Y-m-d H:i:s', strtotime($r_published_at));
        $cms_meta_title = $request->meta_title;
        $cms_meta_keywords = $request->meta_keywords;
        $cms_order = $request->order;
        $cms_meta_description = $request->meta_description;
        $cms_show_in_main_menu = !isset($request->show_in_main_menu) ? 0 : 1;
        

        if(Posts::where('id', '=', $id)->update([
            'title' => $cms_title, 'menu_title'=>$cms_menu_title, 'slug' => $cms_slug, 'intro' => $cms_intro, 'content' => $cms_content, 'type' => $cms_type,'module_type'=>$cms_module_type,  'created_by' => $cms_created_by, 'status' => $cms_status, 'published_at' => $cms_published_at, 'meta_title' => $cms_meta_title, 'meta_keywords' => $cms_meta_keywords, 'order' => $cms_order, 'meta_description' => $cms_meta_description,'show_in_main_menu'=>$cms_show_in_main_menu])){
                return redirect()->route('admin.articles')->withFlashSuccess("Article Updated Successfully");
            }
        else
            return redirect()->route('admin.articles')->withErrors('Error updating data');
        
        //if ($request->hasFile('featured_image')) {
        //
        //    $fimg = Posts::where('id', '=', $id)->first();
        //
        //    File::delete("images/cms/" . $fimg->featured_image);
        //
        //    $filenameWithExt = $request->file('featured_image')->getClientOriginalName();
        //    // Get Filename
        //    $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        //    // Get just Extension
        //    $extension = $request->file('featured_image')->getClientOriginalExtension();
        //    // Filename To store
        //    $fileNameToStore = $filename . '_' . time() . '.' . $extension;
        //    $request->featured_image->move('images/cms', $fileNameToStore);
        //}
        //
        


    }

    public function show($id) {
        $module_title = "View Article";

        $article_det = Posts::findOrFail($id);

        Log::info($module_title . ' | User:' . Auth::user()->name . '(ID:' . Auth::user()->id . ')');

        return view(
                "backend.articles.show",
                compact('module_title', 'module_name', "article_det")
        );
    }

    public function destroy($id) {
        $module_title = "Delete Article";
        $module_name_singular = Posts::Where('type','<>','module_page')->findOrFail($id);
        Log::info($module_title . " | '" . $module_name_singular->name . ', ID:' . $module_name_singular->id . " ' by User:" . Auth::user()->name . '(ID:' . Auth::user()->id . ')');
        $module_name_singular->delete();
        return redirect()->route('admin.articles')->withFlashSuccess("Article Deleted Successfully!");
    }
    
    
    public function generateUrlPart($input='') 
    { 
        $input = str_replace("&nbsp;", " ", $input);
        $input = mb_convert_case($input, MB_CASE_LOWER, "UTF-8"); //convert to lowercase
        $input = preg_replace("#[^a-zA-Z0-9]+#", "-", $input); //replace everything non an with dashes
        $input = preg_replace("#(-){2,}#", "$1", $input); //replace multiple dashes with one
        $input = trim($input, "-"); //trim dashes from beginning and end of string if any
        return $input; 
    }      

}
