<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Auth\Course;
use App\Models\Auth\BatchStudents;
use Illuminate\Foundation\Http\FormRequest;
use App\Repositories\Backend\Auth\RoleRepository;
use App\Repositories\Backend\Auth\PermissionRepository;
use App\Models\Auth\User;
use App\Models\Auth\Branch;
use App\Models\Auth\Batch;
use Illuminate\Support\Facades\Input;
use App\Models\Auth\Trainers;
use App\Http\Requests\Backend\Auth\User\BatchRequest;
use App\Http\Requests\Backend\Auth\User\ManageUserRequest;
use App\Repositories\Backend\Auth\UserRepository;
use App\Models\Auth\Attendance;

class AttendanceController extends Controller {

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('training classes'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }            
            return $next($request);
        });
    }

    public function index() {
        return view('backend.attendance.attendance');
    }
    
    public function ajaxfeedbackdata(ManageUserRequest $request) {
        if (!$request->ajax()) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this page.');
        }
        echo $this->getDatatableFeedback($request);
    }
    
    
    
    
    public function getDatatableFeedback($request){
    
        $columns = array( 
                            0 =>'date', 
                            1 =>'student_name',
                            2=> 'mobile',
                            3=> 'code',
                            4=> 'title',
                            5=> 'trainer',
                            6=> 'rating',
                            7=> 'review'
                        );
        
        
        $totalData = DB::table('attendance')
                ->join('users', 'users.id', '=', 'attendance.student_id')
                ->join('batch', 'batch.id', '=', 'attendance.batch_id')
                ->join('courses', 'courses.id', '=', 'batch.course')
                ->count();
        
        $totalFiltered = $totalData; 
    
        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');
            
        if(empty($request->input('search.value')))
        {            
            $users = DB::table('attendance')
                    ->select('attendance.date', 'attendance.rating', 'attendance.review', 'users.first_name', 'users.last_name', 'batch.code', 'users.mobile', 'courses.title', 'batch.trainer','attendance.student_id', 'attendance.id')
                    ->join('users', 'users.id', '=', 'attendance.student_id')
                    ->join('batch', 'batch.id', '=', 'attendance.batch_id')
                    ->join('courses', 'courses.id', '=', 'batch.course')
                    ->offset($start)
                    ->limit($limit)
                    ->orderBy($order, $dir)
                    ->get();
        }
        else {
            $get_search = $request->input('search.value'); 
            $users = DB::table('attendance')
                    ->select('attendance.date', 'attendance.rating', 'attendance.review', 'users.first_name', 'users.last_name', 'batch.code', 'users.mobile', 'courses.title', 'batch.trainer','attendance.student_id', 'attendance.id')
                    ->join('users', 'users.id', '=', 'attendance.student_id')
                    ->join('batch', 'batch.id', '=', 'attendance.batch_id')
                    ->join('courses', 'courses.id', '=', 'batch.course')
                    ->where(function($query) use ($get_search){
                        $query->where('attendance.date', 'like', "%$get_search%")
                        ->orWhere('attendance.rating', 'like', "%$get_search%")
                        ->orWhere('attendance.review', 'like', "%$get_search%")
                        ->orWhere('users.first_name', 'like', "%$get_search%")
                        ->orWhere('users.last_name', 'like', "%$get_search%")
                        ->orWhere('batch.code', 'like', "%$get_search%")
                        ->orWhere('courses.title', 'like', "%$get_search%")
                        ->orWhere('batch.trainer', 'like', "%$get_search%")
                        ->orWhere('users.mobile', 'like', "%$get_search%");
                    })
                    ->offset($start)
                    ->limit($limit)
                    ->orderBy($order, $dir)
                    ->get();
                        
            $totalFiltered = DB::table('attendance')
                    ->join('users', 'users.id', '=', 'attendance.student_id')
                    ->join('batch', 'batch.id', '=', 'attendance.batch_id')
                    ->join('courses', 'courses.id', '=', 'batch.course')
                    ->where(function($query) use ($get_search){
                        $query->where('attendance.date', 'like', "%$get_search%")
                        ->orWhere('attendance.rating', 'like', "%$get_search%")
                        ->orWhere('attendance.review', 'like', "%$get_search%")
                        ->orWhere('users.first_name', 'like', "%$get_search%")
                        ->orWhere('users.last_name', 'like', "%$get_search%")
                        ->orWhere('batch.code', 'like', "%$get_search%")
                        ->orWhere('courses.title', 'like', "%$get_search%")
                        ->orWhere('batch.trainer', 'like', "%$get_search%")
                        ->orWhere('users.mobile', 'like', "%$get_search%");
                    })
                    ->count();
        }
        
        $data = array();
        if(!empty($users))
        {
            foreach ($users as $page)
            {
                
                $customResult['date'] = get_date_formated($page->date);
                $customResult['student_name'] = "<a target='_blank' href='" . route('admin.auth.user.show', $page->id) . "'><strong><span style='white-space:nowrap;'>".$page->first_name.' '.$page->last_name."</a>";
                $customResult['mobile'] = $page->mobile;
                $customResult['code'] = $page->code;
                $customResult['title'] = $page->title;
                $customResult['trainer'] = get_user_full_name_by_id($page->trainer);
                $customResult['rating'] = $page->rating.'<i class="bi bi-star-fill" style="font-size:14px;color: #4154f3;"></i>';
                $read_full = '';
                if(strlen($page->review)>50){
                    $read_full = '&gt;&gt;';
                }
                $customResult['review'] = '<span title="'.$page->review.'">'.substr($page->review, 0, 50).$read_full.'</span>';
                $data[] = $customResult;
            }
        }
          
        $json_data = array(
                    "draw"            => intval($request->input('draw')),  
                    "recordsTotal"    => intval($totalData),  
                    "recordsFiltered" => intval($totalFiltered), 
                    "data"            => $data   
                    );
            
        return json_encode($json_data); 
    }    
    
    
    
 }
