<?php

namespace App\Http\Controllers\Backend\Auth\User;
use App\Models\Auth\User;
use Illuminate\Support\Str;
use App\Models\StaffDetails;
use Illuminate\Http\Request;
use  App\Models\StaffWorkExp;
use App\Models\StaffEduDetails;
use App\Models\Auth\UserDetails;
use App\Models\Auth\AgentDetails;
use App\Recipients\AdminRecipient;
use App\Http\Controllers\Controller;
use App\Models\Auth\UserNotification;
use App\Models\StaffDependentDetails;
use App\Models\StaffAditionalDocument;
use Illuminate\Support\Facades\Storage;
use App\Repositories\Backend\Auth\UserRepository;
use App\Http\Requests\Backend\Auth\User\ManageUserRequest;
use App\Http\Requests\Backend\Auth\User\UpdateSelfPasswordRequest;
use App\Http\Requests\Backend\Auth\User\UpdateAdminBasicInfoRequest;


/**
 * Class AccountController.
 */
class AccountController extends Controller
{
    
    
    /**
     * @var UserRepository
     */
    protected $userRepository;

    /**
     * @param UserRepository $userRepository
     */
    public function __construct(UserRepository $userRepository)
    {
        $this->userRepository = $userRepository;
    }
    
    
    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        
        $user_id = \Auth::user()->id;
        if(!UserDetails::where('userid', $user_id)->exists()) {
            $userdetails = new UserDetails([
                'userid'    => $user_id,
            ]);
            $userdetails->save();
        }
        $userDetails = UserDetails::where('userid', $user_id)->first();
        return view('backend.auth.user.account', compact('userDetails'));
    }
    
    
    
    public function basicinfo(){
        if(\Auth::user()->isAgent()){
            $user = User::find(\Auth::user()->id);
            $agent_details = AgentDetails::where('agent_id', $user->id)->first();
            if(!$agent_details){
                $agent_details = AgentDetails::create([
                    'agent_id' => $user->id,
                ]);
                $agent_details->save();
            }
            return view('backend.agents.profile', ['agent_details' => $agent_details, 'user' => $user]);
        } else{
            return view('backend.auth.user.basicinfo');
        }
        // return view('backend.auth.user.basicinfo');
    }

    public function updateBusinessLogo(Request $request){
        $request->validate([
            'agent_panel_logo' => 'required|mimes:jpg,jpeg,gif,png,svg|max:500'
        ]);

        $agent_id = $request->agent_id;
        $agent_panel_logo = "";

        if ($request->file('agent_panel_logo')) {
            $file = $request->agent_panel_logo->getClientOriginalName();
            $filename = pathinfo($file, PATHINFO_FILENAME);
            if (strlen($filename) > 125)
                $filename = substr($filename, 0, 125);
        
            $filename = $filename . Str::random(20) . "." . $request->agent_panel_logo->getClientOriginalExtension();
            $agent_panel_logo = $request->file('agent_panel_logo')->storeAs('/agent_doc', $filename, 'public');
        }

        $user = User::where('id', $agent_id)->first();
        $agent_details = AgentDetails::where('agent_id', $agent_id)->first();
        if($agent_panel_logo){
            $agent_details->agent_panel_logo = $agent_panel_logo;
            $agent_details->logo_approved = 0;
        }
        $agent_details->save();

		$msg_details = "Agent has Uploaded new logo.<br /><br />Agent Name: " . get_user_full_name_by_id($user->id) . "<br />Business Name: " . $agent_details->business_name ."<br />email: " . $user->email . "<br />Mobile: " . $user->dialcode . ' ' . $user->mobile;
		$notify_emails = get_site_config('event_notification_email');
		if($notify_emails) {
			send_event_notification_email(explode(",", $notify_emails), "Agent Portal Logo Uploaded", $msg_details);
		}
    
        return redirect()->route('admin.auth.abasicinfo')->withFlashSuccess("Business Logo Updated.");
    }
    
    /**
     * @param UpdatePasswordRequest $request
     *
     * @return mixed
     * @throws \App\Exceptions\GeneralException
     */
    public function updateAdminPassword(UpdateSelfPasswordRequest $request)
    {
        if(env('DEMO_MODE') && in_array($request->user()->id, config('app.demo_users')))
            return redirect()->route('admin.demo-user-restriction');
            
        $this->userRepository->updateSelfPassword($request->only('old_password', 'password'));
        return redirect()->route('admin.auth.adminaccount')->withFlashSuccess(__('strings.frontend.user.password_updated'));
    }
        
    
    public function updateBasicinfo(UpdateAdminBasicInfoRequest $request)
    {
        if(env('DEMO_MODE') && in_array($request->user()->id, config('app.demo_users')))
            return redirect()->route('admin.demo-user-restriction');    

        $output = $this->userRepository->updateBasicInfo(
                 $request,         
                $request->user()->id, 
                $request->all()
        );
        return redirect()->route('admin.auth.abasicinfo')->withFlashSuccess(__('strings.frontend.user.profile_updated'));
    }


    public function emailSignature(Request $request){
        $user_id = \Auth::user()->id;
        // $messages = $request->get('email_signature');
        $userdetails = UserDetails::where('userid', $user_id)->first();
        if($userdetails){
            $userdetails->email_signature = $request->get('email_signature');
            $userdetails->save();
        }else{
            $userdetails = new UserDetails([
                'userid'    => $user_id,
                'email_signature' => $request->get('email_signature')
            ]);
            $userdetails->save();
        }
        return redirect()->route('admin.auth.adminaccount')->withFlashSuccess("Email Signature Save Successfully!");

    }


     public function updatePassportDoc(Request $request ,$staff_id)
    {
       
        $request->validate([
            'passport_doc' => 'required|mimes:jpeg,jpg,png,pdf|max:' . (config('app.staff_doc_max_size') * 1024),
        ], [
            'passport_doc.max' => 'The passport_doc may not be greater than ' . config('app.staff_doc_max_size') . ' MB.',
        ]);

    
       
        $staff_details = StaffDetails::where('staff_id' , $staff_id)->first();
    
        if ($request->hasFile('passport_doc')) {
            // Delete old file
            if (!empty($staff_details->passport_doc) && Storage::disk('public')->exists($staff_details->passport_doc)) {
                Storage::disk('public')->delete($staff_details->passport_doc);
            }
    
            // Store new file
            $file = $request->file('passport_doc');
            $originalFileName = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $extension = strtolower($file->getClientOriginalExtension()); 

    
            $filename = Str::slug($originalFileName) . '.' . $extension; 
            $path = $file->storeAs('uploads/staff_doc', $filename, 'public');
            
            $staff_details->passport_doc ='uploads/staff_doc/' . $filename;
            
        }
        $staff_details->save();
        return redirect()->back()
                        ->withFlashSuccess("Passport Uploaded Successfully"); ;
    }
    public function updateNationalIdDoc(Request $request , $staff_id)
    {
       
        $request->validate([
            'national_insurance_doc' => 'required|mimes:jpeg,jpg,png,pdf|max:2048',
        ]);
    
        $user = auth()->user(); // Get current user
        $staff_details = StaffDetails::where('staff_id', $staff_id)->first();
    
        if ($request->hasFile('national_insurance_doc')) {
            // Delete old file
            if (!empty($staff_details->national_insurance_doc) && Storage::disk('public')->exists($staff_details->national_insurance_doc)) {
                Storage::disk('public')->delete($staff_details->national_insurance_doc);
            }
    
            // Store new file
            $file = $request->file('national_insurance_doc');
            $originalFileName = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $extension = strtolower($file->getClientOriginalExtension()); 

    
            $filename = Str::slug($originalFileName) . '.' . $extension; 
            $path = $file->storeAs('uploads/staff_doc', $filename, 'public');
            
            $staff_details->national_insurance_doc ='uploads/staff_doc/' . $filename;
            
        }
        $staff_details->save();
        return redirect()->back()
        ->withFlashSuccess("National Insurance Uploaded Successfully"); ;
    }
    public function updateHmrcDoc(Request $request , $staff_id)
    {
       
        $request->validate([
            'hmrc_document_doc' => 'required|mimes:jpeg,jpg,png,pdf|max:2048',
        ]);
    
        $user = auth()->user(); // Get current user
        $staff_details = StaffDetails::where('staff_id', $staff_id)->first();
    
        if ($request->hasFile('hmrc_document_doc')) {
            // Delete old file
            if (!empty($staff_details->hmrc_document_doc) && Storage::disk('public')->exists($staff_details->hmrc_document_doc)) {
                Storage::disk('public')->delete($staff_details->hmrc_document_doc);
            }
    
            // Store new file
            $file = $request->file('hmrc_document_doc');
            $originalFileName = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $extension = strtolower($file->getClientOriginalExtension()); 

    
            $filename = Str::slug($originalFileName) . '.' . $extension; 
            $path = $file->storeAs('uploads/staff_doc', $filename, 'public');
            
            $staff_details->hmrc_document_doc ='uploads/staff_doc/' . $filename;
            
        }
        $staff_details->save();
        return redirect()->back()
        ->withFlashSuccess("HMRC Uploaded Successfully"); ;
    }
    // public function updateContractDoc(Request $request)
    // {
       
    //     $request->validate([
    //         'doc_contract_agreement' => 'required|mimes:jpeg,jpg,png,pdf|max:2048',
    //     ]);
    
    //     $user = auth()->user(); 
    //     $staff_details = StaffDetails::where('staff_id', $user->id)->first();
    
    //     if ($request->hasFile('doc_contract_agreement')) {
        
    //         if (!empty($staff_details->doc_contract_agreement) && Storage::disk('public')->exists($staff_details->doc_contract_agreement)) {
    //             Storage::disk('public')->delete($staff_details->doc_contract_agreement);
    //         }
    
            
    //         $file = $request->file('doc_contract_agreement');
    //         $originalFileName = $file->getClientOriginalName();
    //         $filename = time(). '.' . $file->getClientOriginalExtension();
    //         $path= $file->storeAs('uploads/staff_profiles', $originalFileName , 'public');
    //         $staff_details->doc_contract_agreement ='uploads/staff_profiles/' . $filename;
            
    //     }
    //     $staff_details->save();
    //     return redirect()->route('admin.auth.abasic.info.edit')->withFlashSuccess("Contract document Uploaded Successfully"); ;
    // }
    

    public function updateContractDoc(Request $request, $staff_id)
{
    $request->validate([
        'doc_contract_agreement' => 'required|mimes:jpeg,jpg,png,pdf|max:2048',
    ]);

    $user = auth()->user(); 
    $staff_details = StaffDetails::where('staff_id', $staff_id)->first();

    if ($request->hasFile('doc_contract_agreement')) {
      
        if (!empty($staff_details->doc_contract_agreement) && Storage::disk('public')->exists($staff_details->doc_contract_agreement)) {
            Storage::disk('public')->delete($staff_details->doc_contract_agreement);
        }

 
        $file = $request->file('doc_contract_agreement');
        $originalFileName = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
        $extension = $file->getClientOriginalExtension(); 

   
        $filename = Str::slug($originalFileName) . '.' . $extension; 
        $path = $file->storeAs('uploads/staff_doc', $filename, 'public');

        // Save file path in database
        $staff_details->doc_contract_agreement = $path;
        $staff_details->save();
    }

    return redirect()->back()
    ->withFlashSuccess("Contract document uploaded successfully.");
}

public function staffFileUpload(Request $request, $staff_id , $document_column_name)
{
    $request->validate([
    $document_column_name => 'required|mimes:jpeg,jpg,png,pdf|max:' . (config('app.staff_doc_max_size') * 1024),
], [
    $document_column_name.'.max' => 'The ' . $document_column_name . ' may not be greater than ' . config('app.staff_doc_max_size') . ' MB.',
]);

    $staff_details = StaffDetails::where('staff_id', $staff_id)->first();

    if ($request->hasFile( $document_column_name)) {
      
        if (!empty($staff_details->$document_column_name) && Storage::disk('public')->exists($staff_details->$document_column_name)) {
            Storage::disk('public')->delete($staff_details->$document_column_name);
        }

 
        $file = $request->file($document_column_name);
        $originalFileName = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
        $extension = $file->getClientOriginalExtension(); 

   
        $filename = Str::slug($originalFileName) . '.' . $extension; 
        $path = $file->storeAs('/staff_doc', $filename, 'public');

        // Save file path in database
        $staff_details->$document_column_name = $path;
        $staff_details->save();
    }

    return redirect()->back()
    ->withFlashSuccess("Document uploaded successfully.");
}

// all file uploaded 


    public function updateStaffDoc(Request $request)
    {
        $request->validate([
            'file_names' => 'required|array|max:4',
            'file_names.*' => 'required|string|max:255',
            'documents' => 'required|array|max:4',
            'documents.*' => 'required|mimes:jpeg,jpg,png,pdf|max:2048',
        ]);
    
        $user = auth()->user(); // Get current user
        $uploadedFiles = [];
    
        foreach ($request->file('documents') as $index => $file) {
            $originalFileName = Str::slug($request->file_names[$index], '-'); // Slugify filename
            $extension = $file->getClientOriginalExtension();
            $finalFileName = time() . '-' . $originalFileName . '.' . $extension;
            
            $path = $file->storeAs('uploads/documents', $finalFileName, 'public');
            $uploadedFiles[] = $path;
        }
    
        return redirect()->back()->with('success', 'Files uploaded successfully.');
    }

    //delete document 

    public function deletePassportDoc()
    {
        $user = auth()->user();
        $staff_details = StaffDetails::where('staff_id', $user->id)->first();

        if (!empty($staff_details->passport_doc) && Storage::disk('public')->exists($staff_details->passport_doc)) {
            // Delete file from storage
            Storage::disk('public')->delete($staff_details->passport_doc);
            
            // Remove file path from the database
            $staff_details->passport_doc = null;
            $staff_details->save();
        }

        return redirect()->back()->withFlashSuccess( 'Passport document deleted successfully');
    }
    public function deleteNationalIdDoc()
    {
        $user = auth()->user();
        $staff_details = StaffDetails::where('staff_id', $user->id)->first();

        if (!empty($staff_details->national_insurance_doc) && Storage::disk('public')->exists($staff_details->national_insurance_doc)) {
            // Delete file from storage
            Storage::disk('public')->delete($staff_details->national_insurance_doc);
            
            // Remove file path from the database
            $staff_details->national_insurance_doc = null;
            $staff_details->save();
        }

        return redirect()->back()->withFlashSuccess('National Id document deleted successfully');
    }
    public function deleteHmrcDoc()
    {
        $user = auth()->user();
        $staff_details = StaffDetails::where('staff_id', $user->id)->first();

        if (!empty($staff_details->hmrc_document_doc) && Storage::disk('public')->exists($staff_details->hmrc_document_doc)) {
            // Delete file from storage
            Storage::disk('public')->delete($staff_details->hmrc_document_doc);
            
            // Remove file path from the database
            $staff_details->hmrc_document_doc = null;
            $staff_details->save();
        }

        return redirect()->back()->withFlashSuccess( 'HMRC document deleted successfully');
    }
    public function deleteContractAgreementDoc()
    {
        $user = auth()->user();
        $staff_details = StaffDetails::where('staff_id', $user->id)->first();

        if (!empty($staff_details->doc_contract_agreement) && Storage::disk('public')->exists($staff_details->doc_contract_agreement)) {
            // Delete file from storage
            Storage::disk('public')->delete($staff_details->doc_contract_agreement);
            
            // Remove file path from the database
            $staff_details->doc_contract_agreement = null;
            $staff_details->save();
        }

        return redirect()->back()->withFlashSuccess( 'Contract document deleted successfully');
    }
    public function deletePanCardDoc()
    {
        $user = auth()->user();
        $staff_details = StaffDetails::where('staff_id', $user->id)->first();

        if (!empty($staff_details->doc_pan_card) && Storage::disk('public')->exists($staff_details->doc_pan_card)) {
            // Delete file from storage
            Storage::disk('public')->delete($staff_details->doc_pan_card);
            
            // Remove file path from the database
            $staff_details->doc_pan_card = null;
            $staff_details->save();
        }

        return redirect()->back()->withFlashSuccess('Contract document deleted successfully');
    }

    public function deleteAlldocument(Request $request, $staff_id, $columnname)
    {
    
        $staff_details = StaffDetails::where('staff_id', $staff_id)->first();
        
        if (!empty($staff_details->$columnname) && Storage::disk('public')->exists($staff_details->$columnname)) {
            // dd("called" ,$staff_id , $columnname , $staff_details);
            // Delete file from storage
            Storage::disk('public')->delete($staff_details->$columnname);
            
           
        }
         // Remove file path from the database
         $staff_details->$columnname= null;
         // dd( $staff_details->$columnname);
          $staff_details->save();

        return redirect()->back()->withFlashSuccess( 'Document deleted successfully');
   
    }

    public function downloadFile($filename)
{

    $filePath = 'staff_doc/' . $filename;

  
    if (!Storage::disk('public')->exists($filePath)) {
        return redirect()->back()->with('error', 'File not found.');
    }

    // Return file as a download response
    // return response()->download(storage_path('app/public/' . $filePath));

    // Get full path
    $fullPath = storage_path('app/public/' . $filePath);

    return response()->download($fullPath, $filename, [
        'Content-Type' => 'application/octet-stream',
        'Content-Disposition' => 'attachment; filename="' . $filename . '"',
    ]);
}

    public function accountRemoval(Request $request){
        // dd($request->all());
        $userId = \Auth::user()->id;
        $user = User::with('roles', 'permissions', 'providers')
                    ->whereHas('roles', function ($q) {
                        $q->whereIn('name', ['agent']);
                    })
                    ->where('id', $userId)
                    ->first();
        
        if($request->confirm_delete_text == "DELETE"){
            $user->active = 0;
            $user->confirmed = 0;
            $user->save();

            $subject = "Agent: {$user->full_name} ({$user->id}) requested account deletion.";
            $email_message = "
                Hi,<br/><br/>
                The following Agent has requested account deletion.<br/><br/>
                <strong>Agent Details:</strong><br/>
                Name: {$user->first_name} {$user->last_name}<br/>
                Mobile: {$user->mobile}<br/>
                Email: {$user->email}<br/><br/>
                Please review this request and take necessary actions.<br/><br/>
            ";

            $recipient = new AdminRecipient();
            try {
                user_notify($recipient, "NOTIFICATION: ".$subject, $email_message);
                \Log::debug("Mail Sent to Admin- ($subject) " . $email_message);
            } catch (\Exception $e) {
                $err_message = $e->getMessage();
                \Log::debug("Mail Error: Admin- ($subject) " . $email_message.". Error: ".$err_message);
            }

            $email_message = "
                Requested Account Deletion: The following Agent has requested account deletion.<br/>
                <strong>Agent Details:</strong><br/>
                Name: {$user->first_name} {$user->last_name}<br/>
                Mobile: {$user->mobile}<br/>
                Email: {$user->email}<br/>
                Please review this request and take necessary actions.<br/>
            ";
            $noti = new UserNotification;
            $noti->user_id = 1;
            $noti->application_id = $user->id;
            $noti->application_type = "agent";
            $noti->message = $email_message;
            $noti->from_user = $userId;
            $noti->save();

            // Logout user
            auth()->logout();

            return redirect()->route('admin.auth.adminaccount')->withFlashSuccess("Your account deletion request has been submitted successfully and it will be removed within 7 days.");
        }

        return redirect()->route('frontend.user.profile')->withFlashDanger('Please confirm account deletion by checking the box.');
    }
    
}
