<?php

namespace App\Http\Controllers\Backend\Auth\User;

use App\Models\Auth\User;
use App\Models\Auth\Branch;
use App\Models\StaffBranch;
use Illuminate\Support\Str;
use App\Models\Auth\Country;
use App\Models\StaffDetails;
use App\Models\StaffWorkExp;
use Illuminate\Http\Request;
use App\Models\MailTemplates;
use App\Models\StaffEduDetails;
use App\Models\Auth\AgentDetails;
use App\Models\Auth\CountryStudy;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\StaffDependentDetails;
use Intervention\Image\Facades\Image;
use App\Models\StaffAditionalDocument;
use Illuminate\Support\Facades\Storage;
use App\Notifications\Backend\UserAlert;
use App\Events\Backend\Auth\User\UserDeleted;
use App\Repositories\Backend\Auth\RoleRepository;
use App\Repositories\Backend\Auth\UserRepository;
use App\Repositories\Backend\Auth\StaffRepository;
use App\Repositories\Backend\Auth\PermissionRepository;
use App\Http\Requests\Backend\Auth\User\ManageUserRequest;
use App\Http\Requests\Backend\Auth\User\StoreStaffRequest;
use App\Http\Requests\Backend\Auth\User\UpdateStaffRequest;
use App\Http\Requests\Backend\Auth\User\StoreStudentRequest;

/**
 * Class StaffController.
 */
class StaffController extends Controller
{

    /**
     * @var StaffRepository
     */
    protected $staffRepository;



    /**
     * StaffController constructor.
     *
     * @param StaffRepository $staffRepository
     */
    public function __construct(StaffRepository $staffRepository)
    {
        $this->staffRepository = $staffRepository;
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('view staff') || \Auth::user()->isAgent())) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }
            return $next($request);
        });
    }



    /**
     * @param ManageUserRequest $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(ManageUserRequest $request)
    {
        return view('backend.staff.staff_index');
    }



    public function ajaxuserdata(ManageUserRequest $request)
    {
        echo $this->staffRepository->getDatatableUsers($request);
        
    }

    public function search(ManageUserRequest $request)
    {
        return view('backend.auth.user.staff')
            ->withFilter($request->input('q'))
            ->withUsers($this->staffRepository->getStaffFilteredPaginated($request->input('q'), 10, 'id', 'desc'));
    }

    /**
     * @param ManageUserRequest $request
     *
     * @return mixed
     */
    public function getDeactivated(ManageUserRequest $request)
    {
        return view('backend.auth.user.deactivatedstaff', ['staff_mgmt' => 1])
            ->withUsers($this->staffRepository->getInactivePaginated(25, 'id', 'asc'));
    }




    /**
     * @param ManageUserRequest $request
     *
     * @return mixed
     */
    public function getDeleted(ManageUserRequest $request)
    {
        return view('backend.auth.user.deletedstaff', ['staff_mgmt' => 1])
            ->withUsers($this->staffRepository->getDeletedPaginated(25, 'id', 'asc'));
    }




    /**
     * @param ManageUserRequest $request
     * @param User              $deletedUser
     *
     * @return mixed
     * @throws \App\Exceptions\GeneralException
     */
    public function restore(ManageUserRequest $request, User $deletedUser)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('edit-staff'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        $this->staffRepository->restore($deletedUser);

        return redirect()->route('admin.auth.staff')->withFlashSuccess(__('alerts.backend.users.restored'));
    }



    /**
     * @param ManageUserRequest    $request
     * @param RoleRepository       $roleRepository
     * @param PermissionRepository $permissionRepository
     *
     * @return mixed
     */
    public function staffCreate(ManageUserRequest $request, RoleRepository $roleRepository, PermissionRepository $permissionRepository)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('edit-staff'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        // $dialcodes = Country::groupBy('tel')->orderBy('tel','asc')->get(['tel as code', 'title_en as name']);
        $dialcodes = Country::orderBy('country_code', 'asc')->get(['tel as code', 'code as country_code', 'title_en as name']);
        $branch_list = Branch::orderBy('branch_name')->get();
        return view('backend.staff.createstaff', ['dialcodes' => $dialcodes, 'branch_list' => $branch_list])
            ->withRoles($roleRepository->with('permissions')->get(['id', 'name']))
            ->withPermissions($permissionRepository->get(['id', 'name']));
    }



    /**
     * @param StoreStaffRequest $request
     *
     * @return mixed
     * @throws \Throwable
     */
    public function staffStore(StoreStaffRequest $request)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('edit-staff'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }

        $result = create_staff($request->only(
            'first_name',
            'last_name',
            'email',
            'dialcode',
            'mobile',
            'smtp_host',
            'smtp_port',
            // 'imap_host',
            // 'imap_port',
            'email_integration',
            'smtp_encryption',
            'smtp_password',
            'whatsapp_dialcode',
            'whatsapp_number',
            'password',
            'active',
            'branch',
            'reporting_to',
            'confirmed',
            'confirmation_email',
            'roles',
            'permissions'
        ));

        if ($result) {
            return redirect()->route('admin.auth.staff')->withFlashSuccess("The staff was successfully created.");
        } else {
            return redirect()->route('admin.auth.staff')->withFlashDanger("The staff limit reached.");
        }
    }



    /**
     * @param ManageUserRequest $request
     * @param User              $user
     *
     * @return mixed
     */
    public function show(ManageUserRequest $request, User $user)
    {
        if (!is_staff_user($user->id)) {
            return redirect()->route('admin.auth.staff')->withFlashDanger('Invalid Staff ID');
        }
        $userDetails = DB::table('user_details')->where('userid', $user->id)->first();
        // dd($userDetails);  
        $userStaff= DB::table('staff_details')->where('staff_id', $user->id)->first();
        $aditional_documents_details = StaffAditionalDocument::where('staff_id', $user->id)->get();
        $staff_workexperience_details = StaffWorkExp::where('staff_id', $user->id)->get();
        $staff_education_details = StaffEduDetails::where('staff_id', $user->id)->get();
       $staff_dependent_details = StaffDependentDetails::where('staff_id', $user->id)->get();
                       
        return view('backend.staff.showstaff', [
            'userDetails' => $userDetails,
            'userStaff'=> $userStaff,
            'aditional_documents_details'=>$aditional_documents_details,
            'staff_workexperience_details' => $staff_workexperience_details,
            'staff_education_details' => $staff_education_details,
            'staff_dependent_details' => $staff_dependent_details
            
            
            
            ])
            ->withUser($user);
    }



    /**
     * @param ManageUserRequest    $request
     * @param RoleRepository       $roleRepository
     * @param PermissionRepository $permissionRepository
     * @param User                 $user
     *
     * @return mixed
     */
    public function edit(ManageUserRequest $request, RoleRepository $roleRepository, PermissionRepository $permissionRepository, User $user)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('edit-staff'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        if (!is_staff_user($user->id)) {
            return redirect()->route('admin.auth.staff')->withFlashDanger('Invalid Staff ID');
        }
        $data = DB::table('users')->select('country_interested')->get();
        $pages = CountryStudy::all();
        foreach ($data as $rest) {
            $system = $rest->country_interested;
        }
        $rty = explode(',', $system);
        // $dialcodes = Country::groupBy('tel')->orderBy('tel','asc')->get(['tel as code', 'title_en as name']);
        $dialcodes = Country::orderBy('country_code', 'asc')->get(['tel as code', 'code as country_code', 'title_en as name']);
        $branch_list = Branch::orderBy('branch_name')->get();    
        $staff_branch = DB::table('staff_branch')->where('staff_id', $user->id)->pluck('branch_id')->toArray();
        if (!StaffDetails::where('staff_id', $user->id)->exists()) {
            StaffDetails::create([
                'staff_id' => $user->id,
                'smtp_username' => $user->email
            ]);
        }
        $staff_details = DB::table('staff_details')->where('staff_id', $user->id)->first();
        
        
        return view('backend.staff.staff_edit', ['pages' => $pages, 'rty' => $rty, 'dialcodes' => $dialcodes, 'staff_mgmt' => 1, 'branch_list' => $branch_list, 'staff_branch' => $staff_branch, 'staff_details' => $staff_details])
            ->withUser($user)
            ->withRoles($roleRepository->get())
            ->withUserRoles($user->roles->pluck('name')->all())
            ->withPermissions($permissionRepository->get(['id', 'name']))
            ->withUserPermissions($user->permissions->pluck('name')->all());
    }



    public function update(UpdateStaffRequest $request, User $user)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('edit-staff'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        if (!is_staff_user($user->id)) {
            return redirect()->route('admin.auth.staff')->withFlashDanger('Invalid Staff ID');
        }
        if ($user->id == 1 && \Auth::user()->id != 1) {
            // Other staff cannot update super admin details
            return redirect()->route('admin.dashboard.message')->withFlashDanger('This operation is not allowed');
        }

        if (env('DEMO_MODE') && in_array($user->id, config('app.demo_users')))
            return redirect()->route('admin.demo-user-restriction');


        $this->staffRepository->update($user, $request->only(
            'first_name',
            'last_name',
            'email',
            'dialcode',
            'smtp_host',
            'smtp_port',
            // 'imap_host',
            // 'imap_port',
            'email_integration',
            'smtp_encryption',
            'smtp_password',
            'old_smtp_password',
            'mobile',
            'whatsapp_dialcode',
            'whatsapp_number',
            'alternate_contact',
            'reporting_to',
            'roles',
            'birthday',
            'branch',
            'permissions'
        ));

        return redirect()->route('admin.auth.staff')->withFlashSuccess("The staff was successfully updated.");
    }



    /**
     * @param ManageUserRequest $request
     * @param User              $user
     *
     * @return mixed
     * @throws \Exception
     */
    public function destroy(ManageUserRequest $request, User $user)
    {
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('edit-staff'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        if (!is_staff_user($user->id)) {
            return redirect()->route('admin.auth.staff')->withFlashDanger('Invalid Staff ID');
        }
        if ($user->id == 1) {
            // Cant delete super admin
            return redirect()->route('admin.dashboard.message')->withFlashDanger('This operation is not allowed');
        }        
        
        if($user->id){
            DB::table("users")->where("assigned_to", $user->id)->update(["assigned_to" => 1]);
            DB::table("university_application")->where("assign_to", $user->id)->update(["assign_to" => 1]);
        }
        

        $this->staffRepository->deleteById($user->id);

        event(new UserDeleted($user));

        return redirect()->route('admin.auth.staff')->withFlashSuccess(__('alerts.backend.users.deleted'));
    }

    public function my_docs(ManageUserRequest $request, User $user)
    {
        $data = array();
        return view('user.documents', $data);
    }

    // public function editStaffDetails(ManageUserRequest $request, RoleRepository $roleRepository, PermissionRepository $permissionRepository, User $user)
    // {
    //     // $user = User::find($id);
    //     if (!(\Auth::user()->isAdmin() || \Auth::user()->can('edit-staff'))) {
    //         return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
    //     }
    //     if (!is_staff_user($user->id)) {
    //         return redirect()->route('admin.auth.staff')->withFlashDanger('Invalid Staff ID');
    //     }

    //     // $data = DB::table('users')->select('country_interested')
    //     //     ->get();
    //     // $pages = CountryStudy::all();
    //     // foreach ($data as $rest) {
    //     //     $system = $rest->country_interested;
    //     // }
    //     // $rty = explode(',', $system);
    //     // $dialcodes = Country::groupBy('tel')->orderBy('tel','asc')->get(['tel as code', 'title_en as name']);
    //     // $branch_list = Branch::orderBy('branch_name')->get();    
    //     // $staff_branch = DB::table('staff_branch')->where('staff_id', $user->id)->pluck('branch_id')->toArray();
    //     // if(!StataiffDels::where('staff_id', $user->id)->exists()) {
    //     //     StaffDetails::create([
    //     //         'staff_id' => $user->id,
    //     //         'smtp_username' => $user->email
    //     //     ]);
    //     // }
    //     $countries  = Country::groupBy('tel')->orderBy('title_en', 'asc')->get();
    //     $staff_details = DB::table('staff_details')->where('staff_id', $user->id)->first();

    //     return view('backend.staff.staff_edit_profile', ['staff_details' => $staff_details, 'countries' => $countries])
    //         ->withUser($user);

    //     // return view('backend.staff.staff_edit_profile', ['pages' => $pages, 'rty' => $rty,'dialcodes' => $dialcodes, 'staff_mgmt' => 1,'branch_list' => $branch_list,'staff_branch' => $staff_branch,'staff_details'=>$staff_details])
    //     //     ->withUser($user)
    //     //     ->withRoles($roleRepository->get())
    //     //     ->withUserRoles($user->roles->pluck('name')->all())
    //     //     ->withPermissions($permissionRepository->get(['id', 'name']))
    //     //     ->withUserPermissions($user->permissions->pluck('name')->all());
    // }

    public function editStaffDetails(ManageUserRequest $request, RoleRepository $roleRepository, PermissionRepository $permissionRepository, User $user)
    {
        // $user = User::find($id);
        if (!(\Auth::user()->isAdmin() || \Auth::user()->can('edit-staff'))) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }
        if (!is_staff_user($user->id)) {
            return redirect()->route('admin.auth.staff')->withFlashDanger('Invalid Staff ID');
        }

        // $data = DB::table('users')->select('country_interested')
        //     ->get();
        // $pages = CountryStudy::all();
        // foreach ($data as $rest) {
        //     $system = $rest->country_interested;
        // }
        // $rty = explode(',', $system);
        // $dialcodes = Country::groupBy('tel')->orderBy('tel','asc')->get(['tel as code', 'title_en as name']);
        // $branch_list = Branch::orderBy('branch_name')->get();    
        // $staff_branch = DB::table('staff_branch')->where('staff_id', $user->id)->pluck('branch_id')->toArray();
        // if(!StataiffDels::where('staff_id', $user->id)->exists()) {
        //     StaffDetails::create([
        //         'staff_id' => $user->id,
        //         'smtp_username' => $user->email
        //     ]);
        // }
        $countries  = Country::groupBy('tel')->orderBy('title_en', 'asc')->get();
        $userdata=DB::table("users")->where("id", $user->id)->get();
        \Log::info([$userdata]);
        $staff_details = DB::table('staff_details')->where('staff_id', $user->id)->first();
        $aditional_documents_details = StaffAditionalDocument::where('staff_id', $user->id)->get();
        $staff_workexperience_details = StaffWorkExp::where('staff_id', $user->id)->get();
        $staff_education_details = StaffEduDetails::where('staff_id', $user->id)->get();
        $staff_dependent_details = StaffDependentDetails::where('staff_id', $user->id)->get();
        $branch_details = Branch::groupBy('city')->orderBy('id', 'asc')->get();
        $dialcodes = Country::orderBy('country_code', 'asc')->get(['tel as code', 'code as country_code', 'title_en as name']);

        return view('backend.staff.staff_edit_profile', [
            'staff_details' => $staff_details, 
            'countries' => $countries,
            'aditional_documents_details'=>$aditional_documents_details,
            'staff_workexperience_details' => $staff_workexperience_details,
             'staff_education_details' => $staff_education_details,
            'staff_dependent_details' => $staff_dependent_details,
            'branch_details' =>$branch_details,
            'dialcodes'=>$dialcodes,
            'userdata'=>$userdata

            ])
            ->withUser($user);

        // return view('backend.staff.staff_edit_profile', ['pages' => $pages, 'rty' => $rty,'dialcodes' => $dialcodes, 'staff_mgmt' => 1,'branch_list' => $branch_list,'staff_branch' => $staff_branch,'staff_details'=>$staff_details])
        //     ->withUser($user)
        //     ->withRoles($roleRepository->get())
        //     ->withUserRoles($user->roles->pluck('name')->all())
        //     ->withPermissions($permissionRepository->get(['id', 'name']))
        //     ->withUserPermissions($user->permissions->pluck('name')->all());
    }

     public function updateStaffDetails(Request $request, $user)
    {
        // dd($request->all())
       
        // Combined validation rules
        $request->validate([
            'gender' => 'required',
            // 'passport_issue_date' => 'required|date_format:d-m-Y',
            // 'passport_expiry_date' => 'required|date_format:d-m-Y',
            // 'visa_expiry_date' => 'nullable|date_format:d-m-Y', 
            // 'cos_issue_date' => 'required|date_format:d-m-Y',
            // 'cos_expiry_date' => 'required|date_format:d-m-Y',

            // 'dob' =>'required|date_format:d-m-Y',
            'employee_ID' => 'required',
            'employee_designation' => 'required',
            'department' => 'required',
            'emp_start_date' => 'required',
            'pan_number'=>'required',
            'employee_type'=>'required',
            'emp_end_date'=>'nullable',
            'profile_img' => 'nullable|image|mimes:jpg,jpeg,png|max:2048',
            'rwc_file' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:8192',
            'aadhar_card' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:8192',

            'current_ctc' => 'nullable|numeric',
        ], [
            'file.max' => __('strings.frontend.general.the_file_may_not_be_greater_than') . (config('app.doc_single_max_size')) . ' MB.',
        ]);
    
        $staffDetails = StaffDetails::where('staff_id', $user)->firstOrNew(['staff_id' => $user]);
    
        


// Handle profile image upload
if ($request->hasFile('profile_img')) {
    $file = $request->file('profile_img');

    \Log::info("check for the profile image exists");

    $filename = 'profile_img_' . time() . '.' . $file->getClientOriginalExtension();

    // Ensure directories exist inside uploads
    Storage::makeDirectory('public/staff_doc');
    Storage::makeDirectory('public/staff_doc/thumb');

    // Relative paths (to save in DB)
    $mainPath  = 'staff_doc/' . $filename;
    $thumbPath = 'staff_doc/thumb/' . $filename;

    // === Save main image ===
    $img = Image::make($file->getRealPath());
    if ($img->height() > 600) {
        $img->resize(null, 600, function ($constraint) {
            $constraint->aspectRatio();
        });
    }
    $img->save(storage_path('app/public/' . $mainPath));

    // === Save thumbnail ===
    
    $thumb = Image::make($file->getRealPath())
        ->resize(100, 100, function ($constraint) {
            $constraint->aspectRatio();
              $constraint->upsize();
        });
    $thumb->save(storage_path('app/public/' . $thumbPath));

    // Save main image path to DB
    $staffDetails->photo = $mainPath;
    // $staffDetails->save();
}


        if ($request->hasFile('offer_letter')) {
            $file = $request->file('offer_letter');
            $filename = 'offer_letter' . time() . '.' . $file->getClientOriginalExtension();
            $path = $file->storeAs('staff_doc', $filename, 'public');
            // Retrieve or create staff details
            $staffDetails->doc_offer_letter = $path;
                // Save the model
        }
        if ($request->hasFile('rwc_file')) {
            $file = $request->file('rwc_file');
            $filename = 'rwc_file' . time() . '.' . $file->getClientOriginalExtension();
            $path = $file->storeAs('staff_doc', $filename, 'public');
            // Retrieve or create staff details

            $staffDetails->rwc_file = $path;
                // Save the model
        }

        if ($request->hasFile('resume')) {
            $file = $request->file('resume');
            $filename = 'resume' . time() . '.' . $file->getClientOriginalExtension();
            $path = $file->storeAs('staff_doc', $filename, 'public');
            // Retrieve or create staff details

            $staffDetails->doc_resume = $path;

        }
        if ($request->hasFile('contract_agreement')) {
            $file = $request->file('contract_agreement');
            $filename = 'contract_agreement' . time() . '.' . $file->getClientOriginalExtension();
            $path = $file->storeAs('staff_doc', $filename, 'public');
            // Retrieve or create staff details
            $staffDetails->doc_contract_agreement = $path;
        
        }
        if ($request->hasFile('pan_card')) {
            $file = $request->file('pan_card');
            $filename = 'pan_card' . time() . '.' . $file->getClientOriginalExtension();
            $path = $file->storeAs('staff_doc', $filename, 'public');
            // Retrieve or create staff details
            $staffDetails->doc_pan_card= $path;
        
        }
        if ($request->hasFile('aadhar_card')) {
            $file = $request->file('aadhar_card');
            $filename = 'aadhar_card' . time() . '.' . $file->getClientOriginalExtension();
            $path = $file->storeAs('staff_doc', $filename, 'public');
            // Retrieve or create staff details
            $staffDetails->doc_aadhar_card= $path;
        
        }

        // Save the model
      

        if (!empty($request->input('dob'))) {
            $dob = substr($request->input('dob'), 6, 4) . "-" . substr($request->input('dob'), 3, 2) . "-" . substr($request->input('dob'), 0, 2);
        } else {
            $dob = NULL;
        }
        
        if (!empty($request->input('emp_start_date'))) {
            $emp_start_date = substr($request->input('emp_start_date'), 6, 4) . "-" . substr($request->input('emp_start_date'), 3, 2) . "-" . substr($request->input('emp_start_date'), 0, 2);
        } else {
            $emp_start_date = NULL;
        }
       
        if (!empty($request->input('emp_end_date'))) {
            $emp_end_date = substr($request->input('emp_end_date'), 6, 4) . "-" . substr($request->input('emp_end_date'), 3, 2) . "-" . substr($request->input('emp_end_date'), 0, 2);
        } else {
            $emp_end_date = NULL;
        }
        if (!empty($request->input('passport_issue_date'))) {
            $passport_issue_date = substr($request->input('passport_issue_date'), 6, 4) . "-" . substr($request->input('passport_issue_date'), 3, 2) . "-" . substr($request->input('passport_issue_date'), 0, 2);
        } else {
            $passport_issue_date = NULL;
        }
        if (!empty($request->input('passport_expiry_date'))) {
            $passport_expiry_date = substr($request->input('passport_expiry_date'), 6, 4) . "-" . substr($request->input('passport_expiry_date'), 3, 2) . "-" . substr($request->input('passport_expiry_date'), 0, 2);
        } else {
            $passport_expiry_date = NULL;
        }
        if (!empty($request->input('share_code_entry_date'))) {
            $share_code_entry_date = substr($request->input('share_code_entry_date'), 6, 4) . "-" . substr($request->input('share_code_entry_date'), 3, 2) . "-" . substr($request->input('share_code_entry_date'), 0, 2);
        } else {
            $share_code_entry_date= NULL;
        }
        if (!empty($request->input('share_code_expiry_date'))) {
            $share_code_expiry_date = substr($request->input('share_code_expiry_date'), 6, 4) . "-" . substr($request->input('share_code_expiry_date'), 3, 2) . "-" . substr($request->input('share_code_expiry_date'), 0, 2);
        } else {
            $share_code_expiry_date = NULL;
        }
        if (!empty($request->input('cos_issue_date'))) {
            $cos_issue_date = substr($request->input('cos_issue_date'), 6, 4) . "-" . substr($request->input('cos_issue_date'), 3, 2) . "-" . substr($request->input('cos_issue_date'), 0, 2);
        } else {
            $cos_issue_date = NULL;
        }
        if (!empty($request->input('cos_expiry_date'))) {
            $cos_expiry_date = substr($request->input('cos_expiry_date'), 6, 4) . "-" . substr($request->input('cos_expiry_date'), 3, 2) . "-" . substr($request->input('cos_expiry_date'), 0, 2);
        } else {
            $cos_expiry_date = NULL;
        }
        if (!empty($request->input('share_code_entry_date'))) {
            $share_code_entry_date = substr($request->input('share_code_entry_date'), 6, 4) . "-" . substr($request->input('share_code_entry_date'), 3, 2) . "-" . substr($request->input('share_code_entry_date'), 0, 2);
        } else {
            $share_code_entry_date  = NULL;
        }
        if (!empty($request->input('share_code_expiry_date'))) {
            $share_code_expiry_date = substr($request->input('share_code_expiry_date'), 6, 4) . "-" . substr($request->input('share_code_expiry_date'), 3, 2) . "-" . substr($request->input('share_code_expiry_date'), 0, 2);
        } else {
            $share_code_expiry_date  = NULL;
        }
        if (!empty($request->input('rwc_check_date'))) {
            $rwc_check_date= substr($request->input('rwc_check_date'), 6, 4) . "-" . substr($request->input('rwc_check_date'), 3, 2) . "-" . substr($request->input('rwc_check_date'), 0, 2);
        } else {
            $rwc_check_date = NULL;
        }
        if (!empty($request->input('visa_expiry_date'))) {
            $visa_expiry_date= substr($request->input('visa_expiry_date'), 6, 4) . "-" . substr($request->input('visa_expiry_date'), 3, 2) . "-" . substr($request->input('visa_expiry_date'), 0, 2);
        } else {
            $visa_expiry_date = NULL;
        }
        // dd($request->all());
        
    
        // dd($request->all());
        // dd($request->address_2 , $request->address_1);
        $exists = DB::table('users')->where('id', $user)->exists();

        if ($exists) {
            DB::table('users')->where('id', $user)->update([
                'gender' => $request->input('gender'),
                'address_2'=> $request->input('address_2'),
                'address_1'=> $request->input('address_1'),
                'reporting_to'=>$request->input('reporting_to'),
                'dialcode' => $request->input('dialcode'),
                'mobile'=>$request->input('personal_phone'),
                'email'=>$request->input('personal_email'),
            ]);
        } else {
            DB::table('users')->insert([
                'id' => $user,
                'gender' => $request->input('gender'),
                'address_2'=> $request->input('address_2'),
                'address_1'=> $request->input('address_1'),
                 'reporting_to'=>$request->input('reporting_to'),
                 'dialcode' => $request->input('dialcode'),
                  'mobile'=>$request->input('personal_phone'),
                'email'=>$request->input('personal_email'),
            ]);
        }
        // dd(DB::table('users')->where('id',  $user)->value('address_2'));


        
     
        StaffDetails::updateOrCreate(
            [
                'staff_id'   => $user,
            ],
            [
                'gender' => $request->input('gender'),
                'marital_status' => $request->input('marital_status'),
                // 'imap_host' => $data['imap_host'],
                // 'imap_port' => $data['imap_port'],
                'dob' => $dob ,
                'father_name' => $request->input('father_name'),
                'mother_name' => $request->input('mother_name'),
                'blood_group' => $request->input('blood_group'),
                'about'=>$request->input('about'),
                'passport_no'=>$request->input('passport_no'),
                'passport_issue_date'=>$passport_issue_date,
                'passport_expiry_date'=>$passport_expiry_date ,
                'passport_issue_country'=>$request->input('passport_issue_country'),
                'aadhar_no' => $request->input('aadhar_number'),
                'pan_no' => $request->input('pan_number'),
                'address' => $request->input('address'),
                'country' => $request->input('country'),                
                'state' => $request->input('state'),
                'city' => $request->input('city'),
                'postal_code' => $request->input('postal_code'),
                'permanent_country' => $request->input('country-permanant'),                
                'permanent_state' => $request->input('state-permanant'),
                'permanent_city' => $request->input('permanent_city'),
                'permanent_postal_code' => $request->input('permanent_postal_code'),
                
                'designation' => $request->input('employee_designation'),
                'department' => $request->input('department'),
                'emp_type'=>$request->input('employee_type'),
                'emp_status'=>$request->input('emp_status'),
                'hiring_source'=>$request->input('hiring_source'),
                //'zoho_role'=>$request->input('zoho_role'),
                'seating_location'=>$request->input('seating_location'),
                'personal_phone'=>$request->input('personal_phone'),
                'personal_email'=>$request->input('personal_email'),
                //cos
                'cos_no'=> $request->input('cos_no'),
                'cos_status'=>$request->input('cos_status'),
               
                'cos_issue_date'=>$cos_issue_date,
                'cos_expiry_date'=>$cos_expiry_date,
                //right to work
                'share_code_right_work'=>$request->input('share_code_right_work'),
                'share_code_entry_date'=>$share_code_entry_date,
                'share_code_expiry_date'=>$share_code_expiry_date,
                'rwc_check_date'=>$rwc_check_date,
                'rwc_file'=>$request->input('rwc_file'),
                'onboarding_status'=>$request->input('onboarding_status'),

        
                'ctc' => $request->input('current_ctc'),
                'emp_start_date' =>$emp_start_date,
                'emp_end_date'=>$emp_end_date,
                'reporting_to' => $request->input('reporting_to'),
                'bank_account_no' => $request->input('account_number'),
                'bank_payee' => $request->input('account_holder_name'),
                'emp_id' => $request->input('employee_ID'),
                'bank_ifsc' => $request->input('ifsc_code'),
                'bank_bank_name' => $request->input('bank_name'),
                'bank_branch' => $request->input('branch_name'),
                'past_experience_year'=>$request->input('past_experience_year'),
                'past_experience_month'=>$request->input('past_experience_month'),
                'work_phone_no'=>$request->input('work_phone_no'),
                'work_ph_dialcode'=>$request->input('work_ph_dialcode'),
                'extension'=>$request->input('extension'),
                //visa information
                'visa_no'=>$request->input('visa_no'),
                 'visa_expiry_date'=>$visa_expiry_date,
                'entry_clearance'=>$request->input('entry_clearance'),
                'brp'=>$request->input('brp'),
                'emergency_contact_email'=>$request->input('emergency_contact_email'),
                'emergency_contact_ph_no'=>$request->input('emergency_contact_ph_no'),
                'emergency_contact_name'=>$request->input('emergency_contact_name'),
                'emergency_contact_address'=>$request->input('emergency_contact_address'),
                'modified_by'=>\Auth::user()->id

            ]
        );
       
        $staffDetails->save();
        return redirect()->route('admin.auth.staff.edit.profile', $user)->withFlashSuccess('Staff details updated successfully');
    }

    public function store(Request $request)
    {
        // Validate the request
        $request->validate([
            'file' => 'required|file|mimes:jpg,jpeg,png,gif|max:2048', // Adjust rules as needed
        ]);

        // Handle the uploaded file
        if ($request->hasFile('file')) {
            $file = $request->file('file');
            $filename = time() . '.' . $file->getClientOriginalExtension();
            $path = $file->storeAs('uploads', $filename, 'public'); // Store file in 'public/uploads'

            // Optionally save the path to the database or perform other actions

            return back()->with('success', 'File uploaded successfully')->with('path', $path);
        }

        return back()->with('error', 'No file selected');
    }
    public function storeFile(Request $request)
    {
        // Validate the request
        $request->validate([
            'file' => 'required|file|mimes:jpg,jpeg,png,gif,doc,docx,pdf|max:2048', // Adjust rules as needed
        ]);

        // Handle the uploaded file
        if ($request->hasFile('file')) {
            $file = $request->file('file');
            $filename = time() . '.' . $file->getClientOriginalExtension();
            $path = $file->storeAs('uploads', $filename, 'public'); // Store file in 'public/uploads'

            // Optionally save the path to the database or perform other actions
            // e.g., saving the file path to staff details if required
            // $staffDetails = StaffDetails::where('staff_id', $request->user()->id)->first();
            // $staffDetails->update(['document_path' => $path]);

            return back()->with('success', 'File uploaded successfully')->with('path', $path);
        }

        return back()->with('error', 'No file selected');
    }

    /**
     * Handle file uploads for staff profile.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $userId
     * @return \Illuminate\Http\RedirectResponse
     */
    public function updateStaffFiles(Request $request, $userId)
    {
        $request->validate([
            'profile_image' => 'nullable|file|mimes:jpg,jpeg,png|max:2048',
            'resume' => 'nullable|file|mimes:pdf|max:2048',
            // Add other file validation rules as needed
        ]);
        $single_file_max = config('app.doc_single_max_size') * 1024;

        $size_msg = $single_file_max / pow(1024, 1);
        $request->validate(
            [
                'file' => 'required',
                'file' => 'mimes:doc,docx|max:' . $single_file_max,
            ],
            [
                'max' => __('strings.frontend.general.the_file_may_not_be_greater_than') . $size_msg . ' MB.',
            ]
        );

        $userid = \Auth::user()->id;

        $file = $request->file('file');
        $filename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
        $filename = str_replace(" ", "-", $filename);
        $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
        if (strlen($filename) > 20) {
            $filename = substr($filename, 0, 20);
        }
        $filename .= "-" . round(microtime(true) * 1000);
        $path = $file->storeAs('/cert', $filename . "." . $file->getClientOriginalExtension(), 'public');
        if (DB::table('user_docs_other')->where(["userid" => $userid, "doc_type" => "cv"])->exists()) {
            DB::table('user_docs_other')->where(["userid" => $userid, "doc_type" => "cv"])->update(["file" => $path]);
        } else {
            DB::table('user_docs_other')->insert(["userid" => $userid, "doc_type" => "cv", "file" => $path]);
        }

        $staffDetails = StaffDetails::where('staff_id', $userId)->firstOrNew(['staff_id' => $userId]);

        if ($request->hasFile('profile_image')) {
            $file = $request->file('profile_image');
            $filename = 'profile_image_' . time() . '.' . $file->getClientOriginalExtension();
            $path = $file->storeAs('staff_doc', $filename, 'public');
            $thumbPath = 'staff_doc/thumb/' . $filename;
            $thumb = Image::make($file->getRealPath())
                ->resize(100, 100, function ($constraint) {
                    $constraint->aspectRatio();
                    $constraint->upsize();
                });
            $thumb->save(storage_path('app/public/' . $thumbPath));
            $staffDetails->profile_image = $path;
        }

        if ($request->hasFile('resume')) {
            $file = $request->file('resume');
            $filename = 'resume_' . time() . '.' . $file->getClientOriginalExtension();
            $path = $file->storeAs('staff_doc', $filename, 'public');
            $staffDetails->resume = $path;
        }

        // Save other file details as necessary

        $staffDetails->save();

        return redirect()->route('admin.auth.staff.edit.profile', $userId)
            ->with('success', 'Files updated successfully');
    }


    public function basicinfo(){
        $user = User::find(\Auth::user()->id);
    
        if (\Auth::user()->isAgent()) {
            $agent_details = AgentDetails::firstOrCreate(['agent_id' => $user->id]);
    
            return view('backend.agents.profile', [
                'agent_details' => $agent_details,
                'user' => $user
            ]);
        } else {
            $aditional_documents_details = StaffAditionalDocument::where('staff_id', $user->id)->get();
            $staff_details = StaffDetails::firstOrCreate(['staff_id' => $user->id]);
            $staff_workexperience_details = StaffWorkExp::where('staff_id', $user->id)->get();
            $staff_education_details = StaffEduDetails::where('staff_id', $user->id)->get();
            $staff_dependent_details = StaffDependentDetails::where('staff_id', $user->id)->get();
            
    
            return view('backend.staff.basicinfo', [
                'staff_details' => $staff_details,
                'staff_workexperience_details' => $staff_workexperience_details,
                'staff_education_details' => $staff_education_details,
                'staff_dependent_details' => $staff_dependent_details,
                'aditional_documents_details'=>$aditional_documents_details,
            
                'user' => $user
            ]);
        }
    }
    
      public function basicinfoedit()
{
    $user = User::find(\Auth::id()); 
    $country_details = Country::all();   

    if ($user->isAgent()) {
        $agent_details = AgentDetails::firstOrCreate(['agent_id' => $user->id]);

        return view('backend.agents.profile', [
            'agent_details' => $agent_details,
            'user' => $user
        ]);
    } else {
            $aditional_documents_details = StaffAditionalDocument::where('staff_id', $user->id)->get();
            $staff_details = StaffDetails::firstOrCreate(['staff_id' => $user->id]);
            $staff_workexperience_details = StaffWorkExp::where('staff_id', $user->id)->get();
            $staff_education_details = StaffEduDetails::where('staff_id', $user->id)->get();
            $staff_dependent_details = StaffDependentDetails::where('staff_id', $user->id)->get();
            $branch_list = Branch::orderBy('branch_name')->get();  
            $dialcodes = Country::orderBy('country_code', 'asc')->get(['tel as code', 'code as country_code', 'title_en as name']);

        return view('backend.staff.basicinfoedit', [
            'staff_details' => $staff_details,
            'country_details' => $country_details,
            'staff_workexperience_details' => $staff_workexperience_details,
            'staff_education_details' => $staff_education_details,
            'staff_dependent_details' => $staff_dependent_details,
            'aditional_documents_details'=>$aditional_documents_details,
            'branch_list'=>$branch_list,
            'user' => $user ,
            'dialcodes'=>$dialcodes
        ]);
    }
}
}
