<?php

namespace App\Http\Controllers\Backend\Auth\User;

use App\Models\Auth\User;
use App\Http\Controllers\Controller;
use App\Repositories\Backend\Auth\UserRepository;
use App\Http\Requests\Backend\Auth\User\ManageUserRequest;
use App\Http\Requests\Backend\Auth\User\UpdateUserPasswordRequest;

/**
 * Class UserPasswordController.
 */
class UserPasswordController extends Controller
{
    /**
     * @var UserRepository
     */
    protected $userRepository;

    /**
     * @param UserRepository $userRepository
     */
    public function __construct(UserRepository $userRepository)
    {
        $this->userRepository = $userRepository;
    }

    /**
     * @param ManageUserRequest $request
     * @param User              $user
     *
     * @return mixed
     */
    public function edit(ManageUserRequest $request, User $user)
    {
        // It excuted for user reset password
        return view('backend.auth.user.change-password',['staff_mgmt'=>0])
            ->withUser($user);
    }

    public function editLead(ManageUserRequest $request, User $user)
    {
        // It excuted for leads reset password
        return view('backend.auth.user.change-password',['is_lead'=>1])
            ->withUser($user);
    }
    
    
    /**
     * @param ManageUserRequest $request
     * @param User              $user
     *
     * @return mixed
     */
    public function editStaff(ManageUserRequest $request, User $user)
    {
        // It excuted for staff reset password
        return view('backend.staff.staff_change_password',['is_staff'=>1])
            ->withUser($user);
    }

    public function editAgent(ManageUserRequest $request, User $user)
    {
        return view('backend.auth.user.change-password',['is_agent'=>1])
            ->withUser($user);
    }

    public function editTrainer(ManageUserRequest $request, User $user)
    {
        return view('backend.auth.user.change-password',['is_trainer'=>1])
            ->withUser($user);
    }
    

    /**
     * @param UpdateUserPasswordRequest $request
     * @param User                      $user
     *
     * @return mixed
     * @throws \App\Exceptions\GeneralException
     */
    public function update(UpdateUserPasswordRequest $request, User $user)
    {
        if(env('DEMO_MODE') && in_array($user->id, config('app.demo_users')))
            return redirect()->route('admin.demo-user-restriction');    

        $is_lead = $user->is_lead;
        $this->userRepository->updatePassword($user, $request->only('password'));

        if($is_lead){
            return redirect()->route('admin.leadmanagementdetails')->withFlashSuccess(__('alerts.backend.users.updated_password'));
        }else{
            if($user->agent_id == 0){
                return redirect()->route('admin.auth.user.index')->withFlashSuccess("Password updated successfully & emailed to user");
            }else{
                return redirect()->route('admin.auth.user.index')->withFlashSuccess(__('alerts.backend.users.updated_password'));
            }
        }
    }
    
    
    /**
     * @param UpdateUserPasswordRequest $request
     * @param User                      $user
     *
     * @return mixed
     * @throws \App\Exceptions\GeneralException
     */
    public function updateStaff(UpdateUserPasswordRequest $request, User $user)
    {

        if(env('DEMO_MODE') && in_array($user->id, config('app.demo_users')))
            return redirect()->route('admin.demo-user-restriction');    

        $this->userRepository->updatePassword($user, $request->only('password'));
        return redirect()->route('admin.auth.staff')->withFlashSuccess(__('alerts.backend.users.updated_password'));
    }
    
    public function updateAgent(UpdateUserPasswordRequest $request, User $user)
    {
        $this->userRepository->updatePassword($user, $request->only('password'));
        return redirect()->route('admin.agents.index')->withFlashSuccess(__('alerts.backend.users.updated_password'));
    }
    
    public function updateTrainer(UpdateUserPasswordRequest $request, User $user)
    {
        $this->userRepository->updatePassword($user, $request->only('password'));
        return redirect()->route('admin.trainers.index')->withFlashSuccess(__('alerts.backend.users.updated_password'));
    }
    
    
}
