<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CourseSuggestion;
use App\Models\Auth\UniversityCourses;
use App\Models\Auth\Universities;
use App\Models\Auth\User;
use App\Models\Auth\UserDetails;
use App\Models\Auth\Services;
use Illuminate\Support\Str;
use App\Models\Auth\AutomationWorkflow;
use App\Models\Auth\CountryStudy;
use App\Models\Auth\Country;
use App\Models\Auth\AutomationCampaign;
use Illuminate\Support\Facades\DB;
use App\Repositories\Backend\Auth\UserRepository;
use App\Notifications\Backend\UserAlert;
use App\Models\MailTemplates;
use Yajra\DataTables\DataTables;
use App\Mail\MailSend;
use Illuminate\Support\Facades\Mail;

class AutomationController extends Controller {

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('automations'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }  
            
            if(!env('MARKETING_AUTOMATION_ENABLE')){
                return redirect()->route('admin.dashboard.message')->withFlashDanger('Marketing Automation is disabled.');
            }

            return $next($request);
        });
    }
    public function check_title(Request $request)
    {
        $workflow = AutomationWorkflow::where('title',$request->title)->count();

        if($workflow){
            return response()->json(array('status' => "FALSE","msg" => "Workflow with this title already exists."));
        }else{
            return response()->json(array('status' => "TRUE"));
        }
    }

    public function check_campaign_title(Request $request)
    {
        $campaign = AutomationCampaign::where('title',$request->title)->count();

        if($campaign){
            return response()->json(array('status' => "FALSE","msg" => "Campaign with this title already exists."));
        }else{
            return response()->json(array('status' => "TRUE"));
        }
    }
    public function fetchCriteriaValues(Request $request)
    {
        if($request->criteria_type == "Intake"){
            $month = date('n'); // current month
            for ($x = 0; $x < 24; $x++) { 
                $data[$x]['val'] = date('m Y', mktime(0, 0, 0, $month + $x, 1));
                $data[$x]['title'] = date('F Y', mktime(0, 0, 0, $month + $x, 1));
             }
             return response()->json($data);
        }

        if($request->criteria_type == "Country Interested"){
            $countries = CountryStudy::where('status', 1)->orderBy('country', 'ASC')->get(["country as title","country as val"]);
            return response()->json($countries);
        }
        if($request->criteria_type == "Course Interested to Study"){
            $courses = User::where('overseas_course_intersted',"<>", NULL)->orderBy('overseas_course_intersted', 'ASC')
            ->distinct('overseas_course_intersted')
            ->get(["overseas_course_intersted as title","overseas_course_intersted as val"]);
            return response()->json($courses);
        }
        if($request->criteria_type == "Passout Year"){
            $year = UserDetails::where('passout_year',"<>", NULL)->orderBy('passout_year', 'ASC')
            ->distinct('passout_year')
            ->get(["passout_year as title","passout_year as val"]);
            return response()->json($year);
        }
        if($request->criteria_type == "Lead Campaign Name"){
            $year = UserDetails::where('lead_campaign_name',"<>", NULL)->orderBy('lead_campaign_name', 'ASC')
            ->distinct('lead_campaign_name')
            ->get(["lead_campaign_name as title","lead_campaign_name as val"]);
            return response()->json($year);
        }

        if($request->criteria_type == "Other Services Interested"){
            $services = Services::orderBy('service_name', 'ASC')
            ->get(["service_name as title","id as val"]);
            return response()->json($services);
        }
        if($request->criteria_type == "Interested Study Level"){
            $levels = DB::table('study_levels')->orderBy('display_order')->get(['study_level as title', 'study_level as val']);
            return response()->json($levels);
        }
        if($request->criteria_type == "Country of Residence"){
            $country_list = Country::orderBy('title_en', 'ASC')->get(['title_en as title', 'id as val']);
            return response()->json($country_list);
        }
        if($request->criteria_type == "Qualification"){
            $quals = [
                '9th' ,
                '10th',
                '11th',
                '12th',
                'Bachelors',
                'Masters',
                'Ph.D',
            ];
            for ($x = 0; $x < count($quals); $x++) { 
                $data[$x]['val'] = $quals[$x];
                $data[$x]['title'] =  $quals[$x];
            }
            return response()->json($data);
        }
        if($request->criteria_type == "Lead Source"){
            $quals = get_lead_sources();
            for ($x = 0; $x < count($quals); $x++) { 
                $data[$x]['val'] = $quals[$x];
                $data[$x]['title'] =  $quals[$x];
            }
            return response()->json($data);
        }
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index() {
        return view('backend.automation.index');
    }

    public function workflowData(Request $request){

        if (!$request->ajax()) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this page.');
        }
        echo $this->getDatatableWorkflowlist($request);
    }

    public function getDatatableWorkflowlist($request){
        //Query debug
        // DB::enableQueryLog();

        $columns = array(
            0 => 'title',
            1 => 'communication_mode',
            2 => 'workflow_type',
            3 => 'message_details',
            4 => 'status',
            6 => 'created_at'

        );        

        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');
        $get_search = $request->input('search.value');
        

        $totalData = DB::table('automation_workflow')
        ->when(!empty($get_search), function ($query) use ($get_search) {
            return $query->Where('title', 'like', "%$get_search%")
            ->orWhere('status', 'like', "%$get_search%")
            ->orWhere('communication_mode', 'like', "%$get_search%")
            ->orWhere('workflow_type', 'like', "%$get_search%");
        })
        ->count();

        $workflows = DB::table('automation_workflow')
            ->offset($start)
            ->limit($limit)
            ->orderBy($order, $dir)
            ->when(!empty($get_search), function ($query) use ($get_search) {
                return $query->Where('title', 'like', "%$get_search%")
                ->orWhere('status', 'like', "%$get_search%")
                ->orWhere('communication_mode', 'like', "%$get_search%")
                ->orWhere('workflow_type', 'like', "%$get_search%");
            })
            ->get();

        $totalFiltered = $totalData;

        $data = array();
        if (!empty($workflows)) {
            $count = 1;
            foreach ($workflows as $page) {
                $customResult['title'] = "<b>".$page->title."</b>";
                $customResult['mode'] =  ucfirst($page->communication_mode);
                $customResult['type'] = ucfirst(str_replace("_"," ", $page->workflow_type));
                $ddd = json_decode($page->message_details,true);
                $customResult['messages'] = sizeof($ddd);
                $customResult['created_at'] = $page->created_at;
                $customResult['status'] = $page->status ? "<span class='badge badge-success'> Active</span>" : "<span class='badge badge-danger'> Inactive</span>";
              
                
                $options ='<div class="btn-group" role="group" aria-label="'.__('labels.backend.access.users.user_actions').'">
                                <a href="' .  route('admin.automation.workflow.details', $page->id) . '" data-toggle="tooltip" data-placement="top" title="'.__('buttons.general.crud.view').'" class="btn btn-info" style="color: #fff;"><i class="ri-eye-fill"></i></a>
                                    
                                <div class="btn-group btn-group-sm" role="group">
                                  <button style="padding: 0.452rem 0.75rem;margin-bottom:0px;" id="userActions" type="button" class="btn btn-secondary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="true"><i class="bi bi-three-dots-vertical"></i>
                                  </button>
                                  <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow" data-popper-placement="bottom-end">
                                    <a href="' . route('admin.automation.workflow.duplicate', $page->id) . '" name="confirm_item" class="dropdown-item"
                                    data-trans-button-confirm="Duplicate"
                                    data-trans-title="Are you sure you want to Duplicate?">Duplicate</a>
                                    <a href="' . route('admin.automation.workflow.edit', $page->id) . '" class="dropdown-item">Edit</a>';
                        if ($page->status) {
                            $options .= '<a href="' . route('admin.automation.workflow.updateStatus', [$page->id, 0]) . '" class="dropdown-item">Deactivate</a>';
                        } else {
                            $options .= '<a href="' . route('admin.automation.workflow.updateStatus', [$page->id, 1]) . '" class="dropdown-item">Activate</a>';
                        }

                    $options .= '<a class="dropdown-item" href="' . route('admin.automation.workflow.destroy', $page->id) . '"
                            data-method="delete"
                            data-trans-button-cancel="Cancel"
                            data-trans-button-confirm="Delete"
                            data-trans-title="Are you sure to Delete?"
                            class="dropdown-item">Delete</a>';
                    $options .= '</div></div>';
                $customResult['actions'] = $options;
               

                $data[] = $customResult;
            }
        }
        //\Log::debug('My User Id: ' . $my_user_id);
        $json_data = array(
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $data,
        );

        return json_encode($json_data);
    }

    public function create_workflow() {
        return view('backend.automation.create_workflow');
    }


    public function ajaxgettpl(Request $request) {
            if($request->comm_mode == "Email"){
                $data = DB::table('mail_templates')->where('status',1)->orderByDesc('created_at')->pluck('hook');
                return response()->json($data);
            }
            else if($request->comm_mode == "Whatsapp"){
                $data = DB::table('whatsapp_templates')->where('status',1)->orderByDesc('created_at')->pluck('hook');
                return response()->json($data);
            }
            else{
                $data = DB::table('sms_templates')->where('status',1)->orderByDesc('created_at')->pluck('hook');
                return response()->json($data);
            }
           
    }
    
    public function store_workflow(Request $request) {
        
        $request->validate([
            'title' => 'required|unique:automation_workflow,title',
            'workflow_type' => 'required',
            'lead_status.*' => 'required',
        ]);

        //    echo "<pre>";
        //     print_r($request->all());
        //    exit();

        $title = $request->title;
        $workflow_type = $request->workflow_type;
        $communication_mode = $request->communication_mode;
        $run_at =  date('H:i:s', strtotime($request->run_at_time.$request->run_at));


        $workflow = new AutomationWorkflow;
        $workflow->title = $title;
        $workflow->workflow_type = $workflow_type;
        $workflow->communication_mode = $communication_mode;
        $workflow->run_at = $run_at;

        if($request->criteria_condition){
            $workflow->filter_condition = $request->criteria_condition;
        }else{
            $workflow->filter_condition = NULL;
        }
        

        if($workflow_type == "lead_nurture_sequence"){
            //Checking lead status
            $lead_statuses = "";
            $lead_status = $request->lead_status;
            if (!empty($lead_status) && count($lead_status)) {
                $lead_statuses = implode(",", $lead_status);
            }
            $workflow->lead_status = $lead_statuses;

            $other_criteria = $request->other_criteria;
            $criteria_value = $request->criteria_value;
            
            if (!empty($other_criteria) && count($other_criteria) && !is_null($other_criteria)) {
                $criteria_Array = array();
                //echo "<pre>";
                foreach($other_criteria as $otr_cri_val){
                    $rar = str_replace(" ","_",$otr_cri_val);
                    //echo "Val---".$rar;
                    if($rar){
                        //print_r($request->$rar);
                        $criteria_Array[$otr_cri_val] = implode("|", $request->$rar);
                    }
                    //$criteria_Array[$request->$otr_cri_val] = implode("|", $request->$otr_cri_val);
                }

                // for($c=0;$c<count($other_criteria);$c++){
                //     if(!empty($criteria_value) && !is_null($other_criteria[$c]) && !is_null($criteria_value)){
                //         //echo $request->criteria_value[$c];
                //         foreach($criteria_value as $cri_val){
                //             echo $cri_val."<br>";
                //         }
                //         //$criteria_Array[$other_criteria[$c]] = implode("|", $request->criteria_value[$c]);
                //     }
                // }
                if(!empty($criteria_Array)){
                    $criteria_encoded = json_encode($criteria_Array);

                    $workflow->lead_filters = $criteria_encoded;
                }
                
            }
            // exit();
            //dd($criteria_encoded);
            //message
            $lead_age = $request->lead_age;
            $message_template = $request->message_template;
            if (!empty($lead_age) && count($lead_age)) {
                $message_Array = array();
                for($d=0;$d<count($lead_age);$d++){
                    // $message_Array['lead age'] = $lead_age[$d];
                    // $message_Array['template'] = $message_template[$d];
                    if(!empty($message_template[$d])){
                        $message_Array[$lead_age[$d]] = $message_template[$d];
                    }
                }
                $message_encoded = json_encode($message_Array);
                // print_r($message_encoded);
                // exit();
                $workflow->message_details = $message_encoded;
            }
        }
//Message Sequence
        if($workflow_type == "message_sequence"){
            $target = $request->msg_target;
            if($target == "leads"){
                //Checking lead status
                $lead_statuses = "";
                $lead_status = $request->lead_status;
                if (!empty($lead_status) && count($lead_status)) {
                    $lead_statuses = implode(",", $lead_status);
                }
                $workflow->lead_status = $lead_statuses;
            }
            else if($target == "students"){
                //Checking lead status
                $student_statuses = "";
                $student_status = $request->student_status;
                if (!empty($student_status) && count($student_status)) {
                    $student_statuses = implode(",", $student_status);
                }
                $workflow->student_status = $student_statuses;

            }else{
                $workflow->student_status = $workflow->lead_status = NULL;
            }
            $workflow->target = $target;

            if (!empty($request->msg_start_date)) {
                $workflow->start_date = substr($request->msg_start_date, 6, 4) . "-" . substr($request->msg_start_date, 3, 2) . "-" . substr($request->msg_start_date, 0, 2);
            } else {
                $workflow->start_date = NULL;
            }
            $other_criteria = $request->other_criteria;
            $criteria_value = $request->criteria_value;
            // if (!empty($other_criteria) && count($other_criteria)) {
            //     $criteria_Array = array();
            //     for($c=0;$c<count($other_criteria);$c++){
            //         if(!empty($criteria_value[$c])){
            //             $criteria_Array[$other_criteria[$c]] = $criteria_value[$c];
            //         }
            //     }
            //     if(!empty($criteria_Array)){
            //         $criteria_encoded = json_encode($criteria_Array);
            //         if($target == "leads"){
            //             $workflow->lead_filters = $criteria_encoded;
            //         }
            //         else if($target == "students"){
            //             $workflow->student_filters = $criteria_encoded;
            //         }else{
            //             $workflow->lead_filters = $workflow->student_filters = NULL;
            //         }
            //     }
                
            // }

            if (!empty($other_criteria) && count($other_criteria) && !is_null($other_criteria)) {
                $criteria_Array = array();
                foreach($other_criteria as $otr_cri_val){
                    $rar = str_replace(" ","_",$otr_cri_val);
                    if($rar){
                        $criteria_Array[$otr_cri_val] = implode("|", $request->$rar);
                    }
                }
                if(!empty($criteria_Array)){
                    $criteria_encoded = json_encode($criteria_Array);
                    if($target == "leads"){
                        $workflow->lead_filters = $criteria_encoded;
                    }
                    else if($target == "students"){
                        $workflow->student_filters = $criteria_encoded;
                    }else{
                        $workflow->lead_filters = $workflow->student_filters = NULL;
                    }
                }
                
            }
            //dd($criteria_encoded);


            //message
            $after_days = $request->after_days;
            $msg_message_template = $request->msg_message_template;
            if (!empty($msg_message_template) && count($msg_message_template)) {
                $message_Array = array();
                for($d=0;$d<count($msg_message_template);$d++){
                    if($d == 0){
                        $message_Array["00"] = $msg_message_template[$d];
                    }
                    else if($d > 0 && !empty($msg_message_template[$d])){
                        $k=-1;
                        $k= $k+$d;
                        $message_Array[$after_days[$k]] = $msg_message_template[$d];
                        }
                    }
                }
                if(!empty($message_Array) && count($message_Array)){
                    $message_encoded = json_encode($message_Array);
                    $workflow->message_details = $message_encoded;
                }
                //  print_r($message_encoded);
            }
//Message Sequence        


//Specific Event 
if($workflow_type == "specific_event"){
    $target = $request->specific_target;

    if($target == "leads"){
        //Checking lead status
        $lead_statuses = "";
        $lead_status = $request->lead_status;
        if (!empty($lead_status) && count($lead_status)) {
            $lead_statuses = implode(",", $lead_status);
        }
        $workflow->lead_status = $lead_statuses;
    }
    else if($target == "students"){
        //Checking lead status
        $student_statuses = "";
        $student_status = $request->student_status;
        if (!empty($student_status) && count($student_status)) {
            $student_statuses = implode(",", $student_status);
        }
        $workflow->student_status = $student_statuses;

    }else{
        $workflow->student_status = $workflow->lead_status = NULL;
    }
    $workflow->target = $target;
    if (!empty($request->specific_start_date)) {
        $workflow->start_date = substr($request->specific_start_date, 6, 4) . "-" . substr($request->specific_start_date, 3, 2) . "-" . substr($request->specific_start_date, 0, 2);
    } else {
        $workflow->start_date = NULL;
    }
    $other_criteria = $request->other_criteria;
    $criteria_value = $request->criteria_value;
    // if (!empty($other_criteria) && count($other_criteria)) {
    //     $criteria_Array = array();
    //     for($c=0;$c<count($other_criteria);$c++){
    //         if(!empty($criteria_value[$c])){
    //             $criteria_Array[$other_criteria[$c]] = $criteria_value[$c];
    //         }
    //     }
    //     if(!empty($criteria_Array)){
    //         $criteria_encoded = json_encode($criteria_Array);
    //         if($target == "leads"){
    //             $workflow->lead_filters = $criteria_encoded;
    //         }
    //         else if($target == "students"){
    //             $workflow->student_filters = $criteria_encoded;
    //         }else{
    //             $workflow->lead_filters = $workflow->student_filters = NULL;
    //         }
    //     }
        
    // }
    if (!empty($other_criteria) && count($other_criteria) && !is_null($other_criteria)) {
        $criteria_Array = array();
        foreach($other_criteria as $otr_cri_val){
            $rar = str_replace(" ","_",$otr_cri_val);
            if($rar){
                $criteria_Array[$otr_cri_val] = implode("|", $request->$rar);
            }
        }
        if(!empty($criteria_Array)){
            $criteria_encoded = json_encode($criteria_Array);
            if($target == "leads"){
                $workflow->lead_filters = $criteria_encoded;
            }
            else if($target == "students"){
                $workflow->student_filters = $criteria_encoded;
            }else{
                $workflow->lead_filters = $workflow->student_filters = NULL;
            }
        }
        
    }
    $workflow->repeats = $request->repeats;
    //message
    $specific_message_template = $request->specific_message_template;
    if (!empty($specific_message_template) && count($specific_message_template)) {
        $message_Array = array();
        for($d=0;$d<count($specific_message_template);$d++){
                $message_Array["00"] = $specific_message_template[$d];
            }
        }
        if(!empty($message_Array) && count($message_Array)){
            $message_encoded = json_encode($message_Array);
            $workflow->message_details = $message_encoded;
        }
        //  print_r($message_encoded);
        //  exit();  
    }
//Specific Event  

        $workflow->created_by = auth()->user()->id;

        $workflow->save();

        return redirect()->route('admin.automation')->withFlashSuccess('Workflow saved!');
    }


    public function edit_workflow($id) {
        $workflow = AutomationWorkflow::find($id);
        if(!$workflow){
            return redirect()->route('admin.automation')->withFlashDanger('Invalid workflow!');
        }
        $years = get_course_suggest_years();
        $countries = get_study_countries();
        $intakes = get_course_suggest_intake();
        $levels = get_course_suggest_levels();
        $universities = Universities::all();
        return view('backend.automation.edit_workflow', ['years' => $years, 'universities' => $universities, 'countries' => $countries, 'intakes' => $intakes, 'levels' => $levels,'workflowData'=>$workflow]);
    }


    public function update_workflow(Request $request) {
        // echo "<pre>";
        // print_R($request->all());
        // exit();
        $request->validate([
            'title' => 'required',
        ]);

        $workflow = AutomationWorkflow::find($request->workflow_id);
        if(!$workflow){
            return redirect()->route('admin.automation')->withFlashDanger('Invalid workflow!');
        }

        $title = $request->title;
        
        // not editable
        $workflow_type = $workflow->workflow_type;
        $communication_mode = $workflow->communication_mode;
        // not editable

        $run_at =  date('H:i:s', strtotime($request->run_at_time.$request->run_at));

        //$workflow = new AutomationWorkflow;
        $workflow->title = $title;
        $workflow->workflow_type = $workflow_type;
        $workflow->communication_mode = $communication_mode;
        $workflow->run_at = $run_at;

        if($request->criteria_condition){
            $workflow->filter_condition = $request->criteria_condition;
        }else{
            $workflow->filter_condition = NULL;
        }
        
        if($workflow_type == "lead_nurture_sequence"){
            //Checking lead status
            $lead_statuses = "";
            $lead_status = $request->lead_status;
            if (!empty($lead_status) && count($lead_status)) {
                $lead_statuses = implode(",", $lead_status);
            }
            $workflow->lead_status = $lead_statuses;

            $other_criteria = $request->other_criteria;
            $criteria_value = $request->criteria_value;
            // if (!empty($other_criteria) && count($other_criteria)) {
            //     $criteria_Array = array();
            //     for($c=0;$c<count($other_criteria);$c++){
            //         if(!empty($criteria_value[$c])){
            //             $criteria_Array[$other_criteria[$c]] = $criteria_value[$c];
            //         }
            //     }
            //     if(!empty($criteria_Array)){
            //         $criteria_encoded = json_encode($criteria_Array);
            //         $workflow->lead_filters = $criteria_encoded;
            //     }
                
            // }
            if (!empty($other_criteria) && count($other_criteria) && !is_null($other_criteria)) {
                $criteria_Array = array();
                foreach($other_criteria as $otr_cri_val){
                    $rar = str_replace(" ","_",$otr_cri_val);
                    if($rar){
                        $criteria_Array[$otr_cri_val] = implode("|", $request->$rar);
                    }
                }
                if(!empty($criteria_Array)){
                    $criteria_encoded = json_encode($criteria_Array);
                    $workflow->lead_filters = $criteria_encoded;
                }
            }
            //message
            $lead_age = $request->lead_age;
            $message_template = $request->message_template;
            if (!empty($lead_age) && count($lead_age)) {
                $message_Array = array();
                for($d=0;$d<count($lead_age);$d++){
                    if(!empty($message_template[$d])){
                        $message_Array[$lead_age[$d]] = $message_template[$d];
                    }
                }
                $message_encoded = json_encode($message_Array);
                $workflow->message_details = $message_encoded;
            }
        }
//Message Sequence
        if($workflow_type == "message_sequence"){
            $target = $request->msg_target;
            if($target == "leads"){
                //Checking lead status
                $lead_statuses = "";
                $lead_status = $request->lead_status;
                if (!empty($lead_status) && count($lead_status)) {
                    $lead_statuses = implode(",", $lead_status);
                }
                $workflow->lead_status = $lead_statuses;
            }
            else if($target == "students"){
                //Checking lead status
                $student_statuses = "";
                $student_status = $request->student_status;
                if (!empty($student_status) && count($student_status)) {
                    $student_statuses = implode(",", $student_status);
                }
                $workflow->student_status = $student_statuses;

            }else{
                $workflow->student_status = $workflow->lead_status = NULL;
            }
            $workflow->target = $target;

            if (!empty($request->msg_start_date)) {
                $workflow->start_date = substr($request->msg_start_date, 6, 4) . "-" . substr($request->msg_start_date, 3, 2) . "-" . substr($request->msg_start_date, 0, 2);
            } else {
                $workflow->start_date = NULL;
            }
            $other_criteria = $request->other_criteria;
            $criteria_value = $request->criteria_value;
            // if (!empty($other_criteria) && count($other_criteria)) {
            //     $criteria_Array = array();
            //     for($c=0;$c<count($other_criteria);$c++){
            //         if(!empty($criteria_value[$c])){
            //             $criteria_Array[$other_criteria[$c]] = $criteria_value[$c];
            //         }
            //     }
            //     if(!empty($criteria_Array)){
            //         $criteria_encoded = json_encode($criteria_Array);
            //         if($target == "leads"){
            //             $workflow->lead_filters = $criteria_encoded;
            //         }
            //         else if($target == "students"){
            //             $workflow->student_filters = $criteria_encoded;
            //         }else{
            //             $workflow->lead_filters = $workflow->student_filters = NULL;
            //         }
            //     }
            // }
            if (!empty($other_criteria) && count($other_criteria) && !is_null($other_criteria)) {
                $criteria_Array = array();
                foreach($other_criteria as $otr_cri_val){
                    $rar = str_replace(" ","_",$otr_cri_val);
                    if($rar){
                        $criteria_Array[$otr_cri_val] = implode("|", $request->$rar);
                    }
                }
                if(!empty($criteria_Array)){
                    $criteria_encoded = json_encode($criteria_Array);
                    if($target == "leads"){
                        $workflow->lead_filters = $criteria_encoded;
                    }
                    else if($target == "students"){
                        $workflow->student_filters = $criteria_encoded;
                    }else{
                        $workflow->lead_filters = $workflow->student_filters = NULL;
                    }
                }
                
            }
            //message
            $after_days = $request->after_days;
            $msg_message_template = $request->msg_message_template;
            if (!empty($msg_message_template) && count($msg_message_template)) {
                $message_Array = array();
                for($d=0;$d<count($msg_message_template);$d++){
                    if($d == 0){
                        $message_Array["00"] = $msg_message_template[$d];
                    }
                    else if($d > 0 && !empty($msg_message_template[$d])){
                        $k=-1;
                        $k= $k+$d;
                        $message_Array[$after_days[$k]] = $msg_message_template[$d];
                        }
                    }
                }
                if(!empty($message_Array) && count($message_Array)){
                    $message_encoded = json_encode($message_Array);
                    $workflow->message_details = $message_encoded;
                }
            }
//Message Sequence        

//Specific Event 
if($workflow_type == "specific_event"){
    $target = $request->specific_target;
    // echo "<pre>";
    // print_R($request->all());
    // exit();
    if($target == "leads"){
        //Checking lead status
        $lead_statuses = "";
        $lead_status = $request->lead_status;
        if (!empty($lead_status) && count($lead_status)) {
            $lead_statuses = implode(",", $lead_status);
        }
        $workflow->lead_status = $lead_statuses;
    }
    else if($target == "students"){
        //Checking lead status
        $student_statuses = "";
        $student_status = $request->student_status;
        if (!empty($student_status) && count($student_status)) {
            $student_statuses = implode(",", $student_status);
        }
        $workflow->student_status = $student_statuses;

    }else{
        $workflow->student_status = $workflow->lead_status = NULL;
    }
    $workflow->target = $target;
    if (!empty($request->specific_start_date)) {
        $workflow->start_date = substr($request->specific_start_date, 6, 4) . "-" . substr($request->specific_start_date, 3, 2) . "-" . substr($request->specific_start_date, 0, 2);
    } else {
        $workflow->start_date = NULL;
    }
    $other_criteria = $request->other_criteria;
    $criteria_value = $request->criteria_value;
    // if (!empty($other_criteria) && count($other_criteria)) {
    //     $criteria_Array = array();
    //     for($c=0;$c<count($other_criteria);$c++){
    //         if(!empty($criteria_value[$c])){
    //             $criteria_Array[$other_criteria[$c]] = $criteria_value[$c];
    //         }
    //     }
    //     if(!empty($criteria_Array)){
    //         $criteria_encoded = json_encode($criteria_Array);
    //         if($target == "leads"){
    //             $workflow->lead_filters = $criteria_encoded;
    //         }
    //         else if($target == "students"){
    //             $workflow->student_filters = $criteria_encoded;
    //         }else{
    //             $workflow->lead_filters = $workflow->student_filters = NULL;
    //         }
    //     }
    // }
    if (!empty($other_criteria) && count($other_criteria) && !is_null($other_criteria)) {
        $criteria_Array = array();
        foreach($other_criteria as $otr_cri_val){
            $rar = str_replace(" ","_",$otr_cri_val);
            if($rar){
                $criteria_Array[$otr_cri_val] = implode("|", $request->$rar);
            }
        }
        if(!empty($criteria_Array)){
            $criteria_encoded = json_encode($criteria_Array);
            if($target == "leads"){
                $workflow->lead_filters = $criteria_encoded;
            }
            else if($target == "students"){
                $workflow->student_filters = $criteria_encoded;
            }else{
                $workflow->lead_filters = $workflow->student_filters = NULL;
            }
        }
        
    }
    $workflow->repeats = $request->repeats;
    //message
    $specific_message_template = $request->specific_message_template;
    if (!empty($specific_message_template) && count($specific_message_template)) {
        $message_Array = array();
        for($d=0;$d<count($specific_message_template);$d++){
                $message_Array["00"] = $specific_message_template[$d];
            }
        }
        if(!empty($message_Array) && count($message_Array)){
            $message_encoded = json_encode($message_Array);
            $workflow->message_details = $message_encoded;
        }
    }
//Specific Event  
        $workflow->created_by = auth()->user()->id;
        $workflow->save();
        return redirect()->route('admin.automation')->withFlashSuccess('Workflow updated!');
    }



public function workflow_details($id) {
        $workflow = AutomationWorkflow::find($id);
        if(!$workflow){
            return redirect()->route('admin.automation')->withFlashDanger('Invalid workflow!');
        }
        //getting details
        // Leads
        //Query debug
          DB::enableQueryLog();
        if($workflow->target == "leads"){
            if($workflow->lead_status){
                $statusArray = explode(',',$workflow->lead_status);
            }
            else{
                $statusArray = "";
            }
            
            if($workflow->lead_filters != ""){
                $filter_vals = json_decode($workflow->lead_filters);
            }else{
                $filter_vals = "";
            }
            //if filter_condition
            if($workflow->filter_condition){
                $filter_condition = $workflow->filter_condition;
            }else{
                $filter_condition = "";
            }
            
            $userDataCount = User::where('is_lead','1')
            ->join('user_details','user_details.userid','users.id')
            ->when(!empty($statusArray) && count($statusArray), function ($query) use ($statusArray) {
            //->when(count($statusArray), function ($query) use ($statusArray) {
                return $query->WhereIn('lead_status',$statusArray);
            })
            ->when(!empty($filter_vals), function ($query) use ($filter_vals,$filter_condition) {
                return $query->Where(function ($query) use ($filter_vals,$filter_condition) {
                    foreach($filter_vals as $filters => $vals){
                        $filters = strtolower(str_replace(' ', '_',$filters));
                        if($filters == "intake"){
                            $intk = explode("|",$vals);
                            //$intk_vals = implode("",$intk);
                            //$intatake_arr =  explode(" ", $intk_vals);
                            //dd($intk);
                            foreach($intk as $intk_vals){
                                $intatake_arr =  explode(" ", $intk_vals);
                                $query->orwhere('intake_year', 'LIKE', "%$intatake_arr[1]%");
                                $query->orwhere('intake_month', 'LIKE', "%$intatake_arr[0]%");
                            }
                            //exit();
                            // $query->where('intake_year', 'LIKE', "%$intatake_arr[1]%");
                            // $query->where('intake_month', 'LIKE', "%$intatake_arr[0]%");
                        }
                        else if($filters == "interested_study_level"){
                            $cond_vals = explode("|",$vals);
                            if($filter_condition == "and"){
                                $query->whereIn('overseas_study_level_selection',$cond_vals);
                            }
                            else if($filter_condition == "OR"){
                                $query->orwhereIn('overseas_study_level_selection',$cond_vals);
                            }
                            else{
                                $query->orwhereIn('overseas_study_level_selection',$cond_vals);
                            }
                        }
                        else if($filters == "course_interested_to_study"){
                            $cond_vals = explode("|",$vals);
                            if($filter_condition == "and"){
                                $query->whereIn('overseas_course_intersted',$cond_vals);
                            }
                            else if($filter_condition == "OR"){
                                $query->orwhereIn('overseas_course_intersted',$cond_vals);
                            }else{
                                $query->orwhereIn('overseas_course_intersted',$cond_vals);
                            }
                        }
                        else if($filters == "country_of_residence"){
                            $cond_vals = explode("|",$vals);
                            if($filter_condition == "and"){
                                $query->whereIn('country',$cond_vals);
                            }
                            else if($filter_condition == "OR"){
                                $query->orwhereIn('country',$cond_vals);
                            }else{
                                $query->orwhereIn('country',$cond_vals);
                            }
                        }
                        else if($filters == "qualification"){
                            $cond_vals = explode("|",$vals);
                            if($filter_condition == "and"){
                                $query->whereIn('highest_level_education',$cond_vals);
                            } 
                            else if($filter_condition == "OR"){
                                $query->orwhereIn('highest_level_education',$cond_vals);
                            }else{
                                $query->orwhereIn('highest_level_education',$cond_vals);
                            }
                        }
                        else if($filters == "other_services_interested"){
                            $cond_vals = explode("|",$vals);
                            if($filter_condition == "and"){
                                $query->whereIn('services',$cond_vals);
                            }
                            else if($filter_condition == "OR"){
                                $query->orwhereIn('services',$cond_vals);
                            }else{
                                $query->orwhereIn('services',$cond_vals);
                            }
                        }
                        else{
                            $cond_vals = explode("|",$vals);
                            if($filter_condition == "and"){
                                $query->whereIn($filters,$cond_vals);
                            }
                            else if($filter_condition == "OR"){
                                $query->orwhereIn($filters,$cond_vals);
                            }else{
                                $query->orwhereIn($filters,$cond_vals);
                            }
                        }
                       
                    }
                });
            })
            ->count();
        }else{
            $statusArray = explode(',',$workflow->student_status);
            
            if($workflow->student_filters != ""){
                $filter_vals = json_decode($workflow->student_filters);
            }else{
                $filter_vals = "";
            }
            //if filter_condition
            if($workflow->filter_condition){
                $filter_condition = $workflow->filter_condition;
            }else{
                $filter_condition = "";
            }
            $userDataCount = User::where('is_lead','0')
            ->join('user_details','user_details.userid','users.id')
            ->when(count($statusArray), function ($query) use ($statusArray) {
                return $query->WhereIn('overseas_status',$statusArray);
            })
            ->when(!empty($filter_vals), function ($query) use ($filter_vals,$filter_condition) {
                return $query->Where(function ($query) use ($filter_vals,$filter_condition) {
                    foreach($filter_vals as $filters => $vals){
                        $filters = strtolower(str_replace(' ', '_',$filters));
                        if($filters == "intake"){
                            $intk = explode("|",$vals);
                            foreach($intk as $intk_vals){
                                $intatake_arr =  explode(" ", $intk_vals);
                                $query->orwhere('intake_year', 'LIKE', "%$intatake_arr[1]%");
                                $query->orwhere('intake_month', 'LIKE', "%$intatake_arr[0]%");
                            }
                            // $intatake_arr =  explode(" ", $vals);
                            // $query->where('intake_year', 'LIKE', "%$intatake_arr[1]%");
                            // $query->where('intake_month', 'LIKE', "%$intatake_arr[0]%");
                        }
                        else if($filters == "interested_study_level"){
                            $cond_vals = explode("|",$vals);
                            if($filter_condition == "and"){
                            $query->whereIn('overseas_study_level_selection',$cond_vals);
                            }
                            else if($filter_condition == "OR"){
                                $query->orwhereIn('overseas_study_level_selection',$cond_vals);
                            }
                            else{
                                $query->orwhereIn('overseas_study_level_selection',$cond_vals);
                            }
                        }
                        else if($filters == "course_interested_to_study"){
                            $cond_vals = explode("|",$vals);
                            if($filter_condition == "and"){
                                $query->whereIn('overseas_course_intersted',$cond_vals);
                            }
                            else if($filter_condition == "OR"){
                                $query->orwhereIn('overseas_course_intersted',$cond_vals);
                            }else{
                                $query->orwhereIn('overseas_course_intersted',$cond_vals);
                            }
                        }
                        else if($filters == "country_of_residence"){
                            $cond_vals = explode("|",$vals);
                            if($filter_condition == "and"){
                                $query->whereIn('country',$cond_vals);
                            }
                            else if($filter_condition == "OR"){
                                $query->orwhereIn('country',$cond_vals);
                            }else{
                                $query->orwhereIn('country',$cond_vals);
                            }
                        }
                        else if($filters == "qualification"){
                            $cond_vals = explode("|",$vals);
                            if($filter_condition == "and"){
                                $query->whereIn('highest_level_education',$cond_vals);
                            } 
                            else if($filter_condition == "OR"){
                                $query->orwhereIn('highest_level_education',$cond_vals);
                            }else{
                                $query->orwhereIn('highest_level_education',$cond_vals);
                            }
                        }
                        else if($filters == "other_services_interested"){
                            $cond_vals = explode("|",$vals);
                            if($filter_condition == "and"){
                                $query->whereIn('services',$cond_vals);
                            }
                            else if($filter_condition == "OR"){
                                $query->orwhereIn('services',$cond_vals);
                            }else{
                                $query->orwhereIn('services',$cond_vals);
                            }
                        }
                        else{
                            $cond_vals = explode("|",$vals);
                            if($filter_condition == "and"){
                                $query->whereIn($filters,$cond_vals);
                            }
                            else if($filter_condition == "OR"){
                                $query->orwhereIn($filters,$cond_vals);
                            }else{
                                $query->orwhereIn($filters,$cond_vals);
                            }
                        }
                    }
                });
            })
            ->count();
        }
        //dd(\DB::getQueryLog());
        $execution_history = DB::table('auto_workflow_activity')->where('workflow_id',$workflow->id)->orderBy('created_at')->get();
        return view('backend.automation.workflow_details', ['workflowData'=>$workflow,'userDataCount'=>$userDataCount,'execution_history' => $execution_history]);

    }

    public function update_status($id,$status) {
        $workflow = AutomationWorkflow::find($id);
        $workflow->status = $status;
        $workflow->save();
        return redirect()->route('admin.automation')->withFlashSuccess('Workflow Status Changed');         
    } 

    public function duplicate($id) {
        
        $workflow = AutomationWorkflow::find($id);
        $newWorkflow = $workflow->replicate();
        $newWorkflow->created_at = now();
        $newWorkflow->save();
        return redirect()->route('admin.automation')->withFlashSuccess('Workflow Duplicated');         
    } 
    

    public function destroy($id) {
            $workflowdelete = AutomationWorkflow::find($id);
            $workflowdelete->delete();
            return redirect()->route('admin.automation')->withFlashSuccess('Workflow Deleted Successfully');         
        } 


    public function workflow_message_history($id){
        $workflow = AutomationWorkflow::find($id);
        if(!$workflow){
            return redirect()->route('admin.automation')->withFlashDanger('Invalid workflow!');
        }
          return view('backend.automation.workflow_message_history',compact('id'));
    }
      
    public function workflow_message_history_list(Request $request){

          $data = DB::table('user_activity')->join('automation_workflow','automation_workflow.id',"=",'user_activity.workflow_campaign_id')->where('workflow_campaign_id',$request->id)->latest('created_at')->get(['user_activity.*','automation_workflow.communication_mode']);
          return Datatables::of($data)
          ->addIndexColumn()
          ->editColumn('date', function ($data) {
            return date('d M, g:ia', strtotime($data->created_at));
          })
          ->editColumn('msg_type', function ($data) {
            return ucfirst($data->communication_mode);
          })
          ->editColumn('title', function ($data) {
            return $data->title;
          })
          ->editColumn('details', function ($data) {
            return $data->detail;
          })
          ->editColumn('sent_to', function ($data) {
            return get_user_email_by_id($data->user_id);
          })
          ->rawColumns(['details'])
          ->make(true);
        }

    //Campaigns
    public function create_campaign() {
        
        return view('backend.automation.create_campaign');
    }

    public function calculate_matched_audience(Request $request) {
        // return response()->json($request->all());
        // Leads
        \DB::enableQueryLog();

        
        if($request->target == "leads"){
            if($request->lead_status){
                $statusArray = $request->lead_status;
            }else{
                $statusArray = "";
            }
            
            $other_criteria = $request->other_criteria;
            $criteria_value = $request->criteria_value;
            
            if (!empty($other_criteria) && count($other_criteria) && !is_null($other_criteria['0'])) {
                $criteria_Array = array();
                for($c=0;$c<count($other_criteria);$c++){
                    if(!empty($criteria_value[$c])){
                        $criteria_Array[$other_criteria[$c]] = $criteria_value[$c];
                    }
                }
                if(!empty($criteria_Array)){
                    $criteria_encoded = json_encode($criteria_Array);
                }
                
            }
            if(isset($criteria_encoded) && $criteria_encoded != ""){
                $filter_vals = json_decode($criteria_encoded);
            }else{
                $filter_vals = "";
            }
            //if filter_condition
            if($request->filter_condition){
                $filter_condition = $request->filter_condition;
            }else{
                $filter_condition = "";
            }
            $audienceCount = User::where('is_lead','1')
            ->join('user_details','user_details.userid','users.id')
            ->when(!empty($statusArray) && count($statusArray), function ($query) use ($statusArray) {
                return $query->WhereIn('lead_status',$statusArray);
            })
            ->when(!empty($filter_vals), function ($query) use ($filter_vals,$filter_condition) {
                return $query->Where(function ($query) use ($filter_vals,$filter_condition) {
                    foreach($filter_vals as $filters => $vals){
                        $filters = strtolower(str_replace(' ', '_',$filters));
                        // if($filters == "intake"){
                        //     $intatake_arr =  explode(" ", $vals);
                        //     $query->orwhere('intake_year', 'LIKE', "%$intatake_arr[1]%");
                        //     $query->orwhere('intake_month', 'LIKE', "%$intatake_arr[0]%");
                        // }
                        // else if($filters == "interested_study_level"){
                        //     $query->orwhere('overseas_study_level_selection', 'LIKE', "%$vals%");
                        // }
                        // else if($filters == "course_interested_to_study"){
                        //     $query->orwhere('overseas_course_intersted', 'LIKE', "%$vals%");
                        // }
                        // else if($filters == "country_of_residence"){
                        //     $query->orwhere('country', 'LIKE', "%$vals%");
                        // }
                        // else if($filters == "qualification"){
                        //     $query->orwhere('highest_level_education', 'LIKE', "%$vals%");
                        // }
                        // else if($filters == "other_services_interested"){
                        //     $query->orwhere('services', 'LIKE', "%$vals%");
                        // }
                        // else{
                        //     $query->orwhere($filters, 'LIKE', "%$vals%");
                        // }
                        if($filters == "intake"){
                            // $intatake_arr =  explode(" ", $vals);
                            // $query->where('intake_year', 'LIKE', "%$intatake_arr[1]%");
                            // $query->where('intake_month', 'LIKE', "%$intatake_arr[0]%");
                            foreach($vals as $intk_vals){
                                $intatake_arr =  explode(" ", $intk_vals);
                                $query->orwhere('intake_year', 'LIKE', "%$intatake_arr[1]%");
                                $query->orwhere('intake_month', 'LIKE', "%$intatake_arr[0]%");
                            }
                        }
                        else if($filters == "interested_study_level"){
                            if($filter_condition == "and"){
                            $query->whereIn('overseas_study_level_selection',$vals);
                            }
                            else if($filter_condition == "OR"){
                                $query->orwhereIn('overseas_study_level_selection',$vals);
                            }
                            else{
                                $query->orwhereIn('overseas_study_level_selection',$vals);
                            }
                        }
                        else if($filters == "course_interested_to_study"){
                            if($filter_condition == "and"){
                                $query->whereIn('overseas_course_intersted',$vals);
                            }
                            else if($filter_condition == "OR"){
                                $query->orwhereIn('overseas_course_intersted',$vals);
                            }else{
                                $query->orwhereIn('overseas_course_intersted',$vals);
                            }
                        }
                        else if($filters == "country_of_residence"){
                            if($filter_condition == "and"){
                                $query->whereIn('country',$vals);
                            }
                            else if($filter_condition == "OR"){
                                $query->orwhereIn('country',$vals);
                            }else{
                                $query->orwhereIn('country',$vals);
                            }
                        }
                        else if($filters == "qualification"){
                            if($filter_condition == "and"){
                                $query->whereIn('highest_level_education',$vals);
                            } 
                            else if($filter_condition == "OR"){
                                $query->orwhereIn('highest_level_education',$vals);
                            }else{
                                $query->orwhereIn('highest_level_education',$vals);
                            }
                        }
                        else if($filters == "other_services_interested"){
                            if($filter_condition == "and"){
                                $query->whereIn('services',$vals);
                            }
                            else if($filter_condition == "OR"){
                                $query->orwhereIn('services',$vals);
                            }else{
                                $query->orwhereIn('services',$vals);
                            }
                        }
                        else{
                            if($filter_condition == "and"){
                                $query->whereIn($filters,$vals);
                            }
                            else if($filter_condition == "OR"){
                                $query->orwhereIn($filters,$vals);
                            }else{
                                $query->orwhereIn($filters,$vals);
                            }
                        }
                       
                    }
                });
            })
            ->count();
        }
        else if($request->target == "students"){
            if($request->student_status){
                $statusArray = $request->student_status;
            }else{
                $statusArray = "";
            }
            $other_criteria = $request->other_criteria;
            $criteria_value = $request->criteria_value;
            
            if (!empty($other_criteria) && count($other_criteria) && !is_null($other_criteria['0'])) {
                $criteria_Array = array();
                for($c=0;$c<count($other_criteria);$c++){
                    if(!empty($criteria_value[$c])){
                        $criteria_Array[$other_criteria[$c]] = $criteria_value[$c];
                    }
                }
                if(!empty($criteria_Array)){
                    $criteria_encoded = json_encode($criteria_Array);
                }
                
            }
            if(isset($criteria_encoded) && $criteria_encoded != ""){
                $filter_vals = json_decode($criteria_encoded);
            }else{
                $filter_vals = "";
            }
            //if filter_condition
            if($request->filter_condition){
                $filter_condition = $request->filter_condition;
            }else{
                $filter_condition = "";
            }
            $audienceCount = User::where('is_lead','0')
            ->join('user_details','user_details.userid','users.id')
            ->when(!empty($statusArray) && count($statusArray), function ($query) use ($statusArray) {
                return $query->WhereIn('overseas_status',$statusArray);
            })
            ->when(!empty($filter_vals), function ($query) use ($filter_vals,$filter_condition) {
                return $query->Where(function ($query) use ($filter_vals,$filter_condition) {
                    foreach($filter_vals as $filters => $vals){
                        $filters = strtolower(str_replace(' ', '_',$filters));
                        if($filters == "intake"){
                            $intatake_arr =  explode(" ", $vals);
                            $query->orwhere('intake_year', 'LIKE', "%$intatake_arr[1]%");
                            $query->orwhere('intake_month', 'LIKE', "%$intatake_arr[0]%");
                        }
                        else if($filters == "interested_study_level"){
                            if($filter_condition == "and"){
                            $query->whereIn('overseas_study_level_selection',$vals);
                            }
                            else if($filter_condition == "OR"){
                                $query->orwhereIn('overseas_study_level_selection',$vals);
                            }
                            else{
                                $query->orwhereIn('overseas_study_level_selection',$vals);
                            }
                        }
                        else if($filters == "course_interested_to_study"){
                            if($filter_condition == "and"){
                                $query->whereIn('overseas_course_intersted',$vals);
                            }
                            else if($filter_condition == "OR"){
                                $query->orwhereIn('overseas_course_intersted',$vals);
                            }else{
                                $query->orwhereIn('overseas_course_intersted',$vals);
                            }
                        }
                        else if($filters == "country_of_residence"){
                            if($filter_condition == "and"){
                                $query->whereIn('country',$vals);
                            }
                            else if($filter_condition == "OR"){
                                $query->orwhereIn('country',$vals);
                            }else{
                                $query->orwhereIn('country',$vals);
                            }
                        }
                        else if($filters == "qualification"){
                            if($filter_condition == "and"){
                                $query->whereIn('highest_level_education', $vals);
                            } 
                            else if($filter_condition == "OR"){
                                $query->orwhereIn('highest_level_education', $vals);
                            }else{
                                $query->orwhereIn('highest_level_education', $vals);
                            }
                        }
                        else if($filters == "other_services_interested"){
                            if($filter_condition == "and"){
                                $query->whereIn('services', $vals);
                            }
                            else if($filter_condition == "OR"){
                                $query->orwhereIn('services', $vals);
                            }else{
                                $query->orwhereIn('services', $vals);
                            }
                        }
                        else{
                            if($filter_condition == "and"){
                                $query->whereIn($filters, $vals);
                            }
                            else if($filter_condition == "OR"){
                                $query->orwhereIn($filters, $vals);
                            }else{
                                $query->orwhereIn($filters, $vals);
                            }
                        }
                       
                    }
                });
            })
            ->count();
        }
        else if($request->target == "staff"){
           
            $audienceCount = User::with('roles')
            ->whereHas('roles', function ($q) {
                $q->whereNotIn('name', ['user', 'trainer', 'agent']);
            })
            ->count();
        }
        else if($request->target == "agents"){
            $audienceCount =  User::with('roles')
            ->whereHas('roles', function ($q) {
              $q->whereIn('name', ['agent']);
            })
            ->count();
        }
        else{
            $audienceCount =  User::count();
        }
        $data = $request->target;
        
       // return response()->json(\DB::getQueryLog());
        return response()->json($audienceCount);
        
    }

    public function campaigns() {
        $campaigns = AutomationCampaign::all();
        return view('backend.automation.campaigns_index', compact('campaigns'));
    }

    public function campaignData(Request $request){

        if (!$request->ajax()) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this page.');
        }
        echo $this->getDatatableCampaignlist($request);
    }

    public function getDatatableCampaignlist($request){
        //Query debug
        // DB::enableQueryLog();

        $columns = array(
            0 => 'title',
            1 => 'status',
            2 => 'run_at',
            3 => 'communication_mode',
            4 => 'sent_to',
        );        

        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');
        $get_search = $request->input('search.value');
        $status = $request->input('camp_status');
        

        $totalData = DB::table('automation_campaign')
        ->when(!empty($get_search), function ($query) use ($get_search) {
            return $query->Where('title', 'like', "%$get_search%")
            ->orWhere('status', 'like', "%$get_search%")
            ->orWhere('communication_mode', 'like', "%$get_search%");
        })
        ->when(!empty($status), function ($query) use ($status) {
            return  $query->Where('status',$status);
        })
        ->count();

        $workflows = DB::table('automation_campaign')
            ->offset($start)
            ->limit($limit)
            ->orderBy($order, $dir)
            ->when(!empty($get_search), function ($query) use ($get_search) {
                return $query->Where('title', 'like', "%$get_search%")
                ->orWhere('status', 'like', "%$get_search%")
                ->orWhere('communication_mode', 'like', "%$get_search%");
            })
            ->when(!empty($status), function ($query) use ($status) {
                return  $query->Where('status',$status);
            })
            ->get();

        $totalFiltered = $totalData;

        $data = array();
        if (!empty($workflows)) {
            $count = 1;
            foreach ($workflows as $page) {
                $customResult['title'] = "<b>".$page->title."</b>";
                if($page->status == "paused"){
                    $badgeClr = "badge-danger";
                }
                else if($page->status == "sent"){
                    $badgeClr = "badge-secondary";
                }else{
                    $badgeClr = "badge-success";
                }
                $customResult['status'] = "<span class='badge ".$badgeClr."'>".ucfirst($page->status)."</span>";
                $customResult['run_at'] = date("d-m-Y h:i A",strtotime($page->run_at));
                $customResult['mode'] =  ucfirst($page->communication_mode);
                $customResult['audience_count'] = $page->sent_count;
                
                $options ='<div class="btn-group" role="group" aria-label="'.__('labels.backend.access.users.user_actions').'">
                                <a href="' .  route('admin.automation.campaign.details', $page->id) . '" data-toggle="tooltip" data-placement="top" title="'.__('buttons.general.crud.view').'" class="btn btn-info" style="color: #fff;"><i class="ri-eye-fill"></i></a>
                                    
                                <div class="btn-group btn-group-sm" role="group">
                                  <button style="padding: 0.450rem 0.75rem;margin-bottom:0px;" id="userActions" type="button" class="btn btn-secondary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="true"><i class="bi bi-three-dots-vertical"></i>
                                  </button>
                                  <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow" data-popper-placement="bottom-end">
                                    <a href="' . route('admin.automation.campaign.duplicate', $page->id) . '" name="confirm_item" class="dropdown-item"
                                    data-trans-button-confirm="Duplicate"
                                    data-trans-title="Are you sure you want to Duplicate?">Duplicate</a>';
                        if ($page->status != 'running') {
                            $options .= '<a href="' . route('admin.automation.campaign.edit', $page->id) . '" class="dropdown-item">Edit</a>';
                        }
                        if ($page->status == 'queued') {
                            $options .= '<a href="' . route('admin.automation.campaign.updateStatus', [$page->id, "paused"]) . '" class="dropdown-item">Pause</a>';
                        }
                        else if ($page->status == 'paused') {
                            if($page->run_at > now()){
                                $options .= '<a href="' . route('admin.automation.campaign.updateStatus', [$page->id, "queued"]) . '" class="dropdown-item">Resume</a>';
                            }else{
                                $options .= '<a href="#" class="dropdown-item disabled">Resume</a>';
                            }
                            
                        }

                    $options .= '<a class="dropdown-item" href="' . route('admin.automation.campaign.destroy', $page->id) . '"
                            data-method="delete"
                            data-trans-button-cancel="Cancel"
                            data-trans-button-confirm="Delete"
                            data-trans-title="Are you sure to Delete?"
                            class="dropdown-item">Delete</a>';
                    $options .= '</div></div>';
                $customResult['actions'] = $options;
                $data[] = $customResult;
            }
        }
        //\Log::debug('My User Id: ' . $my_user_id);
        $json_data = array(
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $data,
        );

        return json_encode($json_data);
    }


    public function test_Send(Request $request)
    {
        $data = $request->all();
        //return response()->json($data);
        if($data['msg_type'] == '1'){
            //EMAIL Block
            if (!$data['subject_val'] || $data['subject_val']=="") {
                return response()->json(["err"=>'Subject is required!']);
            }
            if (!$data['message'] || $data['message']=="") {
                return response()->json(["err"=>'Message is required!']);
            }
            if (!$data['send_to'] || $data['send_to']=="") {
                return response()->json(["err"=>'Email is required!']);
            }
            //$user = (new UserRepository())->where('id', \Auth::user()->id)->first();
            $message = $data['message'];
            $subject = $data['subject_val'];
             // $messages = str_replace('#first_name#', $user->first_name, $message);
            // $messages = str_replace('#full_name#', $user->first_name . " " . $user->last_name, $messages);
            $messages = str_replace('#first_name#', " ", $message);
            $messages = str_replace('#full_name#', " ", $messages);
            $messages = str_replace('#sitename#', app_name(), $messages);
            $messages = str_replace('#siteurl#', config('app.url'), $messages);
            try{
            \Log::debug("Automation Mail MSG".$messages); 
                //Mail::to($data['send_to'])->send(new MailSend($subject, $messages));
                user_notify($data['send_to'],$subject, $messages);
            }catch (\Exception $e) {
                $message = $e->getMessage();
                \Log::debug("Mail Error: (Test mail: ) ".$message);
                return response()->json(["err"=>'Something Went Wrong!']);   
            }
            return response()->json(["success"=>'Mail sent successfully!']);
        }
        else if($data['msg_type'] == '2'){
        //SMS Block
            if (!$data['message'] || $data['message']=="") {
                return response()->json(["err"=>'Message is required!']);
            }
            if (!$data['send_to'] || $data['send_to']=="") {
                return response()->json(["err"=>'Mobile No. is required!']);
            }
            //$user = (new UserRepository())->where('id', \Auth::user()->id)->first();
            $message = $data['message'];
            // $messages = str_replace('#first_name#', $user->first_name, $message);
            // $messages = str_replace('#full_name#', $user->first_name . " " . $user->last_name, $messages);
            $messages = str_replace('#first_name#', " ", $message);
            $messages = str_replace('#full_name#', " ", $messages);
            $messages = str_replace('#sitename#', app_name(), $messages);
            $messages = str_replace('#siteurl#', config('app.url'), $messages);
            try{
            \Log::debug("Automation SMS MSG".$messages); 
                send_sms([$data['send_to']], $messages, "");
            }catch (\Exception $e) {
                $message = $e->getMessage();
                \Log::debug("SMS Error: (Test sms: ) ".$message);
                return response()->json(["err"=>'Something Went Wrong!']);   
            }
            return response()->json(["success"=>'SMS sent successfully!']);
        }
        else if($data['msg_type'] == '4'){
            //WHATSAPP Block
                if (!$data['whtsp_template'] || $data['whtsp_template']=="") {
                    return response()->json(["err"=>'Whatsapp Template is required!']);
                }
                if (!$data['message'] || $data['message']=="") {
                    return response()->json(["err"=>'Message is required!']);
                }
                if (!$data['send_to'] || $data['send_to']=="") {
                    return response()->json(["err"=>'Mobile No. is required!']);
                }
                //$user = (new UserRepository())->where('id', \Auth::user()->id)->first();
                $message = $data['message'];
                 // $messages = str_replace('#first_name#', $user->first_name, $message);
                // $messages = str_replace('#full_name#', $user->first_name . " " . $user->last_name, $messages);
                $messages = str_replace('#first_name#', " ", $message);
                $messages = str_replace('#full_name#', " ", $messages);
                $messages = str_replace('#sitename#', app_name(), $messages);
                $messages = str_replace('#siteurl#', config('app.url'), $messages);
                // $messages = str_replace('{{first_name}}', $user->first_name, $message);
                // $messages = str_replace('{{full_name}}', $user->first_name . " " . $user->last_name, $messages);
                $messages = str_replace('{{first_name}}', " ", $message);
                $messages = str_replace('{{full_name}}', " ", $messages);
                $messages = str_replace('{{sitename}}', app_name(), $messages);
                $messages = str_replace('{{siteurl}}', config('app.url'), $messages);
                $notify_whtsp = get_whatsapp_template($data['whtsp_template']);
            if ($notify_whtsp) {
                    try{
                    \Log::debug("Automation Whatsapp MSG".$messages); 
                        send_whatsapp_message([$data['send_to']], $messages, $notify_whtsp->hook);
                    }catch (\Exception $e) {
                        $message = $e->getMessage();
                        \Log::debug("WHATSAPP Error: (Test whatsapp: ) ".$message);
                        return response()->json(["err"=>'Something Went Wrong!']);   
                    }
                    return response()->json(["success"=>'WHATSAPP sent successfully!']);
                }else{
                    return response()->json(["err"=>'Whatsapp Disabled!']);
                }
            }
    }

    public function store_campaign(Request $request) {
        
        $request->validate([
            'title' => 'required',
            'target' => 'required',
            'msg_type' => 'required',
        ]);
        $msg_type = $request->msg_type;

        if($msg_type == '1'){
            $communication_mode = "email";
            $template = $request->email_template;
        }else if($msg_type == '2'){
            $communication_mode = "sms";
            $template = $request->sms_template;
        }else{
            $communication_mode = "whatsapp";
            $template = $request->whtsp_template;
        }
        

        if($request->submit_action == 'create_now'){
            $title = $request->title;
            $target = $request->target;

            $campaign = new AutomationCampaign;
            $campaign->title = $title;
            $campaign->target = $target;
            $campaign->communication_mode = $communication_mode;
            $campaign->message_template = $template;
            if ($request->run_at) {
                $campaign->run_at = date("Y-m-d H:i", strtotime($request->run_at));
            }
            //Checking lead/student status
                if($target == "leads"){
                    $lead_statuses = "";
                    $lead_status = $request->lead_status;
                    if (!empty($lead_status) && count($lead_status)) {
                        $lead_statuses = implode(",", $lead_status);
                    }
                    $campaign->lead_status = $lead_statuses;
                }
                else if($target == "students"){
                    $student_statuses = "";
                    $student_status = $request->student_status;
                    if (!empty($student_status) && count($student_status)) {
                        $student_statuses = implode(",", $student_status);
                    }
                    $campaign->student_status = $student_statuses;
            
                }else{
                    $campaign->student_status = $campaign->lead_status = NULL;
                }

                $other_criteria = $request->other_criteria;
                $criteria_value = $request->criteria_value;

                // if (!empty($other_criteria) && count($other_criteria)) {
                //     $criteria_Array = array();
                //     for($c=0;$c<count($other_criteria);$c++){
                //         if(!empty($criteria_value[$c])){
                //             $criteria_Array[$other_criteria[$c]] = $criteria_value[$c];
                //         }
                //     }
                //     if(!empty($criteria_Array)){
                //         $criteria_encoded = json_encode($criteria_Array);
                //         if($target == "leads"){
                //             $campaign->lead_filters = $criteria_encoded;
                //         }
                //         else if($target == "students"){
                //             $campaign->student_filters = $criteria_encoded;
                //         }else{
                //             $campaign->lead_filters = $campaign->student_filters = NULL;
                //         }
                //     }
                    
                // }
                if (!empty($other_criteria) && count($other_criteria) && !is_null($other_criteria)) {
                    $criteria_Array = array();
                    //echo "<pre>";
                    foreach($other_criteria as $otr_cri_val){
                        $rar = str_replace(" ","_",$otr_cri_val);
                        if($rar){
                            $criteria_Array[$otr_cri_val] = implode("|", $request->$rar);
                        }
                    }
                    if(!empty($criteria_Array)){
                        $criteria_encoded = json_encode($criteria_Array);
                        if($target == "leads"){
                            $campaign->lead_filters = $criteria_encoded;
                        }
                        else if($target == "students"){
                            $campaign->student_filters = $criteria_encoded;
                        }else{
                            $campaign->lead_filters = $campaign->student_filters = NULL;
                        }
                    }
                }
            //message
            $campaign->message_subject = $request->subject;
            if($msg_type == '1'){
                $campaign->message_content = $request->message_html;
            }else{
                $campaign->message_content = $request->message;
            }
            if($request->criteria_condition){
                $campaign->filter_condition = $request->criteria_condition;
            }else{
                $campaign->filter_condition = NULL;
            }
            $campaign->created_by = auth()->user()->id;
            $campaign->save();
            return redirect()->route('admin.automation.campaigns')->withFlashSuccess('Campaign Saved!');
        }
        if($request->submit_action == 'send_now'){
            $title = $request->title;
            $target = $request->target;
            $campaign = new AutomationCampaign;
            $campaign->title = $title;
            $campaign->target = $target;
            $campaign->communication_mode = $communication_mode;
            $campaign->message_template = $template;
            $currentTime = now();
            $newTime = $currentTime->addMinutes(1);
            $campaign->run_at = date("Y-m-d H:i", strtotime($newTime));

            //Checking lead/student status
                if($target == "leads"){
                    $lead_statuses = "";
                    $lead_status = $request->lead_status;
                    if (!empty($lead_status) && count($lead_status)) {
                        $lead_statuses = implode(",", $lead_status);
                    }
                    $campaign->lead_status = $lead_statuses;
                }
                else if($target == "students"){
                    $student_statuses = "";
                    $student_status = $request->student_status;
                    if (!empty($student_status) && count($student_status)) {
                        $student_statuses = implode(",", $student_status);
                    }
                    $campaign->student_status = $student_statuses;
            
                }else{
                    $campaign->student_status = $campaign->lead_status = NULL;
                }
                $other_criteria = $request->other_criteria;
                $criteria_value = $request->criteria_value;
                // if (!empty($other_criteria) && count($other_criteria)) {
                //     $criteria_Array = array();
                //     for($c=0;$c<count($other_criteria);$c++){
                //         if(!empty($criteria_value[$c])){
                //             $criteria_Array[$other_criteria[$c]] = $criteria_value[$c];
                //         }
                //     }
                //     if(!empty($criteria_Array)){
                //         $criteria_encoded = json_encode($criteria_Array);
                //         if($target == "leads"){
                //             $campaign->lead_filters = $criteria_encoded;
                //         }
                //         else if($target == "students"){
                //             $campaign->student_filters = $criteria_encoded;
                //         }else{
                //             $campaign->lead_filters = $campaign->student_filters = NULL;
                //         }
                //     }
                // }
                if (!empty($other_criteria) && count($other_criteria) && !is_null($other_criteria)) {
                    $criteria_Array = array();
                    //echo "<pre>";
                    foreach($other_criteria as $otr_cri_val){
                        $rar = str_replace(" ","_",$otr_cri_val);
                        if($rar){
                            $criteria_Array[$otr_cri_val] = implode("|", $request->$rar);
                        }
                    }
                    if(!empty($criteria_Array)){
                        $criteria_encoded = json_encode($criteria_Array);
                        if($target == "leads"){
                            $campaign->lead_filters = $criteria_encoded;
                        }
                        else if($target == "students"){
                            $campaign->student_filters = $criteria_encoded;
                        }else{
                            $campaign->lead_filters = $campaign->student_filters = NULL;
                        }
                    }
                }
            //message
            $campaign->message_subject = $request->subject;
            if($msg_type == '1'){
                $campaign->message_content = $request->message_html;
            }else{
                $campaign->message_content = $request->message;
            }
            if($request->criteria_condition){
                $campaign->filter_condition = $request->criteria_condition;
            }else{
                $campaign->filter_condition = NULL;
            }
            $campaign->created_by = auth()->user()->id;
            $campaign->save();
            return redirect()->route('admin.automation.campaigns')->withFlashSuccess('Campaign Messages Sent!');
        }   
    }

    public function update_campaign_status($id,$status) {
        $campaign = AutomationCampaign::find($id);
        if($campaign->status == "running"){
            return redirect()->route('admin.automation.campaigns')->withFlashDanger('Campaign is Running and status cannot be Changed.');
        }
        if($campaign->run_at <= now()){
            return redirect()->route('admin.automation.campaigns')->withFlashDanger('Campaign status cannot be Changed.');
        }
        $campaign->status = $status;
        $campaign->save();
        return redirect()->route('admin.automation.campaigns')->withFlashSuccess('Campaign Status Changed');         
    } 

    public function duplicate_campaign($id) {
        $campaign = AutomationCampaign::find($id);
        $newCampaign = $campaign->replicate();
        $currentTime = now();
        $newTime = $currentTime->addDays(30);
        $newCampaign->run_at = date("Y-m-d H:i", strtotime($newTime));
        $newCampaign->created_at = now();
        $newCampaign->save();
        return redirect()->route('admin.automation.campaigns')->withFlashSuccess('Campaign Duplicated');         
    } 

    public function destroy_campaign($id) {
        $campaigndelete = AutomationCampaign::find($id);
        if($campaigndelete->status == "running"){
            return redirect()->route('admin.automation.campaigns')->withFlashDanger('Running Campaign cannot be Deleted.');
        }
        $campaigndelete->delete();
        return redirect()->route('admin.automation.campaigns')->withFlashSuccess('Campaign Deleted Successfully');         
    } 

    
    public function campaign_details($id) {
        $campaign = AutomationCampaign::find($id);
        if(!$campaign){
            return redirect()->route('admin.automation')->withFlashDanger('Invalid Campaign!');
        }
        //getting details
        // Leads
        if($campaign->target == "leads"){
            $statusArray = explode(',',$campaign->lead_status);
            
            if($campaign->lead_filters != ""){
                $filter_vals = json_decode($campaign->lead_filters);
            }else{
                $filter_vals = "";
            }
            // $userDataCount = User::where('is_lead','1')
            // ->join('user_details','user_details.userid','users.id')
            // ->when(count($statusArray), function ($query) use ($statusArray) {
            //     return $query->WhereIn('lead_status',$statusArray);
            // })
            // ->when(!empty($filter_vals), function ($query) use ($filter_vals) {
            //     return $query->Where(function ($query) use ($filter_vals) {
            //         foreach($filter_vals as $filters => $vals){
            //             $filters = strtolower(str_replace(' ', '_',$filters));
            //             if($filters == "intake"){
            //                 $intatake_arr =  explode(" ", $vals);
            //                 $query->orwhere('intake_year', 'LIKE', "%$intatake_arr[1]%");
            //                 $query->orwhere('intake_month', 'LIKE', "%$intatake_arr[0]%");
            //             }
            //             else if($filters == "interested_study_level"){
            //                 $query->orwhere('overseas_study_level_selection', 'LIKE', "%$vals%");
            //             }
            //             else if($filters == "course_interested_to_study"){
            //                 $query->orwhere('overseas_course_intersted', 'LIKE', "%$vals%");
            //             }
            //             else if($filters == "country_of_residence"){
            //                 $query->orwhere('country', 'LIKE', "%$vals%");
            //             }
            //             else if($filters == "qualification"){
            //                 $query->orwhere('highest_level_education', 'LIKE', "%$vals%");
            //             }
            //             else if($filters == "other_services_interested"){
            //                 $query->orwhere('services', 'LIKE', "%$vals%");
            //             }
            //             else{
            //                 $query->orwhere($filters, 'LIKE', "%$vals%");
            //             }
                       
            //         }
            //     });
            // })
            // ->count();
        }
        else if($campaign->target == "students"){
            $statusArray = explode(',',$campaign->student_status);
            
            if($campaign->student_filters != ""){
                $filter_vals = json_decode($campaign->student_filters);
            }else{
                $filter_vals = "";
            }

            // $userDataCount = User::where('is_lead','0')
            // ->join('user_details','user_details.userid','users.id')
            // ->when(count($statusArray), function ($query) use ($statusArray) {
            //     return $query->WhereIn('overseas_status',$statusArray);
            // })
            // ->when(!empty($filter_vals), function ($query) use ($filter_vals) {
            //     return $query->Where(function ($query) use ($filter_vals) {
            //         foreach($filter_vals as $filters => $vals){
            //             $filters = strtolower(str_replace(' ', '_',$filters));
            //             if($filters == "intake"){
            //                 $intatake_arr =  explode(" ", $vals);
            //                 $query->orwhere('intake_year', 'LIKE', "%$intatake_arr[1]%");
            //                 $query->orwhere('intake_month', 'LIKE', "%$intatake_arr[0]%");
            //             }
            //             else if($filters == "interested_study_level"){
            //                 $query->orwhere('overseas_study_level_selection', 'LIKE', "%$vals%");
            //             }
            //             else if($filters == "course_interested_to_study"){
            //                 $query->orwhere('overseas_course_intersted', 'LIKE', "%$vals%");
            //             }
            //             else if($filters == "country_of_residence"){
            //                 $query->orwhere('country', 'LIKE', "%$vals%");
            //             }
            //             else if($filters == "qualification"){
            //                 $query->orwhere('highest_level_education', 'LIKE', "%$vals%");
            //             }
            //             else if($filters == "other_services_interested"){
            //                 $query->orwhere('services', 'LIKE', "%$vals%");
            //             }
            //             else{
            //                 $query->orwhere($filters, 'LIKE', "%$vals%");
            //             }
            //         }
            //     });
            // })
            // ->count();
        }
        // else if($campaign->target == "staff"){
           
        //     $userDataCount = User::with('roles')
        //     ->whereHas('roles', function ($q) {
        //         $q->whereNotIn('name', ['user', 'trainer', 'agent']);
        //     })
        //     ->count();
        // }
        // else if($campaign->target == "agents"){
        //     $userDataCount =  User::with('roles')
        //     ->whereHas('roles', function ($q) {
        //       $q->whereIn('name', ['agent']);
        //     })
        //     ->count();
        // }
        // else{
        //     $userDataCount =  User::count();
        // }
        $execution_history = DB::table('user_activity')->where('workflow_campaign_id',$campaign->id)->orderBy('created_at')->get();
        return view('backend.automation.campaign_details', ['campaignData'=>$campaign,
        // 'userDataCount'=>$userDataCount,
        'execution_history' => $execution_history]);

    }

    public function edit_campaign($id) {
        $campaign = AutomationCampaign::find($id);
        if(!$campaign){
            return redirect()->route('admin.automation.campaigns')->withFlashDanger('Invalid campaign!');
        }
        if($campaign->status == 'running'){
            return redirect()->route('admin.automation.campaigns')->withFlashDanger('Campaign Cannot be edited because it is in Running Status!');
        }
        return view('backend.automation.edit_campaign',['campaignData'=>$campaign]);
    }


    public function update_campaign(Request $request) {
        
        $request->validate([
            'title' => 'required',
            'target' => 'required',
            'msg_type' => 'required',
        ]);

        $campaign = AutomationCampaign::find($request->campaign_id);
        $campaign->status = "queued";
        if(!$campaign){
            return redirect()->route('admin.automation')->withFlashDanger('Invalid campaign!');
        }
        if($campaign->status == 'running'){
            return redirect()->route('admin.automation.campaigns')->withFlashDanger('Campaign Cannot be edited because it is in Running Status!');
        }

        $msg_type = $request->msg_type;

        if($msg_type == '1'){
            $communication_mode = "email";
            $template = $request->email_template;
        }else if($msg_type == '2'){
            $communication_mode = "sms";
            $template = $request->sms_template;
        }else{
            $communication_mode = "whatsapp";
            $template = $request->whtsp_template;
        }

        if($request->criteria_condition){
            $campaign->filter_condition = $request->criteria_condition;
        }else{
            $campaign->filter_condition = NULL;
        }

        if($request->submit_action == 'create_now'){
            $title = $request->title;
            $target = $request->target;

            $campaign->title = $title;
            $campaign->target = $target;
            $campaign->communication_mode = $communication_mode;
            $campaign->message_template = $template;
            if ($request->run_at) {
                $campaign->run_at = date("Y-m-d H:i", strtotime($request->run_at));
            }
            //Checking lead/student status
                if($target == "leads"){
                    $lead_statuses = "";
                    $lead_status = $request->lead_status;
                    if (!empty($lead_status) && count($lead_status)) {
                        $lead_statuses = implode(",", $lead_status);
                    }
                    $campaign->lead_status = $lead_statuses;
                }
                else if($target == "students"){
                    $student_statuses = "";
                    $student_status = $request->student_status;
                    if (!empty($student_status) && count($student_status)) {
                        $student_statuses = implode(",", $student_status);
                    }
                    $campaign->student_status = $student_statuses;
            
                }else{
                    $campaign->student_status = $campaign->lead_status = NULL;
                }

                $other_criteria = $request->other_criteria;
                $criteria_value = $request->criteria_value;

                // if ($other_criteria && count($other_criteria) && !is_null($other_criteria['0'])) {
                //     $criteria_Array = array();
                //     for($c=0;$c<count($other_criteria);$c++){
                //         if(!empty($criteria_value[$c])){
                //             $criteria_Array[$other_criteria[$c]] = $criteria_value[$c];
                //         }
                //     }
                //     if(!empty($criteria_Array)){
                //         $criteria_encoded = json_encode($criteria_Array);
                //         if($target == "leads"){
                //             $campaign->lead_filters = $criteria_encoded;
                //         }
                //         else if($target == "students"){
                //             $campaign->student_filters = $criteria_encoded;
                            
                //         }else{
                //             $campaign->lead_filters = $campaign->student_filters = NULL;
                //         }
                //     }
                    
                // }else{
                //     $campaign->lead_filters = $campaign->student_filters = NULL;
                // }

                if (!empty($other_criteria) && count($other_criteria) && !is_null($other_criteria)) {
                    $criteria_Array = array();
                    foreach($other_criteria as $otr_cri_val){
                        $rar = str_replace(" ","_",$otr_cri_val);
                        if($rar){
                            $criteria_Array[$otr_cri_val] = implode("|", $request->$rar);
                        }
                    }
                    if(!empty($criteria_Array)){
                        $criteria_encoded = json_encode($criteria_Array);
                        if($target == "leads"){
                            $campaign->lead_filters = $criteria_encoded;
                        }
                        else if($target == "students"){
                            $campaign->student_filters = $criteria_encoded;
                        }else{
                            $campaign->lead_filters = $campaign->student_filters = NULL;
                        }
                    }
                }
                else{
                    $campaign->lead_filters = $campaign->student_filters = NULL;
                }
            //message
            $campaign->message_subject = $request->subject;
            if($msg_type == '1'){
                $campaign->message_content = $request->message_html;
            }else{
                $campaign->message_content = $request->message;
            }
            if($request->criteria_condition){
                $campaign->filter_condition = $request->criteria_condition;
            }else{
                $campaign->filter_condition = NULL;
            }
            $campaign->created_by = auth()->user()->id;
            $campaign->save();
            return redirect()->route('admin.automation.campaigns')->withFlashSuccess('Campaign Updated!');
        }
        if($request->submit_action == 'send_now'){
            $title = $request->title;
            $target = $request->target;
            //$campaign = new AutomationCampaign;
            $campaign->title = $title;
            $campaign->target = $target;
            $campaign->communication_mode = $communication_mode;
            $campaign->message_template = $template;
        
            $currentTime = now();
            $newTime = $currentTime->addMinutes(1);
            $campaign->run_at = date("Y-m-d H:i", strtotime($newTime));

            //Checking lead/student status
                if($target == "leads"){
                    $lead_statuses = "";
                    $lead_status = $request->lead_status;
                    if (!empty($lead_status) && count($lead_status)) {
                        $lead_statuses = implode(",", $lead_status);
                    }
                    $campaign->lead_status = $lead_statuses;
                }
                else if($target == "students"){
                    $student_statuses = "";
                    $student_status = $request->student_status;
                    if (!empty($student_status) && count($student_status)) {
                        $student_statuses = implode(",", $student_status);
                    }
                    $campaign->student_status = $student_statuses;
            
                }else{
                    $campaign->student_status = $campaign->lead_status = NULL;
                }
                $other_criteria = $request->other_criteria;
                $criteria_value = $request->criteria_value;
                // if ($other_criteria && count($other_criteria) && !is_null($other_criteria['0'])) {
                //     $criteria_Array = array();
                //     for($c=0;$c<count($other_criteria);$c++){
                //         if(!empty($criteria_value[$c])){
                //             $criteria_Array[$other_criteria[$c]] = $criteria_value[$c];
                //         }
                //     }
                //     if(!empty($criteria_Array)){
                //         $criteria_encoded = json_encode($criteria_Array);
                //         if($target == "leads"){
                //             $campaign->lead_filters = $criteria_encoded;
                //         }
                //         else if($target == "students"){
                //             $campaign->student_filters = $criteria_encoded;
                //         }else{
                //             $campaign->lead_filters = $campaign->student_filters = NULL;
                //         }
                //     }
                // }else{
                //     $campaign->lead_filters = $campaign->student_filters = NULL;
                // }
                if (!empty($other_criteria) && count($other_criteria) && !is_null($other_criteria)) {
                    $criteria_Array = array();
                    foreach($other_criteria as $otr_cri_val){
                        $rar = str_replace(" ","_",$otr_cri_val);
                        if($rar){
                            $criteria_Array[$otr_cri_val] = implode("|", $request->$rar);
                        }
                    }
                    if(!empty($criteria_Array)){
                        $criteria_encoded = json_encode($criteria_Array);
                        if($target == "leads"){
                            $campaign->lead_filters = $criteria_encoded;
                        }
                        else if($target == "students"){
                            $campaign->student_filters = $criteria_encoded;
                        }else{
                            $campaign->lead_filters = $campaign->student_filters = NULL;
                        }
                    }
                }
                else{
                    $campaign->lead_filters = $campaign->student_filters = NULL;
                }
            //message
            $campaign->message_subject = $request->subject;
            if($msg_type == '1'){
                $campaign->message_content = $request->message_html;
            }else{
                $campaign->message_content = $request->message;
            }
            if($request->criteria_condition){
                $campaign->filter_condition = $request->criteria_condition;
            }else{
                $campaign->filter_condition = NULL;
            }
            $campaign->created_by = auth()->user()->id;
            $campaign->save();
            return redirect()->route('admin.automation.campaigns')->withFlashSuccess('Campaign Messages Sent and Updated!');
        }   
    }

}


