<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;
use App\Repositories\Backend\Auth\RoleRepository;
use App\Repositories\Backend\Auth\PermissionRepository;
use App\Models\Auth\User;
use App\Models\Auth\Branch;
use Illuminate\Support\Facades\Input;
use App\Models\Auth\Trainers;
use App\Http\Requests\Backend\Auth\User\ManageUserRequest;
use App\Models\StaffBranch;
use App\Models\Auth\Country;
use App\Repositories\Backend\Auth\UserRepository;

class BranchController extends Controller
{

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('branch mgmt'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }
            return $next($request);
        });
    }

    public function index()
    {
        $values = Branch::all(); //->sortBy("display_order");
        return view('backend.branch.list_branch', ['values' => $values]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $page = Branch::all();
        $country_list = Country::pluck('title_en', 'id');
        return view('backend.branch.add_branch', ['pages' => $page, 'country_list' => $country_list]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'branch_name' => 'required|unique:branch',
            // Bug ID: 1234
            // 'phone' => ['nullable', 'numeric', 'digits_between:' . config('app.USER_MOBILE_MIN_LENGTH') . ',' . config('app.USER_MOBILE_MAX_LENGTH')],
        ]);
        $branch_name = $request->branch_name;
        $branch_address = $request->branch_address;
        $city = $request->city;
        $country = $request->country;
        $phone = $request->phone;
        $email = $request->email;

        if ($request->use_custom_smtp) {
            $custom_smtp = $request->use_custom_smtp;
        } else {
            $custom_smtp = 0;
        }

        //smtp
        $username = $request->username;
        $password = $request->password;
        $host = $request->host;
        $port = $request->port;
        $connection_type = $request->connection_type;
        $email_from_name = $request->email_from_name;
        $reply_to_email = $request->reply_to_email;

        if ($custom_smtp) {
            $request->validate([
                'username' => 'required',
                'password' => 'required',
                'host' => 'required',
                'port' => 'required',
                'connection_type' => 'required',
                'email_from_name' => 'required',
            ]);
        }
        //smtp
        $page = new Branch();
        $page->branch_name = $branch_name;
        $page->branch_address = $branch_address;
        $page->city = $city;
        $page->country = $country;
        $page->phone = $phone;
        $page->email = $email;

        //smtp
        $page->custom_smtp = $custom_smtp;
        $page->smtp_email = $username;
        $page->smtp_password = $password;
        $page->smtp_host = $host;
        $page->smtp_port = $port;
        $page->smtp_connection = $connection_type;
        $page->smtp_from_name = $email_from_name;
        $page->smtp_reply_to = $reply_to_email;
        //smtp

        $page->save();

        //Add superadmin to branch
        StaffBranch::create(['staff_id' => 1, 'branch_id' => $page->id]);

        return redirect()->route('admin.settings.branch')->withFlashSuccess('Branch Added Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $value = Branch::find($id);
        $branches = DB::table('branch')->where('id', '=', $value['branch_name'])->first();
        $country_list = Country::pluck('title_en', 'id');
        return view('backend.branch.edit_branch', ['value' => $value, 'branches' => $branches, 'country_list' => $country_list]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $request->validate([
            'branch_name' => 'required|unique:branch,branch_name,' . $id,
            // 'phone' => ['nullable', 'numeric', 'digits_between:' . config('app.USER_MOBILE_MIN_LENGTH') . ',' . config('app.USER_MOBILE_MAX_LENGTH')],
        ]);
        //smtp
        if ($request->use_custom_smtp) {
            $custom_smtp = $request->use_custom_smtp;
        } else {
            $custom_smtp = 0;
        }
        if ($custom_smtp) {
            $request->validate([
                'username' => 'required',
                'password' => 'required',
                'host' => 'required',
                'port' => 'required',
                'connection_type' => 'required',
                'email_from_name' => 'required',
            ]);
        }
        //smtp

        $branchs = Branch::find($id);
        $branchs->branch_name = $request->get('branch_name');
        $branchs->branch_address = $request->get('branch_address');
        $branchs->city = $request->get('city');
        $branchs->country = $request->get('country');
        $branchs->phone = $request->get('phone');
        $branchs->email = $request->get('email');
        //smtp
        $branchs->custom_smtp = $custom_smtp;
        $branchs->smtp_email = $request->get('username');
        $branchs->smtp_password = $request->get('password');
        $branchs->smtp_host = $request->get('host');
        $branchs->smtp_port = $request->get('port');
        $branchs->smtp_connection = $request->get('connection_type');
        $branchs->smtp_from_name = $request->get('email_from_name');
        $branchs->smtp_reply_to = $request->get('reply_to_email');
        //smtp
        $branchs->save();
        return redirect()->route('admin.settings.branch')->withFlashSuccess('Branch Update Successfully!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if (User::where('branch', $id)->count()) {
            return redirect()->back()->withFlashDanger('There are students in this branch. Cannot delete branch.');
        }
        StaffBranch::where('branch_id', $id)->delete();
        Branch::where('id', $id)->delete();
        return redirect()->route('admin.settings.branch')->withFlashSuccess('Branch Deleted Successfully');
    }
}
