<?php
/*
* This file is not used
*/
namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Repositories\Backend\Auth\UserRepository;
use App\Notifications\Backend\UserAlert;
use Illuminate\Support\Facades\Mail;
use App\Mail\MailSend;
use App\Models\UserActivity;
use App\Models\Auth\User;

/**
 * Class BroadcastController.
 */
class BroadcastController extends Controller
{

    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        return view('backend.broadcast.index');
    }

    public function mail_user($userid)
    {
        $userinfo = get_user_by_id($userid);
        return view('backend.broadcast.mail-user', ["userid" => $userid, "name" => $userinfo->first_name . " " . $userinfo->last_name, "email" => $userinfo->email]);
    }

    public function mail_user_now(Request $request)
    {
        $data = $request->all();
        if (!$data['subject']) {
            return redirect()->route('admin.broadcast.mail.user', $data['userid'])->withFlashDanger("Subject is required!");
        }
        if (!$data['message']) {
            return redirect()->route('admin.broadcast.mail.user', $data['userid'])->withFlashDanger("Message is required!");
        }

        $user = (new UserRepository())->where('id', $data['userid'])->first();
        $message = $data['message'];
        $messages = str_replace('#first_name#', $user->first_name, $message);
        $messages = str_replace('#full_name#', $user->first_name . " " . $user->last_name, $messages);
        $messages = str_replace('#sitename#', app_name(), $messages);
        $messages = str_replace('#siteurl#', config('app.url'), $messages);
        try{
            //$user->notify(new UserAlert($data['subject'], $messages));
            user_notify($user, $data['subject'], $message);
        }catch (\Exception $e) {
            $message = $e->getMessage();
            \Log::debug("Mail Error: (Broadcast mail) ".$message);   
        }
        //store event in user activity
        UserActivity::create(['user_id' => $user->id, 'type' => 'email_sent', 'title' => "Email Sent", 'detail' => "Subject:" . $data['subject'] . "<br>Message:" . $messages, 'staff' => \Auth::user()->id]);

        return redirect()->back()->withFlashSuccess("Mail sent successfully!");
    }

    public function mail_lead($userid)
    {
        $lead = User::find($userid);
        return view('backend.broadcast.mail-lead', ["userid" => $userid, "name" => $lead->first_name . " " . $lead->last_name, "email" => $lead->email]);
    }

    public function mail_lead_now(Request $request)
    {
        $data = $request->all();
        if (!$data['subject']) {
            return redirect()->route('admin.broadcast.mail.lead', $data['userid'])->withFlashDanger("Subject is required!");
        }
        if (!$data['message']) {
            return redirect()->route('admin.broadcast.mail.lead', $data['userid'])->withFlashDanger("Message is required!");
        }
        $lead = User::find($data['userid']);
        $message = $data['message'];
        $messages = str_replace('#first_name#', $lead->first_name, $message);
        $messages = str_replace('#full_name#', $lead->first_name . " " . $lead->last_name, $messages);
        $messages = str_replace('#sitename#', app_name(), $messages);
        $messages = str_replace('#siteurl#', config('app.url'), $messages);
        try{
            //Mail::to($lead->email)->send(new MailSend($data['subject'], $messages));
            user_notify($lead->email,$data['subject'], $messages);
        }catch (\Exception $e) {
            $message = $e->getMessage();
            \Log::debug("Mail Error: (Lead) ".$message);   
        }
        //store event in lead activity
        UserActivity::create(['user_id' => $lead->id, 'staff' => \Auth::user()->id, 'detail' => "Email Sent: Subject:" . $data['subject'] . "<br>Message:" . $messages]);

        return redirect()->back()->withFlashSuccess("Mail sent successfully!");
    }

    public function whatsapp_user($userid)
    {
        $userinfo = get_user_by_id($userid);
        return view('backend.broadcast.whatsapp-user', compact('userinfo'));
    }

    public function whatsapp_user_now(Request $request)
    {
        $data = $request->all();
        if (!$data['message']) {
            return redirect()->route('admin.broadcast.whatsapp.user', $data['userid'])->withFlashDanger("Message is required!");
        }
        if (!$data['msg_template']) {
            return redirect()->route('admin.broadcast.whatsapp.user', $data['userid'])->withFlashDanger("Template is required!");
        }
        $userinfo = User::find($data['userid']);
        $template = $data['msg_template'];
        $notify_whtsp = get_whatsapp_template($template);
        if ($notify_whtsp && $notify_whtsp->status) {
            //$notify_sms->message = str_replace("{#var#}", "%s", $notify_sms->message);
            $notify_whtsp->message = str_replace("#first_name#", $userinfo->first_name, $notify_whtsp->message);

            $notify_whtsp->message = str_replace("#sitename#", app_name(), $notify_whtsp->message);
            $notify_whtsp->message = str_replace("#siteurl#", url('/'), $notify_whtsp->message);
            $notify_whtsp->message = str_replace("#first_name#", $userinfo->first_name, $notify_whtsp->message);
            $notify_whtsp->message = str_replace("#full_name#", $userinfo->full_name, $notify_whtsp->message);
            
            $notify_whtsp->message = str_replace("#message#", $data['message'], $notify_whtsp->message);

            if($userinfo->whatsapp($notify_whtsp->message, $notify_whtsp->hook)) {
                //store event in user activity
                UserActivity::create(['user_id' => $userinfo->id, 'type' => 'whatsapp_sent', 'title' => "Whatsapp Sent", 'detail' => $notify_whtsp->message, 'staff' => \Auth::user()->id]);
                return redirect()->back()->withFlashSuccess("Whatsapp sent successfully!");
            } else {
                return redirect()->back()->withFlashDanger("Whatsapp Error!");
            }
        } else {
            return redirect()->back()->withFlashDanger("Whatsapp disabled!");
        }

        return redirect()->back()->withFlashSuccess("Whatsapp sent successfully!");
    }


    public function sms_user($userid)
    {
        $userinfo = get_user_by_id($userid);
        return view('backend.broadcast.sms-user', compact('userinfo'));
    }

    public function sms_user_now(Request $request)
    {
        $data = $request->all();
        if (!$data['message']) {
            return redirect()->route('admin.broadcast.sms.user', $data['userid'])->withFlashDanger("Message is required!");
        }
        $userinfo = User::find($data['userid']);

        $notify_sms = get_sms_template('NOTIFICATION');
        if ($notify_sms && $notify_sms->status) {
            //$notify_sms->message = str_replace("{#var#}", "%s", $notify_sms->message);
            //$notify_sms->message = sprintf($notify_sms->message, $user->first_name);
            $notify_sms->message = str_replace("#sitename#", app_name(), $notify_sms->message);
            $notify_sms->message = str_replace("#message#", $data['message'], $notify_sms->message);

            if($userinfo->sms($notify_sms->message, $notify_sms->template_id)) {
                //store event in user activity
                UserActivity::create(['user_id' => $userinfo->id, 'type' => 'sms_sent', 'title' => "SMS Sent", 'detail' => $notify_sms->message, 'staff' => \Auth::user()->id]);
                return redirect()->back()->withFlashSuccess("SMS sent successfully!");
            } else {
                return redirect()->back()->withFlashDanger("SMS Error!");
            }
        } else {
            return redirect()->back()->withFlashDanger("SMS disabled!");
        }

        return redirect()->back()->withFlashSuccess("SMS sent successfully!");
    }

    public function whatsapp_lead($userid)
    {
        $userinfo = User::find($userid);
        return view('backend.broadcast.whatsapp-lead', compact('userinfo'));
    }

    public function whatsapp_lead_now(Request $request)
    {
        $data = $request->all();
        if (!$data['message']) {
            return redirect()->route('admin.broadcast.whatsapp.lead', $data['userid'])->withFlashDanger("Message is required!");
        }
        if (!$data['msg_template']) {
            return redirect()->route('admin.broadcast.whatsapp.lead', $data['userid'])->withFlashDanger("Template is required!");
        }
        $userinfo = User::find($data['userid']);
        $template = $data['msg_template'];
        $notify_whtsp = get_whatsapp_template($template);
        if ($notify_whtsp && $notify_whtsp->status) {
            //$notify_sms->message = str_replace("{#var#}", "%s", $notify_sms->message);
            $notify_whtsp->message = str_replace("#first_name#", $userinfo->first_name, $notify_whtsp->message);

            $notify_whtsp->message = str_replace("#sitename#", app_name(), $notify_whtsp->message);
            $notify_whtsp->message = str_replace("#siteurl#", url('/'), $notify_whtsp->message);
            $notify_whtsp->message = str_replace("#first_name#", $userinfo->first_name, $notify_whtsp->message);
            $notify_whtsp->message = str_replace("#full_name#", $userinfo->full_name, $notify_whtsp->message);
            
            $notify_whtsp->message = str_replace("#message#", $data['message'], $notify_whtsp->message);

            if($userinfo->whatsapp($notify_whtsp->message, $notify_whtsp->hook)) {
                //store event in user activity
                UserActivity::create(['user_id' => $userinfo->id, 'staff' => \Auth::user()->id, 'detail' => "Whatsapp Sent: " . $notify_whtsp->message]);
                return redirect()->back()->withFlashSuccess("Whatsapp sent successfully!");
            } else {
                return redirect()->back()->withFlashDanger("Whatsapp Error!");
            }
        } else {
            return redirect()->back()->withFlashDanger("Whatsapp disabled!");
        }

        return redirect()->back()->withFlashSuccess("Whatsapp sent successfully!");
    }

    public function sms_lead($userid)
    {
        $lead = User::find($userid);
        return view('backend.broadcast.sms-lead', ["userid" => $userid, "name" => $lead->first_name . " " . $lead->last_name, "mobile" => $lead->mobile]);
    }

    public function sms_lead_now(Request $request)
    {
        $data = $request->all();
        if (!$data['message']) {
            return redirect()->route('admin.broadcast.sms.lead', $data['userid'])->withFlashDanger("Message is required!");
        }
        $lead = User::find($data['userid']);

        $notify_sms = get_sms_template('NOTIFICATION');
        if ($notify_sms && $notify_sms->status) {
            //$notify_sms->message = str_replace("{#var#}", "%s", $notify_sms->message);
            //$notify_sms->message = sprintf($notify_sms->message, $user->first_name);
            $notify_sms->message = str_replace("#sitename#", app_name(), $notify_sms->message);
            $notify_sms->message = str_replace("#message#", $data['message'], $notify_sms->message);

            if($lead->sms($notify_sms->message, $notify_sms->template_id)) {
                //store event in lead activity
                UserActivity::create(['user_id' => $lead->id, 'staff' => \Auth::user()->id, 'detail' => "SMS Sent: " . $notify_sms->message]);
                return redirect()->back()->withFlashSuccess("SMS sent successfully!");
            } else {
                return redirect()->back()->withFlashDanger("SMS Error!");    
            }
        } else {
            return redirect()->back()->withFlashDanger("SMS disabled!");
        }
    }
}
