<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Auth\Course;
use App\Models\Auth\CountryStudy;
use App\Models\Auth\BatchStudents;
use Illuminate\Foundation\Http\FormRequest;
use App\Repositories\Backend\Auth\RoleRepository;
use App\Repositories\Backend\Auth\PermissionRepository;
use App\Models\Auth\User;
use App\Models\Auth\Branch;
use App\Models\Auth\Batch;
use Illuminate\Support\Facades\Input;
use App\Models\Auth\Trainers;
use App\Http\Requests\Backend\Auth\User\BatchRequest;
use App\Http\Requests\Backend\Auth\User\ManageUserRequest;
use App\Repositories\Backend\Auth\UserRepository;
use App\Notifications\Backend\UserAlert;
use Illuminate\Support\Facades\Mail;
use App\Mail\MailSend;
use App\Models\UserActivity;
use App\Jobs\EmailJob;
use App\Mail\BroadcastMailSend;
use Yajra\DataTables\DataTables;
use Spatie\Activitylog\Models\Activity;

/* *****************************************************
*   Bulk Messaging
* *****************************************************/

class BroadcastMessageController extends Controller
{

  public function __construct()
  {
    $this->middleware(function ($request, $next) {
      $user = \Auth::user();
      // if (!(\Auth::user()->isAdmin() || \Auth::user()->can('broadcast'))) {
      if(!(\Auth::user()->isAdmin() || \Auth::user()->can('broadcast to leads and students') || \Auth::user()->can('broadcast to staff') || \Auth::user()->can('broadcast to agents'))){
        return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
      }
      return $next($request);
    });
  }

  private function queueEmail($email, $subject, $message)
  {

    if(env('SAAS_MAIL_SERVER') && Activity::where('event', 'email')->where('created_at', 'like', date("Y-m-").'%')->count() >= env('MONTHLY_EMAIL_LIMIT')) {
      \Log::error("ERROR!!!!! MONTHLY_EMAIL_LIMIT Reached!");
      return;
    }

    try {
      if (env('QUEUE_CONNECTION') == 'redis') {
        //Mail::to($email)->queue(new MailSend($subject, $message));
        \Log::debug("Queue Mail: (BROADCAST MESSAGE) [redis] " . $message);
        EmailJob::dispatch(new BroadcastMailSend($email, $subject, $message));
        activity()->event('email')->log('Email sent To: '.$email. ' Subject: '.$subject);
      } elseif (env('QUEUE_CONNECTION') == 'database') {
        \Log::debug("Queue Mail: (BROADCAST MESSAGE) [database] " . $message);
        // $delay = round(DB::table('jobs')->count() * (1 / env('EMAILS_PER_SEC', 0.13)));
        $delay = email_delay();
        if(get_site_config('bulk_smtp_host') && get_site_config('bulk_smtp_port') && get_site_config('bulk_smtp_email') && get_site_config('bulk_smtp_password') && get_site_config('bulk_smtp_connection') && get_site_config('bulk_smtp_type')== 'smtp_server'){
          \Log::debug("Queue Mail: (BROADCAST MESSAGE) sending through- BROADCAST_SMTP");
          Mail::mailer('broadcast_smtp')->to($email)->later(now()->addSeconds($delay), new MailSend($subject, $message));
        }
        elseif(get_site_config('bulk_smtp_type')== 'google'){
          \Log::debug("Queue Mail: (BROADCAST MESSAGE) sending through- User_notify");
          user_notify($email,$subject, $message);
        }
        else{
          \Log::debug("Queue Mail: (BROADCAST MESSAGE) sending through- SMTP");
          Mail::mailer('smtp')->to($email)->later(now()->addSeconds($delay), new MailSend($subject, $message));
        }
        activity()->event('email')->log('Email sent To: '.$email. ' Subject: '.$subject);

      } else{
        //Mail::mailer('smtp')->to($email)->send(new MailSend($subject, $message));
        user_notify($email,$subject, $message);
      }
    } catch (\Exception $e) {
      $message = $e->getMessage();
      \Log::debug("Queue Mail Error: (BROADCAST MESSAGE) " . $message);
    }
  }

  public function index()
  {
    //$branch = Branch::all();
    $leadcountry = CountryStudy::where('status', 1)->get();

    $show_email_queue = false;
    $email_queue_size = 0;
    if(env('QUEUE_CONNECTION') == 'database') {
      $show_email_queue = true;
      $email_queue_size = DB::table('jobs')->count();
    }
    return view('backend.broadcast_message.broadcast_message', compact('leadcountry', 'show_email_queue', 'email_queue_size'));
  }

  public function preview(Request $request)
  {
    \Log::debug("BROADCASTMESSAGECONTROLLER:preview:request:" . var_export($request->post(), true));
    $my_branch = get_staff_branch_ids(\Auth::user()->id);
    $target = $request->get('target');
    $msgtype = $request->get('msg_type');
    $whtsp_template = $request->whtsp_template;
    if ($msgtype == 1) {
      $messages = $request->get('message_html');
    } else {
      $messages = $request->get('message');
    }

    if ($target == 'Students') {

      DB::enableQueryLog();

      $subject = $request->get('subject');
      $overseas_status = $request->get('overseas_status');
      $sendto = "";
      $user = "";
      $agent_students = $request->get('agent_students');
   

      $batchdetail = User::active()
        ->whereHas('roles', function ($q) {
          $q->whereIn('name', ['user']);
        })
        ->when(!empty($my_branch), function ($query) use ($my_branch) {
          return $query->whereIn('branch', $my_branch);
        })
        ->when(($agent_students == '1'), function ($query){
          return $query->where('agent_id', 0);
        })
        ->whereIn('overseas_status', $overseas_status)
        ->when($msgtype == 4,  function ($query) {
          return $query->where('whatsapp', "!=", '');
        })
        ->where('is_lead', 0)
        ->select('email', 'id', 'dialcode', 'mobile', 'whatsapp', 'first_name')
        ->get();

      $queries = DB::getQueryLog();
      \Log::debug(end($queries));

      return view('backend.broadcast_message.broadcast_preview', ['batchdetail' => $batchdetail, 'sendto' => $sendto, 'target' => $target, 'msgtype' => $msgtype, 'messages' => $messages,'whtsp_template' => $whtsp_template, 'subject' => $subject, 'user' => $user, 'overseas_status' => $overseas_status]);

    } elseif ($target == 'Leads') {

      DB::enableQueryLog();

      $subject = $request->get('subject');
      $lead_status = $request->get('lead_status');
      $leadcountry = $request->get('countrys');
      $sendto = "";
      $user = "";
      /*if ($type == 'study_abroad') {*/
      $leadcountry = $request->get('countrys');

      $batchdetail = User::active()
        // ->whereHas('roles', function ($q) {
        //   $q->whereIn('name', ['user']);
        // })
        ->when(!empty($my_branch), function ($query) use ($my_branch) {
          return $query->whereIn('branch', $my_branch);
        })
        ->when(!empty($lead_status) && count($lead_status), function ($query) use ($lead_status) {
          return  $query->whereIn('lead_status', $lead_status);
        })
        ->when($msgtype == 4,  function ($query) {
          return $query->where('whatsapp', "!=", '');
        })
        ->when(!empty($leadcountry), function ($query) use ($leadcountry) {
          return $query->where('country_interested', 'like', "%$leadcountry%");
        })
        ->where('is_lead', 1)
        ->select('email', 'id', 'dialcode', 'mobile', 'whatsapp', 'first_name')
        ->get();

      $queries = DB::getQueryLog();
      \Log::debug(end($queries));

      return view('backend.broadcast_message.broadcast_preview', ['batchdetail' => $batchdetail, 'messages' => $messages, 'sendto' => $sendto, 'target' => $target, 'msgtype' => $msgtype,'whtsp_template' => $whtsp_template, 'subject' => $subject, 'user' => $user]);

    } elseif ($target == 'Staff') {

      $subject = $request->get('subject');
      $userRepo = new UserRepository();
      if ($msgtype == 4) {
        $batchdetail = $userRepo->getStaffWhatsapp();
      } else {
        $batchdetail = $userRepo->getStaff();
      }
      $sendto = "";
      $user = "";

      return view('backend.broadcast_message.broadcast_preview', ['batchdetail' => $batchdetail, 'target' => $target, 'messages' => $messages, 'sendto' => $sendto, 'msgtype' => $msgtype,'whtsp_template' => $whtsp_template, 'subject' => $subject, 'user' => $user]);
    } elseif ($target == 'Agents') {

      $subject = $request->get('subject');
      $userRepo = new UserRepository();
      if ($msgtype == 4) {
        $batchdetail = $userRepo->getStaffWhatsapp();
      } else {
        $batchdetail = $userRepo->getAgents();
      }
      $sendto = "";
      $user = "";

      return view('backend.broadcast_message.broadcast_preview', ['batchdetail' => $batchdetail, 'target' => $target, 'messages' => $messages, 'sendto' => $sendto, 'msgtype' => $msgtype,'whtsp_template' => $whtsp_template, 'subject' => $subject, 'user' => $user]);
    }
  }

  public function send(Request $request)
  {
    \Log::debug("BROADCASTMESSAGECONTROLLER:send:request:" . var_export($request->post(), true));
    $message = $request->get('msg');
    $subject = $request->get('subject');
    $target = $request->get('target');
    $data = $request->all();
    $data['sendto'] = trim($data['sendto'], ",");

    //1min interval required
    \Log::debug("BROADCASTMESSAGECONTROLLER:send:check 1min interval");
    $last_broadcast = DB::table('broadcast_stats')->orderBy("id", "DESC")->first();
    if ($last_broadcast) {
      $last_broadcast_time = strtotime($last_broadcast->date);
      $time_elapsed = time() - $last_broadcast_time;
      \Log::debug("BROADCASTMESSAGECONTROLLER:send:time elapsed $time_elapsed sec");
      if ($time_elapsed < 120) {
        \Log::debug("BROADCASTMESSAGECONTROLLER:send: Interval not ok. Stop send.");
        return redirect()->route('admin.broadcast.index')->withFlashDanger('2 minute interval required between broadcasts');
      }
    }

    if ($target == 'Leads') {
      if ($data['msgtype'] == '1') {
        $send_to_ids = explode(',', trim($data['sendto'], ","));
        $count = count($send_to_ids);
        $send_to = array();
        foreach ($send_to_ids as $send_to_id) {
          
          $lead = DB::table('users')->select('id', 'email', 'first_name', 'last_name')->where('id', $send_to_id)->first();
          $messages = str_replace('#first_name#', $lead->first_name, $message);
          $messages = str_replace('#full_name#', $lead->first_name . " " . $lead->last_name, $messages);
          $messages = str_replace('#sitename#', app_name(), $messages);
          $messages = str_replace('#siteurl#', config('app.url'), $messages);
          //$messages = nl2br($messages);
          if ($lead->email) {
            $send_to[] = $lead->email;
            \Log::debug("BROADCASTMESSAGECONTROLLER:send email to:" . $lead->email);
            $this->queueEmail($lead->email, $subject, $messages);
            //store event in lead activity
            UserActivity::create(['user_id' => $lead->id, 'staff' => \Auth::user()->id, 'detail' => "Email Sent: Subject:" . $subject . "<br>Message:" . $messages]);
          }
        }
        $send_to_mails = implode(', ', $send_to);
        $this->update_broadcast_history($data['msgtype'], $subject, $message, $send_to_mails, $count);
        return redirect()->route('admin.broadcast.index')->withFlashSuccess('
        Email queued for ' . $count . ' User(s) successfully!');
      } else if ($data['msgtype'] == '2') {
        $send_to_ids = explode(',', trim($data['sendto'], ","));
        $count = count($send_to_ids);
        $send_to = array();
        foreach ($send_to_ids as $send_to_id) {
          $lead = DB::table('users')->select('id', 'dialcode', 'mobile', 'first_name', 'last_name')->where('id', $send_to_id)->first();
          $messages = str_replace('#first_name#', $lead->first_name, $message);
          $messages = str_replace('#full_name#', $lead->first_name . " " . $lead->last_name, $messages);
          $messages = str_replace('#sitename#', app_name(), $messages);
          $messages = str_replace('#siteurl#', config('app.url'), $messages);

          \Log::debug("BROADCASTMESSAGECONTROLLER:send sms to:" . $lead->mobile);
          $notify_sms = get_sms_template('NOTIFICATION');
          if ($notify_sms) {
            $send_to[] = $lead->mobile;
            $notify_sms->message = str_replace("#sitename#", app_name(), $notify_sms->message);
            $notify_sms->message = str_replace("#message#", $messages, $notify_sms->message);

            if (User::find($send_to_id)->sms($notify_sms->message, $notify_sms->template_id)) {
              //store event in lead activity
              UserActivity::create(['user_id' => $lead->id, 'staff' => \Auth::user()->id, 'detail' => "SMS Sent: " . $notify_sms->message]);
            } else {
              return redirect()->route('admin.broadcast.index')->withFlashDanger('SMS Error!');
            }
          } else {
            return redirect()->route('admin.broadcast.index')->withFlashDanger('SMS Disabled!');
          }
        }
        $send_to_mobiles = implode(', ', $send_to);
        $this->update_broadcast_history($data['msgtype'], "", $message, $send_to_mobiles, $count);
        //$this->update_broadcast_history($data['msgtype'], $message, $count);
        return redirect()->route('admin.broadcast.index')->withFlashSuccess('
        SMS sent to ' . $count . ' User(s) successfully!');
      } else if ($data['msgtype'] == '4') {
        $send_to_ids = explode(',', trim($data['sendto'], ","));
        $count = count($send_to_ids);
        $send_to_wp = array();
        foreach ($send_to_ids as $send_to_id) {
          $lead = DB::table('users')->select('id', 'dialcode', 'whatsapp', 'first_name', 'last_name')->where('id', $send_to_id)->first();
          // $messages = str_replace('#first_name#', $lead->first_name, $message);
          // $messages = str_replace('#full_name#', $lead->first_name . " " . $lead->last_name, $messages);
          // $messages = str_replace('#sitename#', app_name(), $messages);
          // $messages = str_replace('#siteurl#', config('app.url'), $messages);

          // $messages = str_replace('{{first_name}}', $lead->first_name, $message);
          // $messages = str_replace('{{full_name}}', $lead->first_name . " " . $lead->last_name, $messages);
          // $messages = str_replace('{{sitename}}', app_name(), $messages);
          // $messages = str_replace('{{siteurl}}', config('app.url'), $messages);

          \Log::debug("BROADCASTMESSAGECONTROLLER:send whatsapp to:" . $lead->whatsapp);
       
          $notify_whtsp = get_whatsapp_template($data['whtsp_template']);
          if ($notify_whtsp && $notify_whtsp->status) {
            $send_to_wp[] = $lead->whatsapp;
            // $notify_whtsp->message = str_replace("#sitename#", app_name(), $notify_whtsp->message);
            // $notify_whtsp->message = str_replace("#message#", $messages, $notify_whtsp->message);

            // $notify_whtsp->message = str_replace("{{sitename}}", app_name(), $notify_whtsp->message);
            // $notify_whtsp->message = str_replace("{{message}}", $messages, $notify_whtsp->message);

            preg_match_all('/#(\S+)#/',$notify_whtsp->message,$matches);
            $msg = array();
            foreach($matches[1] as $key => $vars){
                if($vars == "first_name"){
                    $vals = array("name" => $key+1, "value" => $lead->first_name);
                    array_push($msg, $vals);
                }
                if($vars == "full_name"){
                    $vals = array("name" => $key+1, "value" => $lead->first_name . ' ' . $lead->last_name);
                    array_push($msg, $vals);
                }
                if($vars == "sitename"){
                    $vals = array("name" => $key+1, "value" => app_name());
                    array_push($msg, $vals);
                }
                if($vars == "siteurl"){
                    $vals = array("name" => $key+1, "value" => url('/'));
                    array_push($msg, $vals);
                }
            }
            $whtsp_msg = json_encode($msg);
            if (User::find($send_to_id)->whatsapp($whtsp_msg, $notify_whtsp->hook)) {
              //store event in lead activity
              UserActivity::create(['user_id' => $lead->id, 'staff' => \Auth::user()->id, 'detail' => "Whatsapp Sent: " . $notify_whtsp->message]);
            } else {
              return redirect()->route('admin.broadcast.index')->withFlashDanger('Whatsapp Error!');
            }
          } else {
            return redirect()->route('admin.broadcast.index')->withFlashDanger('Whatsapp Disabled!');
          }
        }
        $send_to_wps = implode(', ', $send_to_wp);
        $this->update_broadcast_history(4, "", $message, $send_to_wps, $count);
        // $this->update_broadcast_history(4, $message, $count);
        return redirect()->route('admin.broadcast.index')->withFlashSuccess('
        Whatsapp sent to ' . $count . ' User(s) successfully!');
      } else {
        //Both Email & SMS
        $send_to_ids = explode(',', trim($data['sendto'], ","));
        $count = count($send_to_ids);
        $send_to = $send_to_ph = array();
        foreach ($send_to_ids as $send_to_id) {
          $lead = DB::table('users')->select('id', 'email', 'first_name', 'last_name')->where('id', $send_to_id)->first();
          $messages = str_replace('#first_name#', $lead->first_name, $message);
          $messages = str_replace('#full_name#', $lead->first_name . " " . $lead->last_name, $messages);
          $messages = str_replace('#sitename#', app_name(), $messages);
          $messages = str_replace('#siteurl#', config('app.url'), $messages);
          //$messages = nl2br($messages);
          if ($lead->email) {
            $send_to[] = $lead->email;
            \Log::debug("BROADCASTMESSAGECONTROLLER:send email to:" . $lead->email);
            $this->queueEmail($lead->email, $subject, $messages);
            //store event in lead activity
            UserActivity::create(['user_id' => $lead->id, 'staff' => \Auth::user()->id, 'detail' => "Email Sent: Subject:" . $subject . "<br>Message:" . $messages]);
          }
        }
        $send_to_mails = implode(', ', $send_to);
        $this->update_broadcast_history(1, $subject, $message, $send_to_mails, $count);
        //$this->update_broadcast_history(1, $subject, $count);
        foreach ($send_to_ids as $send_to_id) {
          $lead = DB::table('users')->select('id', 'dialcode', 'mobile', 'first_name', 'last_name')->where('id', $send_to_id)->first();
          $messages = str_replace('#first_name#', $lead->first_name, $message);
          $messages = str_replace('#full_name#', $lead->first_name . " " . $lead->last_name, $messages);
          $messages = str_replace('#sitename#', app_name(), $messages);
          $messages = str_replace('#siteurl#', config('app.url'), $messages);

          \Log::debug("BROADCASTMESSAGECONTROLLER:send sms to:" . $lead->mobile);

          $notify_sms = get_sms_template('NOTIFICATION');
          if ($notify_sms) {
            $send_to_ph[] = $lead->mobile;
            $notify_sms->message = str_replace("#sitename#", app_name(), $notify_sms->message);
            $notify_sms->message = str_replace("#message#", $messages, $notify_sms->message);

            if (User::find($send_to_id)->sms($notify_sms->message, $notify_sms->template_id)) {
              //store event in lead activity
              UserActivity::create(['user_id' => $lead->id, 'staff' => \Auth::user()->id, 'detail' => "SMS Sent: " . $notify_sms->message]);
            } else {
              return redirect()->route('admin.broadcast.index')->withFlashDanger('SMS Error!');
            }
          } else {
            return redirect()->route('admin.broadcast.index')->withFlashDanger('SMS Disabled!');
          }
        }
        $send_to_mobiles = implode(', ', $send_to_ph);
        $this->update_broadcast_history(2, "", $message, $send_to_mobiles, $count);
        //$this->update_broadcast_history(2, $message, $count);
        return redirect()->route('admin.broadcast.index')->withFlashSuccess('
        Email & SMS sent to ' . $count . ' User(s) successfully!');
      }
    } elseif ($target <> 'Leads') {
      if ($data['msgtype'] == '1') {
        $send_to_ids = explode(',', trim($data['sendto'], ","));
        $count = count($send_to_ids);
        $send_to = array();
        foreach ($send_to_ids as $send_to_id) {
          \Log::debug("BROADCASTMESSAGECONTROLLER:send: $send_to_id");
          $user = DB::table('users')->select('id', 'email', 'first_name', 'last_name')->where('id', $send_to_id)->first();
          $messages = str_replace('#first_name#', $user->first_name, $message);
          $messages = str_replace('#full_name#', $user->first_name . " " . $user->last_name, $messages);
          $messages = str_replace('#sitename#', app_name(), $messages);
          $messages = str_replace('#siteurl#', config('app.url'), $messages);
          //$messages = nl2br($messages);
          if ($user->email) {
            $send_to[] = $user->email;
            \Log::debug("BROADCASTMESSAGECONTROLLER:send email to:" . $user->email);
            $this->queueEmail($user->email, $subject, $messages);
            //store event in user activity
            UserActivity::create(['user_id' => $user->id, 'type' => 'email_sent', 'title' => "Email Sent", 'detail' => "Subject:" . $subject . "<br>Message:" . $messages, 'staff' => \Auth::user()->id]);
          }
        }
        $send_to_mails = implode(', ', $send_to);
        $this->update_broadcast_history(1, $subject, $message, $send_to_mails, $count);
        //$this->update_broadcast_history(1, $subject, $count);
        return redirect()->route('admin.broadcast.index')->withFlashSuccess('
        Email queued for ' . $count . ' User(s) successfully!');
      } else if ($data['msgtype'] == '2') {
        $send_to_ids = explode(',', trim($data['sendto'], ","));
        $count = count($send_to_ids);
        $send_to = array();
        foreach ($send_to_ids as $send_to_id) {
          $user = DB::table('users')->select('id', 'dialcode', 'mobile', 'first_name', 'last_name')->where('id', $send_to_id)->first();
          $messages = str_replace('#first_name#', $user->first_name, $message);
          $messages = str_replace('#full_name#', $user->first_name . " " . $user->last_name, $messages);
          $messages = str_replace('#sitename#', app_name(), $messages);
          $messages = str_replace('#siteurl#', config('app.url'), $messages);

          \Log::debug("BROADCASTMESSAGECONTROLLER:send sms to:" . $user->mobile);

          $notify_sms = get_sms_template('NOTIFICATION');
          if ($notify_sms) {
            $send_to[] = $user->mobile;
            $notify_sms->message = str_replace("#sitename#", app_name(), $notify_sms->message);
            $notify_sms->message = str_replace("#message#", $messages, $notify_sms->message);

            if (User::find($send_to_id)->sms($notify_sms->message, $notify_sms->template_id)) {
              //store event in user activity
              UserActivity::create(['user_id' => $user->id, 'type' => 'sms_sent', 'title' => "SMS Sent", 'detail' => $notify_sms->message, 'staff' => \Auth::user()->id]);
            } else {
              return redirect()->route('admin.broadcast.index')->withFlashDanger('SMS Error!');
            }
          } else {
            return redirect()->route('admin.broadcast.index')->withFlashDanger('SMS Disabled!');
          }
        }
        $send_to_mobiles = implode(', ', $send_to);
        $this->update_broadcast_history(2, "", $message, $send_to_mobiles, $count);
        //$this->update_broadcast_history(2, $message, $count);
        return redirect()->route('admin.broadcast.index')->withFlashSuccess('SMS sent to ' . $count . ' User(s) successfully!');
      } else if ($data['msgtype'] == '4') {
        $send_to_ids = explode(',', trim($data['sendto'], ","));
        $count = count($send_to_ids);
        $send_to_wp = array();
        foreach ($send_to_ids as $send_to_id) {
          $user = DB::table('users')->select('id', 'dialcode', 'whatsapp', 'first_name', 'last_name')->where('id', $send_to_id)->first();
          
          // $messages = str_replace('#first_name#', $user->first_name, $message);
          // $messages = str_replace('#full_name#', $user->first_name . " " . $user->last_name, $messages);
          // $messages = str_replace('#sitename#', app_name(), $messages);
          // $messages = str_replace('#siteurl#', config('app.url'), $messages);

          // $messages = str_replace('{{first_name}}', $user->first_name, $message);
          // $messages = str_replace('{{full_name}}', $user->first_name . " " . $user->last_name, $messages);
          // $messages = str_replace('{{sitename}}', app_name(), $messages);
          // $messages = str_replace('{{siteurl}}', config('app.url'), $messages);

          \Log::debug("BROADCASTMESSAGECONTROLLER:send whatsapp to:" . $user->whatsapp);
          $notify_whtsp = get_whatsapp_template($data['whtsp_template']);
          if ($notify_whtsp && $notify_whtsp->status) {
            $send_to_wp[] = $user->whatsapp;
            // $notify_whtsp->message = str_replace("#sitename#", app_name(), $notify_whtsp->message);
            // $notify_whtsp->message = str_replace("#message#", $messages, $notify_whtsp->message);
            preg_match_all('/#(\S+)#/',$notify_whtsp->message,$matches);
            $msg = array();
            foreach($matches[1] as $key => $vars){
                if($vars == "first_name"){
                    $vals = array("name" => $key+1, "value" => $user->first_name);
                    array_push($msg, $vals);
                }
                if($vars == "full_name"){
                    $vals = array("name" => $key+1, "value" => $user->first_name . ' ' . $user->last_name);
                    array_push($msg, $vals);
                }
                if($vars == "sitename"){
                    $vals = array("name" => $key+1, "value" => app_name());
                    array_push($msg, $vals);
                }
                if($vars == "siteurl"){
                    $vals = array("name" => $key+1, "value" => url('/'));
                    array_push($msg, $vals);
                }
            }
            $whtsp_msg = json_encode($msg);
            if (User::find($send_to_id)->whatsapp($whtsp_msg, $notify_whtsp->hook)) {
              //store event in user activity
              UserActivity::create(['user_id' => $user->id, 'type' => 'whatsapp_sent', 'title' => "Whatsapp Sent", 'detail' => $notify_whtsp->message, 'staff' => \Auth::user()->id]);
            } else {
              return redirect()->route('admin.broadcast.index')->withFlashDanger('Whatsapp Error!');
            }
          } else {
            return redirect()->route('admin.broadcast.index')->withFlashDanger('Whatsapp Disabled!');
          }
        }
        $send_to_wps = implode(', ', $send_to_wp);
        $this->update_broadcast_history(4, "", $message, $send_to_wps, $count);
        // $this->update_broadcast_history(4, $message, $count);
        return redirect()->route('admin.broadcast.index')->withFlashSuccess('Whatsapp sent to ' . $count . ' User(s) successfully!');
      } else {
        //Email & sms
        $send_to_ids = explode(',', trim($data['sendto'], ","));
        $count = count($send_to_ids);
        $send_to = $send_to_ph = array();
        foreach ($send_to_ids as $send_to_id) {
          \Log::debug("BROADCASTMESSAGECONTROLLER:send: $send_to_id");
          $user = DB::table('users')->select('id', 'email', 'first_name', 'last_name')->where('id', $send_to_id)->first();
          $messages = str_replace('#first_name#', $user->first_name, $message);
          $messages = str_replace('#full_name#', $user->first_name . " " . $user->last_name, $messages);
          $messages = str_replace('#sitename#', app_name(), $messages);
          $messages = str_replace('#siteurl#', config('app.url'), $messages);
          //$messages = nl2br($messages);
          if ($user->email) {
            $send_to[] = $user->email;
            \Log::debug("BROADCASTMESSAGECONTROLLER:send email to:" . $user->email);
            $this->queueEmail($user->email, $subject, $messages);
            //store event in user activity
            UserActivity::create(['user_id' => $user->id, 'type' => 'email_sent', 'title' => "Email Sent", 'detail' => "Subject:" . $subject . "<br>Message:" . $messages, 'staff' => \Auth::user()->id]);
          }
        }
        $send_to_mails = implode(', ', $send_to);
        $this->update_broadcast_history(1, $subject, $message, $send_to_mails, $count);
        //$this->update_broadcast_history(1, $subject, $count);
        foreach ($send_to_ids as $send_to_id) {
          $user = DB::table('users')->select('id', 'dialcode', 'mobile', 'first_name', 'last_name')->where('id', $send_to_id)->first();
          $messages = str_replace('#first_name#', $user->first_name, $message);
          $messages = str_replace('#full_name#', $user->first_name . " " . $user->last_name, $messages);
          $messages = str_replace('#sitename#', app_name(), $messages);
          $messages = str_replace('#siteurl#', config('app.url'), $messages);

          \Log::debug("BROADCASTMESSAGECONTROLLER:send sms to:" . $user->mobile);

          $notify_sms = get_sms_template('NOTIFICATION');
          if ($notify_sms) {
            $send_to_ph[] = $user->mobile;
            $notify_sms->message = str_replace("#sitename#", app_name(), $notify_sms->message);
            $notify_sms->message = str_replace("#message#", $messages, $notify_sms->message);

            if (User::find($send_to_id)->sms($notify_sms->message, $notify_sms->template_id)) {
              //store event in user activity
              UserActivity::create(['user_id' => $user->id, 'type' => 'sms_sent', 'title' => "SMS Sent", 'detail' => $notify_sms->message, 'staff' => \Auth::user()->id]);
            } else {
              return redirect()->route('admin.broadcast.index')->withFlashDanger('SMS Error!');
            }
          } else {
            return redirect()->route('admin.broadcast.index')->withFlashDanger('SMS Disabled!');
          }
        }
        $send_to_mobiles = implode(', ', $send_to_ph);

        $this->update_broadcast_history(2, "", $message, $send_to_mobiles, $count);
        //$this->update_broadcast_history(2, $message, $count);
        return redirect()->route('admin.broadcast.index')->withFlashSuccess('Email & SMS sent to ' . $count . ' User(s) successfully!');
      }
    }

  }

  // private function update_broadcast_history($message_type, $message, $sent_count)
  // {
  //   if ($message_type == 1) {
  //     $msg_type = "email";
  //   }
  //   elseif ($message_type == 4) {
  //     $msg_type = "whatsapp";
  //   } else {
  //     $msg_type = "sms";
  //   }
  //   DB::table('broadcast_stats')->insert(["date" => date("Y-m-d H:i:s"), "msg_type" => $msg_type, "message" => $message, "sent_count" => $sent_count]);
  // }

  private function update_broadcast_history($message_type, $subject=null, $message, $sent_to, $sent_count)
  {
    if ($message_type == 1) {
      $msg_type = "email";
    }
    elseif ($message_type == 4) {
      $msg_type = "whatsapp";
    } else {
      $msg_type = "sms";
    }
    $staff_id = \Auth::user()->id;
    DB::table('broadcast_stats')->insert(["date" => date("Y-m-d H:i:s"), "msg_type" => $msg_type, "subject" => $subject, "message" => $message, "sent_to" => $sent_to, "sent_count" => $sent_count, 'staff_id' => $staff_id]);
  }

  public function broadcast_history()
  {
    return view('backend.broadcast_message.broadcast_history');
  }

  public function broadcast_history_list()
  {
    $data = DB::table('broadcast_stats')->latest('date')->get();
    return Datatables::of($data)
    ->addIndexColumn()
    ->editColumn('date', function ($data) {
      return date('d M, g:ia', strtotime($data->date));
    })
    ->editColumn('msg_type', function ($data) {
      return $data->msg_type;
    })
    ->editColumn('subject', function ($data) {
      return $data->subject;
    })
    ->editColumn('message', function ($data) {
      return $data->message;
    })
    ->editColumn('staff', function ($data) {
      return get_user_full_name_by_id($data->staff_id);
    })
    ->editColumn('sent_to', function ($data) {
      return $data->sent_to;
    })
    // ->editColumn('sent_count', function ($data) {
    //   return $data->sent_count;
    // })
    ->rawColumns(['message'])
    ->make(true);
  }
}
