<?php

namespace App\Http\Controllers\Backend;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Auth\User;
use App\Models\Auth\BusinessConfigs;
use App\Models\Auth\Invoice;
use Illuminate\Http\Request;
use Log;

class BusinessConfigsController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $bizConfigs = DB::table('business_configs')->orderBy('name','desc')->get();
        return view('backend.settings.business_configs', compact('bizConfigs'));
    }

   
    public function store(Request $request)
    {
        $this->validate(
            $request,
            [
                'name' => 'required',
                'phone' => 'required',
                'email' => 'required',
            ]
        );

        if ($request->hasFile('business_logo')) {
            $file = $request->business_logo->getClientOriginalName();
            $filename = pathinfo($file, PATHINFO_FILENAME);
            if (strlen($filename) > 125)
                $filename = substr($filename, 0, 125);
            $filename = str_replace(' ','_',$filename) . '_biz_' . rand(10000, 99999) . "." . $request->business_logo->getClientOriginalExtension();
            $business_logo = $request->file('business_logo')->storeAs('/logo', $filename, 'public');
        }else{
            $business_logo = NULL;
        }

        $businessConfig = new BusinessConfigs;
        $businessConfig->name = $request->name;
        $businessConfig->email = $request->email;
        $businessConfig->phone = $request->phone;
        $businessConfig->address = $request->address;
        $businessConfig->tax_id = $request->tax_id;
        $businessConfig->bank_details = $request->bank_details;
        $businessConfig->footer_text = $request->footer_text;
        $businessConfig->terms_text = $request->terms_conditions;
        $businessConfig->logo = $business_logo;
        $businessConfig->save();

        return redirect()->route("admin.settings.business-configs")->withFlashSuccess("Business Configuration Added Successfully!");
    }


    
    public function update(Request $request, $id)
    {
        $businessConfig = BusinessConfigs::findOrFail($id);
        $this->validate(
            $request,
            [
                'name' => 'required',
                'phone' => 'required',
                'email' => 'required',
            ]
        );

        if ($request->hasFile('business_logo')) {
            $file = $request->business_logo->getClientOriginalName();
            $filename = pathinfo($file, PATHINFO_FILENAME);
            if (strlen($filename) > 125)
                $filename = substr($filename, 0, 125);
            $filename = str_replace(' ','_',$filename) . '_biz_' . rand(10000, 99999) . "." . $request->business_logo->getClientOriginalExtension();
            $business_logo = $request->file('business_logo')->storeAs('/logo', $filename, 'public');
        }else{
            $business_logo = $businessConfig->logo;
        }
        $businessConfig->name = $request->name;
        $businessConfig->email = $request->email;
        $businessConfig->phone = $request->phone;
        $businessConfig->address = $request->address;
        $businessConfig->tax_id = $request->tax_id;
        $businessConfig->bank_details = $request->bank_details;
        $businessConfig->footer_text = $request->footer_text;
        $businessConfig->terms_text = $request->terms_conditions;
        $businessConfig->logo = $business_logo;
        $businessConfig->save();

        return redirect()->route("admin.settings.business-configs")->withFlashSuccess("Business Configuration Updated!");
    }


    public function destroy($id)
    {
        $conf = BusinessConfigs::findOrFail($id);
        if($conf){
            //check if invoice is present with this config
            $invoice = Invoice::where('business_id',$conf->id)->count();
            if($invoice > 0){
                return redirect()->route("admin.settings.business-configs")->withFlashDanger("Cannot delete this Business Configuration! <b>".$invoice." invoice(s)</b> present with this business config.");
            }else{
                $conf->delete();
                return redirect()->route("admin.settings.business-configs")->withFlashSuccess("Business Configuration Deleted!");
            }
        }
    }
}
