<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\CannedResponses;
use Illuminate\Http\Request;
use App\Models\Auth\UserDetails;


class CannedResponsesController extends Controller
{

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('canned responses'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }
            return $next($request);
        });
    }

    public function index()
    {
        $templates = CannedResponses::orderBy('created_at', 'DESC')->get();
        return view('backend.canned_responses.index', compact('templates'));
    }


    public function create()
    {
        $variables = "sitename,siteurl,first_name,full_name";
        return view('backend.canned_responses.create', compact('variables'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  Page $template
     * @return view
     */
    public function edit($id)
    {
        $template = CannedResponses::where('hook', '=', $id)->first();
        return view('backend.canned_responses.edit', compact('template'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'hook' => 'required|max:50|unique:canned_responses',
            'message' => 'required',
        ]);

        CannedResponses::create([
            'hook' => $request->get('hook'),
            'message' => $request->get('message'), 
            'status' => 1, 
            'variables' => 'sitename,siteurl,first_name,full_name'
        ]);
        return redirect()->route('admin.cannedresponsetemplates')->withFlashSuccess('Canned Response Template Created Successfully!');
    }


    public function update(Request $request, $id)
    {
        $request->validate([
            'message' => 'required',
        ]);

        $canned_tpl = CannedResponses::findOrFail($id);
        $canned_tpl->message = $request->get('message');
        $canned_tpl->save();
        return redirect()->route('admin.cannedresponsetemplates')->withFlashSuccess('Canned Response Template Updated!');
    }

    public function destroy($id)
    {
        $canned_tpl = CannedResponses::findOrFail($id);
        if ($canned_tpl->system_tpl) {
            return redirect()->back()->withFlashDanger('This template cannot be deleted');
        }
        $canned_tpl->delete();
        return redirect()->back()->withFlashSuccess('Template deleted successfully');
    }

    public function changeStatus($hook, $status) {
        $canned_tpl = CannedResponses::findOrFail($hook);
        $canned_tpl->status = $status;
        $canned_tpl->save();
        return redirect()->route('admin.cannedresponsetemplates')->withFlashSuccess('Canned Response Template Updated!');
    }
}
