<?php

namespace App\Http\Controllers\Backend;


use App\Http\Controllers\Controller;
use App\Models\Auth\Products;
use App\Models\Auth\ProductCategories;
use App\Models\Auth\Categories;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Log;
use File;


class CategoriesController extends Controller
{
  public function index()
  {
    $categories = Categories::where('parent', '=', 0)->get();
    $subcategories = Categories::where('parent', '!=', 0)->get();
    return view(
      "backend.categories.index",
      compact('categories', 'subcategories')
    );
  }


  public function create_category()
  {
    $categories = Categories::where('parent', '=', 0)->get();
    return view(
      "backend.categories.create",
      compact('categories')
    );
  }

  public function save_category(Request $request)
  {
    $this->validate(
      $request,
      [
        'title' => 'required|max:100',
        'status' => 'required',
        'file' => 'image|mimes:jpeg,jpg,gif,png,svg|max:8192',
        'display_order' => 'required|numeric',
      ]
    );

    if ($request->hasFile('file')) {
      $filenameWithExt = $request->file('file')->getClientOriginalName();
      // Get Filename
      $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
      // Get just Extension
      $extension = $request->file('file')->getClientOriginalExtension();
      // Filename To store
      $fileNameToStore = $filename . '_' . time() . '.' . $extension;
      $request->file->move('storage/categories', $fileNameToStore);
    }
    $newslug = explode(' ', $request->title);
    if (count($newslug) > 0) {
      $slug_val = Str::slug($request->title, '-');
      $Gslug = $this->setSlugAttribute($slug_val);
    } else {
      $Cslug = $request->title;
      $Gslug = $this->setSlugAttribute($Cslug);
    }

    $cat = new Categories;
    $cat->title = $request->title;
    $cat->meta_title = $request->title;
    $cat->meta_desc = $request->details;
    $cat->details = $request->details;
    $cat->parent = $request->parentcat;
    $cat->order = $request->display_order;
    $cat->status = $request->status;
    if ($request->hasFile('file')) {
      $cat->photo = $fileNameToStore;
    }
    $cat->slug = $Gslug;
    $cat->save();
    return redirect()->route('admin.category')->withFlashSuccess("New Category Added Successfully!");
  }


  public function setSlugAttribute($value)
  {

    if (Categories::where('slug', '=', $value)->exists()) {
      // echo "exits";exit;
      $slug = $this->incrementSlug($value);
    } else {
      $delimiter = '-';
      $slug = strtolower(trim(preg_replace('/[\s-]+/', $delimiter, preg_replace('/[^A-Za-z0-9-]+/', $delimiter, preg_replace('/[&]/', 'and', preg_replace('/[\']/', '', iconv('UTF-8', 'ASCII//TRANSLIT', $value))))), $delimiter));
      // $slug = $value;
    }
    return $this->attributes['slug'] = $slug;
  }

  public function incrementSlug($slug)
  {

    $original = $slug;

    $count = 2;

    while (Categories::where('slug', '=', $slug)->exists()) {

      $slug = "{$original}-" . $count++;
    }
    return $slug;
  }

  public function edit_category($slug)
  {
    $categories = Categories::where('parent', '=', 0)->get();
    $cat_det = Categories::where('slug', '=', $slug)->first();
    return view(
      "backend.categories.edit",
      compact('categories', 'cat_det')
    );
  }


  public function removeimg($slug)
  {

    $img = Categories::where('slug', '=', $slug)->first();

    File::delete("storage/categories/" . $img->photo);

    Categories::where('slug', '=', $slug)->update(['photo' => '']);

    return redirect()->route('admin.category.edit-category', [$slug])->withFlashSuccess("Featured Image Removed Successfully!");
  }

  public function update_category(Request $request)
  {
    $slug = $request->slug;

    $this->validate(
      $request,
      [
        'title' => 'required|max:100',
        'status' => 'required',
        'file' => 'image|mimes:jpeg,jpg,gif,png,svg|max:8192',
        'display_order' => 'required|numeric',
      ]
    );

    if ($request->hasFile('file')) {
      $filenameWithExt = $request->file('file')->getClientOriginalName();
      // Get Filename
      $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
      // Get just Extension
      $extension = $request->file('file')->getClientOriginalExtension();
      // Filename To store
      $fileNameToStore = $filename . '_' . time() . '.' . $extension;
      $request->file->move('storage/categories', $fileNameToStore);
    }

    if ($request->hasFile('file')) {
      Categories::where('slug', '=', $slug)->update([
        'title' => $request->title,
        'details' => $request->details,
        'parent' => $request->parentcat,
        'order' => $request->display_order,
        'status' => $request->status,
        'photo' => $fileNameToStore
      ]);
    } else {
      Categories::where('slug', '=', $slug)->update([
        'title' => $request->title,
        'details' => $request->details,
        'parent' => $request->parentcat,
        'order' => $request->display_order,
        'status' => $request->status
      ]);
    }
    return redirect()->route('admin.category')->withFlashSuccess("Category Updated Successfully!");
  }

  public function delete_category($slug)
  {
    $img = Categories::where('slug', '=', $slug)->first();
    $check_products = ProductCategories::where('category_id', '=', $img->id)->get();
    if (count($check_products) > 0) {
      return redirect()->route('backend.category')->withFlashSuccess("You can`t Deleted this Category, Listings are there with this Category!");
    }
    File::delete("storage/categories/" . $img->photo);
    Categories::where('slug', '=', $slug)->delete();
    return redirect()->route('admin.category')->withFlashSuccess(" Category Removed Successfully!");
  }
}
