<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Repositories\Backend\Auth\UserRepository;
use App\Notifications\Backend\UserAlert;
use Illuminate\Support\Facades\Mail;
use App\Mail\MailSend;
use App\Models\UserActivity;
use App\Models\Auth\User;
use App\Models\Auth\UserDetails;
use App\Services\ExotelAPIService;
use App\Services\ZadarmaAPIService;
use Illuminate\Support\Facades\DB;

/**
 * Class CommunicationController.
 */
class CommunicationController extends Controller
{

    public function mail($userid)
    {
        $userinfo = get_user_by_id($userid);
        $user_id = \Auth::user()->id;
        if(!UserDetails::where('userid', $user_id)->exists()) {
            $userdetails = new UserDetails([
                'userid'    => $user_id,
            ]);
            $userdetails->save();
        }
        $userDetails = UserDetails::where('userid', $user_id)->first();

        $from = "";
        //check if staff has custom SMTP
        // $smtpdata = DB::table('staff_details')->where('staff_id',auth()->user()->id)->first();
        $smtpdata = DB::table('staff_details')->where('staff_id',auth()->user()->id)->where('email_integration',1)->first();
        //check if student branch has custom SMTP
        $branch = DB::table('branch')->where("id", $userinfo->branch)->first();
        if(isset($smtpdata) && $smtpdata->id){
            if(auth()->user()->email){
                $from = auth()->user()->first_name ." ".auth()->user()->last_name." <".auth()->user()->email.">";
            } else{
                $from = auth()->user()->first_name ." ".auth()->user()->last_name;
            }
        } elseif($branch->custom_smtp){
            if($branch->smtp_email){
                $from = $branch->smtp_from_name." <".$branch->smtp_email.">";
            } else{
                $from = $branch->smtp_from_name;
            }
        } else{
            if(get_site_config('smtp_email')){
                $from = get_site_config('app_name')." <".get_site_config('smtp_email').">";
            } else{
                $from = get_site_config('app_name');
            }
        }
       
        return view('backend.communicate.mail-user', ["from" => $from, "userDetails" => $userDetails, "userid" => $userid, "name" => $userinfo->first_name . " " . $userinfo->last_name, "email" => $userinfo->email]);
    }

    public function mailSend(Request $request)
    {
        $data = $request->all();
        if (!$data['subject']) {
            return redirect()->route('admin.communicate.mail', $data['userid'])->withFlashDanger("Subject is required!");
        }
        if (!$data['message']) {
            return redirect()->route('admin.communicate.mail', $data['userid'])->withFlashDanger("Message is required!");
        }
        $max_size = env('ATTACHMENT_MAX_SIZE')* 1024;
        $request->validate([
            'attachment.*' => 'mimes:doc,docx,pdf,jpg,jpeg,png,gif,zip|max:'.$max_size,
            ],[
                'attachment.*.mimes' => 'Only doc,docx,pdf,jpg,jpeg,png,gif,zip are allowed',
                'attachment.*.max' => 'Sorry! Maximum allowed size for an attachment is '.env('ATTACHMENT_MAX_SIZE').'MB',
            ]
        );
        
        $user = (new UserRepository())->where('id', $data['userid'])->first();
        $message = $data['message'];
        $messages = str_replace('#first_name#', $user->first_name, $message);
        $messages = str_replace('#full_name#', $user->first_name . " " . $user->last_name, $messages);
        $messages = str_replace('#sitename#', app_name(), $messages);
        $messages = str_replace('#siteurl#', config('app.url'), $messages);
        try{
            $att_string = $att_arr = "";
            if (isset($request->attachment)) {
                $att_string = array();
                foreach ($request->attachment as $file) {
                    $filename = $file->getClientOriginalName();
                    $filename = microtime()."_".$filename;
                    $filename = str_replace(" ", "-", $filename);
                    $filename = preg_replace('/[^A-Za-z0-9\-_]+/', '', $filename);
                    if (strlen($filename) > 20) {
                        $filename = substr($filename, 0, 20);
                    }
                    $file->storeAs('email_attachments/', $filename.".".$file->getClientOriginalExtension(), 'public');
                    $att_string[] = $filename.".".$file->getClientOriginalExtension();
                }
                $att_arr = $att_string;
                $att_string = implode(",",$att_string);
            }

            notify_student($user,$data['subject'],$messages,$att_arr);
            //$user->notify(new UserAlert($data['subject'], $messages,"", $att_arr));

            //store event in user activity
            UserActivity::create(['user_id' => $user->id, 'type' => 'email_sent', 'title' => "Email Sent", 'detail' => "Subject:" . $data['subject'] . "<br>Message:" . $messages, 'staff' => \Auth::user()->id,'attachment'=>$att_string]);
        }catch (\Exception $e) {
            $message = $e->getMessage();
            \Log::debug("Mail Error: (Single mail: ) ".$message); 
            return redirect()->back()->withFlashDanger("Error Sending email: ".$message);  
        }
        
        return redirect()->back()->withFlashSuccess("Mail sent successfully!");
    }

    

    public function whatsapp($userid)
    {
        $userinfo = get_user_by_id($userid);
        return view('backend.communicate.whatsapp-user', compact('userinfo'));
    }

    public function whatsappSend(Request $request)
    {
        $data = $request->all();
        if(!get_site_config('whatsapp_enabled')){
            return redirect()->route('admin.communicate.whatsapp', $data['userid'])->withFlashDanger("Whatsapp is Disabled!");
        }
        if(get_site_config('whatsapp_enabled')){
            if(get_site_config('whatsapp_provider') == "wati" && !get_site_config('wati_token')){
                \Log::debug("Communication Controller - Whatsapp Error: Wati Token Missing");   
                return redirect()->route('admin.communicate.whatsapp', $data['userid'])->withFlashDanger("Whatsapp not configured properly!");
            }
            if(get_site_config('whatsapp_provider') == "aisensy" && !get_site_config('aisensy_api_key')){
                \Log::debug("Communication Controller - Whatsapp Error: Aisensy API KEY Missing"); 
                return redirect()->route('admin.communicate.whatsapp', $data['userid'])->withFlashDanger("Whatsapp not configured properly!");
            }
            if(get_site_config('whatsapp_provider') == "whatsapp_cloud_api" && !get_site_config('whatsapp_cloud_access_token')){
                \Log::debug("Communication Controller - Whatsapp Error: Whatsapp Cloud API KEY Missing"); 
                return redirect()->route('admin.communicate.whatsapp', $data['userid'])->withFlashDanger("Whatsapp not configured properly!");
            }
            
        }
        if (!$data['message']) {
            return redirect()->route('admin.communicate.whatsapp', $data['userid'])->withFlashDanger("Message is required!");
        }
        if (!$data['msg_template']) {
            return redirect()->route('admin.communicate.whatsapp', $data['userid'])->withFlashDanger("Template is required!");
        }
        $userinfo = User::find($data['userid']);
        /*
        $userinfo = User::find($data['userid']);
        $template = $data['msg_template'];
        $notify_whtsp = get_whatsapp_template($template);
        // dd($notify_whtsp);
        if ($notify_whtsp && $notify_whtsp->status) {
            //$notify_sms->message = str_replace("{#var#}", "%s", $notify_sms->message);
            //Wati
            // $notify_whtsp->message = str_replace("#first_name#", $userinfo->first_name, $notify_whtsp->message);
            // $notify_whtsp->message = str_replace("#sitename#", app_name(), $notify_whtsp->message);
            // $notify_whtsp->message = str_replace("#siteurl#", url('/'), $notify_whtsp->message);
            // $notify_whtsp->message = str_replace("#full_name#", $userinfo->full_name, $notify_whtsp->message);
            // $notify_whtsp->message = str_replace("#message#", $data['message'], $notify_whtsp->message);

            preg_match_all('/#(\S+)#/',$notify_whtsp->message,$matches);
            $msg = array();
            foreach($matches[1] as $key => $vars){
                if($vars == "first_name"){
                    $vals = array("name" => $key+1, "value" => $userinfo->first_name);
                    array_push($msg, $vals);
                }
                if($vars == "full_name"){
                    $vals = array("name" => $key+1, "value" => $userinfo->first_name . ' ' . $userinfo->last_name);
                    array_push($msg, $vals);
                }
                if($vars == "sitename"){
                    $vals = array("name" => $key+1, "value" => app_name());
                    array_push($msg, $vals);
                }
                if($vars == "siteurl"){
                    $vals = array("name" => $key+1, "value" => url('/'));
                    array_push($msg, $vals);
                }
            }
            $whtsp_msg = json_encode($msg);
            // dd($msg);
            //Wati
            
            //Aisensy
            // $notify_whtsp->message = str_replace("{{first_name}}", $userinfo->first_name, $notify_whtsp->message);
            // $notify_whtsp->message = str_replace("{{sitename}}", app_name(), $notify_whtsp->message);
            // $notify_whtsp->message = str_replace("{{siteurl}}", url('/'), $notify_whtsp->message);
            // $notify_whtsp->message = str_replace("{{full_name}}", $userinfo->full_name, $notify_whtsp->message);
            // $notify_whtsp->message = str_replace("{{message}}", $data['message'], $notify_whtsp->message);
            //Aisensy

            //dd($notify_whtsp->message);

            if($userinfo->whatsapp($whtsp_msg, $notify_whtsp->hook)) {
                //store event in user activity
                UserActivity::create(['user_id' => $userinfo->id, 'type' => 'whatsapp_sent', 'title' => "Whatsapp Sent", 'detail' => $notify_whtsp->message, 'staff' => \Auth::user()->id]);
                return redirect()->back()->withFlashSuccess("Whatsapp sent successfully!");
            } else {
                return redirect()->back()->withFlashDanger("Error Occurred: Unauthorized!");
            }
        } else {
            return redirect()->back()->withFlashDanger("Whatsapp disabled!");
        }*/

            $template = get_whatsapp_template($data['msg_template']);
            if ($template && $template->status) {
                if ($userinfo->whatsapp($template, $template->hook, $data['message'])) {
                    UserActivity::create([
                        'user_id' => $userinfo->id,
                        'type' => 'whatsapp_sent',
                        'title' => "Whatsapp Sent",
                        'detail' => $template->message,
                        'staff' => \Auth::user()->id
                    ]);
                    return redirect()->back()->withFlashSuccess("Whatsapp sent successfully!");
                } else {
                    return redirect()->back()->withFlashDanger("Error Occurred: Unauthorized!");
                }
            }
    }


    public function sms($userid)
    {
        $userinfo = get_user_by_id($userid);
        return view('backend.communicate.sms-user', compact('userinfo'));
    }

    public function smsSend(Request $request)
    {
        $data = $request->all();
        if (!$data['message']) {
            return redirect()->route('admin.communicate.sms', $data['userid'])->withFlashDanger("Message is required!");
        }
        $userinfo = User::find($data['userid']);

        //$notify_sms = get_sms_template('NOTIFICATION');
        //if ($notify_sms && $notify_sms->status) {
            //$notify_sms->message = str_replace("{#var#}", "%s", $notify_sms->message);
            //$notify_sms->message = sprintf($notify_sms->message, $user->first_name);
            //$notify_sms->message = str_replace("#sitename#", app_name(), $notify_sms->message);
            //$notify_sms->message = str_replace("#message#", $data['message'], $notify_sms->message);
            $sms_message = $data['message'];
            $sms_message = str_replace("#sitename#", app_name(), $sms_message);
            $sms_message = str_replace("#siteurl#", url('/'), $sms_message);
            $sms_message = str_replace("#first_name#", $userinfo->first_name, $sms_message);
            $sms_message = str_replace("#full_name#", $userinfo->full_name, $sms_message);

            //if($userinfo->sms($notify_sms->message, $notify_sms->template_id)) {
            if($userinfo->sms($sms_message, "")) {
                //store event in user activity
                //UserActivity::create(['user_id' => $userinfo->id, 'type' => 'sms_sent', 'title' => "SMS Sent", 'detail' => $notify_sms->message, 'staff' => \Auth::user()->id]);
                UserActivity::create(['user_id' => $userinfo->id, 'type' => 'sms_sent', 'title' => "SMS Sent", 'detail' => $sms_message, 'staff' => \Auth::user()->id]);
                return redirect()->back()->withFlashSuccess("SMS sent successfully!");
            } else {
                return redirect()->back()->withFlashDanger("Error Occurred!");
            }
        //} else {
        //    return redirect()->back()->withFlashDanger("SMS disabled!");
        //}

        return redirect()->back()->withFlashSuccess("SMS sent successfully!");
    }

    
    public function phoneCall($userid) {
        //Check the outbound call configuration & invoke corresponding service class
        if(!get_site_config('outbound_call_enabled')){
              return json_encode(['err'=>1,'msg'=>'Outbound call is Disabled!']);
        }

        if(get_site_config('outbound_call_provider')=='exotel'){
            $user = User::find($userid);
            if ($user) {
                $staff_num = \Auth::user()->mobile;
                $user_num = $user->mobile;
                if($staff_num==""){
                    return json_encode(['err'=>1,'msg'=>'Invalid Agent Number!']);
                }
                if($user_num==""){
                    return json_encode(['err'=>1,'msg'=>'Invalid User Number!']);
                }
                $ExotelCall = new ExotelAPIService();
                $res = $ExotelCall->make_exotel_call($staff_num,$user_num);
                //$res = make_exotel_call($staff_num,$user_num);
                return $res;
            }else{
                return json_encode(['err'=>1,'msg'=>'Something went wrong!']);
            }
        }

        if(get_site_config('outbound_call_provider')=='zadarma'){
            $user = User::find($userid);
            if ($user) {
                $staff_num = get_site_config('zadarma_agent_number');
                if(!$user->dialcode){
                    return json_encode(['err'=>1,'msg'=>'User dialcode is missing!']);
                }
                if(!$user->mobile){
                    return json_encode(['err'=>1,'msg'=>'User Mobile No. is missing!']);
                }
                $user_num = $user->dialcode.$user->mobile;
                if($staff_num==""){
                    return json_encode(['err'=>1,'msg'=>'Invalid Agent Number!']);
                }
                if($user_num==""){
                    return json_encode(['err'=>1,'msg'=>'Invalid User Number!']);
                }
                $ZadarmaCall = new ZadarmaAPIService();
                $res = $ZadarmaCall->make_zadarma_call($staff_num,$user_num);
                return $res;
            }else{
                return json_encode(['err'=>1,'msg'=>'Something went wrong!']);
            }
        }
       
   

    }

}