<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Auth\Course;
use App\Models\Auth\QuestionAnswerComprehension;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class ComprehensionController extends Controller
{

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('trainings configs'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }            
            return $next($request);
        });
    }
        
    public function index()
    {
        return view('backend.courses.q_a.addcomprehension');
    }
    
    
    public function create()
    {
        $courses = Course::all();
        return view('backend.courses.q_a.addcomprehension', ['courses'=>$courses]);
    }
    
    
    public function store(Request $request)
    {
       $title = $request->post('title');
       $content = $request->post('content');
       $course_id = $request->post('course_id');
       $chapter_no = $request->post('chapter_no');
       $chapter_notes = $request->post('chapter_notes');
       $com_id = $request->post('com_id');
        
        $request->validate([
            'title' => 'required',
            'content' => 'required',
            'course_id' => 'required',
            'chapter_no' => 'required'
        ]);
        
         $data = array(
            'title' => $title,
            'content' => $content,
            'course_id' => $course_id,
            'chapter' => $chapter_no,
            'chapter_notes' => $chapter_notes,
            
         );
         
        QuestionAnswerComprehension::addOrUpdateComprehension($data, $com_id);
        return redirect()->route('admin.comprehension.create')->withFlashSuccess('Comprehension added successfully!');
    }
    
    
    public function list_all()
    {
        $page = \Request::get('page',1);
        $comprehension = QuestionAnswerComprehension::select('q_a_comprehension_text.*', 'courses.title as course_name')
        ->leftJoin('courses', 'courses.id', '=', 'q_a_comprehension_text.course_id')
        ->where('status', '=' , '1')
        ->orderBy("updated_at", 'DESC')->paginate(10);
        return view('backend.courses.q_a.listcomprehension', ['comprehension' => $comprehension,'page'=>$page]);
    }
    
    
    
    public function edit($id)
    {
        $page = \Request::get('page',1);
        $Obj = QuestionAnswerComprehension::where('id','=',$id)->where('status', '=' , '1')->first();
        $courses = Course::all();
        
        if(empty($Obj)){
            return redirect()->route('admin.comprehension.list')->withFlashDanger('invalid!');
        }
        
        $data = QuestionAnswerComprehension::where('id','=',$id)->where('status', '=' , '1')->first();
        return view('backend.courses.q_a.editcomprehension', ['data' => $data,'id'=>$id, 'courses'=>$courses, 'page'=>$page]);
    }
    
    
    public function destroy($id)
    {
        $page = (int)\Request::get('page',1);
        $Obj = QuestionAnswerComprehension::where('id','=',$id)->where('status', '=' , '1')->first();
        if(!empty($Obj)){
            $Obj->status = 0;
            $Obj->save();
            return redirect()->route('admin.comprehension.list', ['page'=>$page])->withFlashSuccess('Deleted Successfully');
        }
        
        return redirect()->route('admin.omprehension.list')->withFlashDanger('Comprehension Id is Invalid');
    }
    
    
    
    
    
    
    
    
    
}
