<?php

/*
* This file is not used
*/
namespace App\Http\Controllers\Backend;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\UserActivity;
use App\Models\Auth\Course;
use App\Models\Auth\Country;
use App\Models\Auth\City;
use App\Models\Auth\LeadStatus;
use App\Recipients\AdminRecipient;
use App\Models\Auth\Branch;
use App\Models\MailTemplates;
use App\Notifications\Frontend\AdminAlert;
use App\Models\Auth\CountryStudy;
use Illuminate\Foundation\Http\FormRequest;
use App\Http\Requests\Backend\Auth\User\LeadRequest;
use Illuminate\Support\Facades\Input;
use App\Repositories\Backend\Auth\UserRepository;
use App\Notifications\Backend\UserAlert;
use Illuminate\Support\Str;
use App\Models\Auth\Batch;
use App\Models\Auth\User;
use App\Mail\MailSend;
use App\Models\Auth\UserDetails;
use Illuminate\Support\Facades\Mail;
use App\Models\StaffBranch;
use App\Repositories\Backend\Auth\StaffRepository;
use App\Exceptions\GeneralException;
use Illuminate\Database\Eloquent\Model;
use Log;

class CounsellingController extends Controller
{

    private $itemsPerPages = 20;
    protected $model;

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('counselling'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }
            $model = app()->make($this->model());
            if (!$model instanceof Model) {
                throw new GeneralException("Class {$this->model()} must be an instance of " . Model::class);
            }
            $this->model = $model;
            return $next($request);
        });
    }

    public function model()
    {
        return User::class;
    }

    public function index(Request $request)
    {
        $search_status = $search_lead_type = $search = $my_data = $counselling_daterange = '';
        if ($request->has('q')) {

            $search_type = $request->input('q') != '' ? $request->input('q') : '';
            if ($search_type != '') {
                $search_status_arr = explode('allstatus::', $search_type);
                $search_lead_type_arr = explode('alllead-type::', $search_type);

                $search_mystatus_arr = explode('mystatus::', $search_type);
                $search_mylead_type_arr = explode('mylead-type::', $search_type);

                $search_mynextcounselling_arr = explode('nextcounselling::', $search_type);

                if (isset($search_status_arr[1]) && $search_status_arr[1] != '') {
                    $search_status = $search_status_arr[1];
                } else if (isset($search_lead_type_arr[1]) && $search_lead_type_arr[1] != '') {
                    $search_lead_type = $search_lead_type_arr[1];
                } else if (isset($search_mystatus_arr[1]) && $search_mystatus_arr[1] != '') {
                    $search_status = $search_mystatus_arr[1];
                    $my_data = 1;
                } else if (isset($search_mylead_type_arr[1]) && $search_mylead_type_arr[1] != '') {
                    $search_lead_type = $search_mylead_type_arr[1];
                    $my_data = 1;
                } elseif(isset($search_mynextcounselling_arr[1]) && $search_mynextcounselling_arr[1] == 'today') {
                    $counselling_daterange = date("d-M-Y")." to ".date("d-M-Y");
                } else {
                    $search = $search_type;
                }
            }
        }
        $courses = Course::all();
        $filters = array("status" => $search_status, "search" => "", "lead" => $search_lead_type, "lead_countries" => "", "assigned_to" => "", "counselling_daterange" => $counselling_daterange, "course" => "", "my_data" => $my_data);
        // $status_list = array('Open' => 'Open', 'Hot' => 'Hot', 'Warm' => 'Warm', 'Cold' => 'Cold', 'Long term nurture' => 'Long term nurture', 'Converted' => 'Converted', 'Disqualified' => 'Disqualified');

        $status_list = '';
        $lead_countries = User::whereNotNull('country')->where('country',"!=",'')->where('is_lead', 1)->distinct()->get(['country']);

        $userRepo = new StaffRepository();
        $staff = $userRepo->getStaffUsers(get_staff_branch_ids(\Auth::user()->id));
        $branch = get_staff_branch(\Auth::user()->id);
        $current_branch = $request->input('branch');
        return view('backend.counselling.counselling_index',  ['lead_countries' => $lead_countries, 'search' => $search, 'filters' => $filters, 'courses' => $courses, 'staff' => $staff, 'status_list' => $status_list, 'branch' => $branch, 'current_branch' => $current_branch]);
    }

    public function ajaxcounsellinglist(Request $request)
    {

        if (!$request->ajax()) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this page.');
        }
        echo $this->getDatatablecounsellinglist($request);
    }


    public function getDatatablecounsellinglist($request)
    {
        //Query debug
        DB::enableQueryLog();

        $columns = array(
            0 => 'id',
            1 => 'id',
            2 => 'id',
            3 => 'first_name',
            4 => 'counselling_date',
            5 => 'lead_status',
            6 => 'assigned_to_name',
            7 => 'next_followup',
            8 => 'created_at',
        );

        $my_branch = "";
        if (\Auth::user()->can('view assigned data only')) {
            \Log::debug('view assigned data only. User: ' . \Auth::user()->id);
            $my_user_id = \Auth::user()->id;
        } else {
            $my_user_id = $request->input('myleads') == 1 ? \Auth::user()->id : '';
        }
        if ($request->input('branch') == "all") {
            $my_branch = get_staff_branch_ids(\Auth::user()->id);
        } else {
            $my_branch = array($request->input('branch'));
        }

        $counselling_date_from = "";
        $counselling_date_to = "";        
        if(!empty($request->input('counselling_daterange'))) {
            $counselling_dts_str = $request->input('counselling_daterange');
            $counselling_dts = explode(" to ", $counselling_dts_str);
            $counselling_date_from = date("Y-m-d 00:00:00", strtotime($counselling_dts[0]));
            $counselling_date_to = date("Y-m-d 23:59:59", strtotime($counselling_dts[1]));
        }
        \Log::debug('Lead follow dt: '.$counselling_date_from. ' to '.$counselling_date_to);


        $totalData = $this->model
            ->active()
            ->when(!empty($my_branch), function ($query) use ($my_branch) {
                return $query->whereIn('branch', $my_branch);
            })
            ->when(!empty($my_user_id), function ($query) use ($my_user_id) {
                return  $query->Where('assigned_to', '=', "$my_user_id");
            })
            ->when(!empty($counselling_date_from), function ($query) use ($counselling_date_from) {
                return  $query->Where('counselling_date', '>=', "$counselling_date_from");
            })
            ->when(!empty($counselling_date_to), function ($query) use ($counselling_date_to) {
                return  $query->Where('counselling_date', '<=', "$counselling_date_to");
            })            
            //->where('lead_status', '=', get_converted_lead_status())
            ->where('lead_status', '=', get_counselling_lead_status())
            ->count();

        $totalFiltered = $totalData;
        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');
        $status = $request->input('status');
        $leadtype = $request->input('leadtype');
        $assigned_to = $request->input('assigned_to');
        $my_user_id = $request->input('myleads') == 1 ? \Auth::user()->id : '';
        $lead_country = $request->input('lead_country');

        // DB::enableQueryLog();

        if (empty($status)) {
            //We exclude other leads by default
            $get_search = $request->input('search.value');
            $users = $this->model
                ->active()
                ->when(!empty($my_branch), function ($query) use ($my_branch) {
                    return $query->whereIn('branch', $my_branch);
                })
                //->where('lead_status', '=', get_converted_lead_status())
                ->where('lead_status', '=', get_counselling_lead_status())
                ->when(!empty($get_search), function ($query) use ($get_search) {
                    return $query->Where(function ($query) use ($get_search) {
                        $query->Where('first_name', 'like', "%$get_search%")
                            ->orWhere('last_name', 'like', "%$get_search%")
                            ->orWhereRaw("CONCAT(`first_name`, ' ', `last_name`) LIKE ?", ['%'.$get_search.'%'])
                            ->orWhere('mobile', '=', "$get_search")
                            ->orWhere('id', '=', "$get_search")
                            ->orWhere('email', 'like', "%$get_search%")
                            ->orWhere('created_at', 'like', "$get_search%") //search date like 2022-05-15
                            ->orWhere('lead_status', '=', "$get_search"); //search open lead status from search input
                    });
                })
                ->when(!empty($leadtype), function ($query) use ($leadtype) {
                    return  $query->Where('student_type', '=', "$leadtype");
                })
                ->when(!empty($lead_country), function ($query) use ($lead_country) {
                    return  $query->Where('country', '=', "$lead_country");
                })
                ->when(!empty($assigned_to), function ($query) use ($assigned_to) {
                    return  $query->Where('assigned_to', '=', "$assigned_to");
                })
                ->when(!empty($my_user_id), function ($query) use ($my_user_id) {
                    return  $query->Where('assigned_to', '=', "$my_user_id");
                })
                ->when(!empty($counselling_date_from), function ($query) use ($counselling_date_from) {
                    return  $query->Where('counselling_date', '>=', "$counselling_date_from");
                })
                ->when(!empty($counselling_date_to), function ($query) use ($counselling_date_to) {
                    return  $query->Where('counselling_date', '<=', "$counselling_date_to");
                })                
                ->where('is_lead', 1)
                ->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                ->get();

            // $queries = DB::getQueryLog();
            // Log::debug(end($queries));

            $totalFiltered = $this->model
                ->active()
                ->when(!empty($my_branch), function ($query) use ($my_branch) {
                    return $query->whereIn('branch', $my_branch);
                })
                //->where('lead_status', '=', get_converted_lead_status())
                ->where('lead_status', '=', get_counselling_lead_status())
                ->when(!empty($get_search), function ($query) use ($get_search) {
                    return $query->Where(function ($query) use ($get_search) {
                        $query->Where('first_name', 'like', "%$get_search%")
                            ->orWhere('last_name', 'like', "%$get_search%")
                            ->orWhereRaw("CONCAT(`first_name`, ' ', `last_name`) LIKE ?", ['%'.$get_search.'%'])
                            ->orWhere('mobile', '=', "$get_search")
                            ->orWhere('id', '=', "$get_search")
                            ->orWhere('email', 'like', "%$get_search%")
                            ->orWhere('created_at', 'like', "$get_search%") //search date like 2022-05-15
                            ->orWhere('lead_status', '=', "$get_search"); //search open lead status from search input
                    });
                })
                ->when(!empty($leadtype), function ($query) use ($leadtype) {
                    return  $query->Where('student_type', '=', "$leadtype");
                })
                ->when(!empty($lead_country), function ($query) use ($lead_country) {
                    return  $query->Where('country', '=', "$lead_country");
                })
                ->when(!empty($assigned_to), function ($query) use ($assigned_to) {
                    return  $query->Where('assigned_to', '=', "$assigned_to");
                })
                ->when(!empty($my_user_id), function ($query) use ($my_user_id) {
                    return  $query->Where('assigned_to', '=', "$my_user_id");
                })
                ->when(!empty($counselling_date_from), function ($query) use ($counselling_date_from) {
                    return  $query->Where('counselling_date', '>=', "$counselling_date_from");
                })
                ->when(!empty($counselling_date_to), function ($query) use ($counselling_date_to) {
                    return  $query->Where('counselling_date', '<=', "$counselling_date_to");
                })                
                ->where('is_lead', 1)
                ->count();
        } else {
            $get_search = $request->input('search.value');
            $users = $this->model
                ->active()
                ->when(!empty($my_branch), function ($query) use ($my_branch) {
                    return $query->whereIn('branch', $my_branch);
                })
                ->where('lead_status', '=', "$status")
                ->when(!empty($get_search), function ($query) use ($get_search) {
                    return $query->Where(function ($query) use ($get_search) {
                        $query->Where('first_name', 'like', "%$get_search%")
                            ->orWhere('last_name', 'like', "%$get_search%")
                            ->orWhereRaw("CONCAT(`first_name`, ' ', `last_name`) LIKE ?", ['%'.$get_search.'%'])
                            ->orWhere('mobile', '=', "$get_search")
                            ->orWhere('id', '=', "$get_search")
                            ->orWhere('email', 'like', "%$get_search%")
                            ->orWhere('created_at', 'like', "$get_search%");
                    });
                })
                ->when(!empty($leadtype), function ($query) use ($leadtype) {
                    return  $query->Where('student_type', '=', "$leadtype");
                })
                ->when(!empty($lead_country), function ($query) use ($lead_country) {
                    return  $query->Where('country', '=', "$lead_country");
                })
                ->when(!empty($assigned_to), function ($query) use ($assigned_to) {
                    return  $query->Where('assigned_to', '=', "$assigned_to");
                })
                ->when(!empty($my_user_id), function ($query) use ($my_user_id) {
                    return  $query->Where('assigned_to', '=', "$my_user_id");
                })
                ->when(!empty($counselling_date_from), function ($query) use ($counselling_date_from) {
                    return  $query->Where('counselling_date', '>=', "$counselling_date_from");
                })
                ->when(!empty($counselling_date_to), function ($query) use ($counselling_date_to) {
                    return  $query->Where('counselling_date', '<=', "$counselling_date_to");
                })                
                ->where('is_lead', 1)
                ->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                ->get();

            // $queries = DB::getQueryLog();
            // Log::debug(end($queries));

            $totalFiltered = $this->model
                ->active()
                ->when(!empty($my_branch), function ($query) use ($my_branch) {
                    return $query->whereIn('branch', $my_branch);
                })
                ->where('lead_status', '=', "$status")
                ->when(!empty($get_search), function ($query) use ($get_search) {
                    return $query->Where(function ($query) use ($get_search) {
                        $query->Where('first_name', 'like', "%$get_search%")
                            ->orWhere('last_name', 'like', "%$get_search%")
                            ->orWhereRaw("CONCAT(`first_name`, ' ', `last_name`) LIKE ?", ['%'.$get_search.'%'])
                            ->orWhere('mobile', '=', "$get_search")
                            ->orWhere('id', '=', "$get_search")
                            ->orWhere('email', 'like', "%$get_search%")
                            ->orWhere('created_at', 'like', "$get_search%");
                    });
                })
                ->when(!empty($leadtype), function ($query) use ($leadtype) {
                    return  $query->Where('student_type', '=', "$leadtype");
                })
                ->when(!empty($lead_country), function ($query) use ($lead_country) {
                    return  $query->Where('country', '=', "$lead_country");
                })
                ->when(!empty($assigned_to), function ($query) use ($assigned_to) {
                    return  $query->Where('assigned_to', '=', "$assigned_to");
                })
                ->when(!empty($my_user_id), function ($query) use ($my_user_id) {
                    return  $query->Where('assigned_to', '=', "$my_user_id");
                })
                ->when(!empty($counselling_date_from), function ($query) use ($counselling_date_from) {
                    return  $query->Where('counselling_date', '>=', "$counselling_date_from");
                })
                ->when(!empty($counselling_date_to), function ($query) use ($counselling_date_to) {
                    return  $query->Where('counselling_date', '<=', "$counselling_date_to");
                })                
                ->where('is_lead', 1)
                ->count();
        }

        $data = $customResult = array();
        if (!empty($users)) {
            $count = 1;
            foreach ($users as $page) {
                // $customResult['id'] = $count++;
                $customResult['id'] = $page->id;
                //$folow_text = $this->get_lead_followup($page->id);
                //if ($folow_text != 0) {
                //    $tooltip_inc = '<div class="edu-tooltip"><i style="font-size:24px;color:#31d2f2;" class="fa fa-comment-dots"></i>
                //                        <span class="edu-tooltiptext">' . $folow_text . '</span>
                //                    </div>';
                //} else {
                //    $tooltip_inc = '';
                //}

                $customResult['name'] = "<strong><p class='mb-2'><a target='_blank' href='" . route('admin.counselling.followups', $page->id) . "'>" . $page->first_name . ' ' . $page->last_name . "</a></p></strong>";
                if ($page->email) {
                    $customResult['name'] .= "<span style='white-space:nowrap;'><i class='fas fa-envelope text-sub'></i> <a target='_blank' href='" . route('admin.broadcast.mail.lead', $page->id) . "'><span class='text-sub'>" . $page->email . "</span></a></span><br />";
                }
                if ($page->mobile) {
                    if ($page->dialcode != '') {
                        $mob = '+' . $page->dialcode . '-' . $page->mobile;
                    } else {
                        $mob = $page->mobile;
                    }
                    $customResult['name'] .= "<span style='white-space:nowrap;'><i class='fas fa-phone-alt text-sub'></i> <a target=\"_blank\" href=" . route('admin.broadcast.sms.lead', $page->id) . "\"><span class='text-sub'>" . $mob . "</span></a></span><br />";
                }
                if ($page->whatsapp) {
                    if ($page->dialcode != '') {
                        $whtsp = '+' . $page->dialcode . '-' . $page->whatsapp;
                    } else {
                        $whtsp = $page->whatsapp;
                    }
                    $customResult['name'] .= "<span style='white-space:nowrap;'><i class='fab fa-whatsapp'></i> <a target=\"_blank\" href=" . route('admin.broadcast.whatsapp.lead', $page->id) . "><span class='text-sub'>" . $whtsp . "</span></a></span><br />";
                }
                $customResult['name'] .= "<span style='white-space:nowrap;'><i class='fas fa-globe text-sub'></i> <span class='text-sub'>";
                if ($page->city) {
                    $customResult['name'] .= get_city_name($page->city) . ", ";
                }
                if ($page->country) {
                    $customResult['name'] .= get_country_name($page->country)." ";
                }
                $customResult['name'] .= "</span></span><br />";

                if($page->branch) {
                    $customResult['name'] .= "<span class='badge badge-default'>" . branch_name($page->branch) . "</span>";
                }

                // if (get_user_by_email($page->email)) {
                //     $customResult['name'] .= "<a target='_blank' href='" . route('admin.auth.user.show', get_user_by_email($page->email)->id) . "'><span style='white-space:nowrap;'><i class='mt-2 fas fa-user text-sub'></i> <span class='text-sub'>Student Profile</span></span></a><br />";
                // }

                //$customResult['recent_activity'] = $tooltip_inc;

                /*$email = $page->email;
                if (strlen($email) > 20) {
                    $email = "<div style='max-width:130px;white-space: nowrap;overflow: hidden;text-overflow: ellipsis;' title='" . $page->email . "'>" . $page->email . "</div>";
                }
                $customResult['email'] = "<a target='_blank' href='" . route('admin.broadcast.mail.lead', $page->id) . "'>" . $email . "</a>";

                $customResult['mobile'] = $page->mobile;
                */
                //$customResult['branch'] = $page->branch ? branch_name($page->branch) : "";
                $customResult['counselling_date'] = $page->counselling_date ? date('d M, g:ia', strtotime($page->counselling_date)) : "--";
                $customResult['next_followup'] = $page->next_followup ? date('d M, g:ia', strtotime($page->next_followup)) : "";

                // $customResult['last_followup'] = $page->last_followup ? date('d M, g:ia', strtotime($page->last_followup)) : "--";
                //$customResult['created_at'] = $page->created_at ? date('d M Y h:i a', strtotime($page->created_at)) : "";
                $customResult['created_at'] = \Carbon\Carbon::parse($page->created_at)->diffForHumans();

                //'Open','Hot','Warm','Cold','Long term nurture','Converted','Disqualified'
                $customResult['status'] = '<span class="tag" style="background-color:' . get_lead_status_color($page->lead_status) . '!important">' . $page->lead_status . '</span>';

                $customResult['assigned_to_name'] = $page->assigned_to ? get_user_full_name_by_id($page->assigned_to) : "--";
                // if (\Auth::user()->isAdmin() || \Auth::user()->can('lead-assignment')) {
                //     $customResult['assigned_to_name'] .= '<a target="_blank" style="padding:0;font-size:12px;float:right;" href="' . route('admin.leads.assignstaff', $page->id) . '" data-toggle="tooltip" data-placement="right" title="Assign Lead" class="btn"><i class="fas fa-user-edit"></i></a>';
                // }
                if (env('WATI_WHATSAPP_TOKEN')) {
                    $whatsapp_link = '<a target="_blank" href="' . route('admin.broadcast.whatsapp.lead', $page->id) . '" class="dropdown-item">Whatsapp</a>';
                } else {
                    $whatsapp_link = '<a target="_blank" href="https://wa.me/' . $page->dialcode . $page->mobile . '" class="dropdown-item">Whatsapp</a>';
                }

                $customResult['actions'] =
                    '<div class="btn-group" role="group" aria-label="User Actions">
                                <a href="' . route('admin.counselling.followups', $page->id) . '" data-toggle="tooltip" data-placement="top" title="Details, Follow-Ups" class="btn" style="background-color:#31abf7;color:#fff;">
                                <i class="fa fa-user-clock"></i>
                                </a>
                                
                                <button type="button" class="btn dropdown-toggle action_dropdown_btn" data-bs-toggle="dropdown" aria-expanded="true" style="background: #416fca; color:#fff; border: 1px solid #416fca; border-radius:0">
                                <b style="font-size: 12px;"><i class="fas fa-bullhorn" style="width:13px;"></i></b>
                                </button>

                                <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow" data-popper-placement="bottom-end">
                                <a target="_blank" href="' . route('admin.broadcast.mail.lead', $page->id) . '" class="dropdown-item ">Email</a> <hr style="margin:0px;">
                                <a target="_blank" href="' . route('admin.broadcast.sms.lead', $page->id) . '" class="dropdown-item">Sms</a> <hr style="margin:0px;">
                                ' . $whatsapp_link . '
                                </div>

                                <button style="border-radius:0;" type="button" class="btn btn-info text-white dropdown-toggle action_dropdown_btn" data-bs-toggle="dropdown" aria-expanded="true">
                                <b style="font-size: 13px;"><i class="fa fa-cog" style="width:13px;" aria-hidden="true"></i></b>
                                </button>
                                <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow" data-popper-placement="bottom-end">
                                <a target="_blank" href="' . route('admin.leadmanagement.edit', $page->id) . '" class="dropdown-item ">Edit</a>
                                </div>

                                <button type="button" class="btn dropdown-toggle action_dropdown_btn" data-bs-toggle="dropdown" aria-expanded="true" title="Change Status" style="background-color:#2293da;color:#fff;">
                                <i class="fa fa-edit" style="width:13px;"></i>
                                </button>
                                <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow" data-popper-placement="bottom-end">
                                <a href="#" class="dropdown-item">Change Status to</a>
                                <div class="dropdown-divider"></div>
                                ';

                foreach (counselling_lead_status_list() as $status_data) {
                    if ($status_data->counselling_status != 1) {
                        $customResult['actions'] .= '<a href="' . route('admin.counselling.changestatus', ['leadid' => $page->id, 'status' => $status_data->status]) . '"class="dropdown-item">' . $status_data->status . '</a>';
                    }
                }
                $customResult['actions'] .= '</div>
                                </div>';

                $data[] = $customResult;
            }
        }

        $json_data = array(
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $data,
            "search" => $get_search,
            "Branch" => $my_branch
        );

        return json_encode($json_data);
    }


    public function get_lead_followup($lead_id)
    {
        $followup = DB::table('user_activity')->where("user_id", $lead_id)->where("type", "followup")->latest()->first();
        if ($followup) {
            return date('d M, g:i A', strtotime($followup->created_at)) . ": " . $followup->detail;
        } else {
            return 0;
        }
    }

    public function followups($id)
    {
        $lead = User::findOrFail($id);
        $lead_details = UserDetails::where('userid', $id)->first();
        $lead_status = LeadStatus::orderBy('display_order', 'asc')->get();
        $lead_followups = UserActivity::where('user_id', $id)->latest()->get();
        $coursevalues = Course::find($lead->coaching_course_interested);
        return view('backend.counselling.lead_followups', compact('lead', 'lead_details', 'lead_followups', 'coursevalues', 'lead_status'));
    }

    public function update_followups(Request $request, $id)
    {
        $request->validate([
            'followup_details' => 'required',
        ]);

        $lead = User::find($id);

        $followup = new UserActivity;
        $followup->user_id = $id;
        $followup->type = 'followup';
        $followup->staff = \Auth::user()->id;
        $followup->detail = nl2br($request->get('followup_details'));
        if($lead->lead_status != $request->get('status') && $request->get('status') != get_converted_lead_status()) {
            $followup->detail .= "<br>LEAD STATUS CHANGED TO: " . $request->get('status');
        }
        $followup->save();

        $lead->last_followup = now();
        $lead->save();

        if($lead->lead_status != $request->get('status') && $request->get('status') == get_converted_lead_status()) {
            if($this->convert($id)) {
                return redirect()->route('admin.counsellingdetails')->withFlashSuccess('Lead Converted Successfully');
            } else {
                return redirect()->route('admin.counsellingdetails')->withFlashDanger('Something went wrong!');
            }
        }        

        $lead->lead_status = $request->get('status');
        if ($request->input('next_followup')) {
            $lead->next_followup = date("Y-m-d H:i", strtotime($request->get('next_followup')));
        } else {
            $lead->next_followup = NULL;
        }
        $lead->save();

        return redirect()->route('admin.counselling.followups', $id)->withFlashSuccess('Lead Follow-up details saved!');
    }

    // public function update_notes(Request $request, $id)
    // {
    //     $leadupdate = User::find($id);
    //     $leadupdate->notes = $request->get('notes');
    //     $leadupdate->save();
    //     return redirect()->route('admin.counselling.followups', $id)->withFlashSuccess('Lead Note updated!');
    // }

    public function changestatus($leadid, $status)
    {

        $lead = User::findOrFail($leadid);
        // if ($lead->status == $status) {
        if ($lead->lead_status == $status) {
            return redirect()->route('admin.counsellingdetails')->withFlashDanger('Lead already in selected status');
        }

        $converted = LeadStatus::where('converted_status', 1)->first();
        
        if ($converted && $converted->status == $status) {
            if($this->convert($leadid)) {
                return redirect()->route('admin.counsellingdetails')->withFlashSuccess('Lead Converted Successfully');
            } else {
                return redirect()->route('admin.counsellingdetails')->withFlashDanger('Something went wrong!');
            }
        }

        $disqualified = LeadStatus::where('disqualified_status', 1)->first();
        if ($disqualified) {
            $disqualified_status = $disqualified->status;
        }

        //if (DB::table('users')->where("id", $leadid)->where('lead_status', '<>', $disqualified_status)->where('lead_status', '<>', $converted_status)->update(['lead_status' => $status])) {
        //Now allowing even converted or disqualified status leads also to be changed. May be needed if status is changed by mistake?
        if (DB::table('users')->where("id", $leadid)->update(['lead_status' => $status])) {
            //Clear next followup if converted or disqualified
            if ($status == $disqualified_status) {
                $lead->next_followup = NULL;
                $lead->save();
            }
            //Adding activity
            $followup = new UserActivity;
            $followup->user_id = $leadid;
            $followup->type = 'others';
            $followup->staff = \Auth::user()->id;
            $followup->detail = "LEAD STATUS CHANGED TO: " . $status;
            $followup->save();
            return redirect()->route('admin.counsellingdetails')->withFlashSuccess('Lead Status Changed Successfully');
        } else {
            return redirect()->route('admin.counsellingdetails')->withFlashDanger('This lead status change not allowed');
        }
    }


    public function convert($id)
    {
        $user = User::findOrFail($id);
        if ($user->lead_status == get_converted_lead_status()) {
            return false;
        }

        $converted = LeadStatus::where('converted_status', 1)->first();
        if ($converted) {
            $converted_status = $converted->status;
            if (DB::table('users')->where("id", $id)->update(['lead_status' => $converted_status, 'next_followup' => NULL])) {

                $user->is_lead = 0;
                $pass = Str::random(6);
                $user->password = $pass;
                $user->save();

                //send email to student
                \Log::debug("Lead Convert: sending welcome mail");
                $mail_tpl = MailTemplates::find("STUDENT_PASSWORD");
                if ($mail_tpl && $mail_tpl->status) {
                    $email_message = $mail_tpl->message;
                    $email_message = str_ireplace("#sitename#", app_name(), $email_message);
                    $email_message = str_ireplace("#siteurl#", url(''), $email_message);
                    $email_message = str_ireplace("#first_name#", $user->first_name, $email_message);
                    $email_message = str_ireplace("#full_name#", $user->full_name, $email_message);
                    $email_message = str_ireplace("#email#", $user->email, $email_message);
                    $email_message = str_ireplace("#password#", $pass, $email_message);
                    try {
                        //$user->notify(new UserAlert($mail_tpl->subject, $email_message));
                        user_notify($user, $mail_tpl->subject, $email_message);
                    } catch (\Exception $e) {
                        $message = $e->getMessage();
                        \Log::debug("Mail Error: (CONVERT LEAD)" . $message);
                    }
                }

                //Adding activity
                $followup = new UserActivity;
                $followup->user_id = $id;
                $followup->type = 'others';
                $followup->staff = \Auth::user()->id;
                $followup->detail = "LEAD CONVERTED";
                $followup->save();
            } else {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}
