<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Auth\Course;
use App\Models\Auth\CourseCategory;
use App\Http\Requests\Backend\Auth\User\ManageUserRequest;

class CourseCategoryController extends Controller{

    public function __construct(){
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('trainings configs'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }            
            return $next($request);
        });
    }
        
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(){
        //$pages = DB::table('course_category')
        //->select('course_category.category','course_category.id')
        //->orderBy('course_category.category', "ASC")
        //->groupBy('course_category.id')
        //->get();
        //return view('backend.course_category.course_category',['pages'=>$pages]);
        return view('backend.course_category.course_category');
    }

    public function ajaxcoursecategorydata(ManageUserRequest $request) {
        if (!$request->ajax()) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this page.');
        }
        echo $this->getDatatableCourseCategory($request);
    }
  
    public function getDatatableCourseCategory($request){
            
        $columns = array( 
                            0 =>'category', 
                            1=> 'actions',
                            2=>'created_at'
                        );
                
        $totalData = count(DB::table('course_category')
                    ->groupBy('course_category.id')
                    ->get());    

                
        $totalFiltered = $totalData; 
        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');
            
        if(empty($request->input('search.value'))){                                
            $users = DB::table('course_category')
                    ->groupBy('course_category.id')
                    ->offset($start)
                    ->limit($limit)
                    ->orderBy($order, $dir)
                    ->get();
                            
        }
        else {
            $get_search = $request->input('search.value');                                                             
            $users = DB::table('course_category')
                    ->groupBy('course_category.id')
                    ->where(function($query) use ($get_search){
                        $query->Where('category', 'like', "%$get_search%");
                    })
                    ->offset($start)
                    ->limit($limit)
                    ->orderBy($order, $dir)
                    ->get();
            
            $totalFiltered = count(DB::table('course_category')
                    ->groupBy('course_category.id')
                    ->where(function($query) use ($get_search){
                        $query->Where('category', 'like', "%$get_search%");
                    })
                    ->get());
            
        }

        $data = $customResult = array();
        if(!empty($users)){
            foreach ($users as $page){
                $customResult['category'] = $page->category;
                $customResult['actions'] = '
                                <a href="'.route('admin.course-category.edit',$page->id).'" class="btn btn-primary btn-sm"><i class="fas fa-edit"></i> Edit</a>
                                <a href="'.route("admin.course-category.destroy",$page->id).'"
                                data-method="delete"
                                data-trans-button-cancel="Cancel"
                                data-trans-button-confirm="Delete"
                                data-trans-title="Are you sure?"
                                class="btn btn-danger btn-sm"><i class="fas fa-trash"></i> Delete</a>';             
                $customResult['created_at'] = $page->created_at;
                $data[] = $customResult;
            }
        }
          
        $json_data = array(
                    "draw"            => intval($request->input('draw')),  
                    "recordsTotal"    => intval($totalData),  
                    "recordsFiltered" => intval($totalFiltered), 
                    "data"            => $data   
                    );
            
        return json_encode($json_data); 
    }    
    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(){
        $page = CourseCategory::all();
        return view('backend.course_category.add_category', ['pages' => $page]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request){
        $category = $request->category;
        $course_category = CourseCategory::where('category', $request->category)->first();
        if($course_category != null){
            return redirect()->route('admin.course-category.index')->withFlashDanger(' Course Category Already Present');
        }else{
            $page= new CourseCategory();
            $page->category=$category;
            $page->save();
            return redirect()->route('admin.course-category.index')->withFlashSuccess(' Course Category Added Successfully');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id){
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function edit($id) {
        $page = CourseCategory::find($id);
        $category =DB::table('course_category')->where('id', '=', $page['category'])->first();

        return view('backend.course_category.edit_category', ['page' => $page,'category'=>$category]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {
        $request->validate([
            'category' => 'required',
        ]);

        $courseinfo = CourseCategory::find($id);
        $courseinfo->category = $request->get('category');
        $courseinfo->save();
        return redirect()->route('admin.course-category.index')->withFlashSuccess('Course Category Update Successfully!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id){
        $course = DB::table('courses')->select('title')->where('category',$id)->first();

        if($course == null){
            $categorydelete = CourseCategory::find($id);
            $categorydelete->delete();
        return redirect()->route('admin.course-category.index')->withFlashSuccess('Category Deleted Successfully');
        }else {
        return redirect()->route('admin.course-category.index')->withErrors('Cannot delete, course '.$course->title.' exists in this category!');            
        }        
    }
}
