<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Auth\Chapters;
use Illuminate\Http\Request;
use App\Models\Auth\OnlineCourse;
use Illuminate\Support\Str;

class CourseChaptersController extends Controller
{
 
    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('trainings configs'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }            
            return $next($request);
        });
    }
        
    public function create()
    {
        $courseId = (int)\Request::get('course_id', 0);
        $onlineCourses = OnlineCourse::getAllOnlineCourses();
        if ($courseId > 0) {
            $courseObj = OnlineCourse::getCourseObjById($courseId);
            if (empty($courseObj)) {
                return redirect()->route('admin.onlinecourses')->withFlashDanger('Online Course id is invalid!');
            }
            return view('backend.chapters.add', ['course_id' => $courseId, 'online_courses' => $onlineCourses,'courseObj'=>$courseObj]);
        }
        return view('backend.chapters.add', ['course_id' => 0, 'online_courses' => $onlineCourses,'courseObj'=>'']);
    }

    public function store(Request $request)
    {
        $request->validate([
            'online_course_id' => 'required|numeric|not_in:0',
            'title' => 'required',
            'file_type1' => 'required|in:video,doc,image',
            'summary' => 'required',
            'duration' => 'required',
            'display_order' => 'required|numeric'
        ]);
        $onlineCourseId = $request->get('online_course_id');
        $courseObj = OnlineCourse::getCourseObjById($onlineCourseId);
        if(empty($courseObj)){
            return redirect()->route('admin.chapters.create')->withFlashDanger('Online Course id is invalid!');
        }
        $file1_type = $request->get('file_type1');
        $file2_type = $request->get('file_type2');
        $file3_type = $request->get('file_type3');
        $file1 = '';
        $file2 = '';
        $file3 = '';
        if ($file1_type == 'video') {
            $file1 = $request->get('video1');
        } else {
            if ($request->hasFile('document1')) {
                $file = $request->document1->getClientOriginalName();
                $filename = pathinfo($file, PATHINFO_FILENAME);
                if (strlen($filename) > 125)
                    $filename = substr($filename, 0, 125);

                $filename = $filename . Str::random(20) . "." . $request->document1->getClientOriginalExtension();
                $file1 = $request->file('document1')->storeAs('/uploads', $filename, 'public');
            } else if ($request->hasFile('image1')) {
                $file = $request->image1->getClientOriginalName();
                $filename = pathinfo($file, PATHINFO_FILENAME);
                if (strlen($filename) > 125)
                    $filename = substr($filename, 0, 125);

                $filename = $filename . Str::random(20) . "." . $request->image1->getClientOriginalExtension();
                $file1 = $request->file('image1')->storeAs('/images', $filename, 'public');
            }
        }
        if($file2_type=='video'){
            $file2 = $request->get('video2');
        }else{
            if ($request->hasFile('document2')) {
                $file = $request->document2->getClientOriginalName();
                $filename = pathinfo($file, PATHINFO_FILENAME);
                if (strlen($filename) > 125)
                    $filename = substr($filename, 0, 125);

                $filename = $filename . Str::random(20) . "." . $request->document2->getClientOriginalExtension();
                $file2 = $request->file('document2')->storeAs('/uploads', $filename, 'public');
            } else if ($request->hasFile('image2')) {
                $file = $request->image2->getClientOriginalName();
                $filename = pathinfo($file, PATHINFO_FILENAME);
                if (strlen($filename) > 125)
                    $filename = substr($filename, 0, 125);

                $filename = $filename . Str::random(20) . "." . $request->image2->getClientOriginalExtension();
                $file2 = $request->file('image2')->storeAs('/images', $filename, 'public');
            }
        }
        if($file3_type=='video'){
            $file3 = $request->get('video3');
        }else{
            if ($request->hasFile('document3')) {
                $file = $request->document3->getClientOriginalName();
                $filename = pathinfo($file, PATHINFO_FILENAME);
                if (strlen($filename) > 125)
                    $filename = substr($filename, 0, 125);

                $filename = $filename . Str::random(20) . "." . $request->document3->getClientOriginalExtension();
                $file3 = $request->file('document3')->storeAs('/uploads', $filename, 'public');
            } else if ($request->hasFile('image3')) {
                $file = $request->image3->getClientOriginalName();
                $filename = pathinfo($file, PATHINFO_FILENAME);
                if (strlen($filename) > 125)
                    $filename = substr($filename, 0, 125);

                $filename = $filename . Str::random(20) . "." . $request->image3->getClientOriginalExtension();
                $file3 = $request->file('image3')->storeAs('/images', $filename, 'public');
            }
        }
        $data = array(
            'online_course_id' => $request->get('online_course_id'),
            'title' => $request->get('title'),
            'file1' => $file1,
            'file1_type' => ((!empty($file1_type)) ? $file1_type : 'none'),
            'file2' => $file2,
            'file2_type' => ((!empty($file2_type)) ? $file2_type : 'none'),
            'file3' => $file3,
            'file3_type' => ((!empty($file3_type)) ? $file3_type : 'none'),
            'summary' => $request->get('summary'),
            'duration' => $request->get('duration'),
            'display_order' => $request->get('display_order'),
            'status' => $request->get('status')
        );
        Chapters::addOrUpdateChapter($data);
        return redirect()->route('admin.onlinecourses.edit',$request->get('online_course_id'))->withFlashSuccess('Chapter Added Successfully!');
    }

    public function edit($id)
    {
        $chapter = Chapters::with(['onlineCourse','quiz'])->where('id','=',$id)->first();
        $onlineCourses = OnlineCourse::getAllOnlineCourses();
        return view('backend.chapters.edit', ['chapter' => $chapter,'online_courses' => $onlineCourses]);
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'online_course_id' => 'required|numeric',
            'title' => 'required',
            'file_type1' => 'required|in:video,doc,image',
            'summary' => 'required',
            'duration' => 'required',
            'display_order' => 'required|numeric'
        ]);
        $chapterObj = Chapters::getChapterById($id);
        if(empty($chapterObj)){
            return redirect()->route('admin.onlinecourses.edit',$request->get('online_course_id'))->withFlashDanger('Chapter id is invalid!');
        }
        $courseObj = OnlineCourse::getCourseObjById($request->get('online_course_id'));
        if(empty($courseObj)){
            return redirect()->route('admin.onlinecourses')->withFlashDanger('Online Course id is invalid!');
        }
        $file1_type = $request->get('file_type1');
        $file2_type = $request->get('file_type2');
        $file3_type = $request->get('file_type3');
        $file1 = '';
        $file2 = '';
        $file3 = '';
        if ($file1_type == 'video') {
            $file1 = $request->get('video1');
        } else {
            if($request->hasFile('document1') || $request->hasFile('image1')){
                $oldImagePath = $chapterObj->file1;
                if(!empty($oldImagePath)){
                    $oldFilePath = storage_path('app/public').'/'.$oldImagePath;
                    if(file_exists($oldFilePath)){
                        unlink($oldFilePath);
                    }
                }
            }
            if ($request->hasFile('document1')) {
                $file = $request->document1->getClientOriginalName();
                $filename = pathinfo($file, PATHINFO_FILENAME);
                if (strlen($filename) > 125)
                    $filename = substr($filename, 0, 125);

                $filename = $filename . Str::random(20) . "." . $request->document1->getClientOriginalExtension();
                $file1 = $request->file('document1')->storeAs('/uploads', $filename, 'public');
            } else if ($request->hasFile('image1')) {
                $file = $request->image1->getClientOriginalName();
                $filename = pathinfo($file, PATHINFO_FILENAME);
                if (strlen($filename) > 125)
                    $filename = substr($filename, 0, 125);

                $filename = $filename . Str::random(20) . "." . $request->image1->getClientOriginalExtension();
                $file1 = $request->file('image1')->storeAs('/images', $filename, 'public');
            }
        }
        if($file2_type=='video'){
            $file2 = $request->get('video2');
        }else{
            if($request->hasFile('document2') || $request->hasFile('image2')){
                $oldImagePath = $chapterObj->file2;
                if(!empty($oldImagePath)){
                    $oldFilePath = storage_path('app/public').'/'.$oldImagePath;
                    if(file_exists($oldFilePath)){
                        unlink($oldFilePath);
                    }
                }
            }
            if ($request->hasFile('document2')) {
                $file = $request->document2->getClientOriginalName();
                $filename = pathinfo($file, PATHINFO_FILENAME);
                if (strlen($filename) > 125)
                    $filename = substr($filename, 0, 125);

                $filename = $filename . Str::random(20) . "." . $request->document2->getClientOriginalExtension();
                $file2 = $request->file('document2')->storeAs('/uploads', $filename, 'public');
            } else if ($request->hasFile('image2')) {
                $file = $request->image2->getClientOriginalName();
                $filename = pathinfo($file, PATHINFO_FILENAME);
                if (strlen($filename) > 125)
                    $filename = substr($filename, 0, 125);

                $filename = $filename . Str::random(20) . "." . $request->image2->getClientOriginalExtension();
                $file2 = $request->file('image2')->storeAs('/images', $filename, 'public');
            }
        }
        if($file3_type=='video'){
            $file3 = $request->get('video3');
        }else{
            if($request->hasFile('document3') || $request->hasFile('image3')){
                $oldImagePath = $chapterObj->file3;
                if(!empty($oldImagePath)){
                    $oldFilePath = storage_path('app/public').'/'.$oldImagePath;
                    if(file_exists($oldFilePath)){
                        unlink($oldFilePath);
                    }
                }
            }
            if ($request->hasFile('document3')) {
                $file = $request->document3->getClientOriginalName();
                $filename = pathinfo($file, PATHINFO_FILENAME);
                if (strlen($filename) > 125)
                    $filename = substr($filename, 0, 125);

                $filename = $filename . Str::random(20) . "." . $request->document3->getClientOriginalExtension();
                $file3 = $request->file('document3')->storeAs('/uploads', $filename, 'public');
            } else if ($request->hasFile('image3')) {
                $file = $request->image3->getClientOriginalName();
                $filename = pathinfo($file, PATHINFO_FILENAME);
                if (strlen($filename) > 125)
                    $filename = substr($filename, 0, 125);

                $filename = $filename . Str::random(20) . "." . $request->image3->getClientOriginalExtension();
                $file3 = $request->file('image3')->storeAs('/images', $filename, 'public');
            }
        }
        $data = array(
            'online_course_id' => $request->get('online_course_id'),
            'title' => $request->get('title'),
            'file1' => $file1,
            'file1_type' => ((!empty($file1_type)) ? $file1_type : 'none'),
            'file2' => $file2,
            'file2_type' => ((!empty($file2_type)) ? $file2_type : 'none'),
            'file3' => $file3,
            'file3_type' => ((!empty($file3_type)) ? $file3_type : 'none'),
            'summary' => $request->get('summary'),
            'duration' => $request->get('duration'),
            'display_order' => $request->get('display_order'),
            'status' => $request->get('status')
        );
        Chapters::addOrUpdateChapter($data,$id);
        return redirect()->route('admin.onlinecourses.edit',$request->get('online_course_id'))->withFlashSuccess('Chapter Information saved!');
    }
    
    public function destroy($id)
    {
        $chapterObj = Chapters::getChapterById($id);
        $courseId = (int)\Request::get('course_id');
        if(!empty($chapterObj)){
            $chapterObj->status = 0;
            $chapterObj->save();
            return redirect()->route('admin.onlinecourses.edit',$courseId)->withFlashSuccess('Chapter Deleted Successfully');
        }
        return redirect()->route('admin.onlinecourses.edit',$courseId)->withFlashDanger('Chapter Not Deleted Successfully');
    }
}
