<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CourseSuggestion;
use Illuminate\Support\Str;
use App\Models\Auth\User;
use App\Notifications\Frontend\AdminAlert;
use App\Recipients\AdminRecipient;
use Illuminate\Support\Facades\DB;
use App\Repositories\Backend\Auth\UserRepository;
use App\Notifications\Backend\UserAlert;
use App\Models\MailTemplates;

class CourseSuggestionController extends Controller
{

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('overseas education configs'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }
            return $next($request);
        });
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $suggestions = CourseSuggestion::all()->sortByDesc('id');
        return view('backend.course_suggestion.index', compact('suggestions'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $years = get_course_suggest_years();
        $countries = get_study_countries();
        $intakes = get_course_suggest_intake();
        $levels = get_course_suggest_levels();
        return view('backend.course_suggestion.create', ['years' => $years, 'countries' => $countries, 'intakes' => $intakes, 'levels' => $levels]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'country' => 'required',
            'level' => 'required',
            'year' => 'required',
            'intake' => 'required'
        ]);

        if (!$request->file('file')) {
            return redirect()->route('admin.coursesuggestion.create')->withFlashDanger("Please select a file");
        }
        $filename = $request->file->getClientOriginalName();
        $fname_end = strpos($filename, $request->file->getClientOriginalExtension());
        $save_filename = substr($filename, 0, $fname_end - 1);
        $save_filename .= Str::random(10) . '.' . $request->file->getClientOriginalExtension();
        $path = $request->file('file')->storeAs('/courses', $save_filename, 'public');
        \Log::debug("::savedpath::$path");

        $coursesuggestion = new CourseSuggestion([
            'title' => $request->get('title'),
            'country' => $request->get('country'),
            'level' => $request->get('level'),
            'year' => $request->get('year'),
            'intake' => implode(', ', $request->get('intake')),
            'file' => $path
        ]);
        $coursesuggestion->save();
        return redirect()->route('admin.coursesuggestion')->withFlashSuccess('Course Suggestion saved!');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $coursesuggestion = CourseSuggestion::find($id);
        return view('backend.course_suggestion.show', compact('coursesuggestion'));
    }

    public function share($id)
    {
        $coursesuggestion = CourseSuggestion::find($id);
        $students = array();
        $res = User::select("id", "first_name", "email", "mobile")->orderBy("id", "desc")->get();
        foreach ($res as $student) {
            array_push($students, array("id" => $student->id, "name" => $student->first_name . " | " . $student->email . " | " . $student->mobile));
        }
        return view('backend.course_suggestion.share', ['coursesuggestion' => $coursesuggestion, 'students' => $students]);
    }

    public function share_do(Request $request)
    {
        $request->validate([
            'suggestion' => 'required',
            'student' => 'required'
        ]);
        $id = $request->input('suggestion');
        $userid = $request->input('student');
        $coursesuggestion = CourseSuggestion::find($id);
        $title = $coursesuggestion->title;
        $file = $coursesuggestion->file;

        DB::table('course_recommendation')
            ->insert(
                ['upload_date' => date('Y-m-d H:i:s'), 'userid' => $userid, 'title' => $title, 'file' => $file]
            );

        $user = (new UserRepository())->where('id', $userid)->first();
        //Check if user has agent
        if($user->agent_id) {
            //Notify Agent
                // \Log::debug("COURSE_SUGGESTION MAIL Sent to Agent");
                $agent = User::find($user->agent_id);
                $mail_tpl = MailTemplates::find("COURSE_SUGGESTION");
                if ($mail_tpl && $mail_tpl->status) {
                    $email_message = $mail_tpl->message;
                    //\Log::debug("MAIL BEFORE:".$email_message);                       
                    $email_message = str_ireplace("#sitename#", app_name(), $email_message);
                    $email_message = str_ireplace("#siteurl#", url(''), $email_message);
                    $email_message = str_ireplace("#first_name#", $user->first_name, $email_message);
                    $email_message = str_ireplace("#full_name#", $user->full_name, $email_message);
                    //\Log::debug("MAIL TPL FINAL:".$email_message);
                    try {
                        //$agent->notify(new UserAlert($mail_tpl->subject, $email_message));
                        user_notify($agent, $mail_tpl->subject, $email_message);
                    } catch (\Exception $e) {
                        $message = $e->getMessage();
                        \Log::debug("Mail Error: (Course Recommendation) " . $message);
                    }
                }
        }else{
            //Notify Student
            // \Log::debug("COURSE_SUGGESTION MAIL Sent to Student");
            $mail_tpl = MailTemplates::find("COURSE_SUGGESTION");
            if ($mail_tpl && $mail_tpl->status) {
                $email_message = $mail_tpl->message;
                //\Log::debug("MAIL BEFORE:".$email_message);                       
                $email_message = str_ireplace("#sitename#", app_name(), $email_message);
                $email_message = str_ireplace("#siteurl#", url(''), $email_message);
                $email_message = str_ireplace("#first_name#", $user->first_name, $email_message);
                $email_message = str_ireplace("#full_name#", $user->full_name, $email_message);
                //\Log::debug("MAIL TPL FINAL:".$email_message);
                try {
                    //$user->notify(new UserAlert($mail_tpl->subject, $email_message));
                    user_notify($user, $mail_tpl->subject, $email_message);
                } catch (\Exception $e) {
                    $message = $e->getMessage();
                    \Log::debug("Mail Error: (Course Recommendation) " . $message);
                }
            }

            // Send Whatsapp
            if (get_site_config('whatsapp_enabled')) {
                $numbers = [$user->whatsapp_dialcode.$user->whatsapp];

                $hook = 'course_suggestion';

                send_whatsapp_message($numbers, $hook, $user->id);
            }

            //sms
            $notify_sms = get_sms_template('COURSE_SUGGESTION');
            if ($notify_sms && $notify_sms->status) {
                $notify_sms->message = str_replace("#sitename#", app_name(), $notify_sms->message);
                $notify_sms->message = str_replace("#siteurl#", url('/'), $notify_sms->message);
                $notify_sms->message = str_replace("#first_name#", $user->first_name, $notify_sms->message);
                $notify_sms->message = str_replace("#full_name#", $user->full_name, $notify_sms->message);
                $user->sms($notify_sms->message, $notify_sms->template_id);
            }
        }
        
        
        
        //email
        // $mail_tpl = MailTemplates::find("COURSE_SUGGESTION");
        // if ($mail_tpl && $mail_tpl->status) {
        //     $email_message = $mail_tpl->message;
        //     //\Log::debug("MAIL BEFORE:".$email_message);                       
        //     $email_message = str_ireplace("#sitename#", app_name(), $email_message);
        //     $email_message = str_ireplace("#siteurl#", url(''), $email_message);
        //     $email_message = str_ireplace("#first_name#", $user->first_name, $email_message);
        //     $email_message = str_ireplace("#full_name#", $user->full_name, $email_message);
        //     //\Log::debug("MAIL TPL FINAL:".$email_message);
        //     try {
        //         $user->notify(new UserAlert($mail_tpl->subject, $email_message));
        //     } catch (\Exception $e) {
        //         $message = $e->getMessage();
        //         \Log::debug("Mail Error: (Course Recommendation) " . $message);
        //     }
        // }
        //Sending email to admin
        // $msg_details = "<p>New Course Recommendation sent to $user->full_name</p>";
        // if ($msg_details) {
        //     $email_message = "Dear Admin,<br><br>" . $msg_details;
        //     $recipient = new AdminRecipient();
        //     try {
        //         $recipient->notify(new AdminAlert("New Course Recommendation", $email_message));
        //     } catch (\Exception $e) {
        //         $message = $e->getMessage();
        //         \Log::debug("Mail Error: (Course Recommendation) " . $message);
        //     }
        // }
        
        // //sms
        // $notify_sms = get_sms_template('COURSE_SUGGESTION');
        // if ($notify_sms && $notify_sms->status) {
        //     $notify_sms->message = str_replace("#sitename#", app_name(), $notify_sms->message);
        //     $notify_sms->message = str_replace("#siteurl#", url('/'), $notify_sms->message);
        //     $notify_sms->message = str_replace("#first_name#", $user->first_name, $notify_sms->message);
        //     $notify_sms->message = str_replace("#full_name#", $user->full_name, $notify_sms->message);
        //     $user->sms($notify_sms->message, $notify_sms->template_id);
        // }

        return redirect()->route('admin.coursesuggestion')->withFlashSuccess('Course Suggestion shared successfully!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
