<?php

namespace App\Http\Controllers\Backend;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Auth\User;
use App\Models\Auth\CustomAttributes;
use App\Models\Auth\ApplicationStages;
use Illuminate\Http\Request;
use Log;

class CustomAttributesController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $attrs = DB::table('custom_attributes')->orderBy('name','desc')->get();
        return view('backend.settings.custom_attributes', compact('attrs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate(
            $request,
            [
                'name' => 'required|unique:custom_attributes,name',
                'type' => 'required',
                'attribute_for' => 'required',
                'label' => 'required',
            ]
        );

        $attr = new CustomAttributes;
        $attr->name = $request->name;
        $attr_name = preg_replace('/[^a-zA-Z0-9 ]/m','',$request->name);
        $attr->attr_name = strtolower(str_replace(" ","_",$attr_name));
        
        $attr->label = $request->label;
        $attr->type = $request->type;
        $attr->placeholder = $request->placeholder;
      
        $attr->selection_values = ($request->values) ? implode("|",array_filter($request->values)) : NULL;

        if($request->selection=="single") {
            $attr->select_multiple = 0;
        }
        else if($request->selection=="multiple") {
            $attr->select_multiple = 1;
        }  
        else {
            $attr->select_multiple = 0;
        }
        $attr->input_datatype = $request->input_type;

        $attr->input_min = $request->min_val;
        $attr->input_max = $request->max_val;

        $attr->laravel_rules = $request->laravel_rules;

        if($request->attribute_for  && in_array("leads",$request->attribute_for)){
            $attr->for_lead = 1;
            if($request->lead_mandatory){
                $attr->for_lead_mandatory = 1;
            }else{
                $attr->for_lead_mandatory = 0;
            }
        }
        if($request->attribute_for  && in_array("students",$request->attribute_for)){
            $attr->for_student = 1;
            if($request->student_mandatory){
                $attr->for_student_mandatory = 1;
            }else{
                $attr->for_student_mandatory = 0;
            }
        }
       
        $attr->display_order = DB::raw('(select COALESCE(MAX(display_order),0) from custom_attributes as display_order) + 1');
        $attr->save();
        return redirect()->route("admin.settings.custom-attributes")->withFlashSuccess("Custom Attribute Created Successfully!");
    }


    
    public function update(Request $request, $id)
    {
        $attr = CustomAttributes::findOrFail($id);
        $this->validate(
            $request,
            [
                'name' => 'required|unique:custom_attributes,name,'.$id,
                'type' => 'required',
                'attribute_for' => 'required',
                'label' => 'required',
            ]
        );
        $attr->name = $request->name;
        $attr_name = preg_replace('/[^a-zA-Z0-9 ]/m','',$request->name);
        $attr->attr_name = strtolower(str_replace(" ","_",$attr_name));
        
        $attr->label = $request->label;
        $attr->type = $request->type;
        $attr->placeholder = $request->placeholder;
      
        $attr->selection_values = ($request->values) ? implode("|",array_filter($request->values)) : NULL;

        if($request->selection=="single") {
            $attr->select_multiple = 0;
        }
        else if($request->selection=="multiple") {
            $attr->select_multiple = 1;
        }  
        else {
            $attr->select_multiple = 0;
        }
        $attr->input_datatype = $request->input_type;

        $attr->input_min = $request->min_val;
        $attr->input_max = $request->max_val;

        $attr->laravel_rules = $request->laravel_rules;

        if($request->attribute_for  && in_array("leads",$request->attribute_for)){
            $attr->for_lead = 1;
            if($request->lead_mandatory){
                $attr->for_lead_mandatory = 1;
            }else{
                $attr->for_lead_mandatory = 0;
            }
        }else{ 
            $attr->for_lead = 0;
            $attr->for_lead_mandatory = 0;
        }
        if($request->attribute_for  && in_array("students",$request->attribute_for)){
            $attr->for_student = 1;
            if($request->student_mandatory){
                $attr->for_student_mandatory = 1;
            }else{
                $attr->for_student_mandatory = 0;
            }
        }else{
            $attr->for_student = 0;
            $attr->for_student_mandatory = 0;
        }
       
        $attr->save();

        return redirect()->route("admin.settings.custom-attributes")->withFlashSuccess("Custom Attribute Updated!");
    }


    public function updateOrder(Request $request)
    {
      if ($request->id && $request->order) {
        $order = CustomAttributes::findOrFail($request->id);
        $order->display_order = $request->order;
        $order->save();
        return response(["status" => 200, "message"=>"Display order updated successfully"]); 
      }
    }

    public function destroy($id)
    {
        $attr = CustomAttributes::findOrFail($id);
        if($attr->web_to_lead){
            return redirect()->route("admin.settings.custom-attributes")->withFlashDanger("Attribute cannot be Deleted. It is used in a form builder form.");
        }
        $attr->delete();
        return redirect()->route("admin.settings.custom-attributes")->withFlashSuccess("Attribute Deleted!");
    }
}
