<?php

namespace App\Http\Controllers\Backend;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Auth\User;
use App\Models\Auth\CustomLabels;
use Illuminate\Http\Request;
use Log;

class CustomLabelsController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $labels = DB::table('custom_labels')->orderBy('id','asc')->get();
        return view('backend.settings.custom_labels', compact('labels'));
    }

    
    public function update(Request $request)
    {
        if($request->input('label_id')){
            $label = CustomLabels::findOrFail($request->label_id);
            $label->custom_text = $request->label_value;
            $label->save();
            return response(["status" => 200, "message"=>"Label updated successfully"]); 
        }
        else{
            return response(["status" => 500, "message"=>"Invalid Label"]); 
        }
        //return redirect()->route("admin.settings.custom-attributes")->withFlashSuccess("Custom Attribute Updated!");
    }

}
