<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Auth\User;
use Illuminate\Http\Request;
use App\Models\Auth\LeadStatus;
use App\Models\Auth\Reminders;
use App\Models\Auth\UniversityApplication;
use App\Models\Auth\StaffAttendance;
use App\Models\MailTemplates;
use App\Models\CannedResponses;
use App\Models\Auth\AgentDetails;
use Illuminate\Support\Facades\DB;
use App\Models\Auth\UserDetails;
use Carbon\Carbon;
use DateTime;
use DateInterval;
use DateTimeImmutable;
use App\Models\Announcements;

/**
 * Class DashboardController.
 */
class DashboardController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */

    private $related_reporting_ids = array();
    
    private function get_subordinate_ids($parent_profile_id) {
        //\Log::debug("get_subordinate_ids: ".$parent_profile_id);  
        if($parent_profile_id == \Auth::user()->id){
            $this->related_reporting_ids[] = $parent_profile_id;
        }
        $profile_id = User::where('reporting_to', '=', $parent_profile_id)
            ->with('roles', 'permissions', 'providers')
            ->active()
            ->whereHas('roles', function ($q) {
                $q->whereNotIn('name', ['user', 'trainer', 'agent']);
            })
            ->get();
        if($profile_id){
            foreach($profile_id as $profile){
                $this->related_reporting_ids[] = $profile->id;
                if($profile->id != "1" && $profile->id != \Auth::user()->id){ 
                    $this->get_subordinate_ids($profile->id);
                }
            }
        }
    }

    public function ajaxgetmailtpl(Request $request) {
        if (!$request->ajax()) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this page.');
        }
        $mail_tpl = MailTemplates::findOrFail($request->hook);
        $user_id = \Auth::user()->id;
        $emailSignature = UserDetails::where('userid', $user_id)->first();
        $array['mail_tpl'] = $mail_tpl;
        $array['emailSignature'] = $emailSignature;

        echo json_encode($array);
        // echo json_encode($mail_tpl);
    }

    public function ajaxgetcannedtpl(Request $request) {
        if (!$request->ajax()) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this page.');
        }
        $canned_tpl = CannedResponses::findOrFail($request->hook);
        $array['canned_tpl'] = $canned_tpl;
        echo json_encode($array);
    }

    public function index($current_branch=null)
    {
        if (!\Auth::user()->isStaff()) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }

        // Enable query logging
        DB::enableQueryLog();

        $branch = get_staff_branch(\Auth::user()->id);
        if($current_branch!=''){
            $my_branch = array($current_branch);
        }
        else{
            $my_branch = get_staff_branch_ids(\Auth::user()->id);
        }

        if (\Auth::user()->can('view assigned data only')) {
            \Log::debug('view assigned data only. User: ' . \Auth::user()->id);
            $userid = \Auth::user()->id;
            $this->get_subordinate_ids($userid);
        } else {
            $userid = "";
        }

        $today_followups = User::where('users.is_lead', 1)
            ->leftJoin('users as staff', 'users.assigned_to', '=', 'staff.id')
            ->select("users.id", "users.first_name", "users.last_name", "users.next_followup", "users.assigned_to", 'users.lead_status', 'staff.first_name as staff_first_name', 'staff.last_name as staff_last_name')
            ->when(!empty($userid), function ($query) use ($userid) {
                return  $query->whereIn('users.assigned_to', $this->related_reporting_ids);
            })
	        //->where('lead_status', '!=', get_counselling_lead_status())	    
            // ->where('next_followup', '<=', date("Y-m-d 23:59:59"))
            ->where('users.next_followup', 'like', date("Y-m-d")."%")
            ->orderBy('users.next_followup', 'ASC')
            ->whereNull('users.deleted_at')
            ->where('users.archived', "0")
            ->get();

        $due_followups = User::where('users.is_lead', 1)
            ->leftJoin('users as staff', 'users.assigned_to', '=', 'staff.id')
            ->select("users.id", "users.first_name", "users.last_name", "users.next_followup", "users.assigned_to", 'users.lead_status', 'staff.first_name as staff_first_name', 'staff.last_name as staff_last_name')
            ->when(!empty($userid), function ($query) use ($userid) {
                return  $query->whereIn('users.assigned_to', $this->related_reporting_ids);
            })
	        //->where('lead_status', '!=', get_counselling_lead_status())	    
            ->where('users.next_followup', '<', date("Y-m-d"))
            ->orderBy('users.next_followup', 'ASC')
            ->whereNull('users.deleted_at')
            ->where('users.archived', "0")
            ->get();

        $future_followups = User::where('users.is_lead', 1)
            ->leftJoin('users as staff', 'users.assigned_to', '=', 'staff.id')
            ->select("users.id", "users.first_name", "users.last_name", "users.next_followup", "users.assigned_to", 'users.lead_status', 'staff.first_name as staff_first_name', 'staff.last_name as staff_last_name')
            ->when(!empty($userid), function ($query) use ($userid) {
                return  $query->whereIn('users.assigned_to', $this->related_reporting_ids);
            })
	        //->where('lead_status', '!=', get_counselling_lead_status())	    
            ->whereDate('users.next_followup', '>', date("Y-m-d"))
            ->orderBy('users.next_followup', 'ASC')
            ->whereNull('users.deleted_at')
            ->where('users.archived', "0")
            ->get();

        $today_stu_followups = User::where('users.is_lead', 0)
            ->leftJoin('users as staff', 'users.assigned_to', '=', 'staff.id')
            ->select("users.id", "users.first_name", "users.last_name", "users.next_followup", "users.assigned_to", 'users.lead_status', 'staff.first_name as staff_first_name', 'staff.last_name as staff_last_name')
            ->when(!empty($userid), function ($query) use ($userid) {
                return  $query->whereIn('users.assigned_to', $this->related_reporting_ids);
            })
            ->where('users.next_followup', 'like', date("Y-m-d")."%")
            ->orderBy('users.next_followup', 'ASC')
            ->whereNull('users.deleted_at')
            ->where('users.archived', "0")
            ->get();

        $due_stu_followups = User::where('users.is_lead', 0)
            ->leftJoin('users as staff', 'users.assigned_to', '=', 'staff.id')
            ->select("users.id", "users.first_name", "users.last_name", "users.next_followup", "users.assigned_to", 'users.lead_status', 'staff.first_name as staff_first_name', 'staff.last_name as staff_last_name')
            ->when(!empty($userid), function ($query) use ($userid) {
                return  $query->whereIn('users.assigned_to', $this->related_reporting_ids);
            })  
            ->where('users.next_followup', '<', date("Y-m-d"))
            ->whereNull('users.deleted_at')
            ->where('users.archived', "0")
            ->orderBy('users.next_followup', 'ASC')
            ->get();

        $future_stu_followups = User::where('users.is_lead', 0)
            ->leftJoin('users as staff', 'users.assigned_to', '=', 'staff.id')
            ->select("users.id", "users.first_name", "users.last_name", "users.next_followup", "users.assigned_to", 'users.lead_status', 'staff.first_name as staff_first_name', 'staff.last_name as staff_last_name')
            ->when(!empty($userid), function ($query) use ($userid) {
                return  $query->whereIn('users.assigned_to', $this->related_reporting_ids);
            })   
            ->whereDate('users.next_followup', '>', date("Y-m-d"))
            ->orderBy('users.next_followup', 'ASC')
            ->whereNull('users.deleted_at')
            ->where('users.archived', "0")
            ->get();

        $upcoming_app_reminders = Reminders::where('reminders.deadline', '<=', Carbon::now()->addDays(14))
            ->where('reminders.done', 0)
            ->orderBy('reminders.deadline', 'ASC')
            ->get();

        $reminderData = array();
        foreach($upcoming_app_reminders as $reminders){
            if($reminders->entity == "university_application"){
                $reminderData[] = Reminders::join('university_application', 'university_application.id', '=', 'reminders.entity_id')
                    ->join('users', 'users.id', '=', 'university_application.userid')
                    ->leftJoin('users as staff', 'university_application.assign_to', '=', 'staff.id')
                    ->when(!empty($userid), function ($query) use ($userid) {
                        return  $query->whereIn('university_application.assign_to', $this->related_reporting_ids);
                    })
                    ->where('reminders.id', $reminders->id)
                    ->whereNull('users.deleted_at')
                    ->where('users.archived', "0")
                    ->first(['staff.first_name as staff_first_name', 'staff.last_name as staff_last_name', 'university_application.appl_id','university_application.id','university_application.assign_to','users.gender','users.first_name','users.last_name','reminders.deadline','reminders.activity','reminders.entity']);
            }
            
            if($reminders->entity == "service_application"){
                $reminderData[] = Reminders::join('service_applications', 'service_applications.id', '=', 'reminders.entity_id')
                    ->join('users', 'users.id', '=', 'service_applications.user_id')
                    ->leftJoin('users as staff', 'service_applications.assigned_to', '=', 'staff.id')
                    ->when(!empty($userid), function ($query) use ($userid) {
                        return  $query->whereIn('service_applications.assigned_to', $this->related_reporting_ids);
                    }) 
                    ->where('reminders.id', $reminders->id)
                    ->whereNull('users.deleted_at')
                    ->where('users.archived', "0")
                    ->first(['staff.first_name as staff_first_name', 'staff.last_name as staff_last_name', 'service_applications.appl_id','service_applications.id','service_applications.assigned_to as assign_to','users.gender','users.first_name','users.last_name','reminders.deadline','reminders.activity','reminders.entity']);
            }
        }

        $other_lead_status = LeadStatus::orderBy('display_order')->get();

        $allLeadsStatus = [];
        $total_leads = 0;
        $converted_lead_status = get_converted_lead_status();
        foreach($other_lead_status as $lead_status){
            if( $lead_status->status == $converted_lead_status){
                $allLeadsStatus[$lead_status->status] = DB::table('users')
                    ->when(!empty($my_branch), function ($query) use ($my_branch) {
                        return $query->whereIn('branch', $my_branch);
                    })
                    ->when(!empty($userid), function ($query) use ($userid) {
                        return  $query->whereIn('assigned_to', $this->related_reporting_ids);
                    })
                    //->where('id', $lead_status->id)
                    ->where('lead_status', $lead_status->status)
                    ->where('deleted_at', '=', null)
                    // ->where('is_lead', '=', 1)
                    ->count();
                $total_leads += $allLeadsStatus[$lead_status->status];
            }else{
                $allLeadsStatus[$lead_status->status] = DB::table('users')
                    ->when(!empty($my_branch), function ($query) use ($my_branch) {
                        return $query->whereIn('branch', $my_branch);
                    })
                    ->when(!empty($userid), function ($query) use ($userid) {
                        return  $query->whereIn('assigned_to', $this->related_reporting_ids);
                    })
                    //->where('id', $lead_status->id)
                    ->where('lead_status', $lead_status->status)
                    ->where('deleted_at', '=', null)
                    ->where('is_lead', '=', 1)
                    ->count();
                $total_leads += $allLeadsStatus[$lead_status->status];
            }
        }

        $myOpenLeads = 0;

        $myOpenLeadStatus = [];
        foreach($other_lead_status as $lead_status){
            if( $lead_status->status == $converted_lead_status){
                $myOpenLeadStatus[$lead_status->status] = DB::table('users')
                    ->when(!empty($my_branch), function ($query) use ($my_branch) {
                        return $query->whereIn('branch', $my_branch);
                    })
                    ->when(!empty($userid), function ($query) use ($userid) {
                        return  $query->whereIn('assigned_to', $this->related_reporting_ids);
                    })
                    ->where('lead_status', $lead_status->status)
                    ->where('deleted_at', '=', null)
                    ->where('is_lead', '=', 0)
                    ->where('assigned_to', '=', auth()->user()->id)
                    ->count();
                $myOpenLeads += $myOpenLeadStatus[$lead_status->status];
            }else{
                $myOpenLeadStatus[$lead_status->status] = DB::table('users')
                    ->when(!empty($my_branch), function ($query) use ($my_branch) {
                        return $query->whereIn('branch', $my_branch);
                    })
                    ->when(!empty($userid), function ($query) use ($userid) {
                        return  $query->whereIn('assigned_to', $this->related_reporting_ids);
                    })
                    ->where('lead_status', $lead_status->status)
                    ->where('deleted_at', '=', null)
                    ->where('is_lead', '=', 1)
                    ->where('assigned_to', '=', auth()->user()->id)
                    ->count();
                $myOpenLeads += $myOpenLeadStatus[$lead_status->status];
            }
        }

        $allApplicationStatus = [];
        $get_application_statuses = get_application_statuses();
        foreach($get_application_statuses as $status){
            $allApplicationStatus[$status->status_name] = DB::table('university_application')
                ->join('users', 'users.id', '=', 'university_application.userid')
                ->when(!empty($userid), function ($query) use ($userid) {
                    return  $query->whereIn('university_application.assign_to', $this->related_reporting_ids);
                })
                ->when(!empty($my_branch), function ($query) use ($my_branch) {
                    return $query->whereIn('users.branch', $my_branch);
                })
                ->where('status', $status->status_name)
                ->where('users.deleted_at', null)
                ->count();
        }

        $allStudentStatus = [];
        $get_overseas_status_list = get_overseas_status_list();
        foreach($get_overseas_status_list as $stu_status){
            $allStudentStatus[$stu_status->status] = User::whereHas('roles', function ($q) {
                $q->whereIn('name', ['user']);
            })
            ->active()
            ->when(!empty($my_branch), function ($query) use ($my_branch) {
                return $query->whereIn('users.branch', $my_branch);
            })
            ->when(!empty($userid), function ($query) use ($userid) {
                return  $query->whereIn('assigned_to', $this->related_reporting_ids);
            })
            ->where('overseas_status', $stu_status->status)
            ->where('users.deleted_at', null)
            ->where('is_lead',0)
            ->count();
        }

        //Applications
        $appl_total = DB::table('university_application')
            ->join('users', 'users.id', '=', 'university_application.userid')
            ->when(!empty($userid), function ($query) use ($userid) {
                return  $query->whereIn('university_application.assign_to', $this->related_reporting_ids);
            })
            ->when(!empty($my_branch), function ($query) use ($my_branch) {
                return $query->whereIn('users.branch', $my_branch);
            })
            ->where('users.deleted_at', null)
            ->count();

        $ticket_new = DB::table('tickets')
            ->join('users', 'users.id', '=', 'tickets.userid')
            ->when(!empty($my_branch), function ($query) use ($my_branch) {
                return $query->whereIn('users.branch', $my_branch);
            })
            ->where('status', '=', 'new')
            ->count();

        $ticket_new_my = DB::table('tickets')
            ->join('users', 'users.id', '=', 'tickets.userid')
            ->when(!empty($my_branch), function ($query) use ($my_branch) {
                return $query->whereIn('users.branch', $my_branch);
            })
            ->where('status', '=', 'new')
            ->where('tickets.assigned_to', '=', auth()->user()->id)
            ->count();

        $ticket_cust = DB::table('tickets')
            ->join('users', 'users.id', '=', 'tickets.userid')
            ->when(!empty($my_branch), function ($query) use ($my_branch) {
                return $query->whereIn('users.branch', $my_branch);
            })
            ->where('status', '=', 'customer_reply')
            ->count();

        $ticket_cust_my = DB::table('tickets')
            ->join('users', 'users.id', '=', 'tickets.userid')
            ->when(!empty($my_branch), function ($query) use ($my_branch) {
                return $query->whereIn('users.branch', $my_branch);
            })
            ->where('status', '=', 'customer_reply')
            ->where('tickets.assigned_to', '=', auth()->user()->id)
            ->count();

        $ticket_inprogress = DB::table('tickets')
            ->join('users', 'users.id', '=', 'tickets.userid')
            ->when(!empty($my_branch), function ($query) use ($my_branch) {
                return $query->whereIn('users.branch', $my_branch);
            })
            ->where('status', '=', 'inprogress')
            ->count();

        $leads_created_labels = [];
        $leads_created_data = [];
        $date = new DateTime("-7 days");
        $interval = DateInterval::createFromDateString('1 day');
        for($i = 0; $i < 7; $i++) {
            $cur_mth = $date->add($interval);
            $leads_created = DB::table('users')
                ->when(!empty($userid), function ($query) use ($userid) {
                    return  $query->Where('assigned_to', '=', "$userid");
                })
                ->when(!empty($my_branch), function ($query) use ($my_branch) {
                    return $query->whereIn('users.branch', $my_branch);
                })
                ->Where('created_at', 'like', $cur_mth->format("Y-m-d")."%")
                ->where(function ($query) {
                    return $query->where('is_lead', 1)
                    ->orWhere(function ($query) {
                        return $query->where('is_lead', 0)->whereNotNull('lead_converted_date');
                    });
                })
                ->where('deleted_at', '=', null)
                ->where('archived', '=', 0)
                ->count();
            $leads_created_labels[] = "'".$cur_mth->format('d')."'";
            $leads_created_data[] = $leads_created;
        }

        $students_created_labels = [];
        $students_created_data = [];
        $date = new DateTime("-14 days");
        $interval = DateInterval::createFromDateString('1 day');
        for($i = 0; $i < 14; $i++) {
            $cur_mth = $date->add($interval);
            $students_created = DB::table('users')
                ->when(!empty($userid), function ($query) use ($userid) {
                    return  $query->Where('assigned_to', '=', "$userid");
                })
                ->when(!empty($my_branch), function ($query) use ($my_branch) {
                    return $query->whereIn('users.branch', $my_branch);
                })
                ->Where('student_created_at', 'like', $cur_mth->format("Y-m-d")."%")
                ->where(function ($query) {
                    return $query->where('is_lead', 0);
                })
                ->where('deleted_at', '=', null)
                ->where('archived', '=', 0)
                ->count();

            $students_created_labels[] = "'".$cur_mth->format('d M')."'";
            $students_created_data[] = $students_created;
        }

        $applications_created_labels = [];
        $applications_created_data = [];
        $date = new DateTime("-7 days");
        $interval = DateInterval::createFromDateString('1 day');
        for($i = 0; $i < 7; $i++) {
            $cur_mth = $date->add($interval);
            $application_created = DB::table('university_application')
                ->when(!empty($userid), function ($query) use ($userid) {
                    return  $query->Where('assign_to', '=', "$userid");
                })
                ->Where('created_at', 'like', $cur_mth->format("Y-m-d")."%")
                ->count();

            $applications_created_labels[] = "'".$cur_mth->format('d')."'";
            $applications_created_data[] = $application_created;
        }

        $allOpenLeads = DB::table('users')
            ->when(!empty($my_branch), function ($query) use ($my_branch) {
                return $query->whereIn('branch', $my_branch);
            })
            ->when(!empty($userid), function ($query) use ($userid) {
                return  $query->whereIn('assigned_to', $this->related_reporting_ids);
            })
            ->where('lead_status', '!=', $converted_lead_status)
            ->where('lead_status', '!=', get_disqualified_lead_status())
            ->where('deleted_at', '=', null)
            ->where('archived', '=', 0)
            ->where('is_lead', '=', 1)
            ->count();
            
        $allStudents = User::whereHas('roles', function ($q) {
                $q->whereIn('name', ['user']);
            })
            ->active()
            ->when(!empty($userid), function ($query) use ($userid) {
                return  $query->whereIn('assigned_to', $this->related_reporting_ids);
            })
            ->when(!empty($my_branch), function ($query) use ($my_branch) {
                return $query->whereIn('branch', $my_branch);
            })
            ->where('deleted_at', '=', null)
            ->where('archived', '=', 0)
            ->where('is_lead', '=', 0)
            ->count();

        $allOpenApplications = DB::table('university_application')
            ->join('users', 'users.id', '=', 'university_application.userid')
            ->when(!empty($my_branch), function ($query) use ($my_branch) {
                return $query->whereIn('users.branch', $my_branch);
            })
            ->when(!empty($userid), function ($query) use ($userid) {
                return  $query->whereIn('university_application.assign_to', $this->related_reporting_ids);
            })
            ->whereNull('users.deleted_at')
            ->where('users.archived', "0")
            ->where('university_application.status', "!=", get_case_close_success_application_status())
            ->where('university_application.status', "!=", get_case_close_rejected_application_status())
            ->count();

        $allOpenTickets = DB::table('tickets')
            ->join('users', 'users.id', '=', 'tickets.userid')
            ->when(!empty($my_branch), function ($query) use ($my_branch) {
                return $query->whereIn('users.branch', $my_branch);
            })
            ->when(!empty($userid), function ($query) use ($userid) {
                return  $query->Where('tickets.assigned_to', '=', "$userid");
            })
            ->whereNull('users.deleted_at')
            ->where('users.archived', "0")
            ->where('status', "new")
            ->count();


        $working = $work_completed = false;
        $startsec = "";
        if(StaffAttendance::where('staff_id', \Auth::user()->id)->where('clock_in', 'like', date("Y-m-d")."%")->exists()) {
            $working = true;
            if(!StaffAttendance::where('staff_id', \Auth::user()->id)->where('clock_out', 'like', date("Y-m-d")."%")->exists()) {
                $work_completed = false;
                $working = true;
                $entry = StaffAttendance::where('staff_id', \Auth::user()->id)->where('clock_in', 'like', date("Y-m-d")."%")->first();
                $work_time = time() - strtotime($entry->clock_in);
            } else {
                //Staff has clockout for the day
                $work_completed = true;
                $entry = StaffAttendance::where('staff_id', \Auth::user()->id)->where('clock_in', 'like', date("Y-m-d")."%")->first();
                $out_entry = StaffAttendance::where('staff_id', \Auth::user()->id)->where('clock_out', 'like', date("Y-m-d")."%")->first();
                $work_time = strtotime($out_entry->clock_out) - strtotime($entry->clock_in);
            }
            $startsec = $work_time;
            // echo $startsec;
            // exit();
        } else {
            //Staff has not yet clocked in today
            $working = false;
        }

        $student_total = User::whereHas('roles', function ($q) {
                $q->whereIn('name', ['user']);
            })
            ->active()
            ->when(!empty($my_branch), function ($query) use ($my_branch) {
                return $query->whereIn('users.branch', $my_branch);
            })
            // ->whereIn('student_type', ['study_abroad', 'study_abroad_course'])
            ->where('is_lead',0)
            ->count();

        // Get the logged queries
        $queries = DB::getQueryLog();

        // Count the queries
        $queryCount = count($queries);
        \Log::debug(end($queries));
        \Log::debug("DASHBOARD DATABASE QUERY COUNT: " . $queryCount);

        return view('backend.dashboard', compact(
            'working',
            'work_completed',
            'startsec',
            'allOpenLeads',
            'allStudents',
            'allOpenApplications',
            'allOpenTickets',
            'reminderData',
            'branch',
            'today_followups',
            'future_followups',
            'due_followups',
            'student_total',

            'future_stu_followups',
            'due_stu_followups',
            // 'today_counselling',
            'today_stu_followups',
            'current_branch',

            'allLeadsStatus',
            'myOpenLeads',
            'total_leads',
            'myOpenLeadStatus',

            'appl_total',

            'allApplicationStatus',
            'allStudentStatus',

            'ticket_new',
            'ticket_new_my',
            'ticket_cust',
            'ticket_cust_my',
            'ticket_inprogress',

            'leads_created_labels',
            'leads_created_data',
            'students_created_labels',
            'students_created_data',
            'applications_created_labels',
            'applications_created_data',

        ));
    }


    public function agentIndex()
    {
        $my_id = \Auth::user()->id;

        $appl_total = DB::table('university_application')
            ->join('users', 'users.id', '=', 'university_application.userid')
            ->where('users.agent_id', '=', $my_id)
            ->count();

        $allApplicationStatus = [];
        $get_application_statuses = get_application_statuses();
        foreach($get_application_statuses as $status){
                $allAgentApplicationStatus[$status->status_name] = DB::table('university_application')
                ->join('users', 'users.id', '=', 'university_application.userid')
                // ->when(!empty($my_branch), function ($query) use ($my_branch) {
                //     return $query->whereIn('users.branch', $my_branch);
                // })
                ->where('users.agent_id', '=', $my_id)
                ->where('status', $status->status_name)
                ->where('users.deleted_at', null)
                ->count();
        }

        //Study Abroad Students

        $allStudentStatus = [];
        $get_overseas_status_list = get_overseas_status_list();
        foreach($get_overseas_status_list as $stu_status){
            $allStudentStatus[$stu_status->status] = User::whereHas('roles', function ($q) {
                $q->whereIn('name', ['user']);
            })
            ->active()
            ->where('users.agent_id', '=', $my_id)
            ->where('overseas_status', $stu_status->status)
            ->where('users.deleted_at', null)
            ->where('is_lead',0)
            ->count();
        }

        // $student_docs = User::whereHas('roles', function ($q) {
        //     $q->whereIn('name', ['user']);
        // })
        // ->active()
        // ->where('users.agent_id', '=', $my_id)
        // ->where('overseas_status', 'Documents')
        // ->where('is_lead',0)
        // ->count();

        // $student_appl_processing = User::whereHas('roles', function ($q) {
        // $q->whereIn('name', ['user']);
        // })
        // ->active()
        // ->where('users.agent_id', '=', $my_id)
        // ->where('overseas_status', 'Application Processing')
        // ->where('is_lead',0)
        // ->count();

        // $student_admission_complete = User::whereHas('roles', function ($q) {
        //     $q->whereIn('name', ['user']);
        // })
        // ->active()
        // ->where('users.agent_id', '=', $my_id)
        // ->where('overseas_status', 'Admission Complete')
        // ->where('is_lead',0)
        // ->count();

        // $student_reject_cancel = User::whereHas('roles', function ($q) {
        //     $q->whereIn('name', ['user']);
        // })
        // ->active()
        // ->where('users.agent_id', '=', $my_id)
        // ->where('overseas_status', 'Application Rejected/Cancelled')
        // ->where('is_lead',0)
        // ->count();

        $student_total = User::whereHas('roles', function ($q) {
            $q->whereIn('name', ['user']);
        })
        ->active()
        ->where('users.agent_id', '=', $my_id)
        ->where('is_lead',0)
        ->count();

        // $student_docs = DB::table('users')
        //     ->where('users.agent_id', '=', $my_id)
        //     ->whereIn('student_type', ['study_abroad', 'study_abroad_course'])
        //     ->where('overseas_status', 'Documents')
        //     ->where('is_lead',0)
        //     ->count();

        // $student_appl_processing = DB::table('users')
        //     ->where('users.agent_id', '=', $my_id)
        //     ->whereIn('student_type', ['study_abroad', 'study_abroad_course'])
        //     ->where('overseas_status', 'Application Processing')
        //     ->where('is_lead',0)
        //     ->count();

        // $student_admission_complete = DB::table('users')
        //     ->where('users.agent_id', '=', $my_id)
        //     ->whereIn('student_type', ['study_abroad', 'study_abroad_course'])
        //     ->where('overseas_status', 'Admission Complete')
        //     ->where('is_lead',0)
        //     ->count();

        // $student_reject_cancel = DB::table('users')
        //     ->where('users.agent_id', '=', $my_id)
        //     ->whereIn('student_type', ['study_abroad', 'study_abroad_course'])
        //     ->where('overseas_status', 'Application Rejected/Cancelled')
        //     ->where('is_lead',0)
        //     ->count();

        // $student_total = DB::table('users')
        //     ->where('users.agent_id', '=', $my_id)
        //     ->whereIn('student_type', ['study_abroad', 'study_abroad_course'])
        //     ->where('is_lead',0)
        //     ->count();


        $agent_details = AgentDetails::where('agent_id', \Auth::user()->id)->first();
		if(!$agent_details){
			$agent_details = AgentDetails::create([
				'agent_id' => \Auth::user()->id,
			]);
			$agent_details->save();
		}

        $current_date = date("Y-m-d H:i:s");
        $announcements = Announcements::where('area', '=', 'agent')->where('published_at', '<', $current_date)->orderBy('created_at', 'DESC')->limit(5)->get();

        return view('backend.agent_dashboard', compact(
            'appl_total',
            'agent_details',
            'allAgentApplicationStatus',

            'allStudentStatus',
            'student_total',

            'announcements'
        ));
    }

    public function showMessage()
    {
        return view('backend.show_message');
    }

    public function announcementsAgent($id)
    {
        // $ann = Announcements::orderBy('created_at', 'DESC')->get();
        $ann = Announcements::findOrFail($id);
        return view("backend.agent_announcements",compact("ann",));
    }

    public function announcementslist()
    {
        $current_date = date("Y-m-d H:i:s");
        $announcements = Announcements::where('area', '=', 'agent')->where('published_at', '<', $current_date)->orderBy('created_at', 'DESC')->get();
        return view("backend.announcementslist",compact("announcements"));
    }

    public function clockIn(Request $request) {
        DB::beginTransaction();
        if(StaffAttendance::where('staff_id', \Auth::user()->id)->where('clock_in', 'like', date("Y-m-d")."%")->exists()) {
            return json_encode(["status" => 0, "message" => "You have already clocked-in for the day!"]);
        } elseif(StaffAttendance::where('staff_id', \Auth::user()->id)->where('clock_out', 'like', date("Y-m-d")."%")->exists()) {
            return json_encode(["status" => 0, "message" => "You have clocked-out for the day! Cannot Clock-In!"]);
        } else {
            $details = "IP: ".$_SERVER['REMOTE_ADDR'].
            " User Agent: ".$_SERVER['HTTP_USER_AGENT'].
            " Screen: ".$request->input("screen").
            " Location: <a target='_blank' class='text-primary' href='https://www.google.com/maps/@".$request->input("lat").",".$request->input("long").",15.5z'>".$request->input("lat").",".$request->input("long")."</a>";
            
            StaffAttendance::create([
                "staff_id" => \Auth::user()->id,
                "date" => date("Y-m-d"),
                "clock_in" => date("Y-m-d H:i:s"),
                "ip" => $_SERVER['REMOTE_ADDR'],
                "lat" => $request->input("lat"),
                "long" => $request->input("long"),
                "details" => $details
            ]);
            DB::commit();
            echo json_encode(["status" => 1, "message" => "Clocked-in!"]);
        }
    }

    public function clockOut(Request $request) {
        if(!StaffAttendance::where('staff_id', \Auth::user()->id)->where('clock_in', 'like', date("Y-m-d")."%")->exists()) {
            return json_encode(["status" => 0, "message" => "You must be clocked-in first, to clock out!"]);
        } elseif(StaffAttendance::where('staff_id', \Auth::user()->id)->where('clock_out', 'like', date("Y-m-d")."%")->exists()) {
            return json_encode(["status" => 0, "message" => "You have already clocked-out for the day! Cannot Clock-Out!"]);
        } else {
            $details = "IP: ".$_SERVER['REMOTE_ADDR'].
            " User Agent: ".$_SERVER['HTTP_USER_AGENT'].
            " Screen: ".$request->input("screen").
            " Location: <a target='_blank' class='text-primary' href='https://www.google.com/maps/@".$request->input("lat").",".$request->input("long").",15.5z'>".$request->input("lat").",".$request->input("long")."</a>";

            StaffAttendance::create([
                "staff_id" => \Auth::user()->id,
                "date" => date("Y-m-d"),
                "clock_out" => date("Y-m-d H:i:s"),
                "ip" => $_SERVER['REMOTE_ADDR'],
                "lat" => $request->input("lat"),
                "long" => $request->input("long"),
                "details" => $details
            ]);
            echo json_encode(["status" => 1, "message" => "Clocked-out!"]);
        }
    }

    public function updateReferralCode() {
        \Log::debug("--------- UPDATE REFERRAL CODE FOR EXISTING USERS");
        $cnt = 0;
        $users = DB::table('users')
        ->whereNull('refcode')
        ->orWhere('refcode',"")
        ->get();
        foreach($users as $user) {
            \Log::debug("-Checking ".$user->first_name." (".$user->id.")");
            $refcode = generate_refcode($user->first_name);
            \Log::debug($user->first_name." (".$user->id.") SET REFCODE: ".$refcode);
            if(!$user->refcode) {
                DB::table('users')->where('id', $user->id)->update(['refcode' => $refcode]);
                $cnt++;
            }
        }
        echo $cnt." USER REFERRAL CODE UPDATED";
    }
}
