<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

/**
 * Class DemoClassController.
 */
class DemoClassController extends Controller {
   
    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('trainings configs'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }            
            return $next($request);
        });
    }

    /**
     * @return \Illuminate\View\View
     */
    public function index($folderid = 0) {

        $folders = array();
        $rows = DB::table('demo_class_category')->where('parent', $folderid)->get();
        if ($rows) {
            foreach ($rows as $row) {
                $folders[] = array("id" => $row->id, "name" => $row->name, "sharing" => $row->sharing);
            }
        }

        $cur_folder = $folderid;
        $folder_breadcrumb = array();
        $i = 0;
        while (true) {
            if ($cur_folder == 0) {
                $folder_breadcrumb[$i++] = array('id' => $cur_folder, 'name' => 'Top Level');
                break;
            } else {
                $row = DB::table('demo_class_category')->where('id', $cur_folder)->first();
                $folder_breadcrumb[$i++] = array('id' => $row->id, 'name' => $row->name);
                $cur_folder = $row->parent;
            }
        }

        //docs
        $docs = array();
        if ($folderid > 0) {
            $rows = DB::table('demo_class_video')->where('folder', $folderid)->get();
            if ($rows) {
                foreach ($rows as $row) {
                    $description = $row->description;
                    if (strlen($description) > 200)
                        $description = substr($description, 0, 200) . "...";
                    $docs[] = array("id" => $row->id, "title" => $row->title, "file" => $row->file_url, "description" => $description);
                }
            }
        }

        return view('backend.democlass', ['folders' => $folders, 'docs' => $docs, 'folder_breadcrumb' => $folder_breadcrumb, 'current_folder' => $folderid]);
    }

    public function addfolder(Request $request) {
        //\Log::debug("::addfolder::".$request->input('name')." parent:".$request->input('parent'));
        DB::table('demo_class_category')
                ->insert(
                        ['name' => $request->input('name'), 'sharing' => $request->input('sharing'), 'parent' => $request->input('parent')]
        );

        return redirect()->back()->withFlashSuccess("Category added successfully");
    }

    public function removefolder($id) {
        if (DB::table('demo_class_category')->where('id', $id)->exists()) {
            if (DB::table('demo_class_video')->where('folder', $id)->exists()) {
                return redirect()->back()->withFlashDanger("This category has documents. First remove documents.");
            } else {
                DB::table('demo_class_category')->where('id', $id)->delete();
                return redirect()->back()->withFlashSuccess("Category removed successfully");
            }
        }
    }

    public function adddoc(Request $request) {
        if (!$request->input('parent') > 0) {
            return redirect()->route('admin.democlass', $request->parent)->withFlashDanger("Uploading documents to Top Level not allowed");
        }

        DB::table('demo_class_video')
                ->insert(
                        ['title' => $request->input('title'), 'file_url' => $request->input('file'), 'folder' => $request->input('parent'), 'description' => $request->input('description')]
        );
        return redirect()->back()->withFlashSuccess("Document added successfully");
    }

    public function removedoc($id) {
        if (DB::table('demo_class_video')->where('id', $id)->exists()) {
            DB::table('demo_class_video')->where('id', $id)->delete();
            return redirect()->back()->withFlashSuccess("Document removed successfully");
        }
    }


}
