<?php
namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Auth\Products;
use App\Models\Auth\ProductCategories;
use App\Models\Auth\Categories;
use App\Models\Auth\ProductImages;
use App\Models\Auth\CurrencyRate;
use App\Models\Auth\ProductDownloads;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Log;
use Response;
use File;
use Yajra\DataTables\DataTables;

class DownloadManagementController extends Controller
{
    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('shop-management'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }
            return $next($request);
        });
    }
   
    public function index()
    { 
       return view("backend.download-management.index"); 
    }

    public function downloads_list(){
        $data = ProductDownloads::latest()->get();
        return Datatables::of($data)
        ->addColumn('action', function($data){
                return view('backend.download-management.btn',compact('data'));
        })
        ->rawColumns(['action'])
        ->make(true);
    }

    public function create_downloads(){
       return view("backend.download-management.create-download");
    }

    public function save_downloads(Request $request){
       $this->validate($request,[
            'name'=>'required|max:200',
            'file'=>'mimes:pdf,docx,doc,zip|max:102400',
        ]
        );

        if ($request->hasFile('file')) {
            $filenameWithExt = $request->file('file')->getClientOriginalName();
            // Get Filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $extension = $request->file('file')->getClientOriginalExtension();
            // Filename To store
            $fileNameToStore = $filename. '_'. time().'.'.$extension;
            $request->file->move('storage/downloads', $fileNameToStore);
        }
        $product = new ProductDownloads();
        $product->name = $request->name;
        $product->file = $fileNameToStore;
        $product->save();
        return redirect()->route('admin.downloads-management')->withFlashSuccess("New Download Added!");
    }

    public function download_file($id){
    	  $fil  = ProductDownloads::where('id','=',$id)->first();
          $filename = $fil->file;
          $file_path = 'storage/downloads/'. $filename;
          return Response::download($file_path, $filename, [
            'Content-Length: '. filesize($file_path)
        ]);
    }


    public function remove_download($id){
    	$fil  = ProductDownloads::where('id','=',$id)->first();

    	if ($fil->product_id == '') {
    		File::delete("storage/downloads/".$fil->file);
	    	ProductDownloads::where('id','=',$id)->delete();
	        return redirect()->route('admin.downloads-management')->withFlashSuccess("Download Removed!");
    	}else{
	        return redirect()->route('admin.downloads-management')->withFlashSuccess("You Cant remove this, While Associated with others!!");
    	}
    }

}
