<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Repositories\Backend\Auth\UserRepository;
use App\Models\Auth\User;
use App\Models\Auth\Invoice;
use App\Models\Auth\InvoiceItems;
use App\Models\Auth\InvoicePayment;
use App\Models\Auth\UniInvoiceDetail;
use App\Models\Auth\UniInvoice;
use App\Models\Auth\Universities;
use App\Models\Auth\UniApplyAgents;
use App\Models\Auth\UniInvoicePayment;
use PDF;
use Illuminate\Support\Facades\Mail;
use Dacastro4\LaravelGmail\Services\Message\Mail as Gmail;

/**
 * Class DownloadsController.
 */
class DownloadsController extends Controller
{

    public function __construct(UserRepository $userRepository)
    {
        $this->userRepository = $userRepository;
        $this->middleware(function ($request, $next) {
            if (!(\Auth::user()->isAdmin() || \Auth::user()->isAgent() || \Auth::user()->can('students'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }
            return $next($request);
        });
    }    

    public function user_alldocs(Request $request)
    {
        $uid = $request->input('uid');
        $user = User::findOrFail($uid);
        if (\Auth::user()->isAgent() && $user->agent_id != \Auth::user()->id) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }        

        \Log::debug("DOWNLOAD docs of user:$uid");
        $zip = new \ZipArchive();
        $filename = storage_path()."/app/public/tmp/".$uid . "-docs.zip";
        \Log::debug("Creating tmp: ".$filename);

        if ($zip->open($filename, \ZipArchive::CREATE) !== TRUE) {
            exit("Cannot Create Zip File $filename");
        }
        $zip->addEmptyDir("edu");
        $zip->addEmptyDir("lang");
        $zip->addEmptyDir("other");

        $row = DB::table('user_documents')->where('userid', $uid)->first();
        if ($row) {
            if ($row->class10) {
                $filepath = storage_path("app/public/" . $row->class10);
                \Log::debug("Class10:$filepath");
                if(file_exists( $filepath)){
                    $zip->addFile($filepath, "edu/10th-Cert-" . substr($row->class10, 5));
                }
            }
            if ($row->class10_marks_sheet) {
                $filepath = storage_path("app/public/" . $row->class10_marks_sheet);
                \Log::debug("Class10:$filepath");
                if(file_exists( $filepath)){
                $zip->addFile($filepath, "edu/10th-Marks-" . substr($row->class10_marks_sheet, 5));
                }
            }

            if ($row->class12) {
                $filepath = storage_path("app/public/" . $row->class12);
                if(file_exists( $filepath)){
                $zip->addFile($filepath, "edu/12th-Cert-" . substr($row->class12, 5));
                }
            }
            if ($row->class12_marks_sheet) {
                $filepath = storage_path("app/public/" . $row->class12_marks_sheet);
                if(file_exists( $filepath)){
                $zip->addFile($filepath, "edu/12th-Marks-" . substr($row->class12_marks_sheet, 5));
                }
            }

            if ($row->diploma) {
                $filepath = storage_path("app/public/" . $row->diploma);
                if(file_exists( $filepath)){
                $zip->addFile($filepath, "edu/Diploma-Cert-" . substr($row->diploma, 5));
                }
            }
            if ($row->diploma_marks_sheet) {
                $filepath = storage_path("app/public/" . $row->diploma_marks_sheet);
                if(file_exists( $filepath)){
                $zip->addFile($filepath, "edu/Diploma-Marks-" . substr($row->diploma_marks_sheet, 5));
                }
            }

            if ($row->grad_degree) {
                $filepath = storage_path("app/public/" . $row->grad_degree);
                if(file_exists( $filepath)){
                $zip->addFile($filepath, "edu/Graduation-Cert-" . substr($row->grad_degree, 5));
                }
            }
            if ($row->grad_transcripts) {
                $filepath = storage_path("app/public/" . $row->grad_transcripts);
                if(file_exists( $filepath)){
                $zip->addFile($filepath, "edu/Graducation-Marks-" . substr($row->grad_transcripts, 5));
                }
            }
            if ($row->grad_provisional) {
                $filepath = storage_path("app/public/" . $row->grad_provisional);
                if(file_exists( $filepath)){
                $zip->addFile($filepath, "edu/Graducation-Provisional-" . substr($row->grad_provisional, 5));
                }
            }            
            if ($row->grad_all_sem) {
                $filepath = storage_path("app/public/" . $row->grad_all_sem);
                if(file_exists( $filepath)){
                $zip->addFile($filepath, "edu/Graduation-AllSem-" . substr($row->grad_all_sem, 5));
                }
            }

            if ($row->pg_degree) {
                $filepath = storage_path("app/public/" . $row->pg_degree);
                if(file_exists( $filepath)){
                $zip->addFile($filepath, "edu/PG-Degree-" . substr($row->pg_degree, 5));
                }
            }
            if ($row->pg_transcripts) {
                $filepath = storage_path("app/public/" . $row->pg_transcripts);
                if(file_exists( $filepath)){
                $zip->addFile($filepath, "edu/PG-Marks-" . substr($row->pg_transcripts, 5));
                }
            }
            if ($row->pg_provisional) {
                $filepath = storage_path("app/public/" . $row->pg_provisional);
                if(file_exists( $filepath)){
                $zip->addFile($filepath, "edu/PG-Provisional-" . substr($row->pg_provisional, 5));
                }
            }            
            if ($row->pg_all_sem) {
                $filepath = storage_path("app/public/" . $row->pg_all_sem);
                if(file_exists( $filepath)){
                $zip->addFile($filepath, "edu/PG-AllSem-" . substr($row->pg_all_sem, 5));
                }
            }

            //Languages
            if ($row->lang_ielts) {
                $filepath = storage_path("app/public/" . $row->lang_ielts);
                if(file_exists( $filepath)){
                $zip->addFile($filepath, "lang/IELTS-" . substr($row->lang_ielts, 5));
                }
            }
            if ($row->lang_pte) {
                $filepath = storage_path("app/public/" . $row->lang_pte);
                if(file_exists( $filepath)){
                $zip->addFile($filepath, "lang/PTE-" . substr($row->lang_pte, 5));
                }
            }
            // if ($row->lor) {
            //     $filepath = storage_path("app/public/" . $row->lor);
            //     $zip->addFile($filepath, "lang/LOR-" . substr($row->lor, 5));
            // }
            // if ($row->sop) {
            //     $filepath = storage_path("app/public/" . $row->sop);
            //     $zip->addFile($filepath, "lang/SOP-" . substr($row->sop, 5));
            // }
            // if ($row->letter_recom) {
            //     $filepath = storage_path("app/public/" . $row->letter_recom);
            //     $zip->addFile($filepath, "lang/Recommendation-" . substr($row->letter_recom, 5));
            // }
            if ($row->gre) {
                $filepath = storage_path("app/public/" . $row->gre);
                if(file_exists( $filepath)){
                $zip->addFile($filepath, "lang/GRE-" . substr($row->gre, 5));
                }
            }
            if ($row->gmat) {
                $filepath = storage_path("app/public/" . $row->gmat);
                if(file_exists($filepath)){
                $zip->addFile($filepath, "lang/GMAT-" . substr($row->gmat, 5));
                }
            }
            if ($row->duolingo) {
                $filepath = storage_path("app/public/" . $row->duolingo);
                if(file_exists( $filepath)){
                $zip->addFile($filepath, "lang/DUOLINGO-" . substr($row->duolingo, 5));
                }
            }            
        }
        //Professional docs
        $rows = DB::table('user_docs_other')->where('userid', $uid)->get();
        if ($rows) {
            foreach ($rows as $row) {
                $filepath = storage_path("app/public/" . $row->file);
                \Log::debug("Download Other Docs File name: ".$row->file);
                if(file_exists( $filepath)){
                $zip->addFile($filepath, "other/" .ucfirst($row->doc_type)."-". substr($row->file, 5));
                }
                // if ($row->doc_type == 'internship') {
                //     $filepath = storage_path("app/public/" . $row->file);
                //     $zip->addFile($filepath, "prof/Internship-" . substr($row->file, 5));
                // } elseif ($row->doc_type == 'offer') {
                //     $filepath = storage_path("app/public/" . $row->file);
                //     $zip->addFile($filepath, "prof/Offer-" . substr($row->file, 5));
                // } elseif ($row->doc_type == 'experience') {
                //     $filepath = storage_path("app/public/" . $row->file);
                //     $zip->addFile($filepath, "prof/Experience-" . substr($row->file, 5));
                // } elseif ($row->doc_type == 'payslip') {
                //     $filepath = storage_path("app/public/" . $row->file);
                //     $zip->addFile($filepath, "prof/Payslip-" . substr($row->file, 5));
                // } elseif ($row->doc_type == 'other') {
                //     $filepath = storage_path("app/public/" . $row->file);
                //     $zip->addFile($filepath, "prof/Other-" . substr($row->file, 5));
                // }
            }
        }
        $zip->close();
        header('Content-Type: application/zip');
        header('Content-Disposition: attachment; filename="' . basename($filename) . '"');
        header('Content-Length: ' . filesize($filename));

        flush();
        readfile($filename);
        unlink($filename);
    }

    public function user_profile_pdf(Request $request){
        //this feature is not used
        
        $userid = $request->input('uid');
        $user = User::findOrFail($userid);
        if (\Auth::user()->isAgent() && $user->agent_id != \Auth::user()->id) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
        }

        $user = (new UserRepository())->where('id', $userid)->first();
        $filename = $user->first_name;
        $userDetails = DB::table('user_details')->where('userid', $user->id)->first();
        $pdf = PDF::loadView('backend.profile_pdf', ['user' => $user, 'userDetails' => $userDetails]);
        return $pdf->download($filename . ".pdf");
    }

    public function invoice_pdf($id)
    {
        $invoice = Invoice::find($id);
        $stuData = User::find($invoice->student_id);
        $payments = InvoicePayment::where('invoice_id', $invoice->id)->get();
        $total_payment = InvoicePayment::where('invoice_id', $invoice->id)->sum('amount');
        $invoice_items = InvoiceItems::where("invoice_id", $invoice->id)->get();
        $filename = "Invoice_" . $invoice->invoice_num;

        $pdf = PDF::loadView('backend.invoice_pdf', ['invoice' => $invoice, 'stuData' => $stuData, 'payments' => $payments, 'total_payment' => $total_payment, 'invoice_items' => $invoice_items]);
        return $pdf->stream($filename . ".pdf");
    }



    public function uni_invoice_pdf($id)
    {
        $invoice = UniInvoice::find($id);
        $invoiceDetails = UniInvoiceDetail::join('university_application', 'uni_invoice_detail.uni_application_id', '=', 'university_application.id')->where('invoice_id',$invoice->id)->get(['uni_invoice_detail.*','university_application.intake','university_application.year','university_application.course_pref_id','university_application.appl_id']);
        $uniData = Universities::find($invoice->university_id);
        $payments = UniInvoicePayment::where('invoice_id', $invoice->id)->get();
        $total_payment = UniInvoicePayment::where('invoice_id', $invoice->id)->sum('amount');
        $filename = "University_invoice_" . $invoice->invoice_num;

        $pdf = PDF::loadView('backend.uni_invoice_pdf', ['invoice' => $invoice,'invoiceDetails' => $invoiceDetails, 'uniData' => $uniData, 'payments' => $payments, 'total_payment' => $total_payment]);
        return $pdf->stream($filename . ".pdf");
    }

    public function ad_hoc_invoice_pdf($id)
    {
        $invoice = UniInvoice::find($id);
        $uniData = Universities::find($invoice->university_id);
        $payments = UniInvoicePayment::where('invoice_id', $invoice->id)->get();
        $total_payment = UniInvoicePayment::where('invoice_id', $invoice->id)->sum('amount');
        $filename = "Ad_hoc_invoice_" . $invoice->invoice_num;

        $pdf = PDF::loadView('backend.adhoc_invoice_pdf', ['invoice' => $invoice, 'uniData' => $uniData, 'payments' => $payments, 'total_payment' => $total_payment]);
        return $pdf->stream($filename . ".pdf");
    }

    public function uni_apply_agent_invoice_pdf($id)
    {
        $invoice = UniInvoice::find($id);
        $invoiceDetails = UniInvoiceDetail::join('university_application', 'uni_invoice_detail.uni_application_id', '=', 'university_application.id')->where('invoice_id',$invoice->id)->get(['uni_invoice_detail.*','university_application.intake','university_application.year','university_application.course_pref_id','university_application.appl_id','university_application.university']);
        $agentData = UniApplyAgents::where('id', $invoice->uni_apply_agent_id)->first();
        $payments = UniInvoicePayment::where('invoice_id', $invoice->id)->get();
        $total_payment = UniInvoicePayment::where('invoice_id', $invoice->id)->sum('amount');
        $filename = "Uni_apply_agent_invoice_" . $invoice->invoice_num;

        $pdf = PDF::loadView('backend.uni_apply_agent_invoice_pdf', ['invoice' => $invoice,'invoiceDetails' => $invoiceDetails, 'agentData' => $agentData, 'payments' => $payments, 'total_payment' => $total_payment]);
        return $pdf->stream($filename . ".pdf");
    }

    public function email_invoice_pdf($id)
    {
        $invoice = Invoice::find($id);
        $invoice_items = InvoiceItems::where("invoice_id", $invoice->id)->get();
        $stuData = User::find($invoice->student_id);
        $payments = InvoicePayment::where('invoice_id', $invoice->id)->get();
        $total_payment = InvoicePayment::where('invoice_id', $invoice->id)->sum('amount');

        $filename = "Invoice_" . $invoice->invoice_num.".pdf";

        if ($stuData->email) {
            $user['to'] = $stuData->email;
            $user['subject'] = "Invoice";
            $data = ['invoice' => $invoice, 'invoice_items' => $invoice_items, 'stuData' => $stuData, 'payments' => $payments, 'total_payment' => $total_payment];
            $pdf = PDF::loadView('backend.invoice_pdf', $data);
            try{
                if(get_site_config('smtp_type')== 'google'){
                    $mail = new Gmail(null, false, 1);
                    $mail->to($user['to'], $name = null );
                    $mail->from(get_site_config('google_email_id'), get_site_config('google_email_from_name'));
                    $mail->subject($user['subject']);
                    //$mail->message($messages);
                   // $content = $pdf->download()->getOriginalContent();
                    $path = storage_path()."/app/public/email_attachments/";
                    $pdf->save($path.'/'.$filename);
                    //\Storage::put('/email_attachments/'.$filename,$content);
                    $mail->attach(storage_path()."/app/public/email_attachments/".$filename);
                    $mail->view('email.invoice',['invoice' => $invoice, 'stuData' => $stuData, 'payments' => $payments, 'total_payment' => $total_payment]);
                    $mail->send();
                    \Log::debug("user_notify - Sending Mail from Gmail API. TO:".$user['to']." SUBJECT:".$user['subject']); 
                    //return "Sent!";
                }
                if(get_site_config('smtp_type')== 'smtp_server'){
                    Mail::send('email.invoice', $data, function ($messages) use ($user, $filename, $pdf) {
                        $messages->to($user['to']);
                        $messages->subject($user['subject']);
                        $messages->attachData($pdf->output(), $filename);
                    });
                }
            }catch (\Exception $e) {
                $message = $e->getMessage();
                \Log::debug("Mail Error: (Email Invoice) ".$message);   
            }
            return redirect()->back()->withFlashSuccess('Email sent!');
        } else {
            return redirect()->back()->withFlashDanger('Email not found for this student.');
        }
    }
}
