<?php

namespace App\Http\Controllers\Backend;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Auth\User;
use App\Models\Auth\ApplicationStages;
use App\Models\Auth\ServiceStages;
use App\Models\Auth\MailSyncAccounts;
use Illuminate\Http\Request;
use Log;

class EmailSyncController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function email_sync()
    {
        $accounts = DB::table('mail_sync_accounts')->OrderBy('created_at','asc')->get();
        return view('backend.settings.email_sync', compact('accounts'));
    }

    public function email_sync_store(Request $request)
    {
        $request->validate([
            'username' => 'required',
            'password' => 'required',
            'imap_hostname' => 'required',
            'port' => 'required',
            'connection_type' => 'required',
        ]);

        $username = $request->username;
        $password = $request->password;
        $imap_hostname = $request->imap_hostname;
        $port = $request->port;
        $connection_type = $request->connection_type;

        $create_lead = ($request->create_lead) ? 1 : 0;
        $filter_condition = $request->filter_condition;
        $filter_val = $request->filter_val;


        DB::table('mail_sync_accounts')->insert([
            "imap_email" => $username, 
            "imap_password" => $password, 
            "imap_host"=> $imap_hostname, 
            "imap_port"=> $port, 
            "imap_connection" => $connection_type, 
            "create_lead" => $create_lead, 
            "filter_subject_type" => $filter_condition, 
            "filter_subject_value" => $filter_val, 
            "status" => 1
        ]);

        return redirect()->route("admin.email-sync")->withFlashSuccess("Email Account Added!");
    }

    public function email_sync_update(Request $request)
    {
        $acc = MailSyncAccounts::findOrFail($request->acc_id);
        $request->validate([
            'username' => 'required',
            'password' => 'required',
            'imap_hostname' => 'required',
            'port' => 'required',
            'connection_type' => 'required',
        ]);
       
        $acc->imap_email = $request->username;
        $acc->imap_password = $request->password;
        $acc->imap_host = $request->imap_hostname;
        $acc->imap_port = $request->port;
        $acc->imap_connection = $request->connection_type;
        $acc->create_lead = ($request->create_lead) ? 1 : 0;
        if($request->create_lead){
            $acc->filter_subject_type = $request->filter_condition;
            $acc->filter_subject_value = $request->filter_val;
        }else{
            $acc->filter_subject_type = null;
            $acc->filter_subject_value = null;
        }
        

        $acc->save();

        return redirect()->route("admin.email-sync")->withFlashSuccess("Email Account Updated!");
    }

    public function updateStatus(Request $request)
    {
      if (isset($request->id) && isset($request->status)) {
        $acc = MailSyncAccounts::findOrFail($request->id);
        $acc->status = $request->status;
        $acc->save();
        return response(["status" => 200, "message"=>"Status updated successfully"]); 
      }
    }

    public function destroy($id)
    {
        $stage = MailSyncAccounts::findOrFail($id);
        $stage->delete();
        return redirect()->route("admin.email-sync")->withFlashSuccess("Email Account Deleted!");
    }
}
