<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\Auth\User\ManageUserRequest;


class ExamController extends Controller
{

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $user = \Auth::user();
            if (!(\Auth::user()->isAdmin() || \Auth::user()->can('training exams'))) {
                return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this feature.');
            }            
            return $next($request);
        });
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index()
    {
        return view('backend.student_exam.student_exam');
    }



    public function ajaxexamresult(ManageUserRequest $request)
    {

        if (!$request->ajax()) {
            return redirect()->route('admin.dashboard.message')->withFlashDanger('You do not have access permission to this page.');
        }
        echo $this->getDatatableExamResult($request);
    }


    public function getDatatableExamResult($request)
    {

        $columns = array(
            0 => 'created_at',
            1 => 'first_name',
            3 => 'mobile',
            2 => 'code',
            4 => 'title',
            5 => 'score',
            6 => 'attempt',
            7 => 'type',
            8 => 'total_marks'
        );

        $totalData_arr = DB::table('users')
            ->join('student_exam_result', 'student_exam_result.student_id', '=', 'users.id')
            ->join('batch_students', 'batch_students.student', '=', 'student_exam_result.student_id')
            ->join('batch', 'batch.id', '=', 'batch_students.batch')
            ->join('courses', 'courses.id', '=', 'batch.course')
            ->join('exam', 'exam.id', '=', 'student_exam_result.exam_id')
            ->groupBy('student_exam_result.id')
            ->get();

        $totalFiltered = $totalData = count($totalData_arr);
        $limit = $request->input('length');
        $start = $request->input('start');
        $order = $columns[$request->input('order.0.column')];
        $dir = $request->input('order.0.dir');

        if (empty($request->input('search.value'))) {
            $users = DB::table('users')
                ->select(
                    'users.first_name',
                    'users.last_name',
                    'users.mobile',
                    'student_exam_result.*',
                    'batch_students.batch',
                    'batch.code',
                    'batch.mid_term_marks',
                    'batch.end_term_marks',
                    'courses.title',
                    'exam.type'
                )
                ->join('student_exam_result', 'student_exam_result.student_id', '=', 'users.id')
                ->join('batch_students', 'batch_students.student', '=', 'student_exam_result.student_id')
                ->join('batch', 'batch.id', '=', 'batch_students.batch')
                ->join('courses', 'courses.id', '=', 'batch.course')
                ->join('exam', 'exam.id', '=', 'student_exam_result.exam_id')
                ->groupBy('student_exam_result.id')
                ->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                ->get();
        } else {
            $get_search = $request->input('search.value');
            $users = DB::table('users')
                ->select(
                    'users.first_name',
                    'users.last_name',
                    'users.mobile',
                    'student_exam_result.*',
                    'batch_students.batch',
                    'batch.code',
                    'batch.mid_term_marks',
                    'batch.end_term_marks',
                    'courses.title',
                    'exam.type'
                )
                ->join('student_exam_result', 'student_exam_result.student_id', '=', 'users.id')
                ->join('batch_students', 'batch_students.student', '=', 'student_exam_result.student_id')
                ->join('batch', 'batch.id', '=', 'batch_students.batch')
                ->join('courses', 'courses.id', '=', 'batch.course')
                ->join('exam', 'exam.id', '=', 'student_exam_result.exam_id')
                ->where(function ($query) use ($get_search) {
                    $query->where('users.first_name', 'like', "%$get_search%")
                        ->orWhere('users.last_name', 'like', "%$get_search%")
                        ->orWhere('users.mobile', 'like', "%$get_search%")
                        ->orWhere('batch.code', 'like', "%$get_search%")
                        ->orWhere('student_exam_result.created_at', 'like', "%$get_search%")
                        ->orWhere('courses.title', 'like', "%$get_search%")
                        ->orWhere('exam.type', 'like', "%$get_search%")
                        ->orWhere('student_exam_result.attempt', 'like', "%$get_search%");
                })
                ->groupBy('student_exam_result.id')
                ->offset($start)
                ->limit($limit)
                ->orderBy($order, $dir)
                ->get();

            $totalFiltered_data = DB::table('users')
                ->join('student_exam_result', 'student_exam_result.student_id', '=', 'users.id')
                ->join('batch_students', 'batch_students.student', '=', 'student_exam_result.student_id')
                ->join('batch', 'batch.id', '=', 'batch_students.batch')
                ->join('courses', 'courses.id', '=', 'batch.course')
                ->join('exam', 'exam.id', '=', 'student_exam_result.exam_id')
                ->where(function ($query) use ($get_search) {
                    $query->where('users.first_name', 'like', "%$get_search%")
                        ->orWhere('users.last_name', 'like', "%$get_search%")
                        ->orWhere('users.mobile', 'like', "%$get_search%")
                        ->orWhere('batch.code', 'like', "%$get_search%")
                        ->orWhere('student_exam_result.created_at', 'like', "%$get_search%")
                        ->orWhere('courses.title', 'like', "%$get_search%")
                        ->orWhere('exam.type', 'like', "%$get_search%")
                        ->orWhere('student_exam_result.attempt', 'like', "%$get_search%");
                })
                ->groupBy('student_exam_result.id')
                ->get();
            $totalFiltered = count($totalFiltered_data);
        }

        $data = array();
        if (!empty($users)) {
            foreach ($users as $page) {
                $customResult['created_at'] = get_date_formated($page->created_at);
                $customResult['first_name'] = "<a target='_blank' href='" . route('admin.auth.user.show', $page->id) . "'><strong><span style='white-space:nowrap;'>".$page->first_name . ' ' . $page->last_name."</a>";
                $customResult['mobile'] = $page->mobile;
                $customResult['code'] = $page->code;
                $customResult['title'] = $page->title;
                $customResult['score'] = $page->score . '<br> Reading:' . $page->reading_marks . ' Writing:' . $page->writing_marks . ' Listening:' . $page->listening_marks;
                $customResult['attempt'] = $page->attempt;
                $customResult['type'] = $page->type;

                if ($page->type == 'mid') {
                    $customResult['total_marks'] = $page->mid_term_marks;
                } else if ($page->type == 'end') {
                    $customResult['total_marks'] = $page->end_term_marks;
                } else {
                    $customResult['total_marks'] = '';
                }


                $data[] = $customResult;
            }
        }

        $json_data = array(
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data"            => $data
        );

        return json_encode($json_data);
    }



    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function essay_exam()
    {
        $pages = DB::table('users')
            ->select(
                'users.first_name',
                'users.last_name',
                'users.mobile',
                'student_essay_exams.*',
                'batch_students.batch',
                'batch.code',
                'courses.title',
                'exam.type'
            )
            ->join('student_essay_exams', 'student_essay_exams.student_id', '=', 'users.id')
            ->join('batch_students', 'batch_students.student', '=', 'student_essay_exams.student_id')
            ->join('batch', 'batch.id', '=', 'batch_students.batch')
            ->join('courses', 'courses.id', '=', 'batch.course')
            ->join('exam', 'exam.id', '=', 'student_essay_exams.exam_id')
            ->orderBy('student_essay_exams.created_at', "DESC")
            ->groupBy('student_essay_exams.id')
            ->get();


        //dd($pages);
        return view('backend.student_exam.essay_exam', ['pages' => $pages]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function oral_exam(Request $request)
    {

        $pages = DB::table('student_marks AS t1')
            ->join('users AS t2', 't1.student_id', '=', 't2.id')
            ->join('exam_offline AS t3', 't3.batch_id', '=', 't1.batch_id')
            ->join('batch AS t4', 't4.id', '=', 't3.batch_id')
            ->join('courses AS t5', 't5.id', '=', 't4.course')
            ->select('t1.*', 't2.first_name', 't2.last_name', 't2.mobile', 't3.type', 't4.code', 't5.title')->get();
        // dd($data);


        // dd($pages);
        return view('backend.student_exam.oral_exam', ['pages' => $pages]);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
