<?php

namespace App\Http\Controllers\Backend;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Forms;
use App\Models\FormItem;
use App\Models\Auth\Country;
use Session;
use DB;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
class FormBuilderController extends Controller
{	

	public function index()
    {
        $forms = Forms::OrderBy('created_at','asc')->get();
		$branches = DB::table('branch')->get();
        return view('backend.settings.forms', compact('forms','branches'));
    }

	
	// public function create_form(){
	// 	$desiredForm = Forms::orderby('id')->first();
	// 		return view ('backend.settings.create_form',[
	// 			'menus' => Forms::all(),
	// 			'desiredForm' => $desiredForm,
	// 			//'menuitems' => $menuitems
	// 		]);
	// }



	public function store(Request $request){
		$data = $request->all(); 
		if(Forms::create($data)){ 
		  $newdata = Forms::orderby('id','DESC')->first();
		  return redirect()->route('admin.form-builder.edit-form',$newdata->id)->withFlashSuccess("Form created successfully! Add the required fields to the form.");            
		}else{
		  return redirect()->back()->with('error','Failed to save Form !');
		}
	  }	
	

	public function edit_form($id){
		$formitems = '';
		$desiredForm = '';  
		if(isset($id) && $id != 'new'){
			$desiredForm = Forms::where('id',$id)->first();
			if($desiredForm->content != ''){
				$formitems = json_decode($desiredForm->content);
				$formitems = $formitems[0]; 
				foreach($formitems as $form){
					$form->title = FormItem::where('id',$form->id)->value('title');
					$form->label = FormItem::where('id',$form->id)->value('label');
					$form->placeholder = FormItem::where('id',$form->id)->value('placeholder');
					$form->hint = FormItem::where('id',$form->id)->value('hint');
					$form->mandatory = FormItem::where('id',$form->id)->value('mandatory');
					$form->unique = FormItem::where('id',$form->id)->value('unique');
					$form->input_name = FormItem::where('id',$form->id)->value('input_name');
					$form->target = FormItem::where('id',$form->id)->value('target');
					$form->type = FormItem::where('id',$form->id)->value('type');
					// if(!empty($form->children[0])){
					// 	foreach ($form->children[0] as $child) {
					// 		$child->title = FormItem::where('id',$child->id)->value('title');
					// 		$form->label = FormItem::where('id',$form->id)->value('label');
					// 		$form->placeholder = FormItem::where('id',$form->id)->value('placeholder');
					// 		$child->input_name = FormItem::where('id',$child->id)->value('input_name');
					// 		$child->target = FormItem::where('id',$child->id)->value('target');
					// 		$child->type = FormItem::where('id',$child->id)->value('type');
					// 	}  
					// }
				}
			}else{
				$formitems = FormItem::where('form_id',$desiredForm->id)->get();                    
			}             
		}else{

			// $desiredForm = Forms::orderby('id')->first();
			// if($desiredForm){
			// 	if($desiredForm->content != ''){
			// 	$formitems = json_decode($desiredForm->content);
			// 	$formitems = $formitems[0]; 
			// 	foreach($formitems as $menu){
			// 		$menu->title = FormItem::where('id',$menu->id)->value('title');
			// 		$menu->name = FormItem::where('id',$menu->id)->value('name');
			// 		$menu->input_name = FormItem::where('id',$menu->id)->value('input_name');
			// 		$menu->target = FormItem::where('id',$menu->id)->value('target');
			// 		$menu->type = FormItem::where('id',$menu->id)->value('type');
			// 		if(!empty($menu->children[0])){
			// 			foreach ($menu->children[0] as $child) {
			// 				$child->title = FormItem::where('id',$child->id)->value('title');
			// 				$child->name = FormItem::where('id',$child->id)->value('name');
			// 				$child->input_name = FormItem::where('id',$child->id)->value('input_name');
			// 				$child->target = FormItem::where('id',$child->id)->value('target');
			// 				$child->type = FormItem::where('id',$child->id)->value('type');
			// 			}  
			// 		}
			// 	}
			// 	}else{
			// 		$formitems = FormItem::where('form_id',$desiredForm->id)->get();
			// 	}                                   
			// }           
		}

		//Checking custom attributes
		$custom_attributes = DB::table('custom_attributes')->get(["custom_attributes.*"]);
		// if(count($custom_attributes)){
		// 	foreach($custom_attributes as $attrs){
			
		// 		$name = $attrs->attr_name;
		// 		if($request->$name){
					
		// 			DB::table('custom_attributes')->where("attr_name",$name)->update(["web_to_lead"=>'1']);
		// 		}else{
		// 			DB::table('custom_attributes')->where("attr_name",$name)->update(["web_to_lead"=>'0']);
		// 		}
		// 	}
		// }
		//Checking custom attributes
		$branches = DB::table('branch')->get();
		return view ('backend.settings.edit_form',[
			'forms' => Forms::all(),
			'desiredForm' => $desiredForm,
			'formitems' => $formitems,
			'custom_attributes' => $custom_attributes,
			'branches' => $branches
		]);
	}	


	public function addItemToForm(Request $request){
		 //dd($request->all());
		$data = $request->all();
		$formid = $request->formid;
		$ids = $request->ids;
		$type = $request->type;
		// dd($data);
		$form = Forms::findOrFail($formid);
		if($form->content == ''){
			for($h=0; $h<count($ids);$h++){
				$data['title'] = ucfirst(str_replace("_"," ", $ids[$h]));
				$data['input_name'] = $ids[$h];
				$data['label'] = $data['title'];
				$data['type'] = $type[$h];
				$data['form_id'] = $formid;
				$data['updated_at'] = NULL;
				if($type[$h] == "custom_attr"){
					DB::table('custom_attributes')->where("attr_name",$ids[$h])->update(["web_to_lead"=>'1']);
				}
				FormItem::create($data);
				
			}
		}else{
			for($i=0; $i<count($ids);$i++){
			//foreach($ids as $id){
				$data['title'] = ucfirst(str_replace("_"," ", $ids[$i]));
				$data['input_name'] = $ids[$i];
				$data['label'] = $data['title'];
				$data['type'] = $type[$i];
				$data['form_id'] = $formid;
				$data['updated_at'] = NULL;
				if($type[$i] == "custom_attr"){
					DB::table('custom_attributes')->where("attr_name",$ids[$i])->update(["web_to_lead"=>'1']);
				}
				FormItem::create($data);
				
			}
			for($j=0; $j<count($ids);$j++){
				$olddata = json_decode($form->content,true); 
				$array['title'] = ucfirst(str_replace("_"," ", $ids[$j]));
				$array['input_name'] = $ids[$j];
				$array['label'] = $array['title'];
				$array['type'] = $type[$j];
				$array['target'] = NULL;
				$array['id'] = FormItem::where('input_name',$array['input_name'])
					->where('label',$array['label'])
					->where('type',$array['type'])
					->where('form_id',$formid)
					->orderby('id','DESC')
					->value('id');
				               
				//$array['children'] = [[]];
				array_push($olddata[0],$array);
				$olddata = json_encode($olddata);
				$form->update(['content'=>$olddata]);
			}
		}
	}


	public function addEnquiryToForm(Request $request){
		//dd($request->all());
	   $data = $request->all();
	   $formid = $request->formid;
	   $id = $request->id;
	   // dd($data);
	   $form = Forms::findOrFail($formid);
	   if($form->content == ''){
			   $data['title'] = ucfirst(str_replace("_"," ", $id));
			   $data['input_name'] = $id;
			   $data['label'] = $data['title'];
			   $data['type'] = "default_input";
			   $data['form_id'] = $formid;
			   $data['updated_at'] = NULL;
			   FormItem::create($data);  
	   }else{
			   $data['title'] = ucfirst(str_replace("_"," ", $id));
			   $data['input_name'] = $id;
			   $data['label'] = $data['title'];
			   $data['type'] = "default_input";
			   $data['form_id'] = $formid;
			   $data['updated_at'] = NULL;
			   FormItem::create($data);
			   
			   $olddata = json_decode($form->content,true); 
			   $array['title'] = ucfirst(str_replace("_"," ", $id));
			   $array['input_name'] = $id;
			   $array['label'] = $array['title'];
			   $array['type'] = "default_input";
			   $array['target'] = NULL;
			   $array['id'] = FormItem::where('input_name',$array['input_name'])
				   ->where('label',$array['label'])
				   ->where('type',$array['type'])
				   ->where('form_id',$formid)
				   ->orderby('id','DESC')
				   ->value('id');
			   array_push($olddata[0],$array);
			   $olddata = json_encode($olddata);
			   $form->update(['content'=>$olddata]);
		   
	   }
   }


  public function updateForm(Request $request){
    $newdata = $request->all(); 
	// dd($newdata);
    $form=Forms::findOrFail($request->formid);            
    $content = $request->data; 
    $newdata = [];  
        
    $newdata['content'] = json_encode($content);
	$newdata['title'] = $request->title;
	$newdata['form_heading'] = $request->form_heading;
	$newdata['description'] = $request->description;
	$newdata['redirect_url'] = $request->redirect_url;
	$newdata['branch'] = $request->branch;
	$newdata['assign_to'] = $request->assign_to;
    $rtr = $form->update($newdata); 
	if($rtr){
		Session::flash('flash_success', 'Form saved successfully!');
		return response()->json(['status'=> true]);
	}else{
		Session::flash('flash_danger', 'Error in saving form!');
		return response()->json(['status'=> true]);
	}
  }

  public function updateFormItem(Request $request){
    $data = $request->all();        
    $item = FormItem::findOrFail($request->id);
	if($request->has('mandatory')){
		$data['mandatory'] = $request->mandatory;
	}else{
		$data['mandatory'] = 0;
	}
	if($request->has('unique')){
		$data['unique'] = $request->unique;
	}else{
		$data['unique'] = 0;
	}
    $item->update($data);
    return redirect()->back()->withFlashSuccess('Field updated successfully');
  }

  public function deleteFormItem($id,$key,$attr_name=''){   
	if($attr_name != ''){
		DB::table('custom_attributes')->where("attr_name",$attr_name)->update(["web_to_lead"=>'0']);
	}     
    $formitem = FormItem::findOrFail($id);
	if($formitem){
		$form = Forms::where('id',$formitem->form_id)->first();
		if($form->content != ''){
		$data = json_decode($form->content,true);            
		$maindata = $data[0];            
		//if($in == ''){
			unset($data[0][$key]);
			$newdata = json_encode($data); 
			$form->update(['content'=>$newdata]);                         
		//}
		// else{
		// 	unset($data[0][$key]['children'][0][$in]);
		// 	$newdata = json_encode($data);
		// 	$menu->update(['content'=>$newdata]); 
		// }
		}
		$formitem->delete();
	}
    return redirect()->back();
  }	

  public function destroy(Request $request){
    FormItem::where('form_id',$request->id)->delete();  
    Forms::findOrFail($request->id)->delete();
    return redirect()->route('admin.form-builder')->withFlashSuccess('Form deleted successfully');
  }	
  
  public function view_form_qr($form_id){
	$form_data = Forms::Where('id',$form_id)->first();
	if($form_data){
		$form_url = route('form-builder.view-form', $form_id);
		return QrCode::size(300)
		->generate($form_url);
	}else{
		return "<h3 class='p-3'>Invalid QR Code!</h3>";
	}

  }

  public function view_form_html($form_id){
	$form_data = Forms::Where('id',$form_id)->first();
	$formItems = "";
	if($form_data->content){
		$formItems = json_decode($form_data->content);
		$formItems = $formItems[0]; 
		foreach($formItems as $form){
		$form->title = FormItem::where('id',$form->id)->value('title');
		$form->label = FormItem::where('id',$form->id)->value('label');
		$form->placeholder = FormItem::where('id',$form->id)->value('placeholder');
		$form->unique = FormItem::where('id',$form->id)->value('unique');
		$form->hint = FormItem::where('id',$form->id)->value('hint');
		$form->mandatory = FormItem::where('id',$form->id)->value('mandatory');
		$form->input_name = FormItem::where('id',$form->id)->value('input_name');
		$form->type = FormItem::where('id',$form->id)->value('type');
		}
	}
	$country_list = Country::pluck('title_en', 'id');
	$study_countries = Country::where('overseas_status', 1)->orderBy('title_en', 'ASC')->get();
	$dialcodes = Country::groupBy('tel')->orderBy('tel','asc')->get(['tel as dialcode','code', 'title_en as name']);
	// return view("frontend.form_view", compact("form_data","formItems", "cms_page", "main_menu_arr", "list_det","dialcodes","country_list","study_countries"));


	if(!empty($formItems)){
		$mobile_unique = $email_unique = 0;
		$default_country = env('USER_DEFAULT_COUNTRY');
		$html_code = '';
		$html_code .= "<form id='form_builder_form' action='" . route('form-builder-lead-tracking') . "' method='POST' onsubmit='checkEmailMobile();'>";
		$html_code .= "\n<input type='hidden' name='staff' value='$form_data->assign_to'>";
        $html_code .= "\n<input type='hidden' name='staff_branch' value='$form_data->branch'>";
        $html_code .= "\n<input type='hidden' name='form_id' value='$form_data->id'>";
		$html_code .= "\n<input type='hidden' name='form_type' value='html'>";
		if(!in_array('country_of_citizenship', array_column($formItems, 'input_name')) && in_array('city', array_column($formItems, 'input_name'))){
			$html_code .= "\n<input type='hidden' id='country_of_citizenship' onchange='get_cities(this.value);' name='country_of_citizenship' value='".$default_country."'>";
		}
        $html_code .= "\n<table cellspacing='1' cellpadding='5'>";
		foreach($formItems as $item){
			if($item->input_name == 'name'){
				$html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label class='form-label'>";
					if($item->label){ 
						$lbl = $item->label; 
					} else {
						$lbl = $item->title;
					}
					if($item->mandatory){
						$mend_sign = '*';
						$mend ='required';
					} else {
						$mend_sign = '';
						$mend ='';
					}
				$html_code .= "$lbl $mend_sign</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n<input type='text' name='name' id='name' class='form-control' placeholder='$item->placeholder'";
				$html_code .= " $mend>";
				$html_code .= "\n<small>$item->hint</small>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
			}
			if($item->input_name == 'full_name'){
				$html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label class='form-label'>";
					if($item->mandatory){
						$mend_sign = '*';
						$mend ='required';
					} else {
						$mend_sign = '';
						$mend ='';
					}
				$html_code .= "Full Name$mend_sign</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n<input type='text' name='first_name' id='first_name' class='form-control' placeholder='First Name'";
				$html_code .= " $mend>";
				$html_code .= "\n<input type='text' name='last_name' id='last_name' class='form-control' placeholder='Last Name'";
				$html_code .= " $mend>";
				$html_code .= "\n<small>$item->hint</small>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
			}
			if($item->input_name == 'email'){
				$email_present = 1;
				if($item->unique){
					$email_unique = 1;
					$html_code .= "\n<input type='hidden' name='email_unique' value='1'>";
				}else{
					$email_unique = 0;
					$html_code .= "\n<input type='hidden' name='email_unique' value='0'>";
				}
				$html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label class='form-label'>";
					if($item->label){ 
						$lbl = $item->label; 
					} else {
						$lbl = $item->title;
					}
					if($item->mandatory){
						$mend_sign = '*';
						$mend ='required';
					} else {
						$mend_sign = '';
						$mend ='';
					}
				$html_code .= "$lbl $mend_sign</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n<input type='email' name='email' id='email' class='form-control' placeholder='$item->placeholder'";
				$html_code .= " $mend>";
				$html_code .= "\n<small>$item->hint</small>";
				$html_code .= "\n<p class='error' id='invalid_email'></p>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
			}

			if($item->input_name == 'mobile'){
				$mobile_present = 1;
				if($item->unique){
					$mobile_unique = 1;
					$html_code .= "\n<input type='hidden' name='mobile_unique' value='1'>";
				}else{
					$mobile_unique = 0;
					$html_code .= "\n<input type='hidden' name='mobile_unique' value='0'>";
				}
				$html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label class='form-label'>";
					if($item->label){ 
						$lbl = $item->label; 
					} else {
						$lbl = $item->title;
					}
					if($item->mandatory){
						$mend_sign = '*';
						$mend ='required';
					} else {
						$mend_sign = '';
						$mend ='';
					}
				$html_code .= "$lbl $mend_sign</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
				$html_code .= "\n" . '<select class="form-select form-control" name="dialcode" id="dialcode" '.$mend.'>';
							foreach($dialcodes as $dialcode){
								$html_code .= "<option value='$dialcode->dialcode'>$dialcode->code' +'$dialcode->dialcode</option>";
							}
 				$html_code .='</select>';

                $html_code .= "\n<input 
                                type='text' 
                                placeholder='$item->placeholder' 
                                class='form-control'
                                onkeypress='return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))' 
                                name='mobile'
                                id='mobile'
                                minlength='".config('app.USER_MOBILE_MIN_LENGTH')."' 
                                maxlength='".config('app.USER_MOBILE_MAX_LENGTH')."' 
                                $mend";
				
				$html_code .= " $mend>";
				$html_code .= "\n<small>$item->hint</small>";
				$html_code .= "\n<p class='error' id='invalid_mobile'></p>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
			}
			if($item->input_name == 'whatsapp'){
				$html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label class='form-label'>";
					if($item->label){ 
						$lbl = $item->label; 
					} else {
						$lbl = $item->title;
					}
					if($item->mandatory){
						$mend_sign = '*';
						$mend ='required';
					} else {
						$mend_sign = '';
						$mend ='';
					}
				$html_code .= "$lbl $mend_sign</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
				$html_code .= "\n" . '<select class="form-select form-control" name="whatsapp_dialcode" id="whatsapp_dialcode" '.$mend.'>';
							foreach($dialcodes as $dialcode){
								$html_code .= "<option value='$dialcode->dialcode'>$dialcode->code' +'$dialcode->dialcode</option>";
							}
 				$html_code .='</select>';

                $html_code .= "\n<input 
                                type='text' 
                                placeholder='$item->placeholder' 
                                class='form-control'
                                onkeypress='return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))' 
                                name='whatsapp_number'
                                id='whatsapp_number'
                                minlength='".config('app.USER_MOBILE_MIN_LENGTH')."' 
                                maxlength='".config('app.USER_MOBILE_MAX_LENGTH')."' 
                                $mend";
				
				$html_code .= " $mend>";
				$html_code .= "\n<small>$item->hint</small>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
			}
			if($item->input_name == 'date_of_birth'){
				$html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label class='form-label'>";
					if($item->label){ 
						$lbl = $item->label; 
					} else {
						$lbl = $item->title;
					}
					if($item->mandatory){
						$mend_sign = '*';
						$mend ='required';
					} else {
						$mend_sign = '';
						$mend ='';
					}
				$html_code .= "$lbl $mend_sign</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n<input type='date' name='date_of_birth' id='date_of_birth' class='form-control' placeholder='$item->placeholder'";
				$html_code .= " $mend>";
				$html_code .= "\n<small>$item->hint</small>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
			}

			if($item->input_name == 'gender'){
				$html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label class='form-label'>";
					if($item->label){ 
						$lbl = $item->label; 
					} else {
						$lbl = $item->title;
					}
					if($item->mandatory){
						$mend_sign = '*';
						$mend ='required';
					} else {
						$mend_sign = '';
						$mend ='';
					}
				$html_code .= "$lbl $mend_sign</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
				$html_code .= "\n<select name='gender' id='gender' class='form-control' $mend>";
                $html_code .= "\n<option value=''>Select</option>";
                $html_code .= "\n<option value='male'>Male</option>";
                $html_code .= "\n<option value='female'>Female</option>";
                $html_code .= "\n</select>";
				$html_code .= "\n<small>$item->hint</small>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
			}
			if($item->input_name == 'marital_status'){
				$html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label class='form-label'>";
					if($item->label){ 
						$lbl = $item->label; 
					} else {
						$lbl = $item->title;
					}
					if($item->mandatory){
						$mend_sign = '*';
						$mend ='required';
					} else {
						$mend_sign = '';
						$mend ='';
					}
				$html_code .= "$lbl $mend_sign</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
				$html_code .= "\n<select name='marital_status' id='marital_status' class='form-control' $mend>";
                $html_code .= "\n<option value=''>Select</option>";
                $html_code .= "\n<option value='Single'>Single</option>";
                $html_code .= "\n<option value='Married'>Married</option>";
                $html_code .= "\n</select>";
				$html_code .= "\n<small>$item->hint</small>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
			}
			if($item->input_name == 'country_of_citizenship'){
				$html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label class='form-label'>";
					if($item->label){ 
						$lbl = $item->label; 
					} else {
						$lbl = $item->title;
					}
					if($item->mandatory){
						$mend_sign = '*';
						$mend ='required';
					} else {
						$mend_sign = '';
						$mend ='';
					}
				$html_code .= "$lbl $mend_sign</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
				$html_code .= "\n<select name='country_of_citizenship' id='country_of_citizenship'  onchange='get_cities(this.value);' class='form-control form-select' $mend>";
                $html_code .= "\n<option value=''>Select Country</option>";
				foreach($country_list as $key => $value){
					$html_code .= "<option value='$key'>$value</option>";
				}
                $html_code .= "\n</select>";
				$html_code .= "\n<small>$item->hint</small>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
			}

			if($item->input_name == 'city'){
				$html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label class='form-label'>";
					if($item->label){ 
						$lbl = $item->label; 
					} else {
						$lbl = $item->title;
					}
					if($item->mandatory){
						$mend_sign = '*';
						$mend ='required';
					} else {
						$mend_sign = '';
						$mend ='';
					}
				$html_code .= "$lbl $mend_sign</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
				$html_code .= "\n<select name='city' id='city-dd' class='form-control form-select' $mend>";
                $html_code .= "\n<option value=''>Select City</option>";
                $html_code .= "\n</select>";
				$html_code .= "\n<small>$item->hint</small>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
			}

			if($item->input_name == 'passout_year'){
				$html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label class='form-label'>";
					if($item->label){ 
						$lbl = $item->label; 
					} else {
						$lbl = $item->title;
					}
					if($item->mandatory){
						$mend_sign = '*';
						$mend ='required';
					} else {
						$mend_sign = '';
						$mend ='';
					}
				$html_code .= "$lbl $mend_sign</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n<input type='text' onkeypress='return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))' minlength='4' maxlength='4' name='passout_year' id='passout_year' class='form-control' placeholder='$item->placeholder'";
				$html_code .= " $mend>";
				$html_code .= "\n<small>$item->hint</small>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
			}

			if($item->input_name == 'visa_refusal'){
				$html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label class='form-label'>";
					if($item->label){ 
						$lbl = $item->label; 
					} else {
						$lbl = $item->title;
					}
					if($item->mandatory){
						$mend_sign = '*';
						$mend ='required';
					} else {
						$mend_sign = '';
						$mend ='';
					}
				$html_code .= "$lbl $mend_sign</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n<div>
                            <input type='radio' class='radio-col-blue' onchange='visaRefusal(this.value);' name='visa_refusal' id='no_visa_refusal' value='0' $mend>
                            <label class='custom-control-label' for='no_visa_refusal'>No</label>
                            <input type='radio' class='radio-col-blue' onchange='visaRefusal(this.value);' name='visa_refusal' id='yes_visa_refusal' value='1' $mend>
                            <label class='custom-control-label' for='yes_visa_refusal'>Yes</label>
                            </div>
							<div class='col-md-3 mt-3' id='select_visa_refusal_country' style='display:none;' >
                            <label class='fw-bold text-dark'>Select Country</label>
                            <select class='form-control form-select select2' style='width: 100%' id='visa_refusal_country' name='visa_refusal_country[]' multiple>";
                                foreach ($country_list as $key => $value){
									$html_code .= "<option value='$key'>$value</option>";
								}
				$html_code .= "</select>
                    		</div>";
				$html_code .= "\n<small>$item->hint</small>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
			}

			if($item->input_name == 'currently_studying_course'){
				$html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label class='form-label'>";
					if($item->label){ 
						$lbl = $item->label; 
					} else {
						$lbl = $item->title;
					}
					if($item->mandatory){
						$mend_sign = '*';
						$mend ='required';
					} else {
						$mend_sign = '';
						$mend ='';
					}
				$html_code .= "$lbl $mend_sign</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n<input type='text' name='current_course' id='current_course' class='form-control' placeholder='$item->placeholder'";
				$html_code .= " $mend>";
				$html_code .= "\n<small>$item->hint</small>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
			}

			if($item->input_name == 'interested_study_level'){
				$html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label class='form-label'>";
					if($item->label){ 
						$lbl = $item->label; 
					} else {
						$lbl = $item->title;
					}
					if($item->mandatory){
						$mend_sign = '*';
						$mend ='required';
					} else {
						$mend_sign = '';
						$mend ='';
					}
				$html_code .= "$lbl $mend_sign</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
				$html_code .= "\n<select name='study_level' id='study_level' class='form-control' $mend>";
                $html_code .= "\n<option value=''>Select Study Level</option>";
					foreach(get_study_levels() as $key => $value){
						$html_code .= "<option value='$value'>$value</option>";
					}    
                $html_code .= "\n</select>";
				$html_code .= "\n<small>$item->hint</small>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
			}

			if($item->input_name == 'course_interested'){
				$html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label class='form-label'>";
					if($item->label){ 
						$lbl = $item->label; 
					} else {
						$lbl = $item->title;
					}
					if($item->mandatory){
						$mend_sign = '*';
						$mend ='required';
					} else {
						$mend_sign = '';
						$mend ='';
					}
				$html_code .= "$lbl $mend_sign</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n<input type='text' name='course_interested' id='course_interested' class='form-control' placeholder='$item->placeholder'";
				$html_code .= " $mend>";
				$html_code .= "\n<small>$item->hint</small>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
			}

			if($item->input_name == 'intake'){
				$html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label class='form-label'>";
					if($item->label){ 
						$lbl = $item->label; 
					} else {
						$lbl = $item->title;
					}
					if($item->mandatory){
						$mend_sign = '*';
						$mend ='required';
					} else {
						$mend_sign = '';
						$mend ='';
					}
				$html_code .= "$lbl $mend_sign</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
				$html_code .= "\n<select name='intake' id='intake' class='form-control' $mend>";
                $html_code .= "\n<option value=''>Intake</option>";
					$month = date('n'); // current month
					for ($x = 0; $x < 24; $x++) {
					$html_code .= "<option value='".date('m Y', mktime(0,0,0,$month + $x,1))."'>".date('F Y', mktime(0,0,0,$month + $x,1));}
					"</option>";
                $html_code .= "\n</select>";
				$html_code .= "\n<small>$item->hint</small>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
			}

			if($item->input_name == 'country_interested'){
				$html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label class='form-label'>";
					if($item->label){ 
						$lbl = $item->label; 
					} else {
						$lbl = $item->title;
					}
					if($item->mandatory){
						$mend_sign = '*';
						$mend ='required';
					} else {
						$mend_sign = '';
						$mend ='';
					}
				$html_code .= "$lbl $mend_sign</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
				$html_code .= "\n<select name='country_interested' id='country_interested' class='form-control' $mend>";
                $html_code .= "\n<option value=''>Select Country</option>";
					foreach($study_countries as $study_country){
						$html_code .= "<option value='$study_country->title_en'>$study_country->title_en</option>";
					}    
                $html_code .= "\n</select>";
				$html_code .= "\n<small>$item->hint</small>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
			}

			if($item->input_name == 'qualification'){
				$html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label class='form-label'>";
					if($item->label){ 
						$lbl = $item->label; 
					} else {
						$lbl = $item->title;
					}
					if($item->mandatory){
						$mend_sign = '*';
						$mend ='required';
					} else {
						$mend_sign = '';
						$mend ='';
					}
				$html_code .= "$lbl $mend_sign</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
				$html_code .= "\n<select name='qualification' id='qualification' class='form-control' $mend>";
                $html_code .= "\n" . "<option value=''>Select Qualification</option>
                <option value='9th'>9th</option>
                <option value='10th'>10th</option>
                <option value='11th'>11th</option>
                <option value='12th'>12th</option>
                <option value='Bachelors'>Bachelors</option>
                <option value='Masters'>Masters</option>
                <option value='Ph.D'>Ph.D</option>";
                $html_code .= "\n</select>";
				$html_code .= "\n<small>$item->hint</small>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
			}

			if($item->input_name == 'score'){
				$html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label class='form-label'>";
					if($item->label){ 
						$lbl = $item->label; 
					} else {
						$lbl = $item->title;
					}
					if($item->mandatory){
						$mend_sign = '*';
						$mend ='required';
					} else {
						$mend_sign = '';
						$mend ='';
					}
				$html_code .= "$lbl $mend_sign</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n<input type='text' name='score' id='score' class='form-control' placeholder='$item->placeholder'";
				$html_code .= " $mend>";
				$html_code .= "\n<small>$item->hint</small>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
			}
			if($item->input_name == 'academic'){
				$html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label class='form-label'>";
					if($item->label){ 
						$lbl = $item->label; 
					} else {
						$lbl = $item->title;
					}
					if($item->mandatory){
						$mend_sign = '*';
						$mend ='required';
					} else {
						$mend_sign = '';
						$mend ='';
					}
					$academic_years = array();
					$s_yr = date("Y") + 3;
					$e_yr = $s_yr - 60;
					for ($i = $s_yr; $i >= $e_yr; $i--) {
						$academic_years[] = $i;
					}
				$html_code .= "$lbl $mend_sign</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n <table class='table'>
                                    <thead>
                                        <tr>
                                            <th>Education Level</th>
                                            <th>Percentage or CGPA</th>
                                            <th>Year of Passing</th>
                                            <th>Specialisation</th>
                                            <th>School\University</th>
                                            <th>University\Board</th>
                                        </tr>
								</thead>
								<tbody>";
                                    $aca_level = array('10', '12', 'Diploma', 'Bachelors', 'Masters', 'Other');
                                    for ($i = 0; $i < count($aca_level); $i++){
							$html_code .= "<tr>
                                            <td>";
                                                $html_code .= $aca_level[$i];
                                                if ($aca_level[$i] == '10' || $aca_level[$i] == '12') {
                                                    $html_code .= "<sup>th</sup>";
                                                }
                            $html_code .= "</td>
                                            <td>
                                                <input type='text' name='aca[$aca_level[$i]][percent_cgpa]' class='form-control' value='' />
                                            </td>
                                            <td>
                                                <select name='aca[$aca_level[$i]][pass_year]' class='form-control' style='min-width:80px'>
                                                    <option value=''>Select</option>";
                                                    foreach ($academic_years as $year) {
                                                        $html_code .= "<option value='$year'>$year</option>";
                                                    }
                                                   
                            $html_code .= "</select>
                                            </td>
                                            <td>
                                                <input type='text' name='aca[$aca_level[$i]][specialization]' class='form-control' value='' />
                                            </td>
                                            <td>
                                                <input type='text' name='aca[$aca_level[$i]][school_college]' class='form-control' value='' />
                                            </td>
                                            <td>
                                                <input type='text' name='aca[$aca_level[$i]][university]' class='form-control' value='' />
                                            </td>
                                            </tr>";
				 					}
				$html_code .= "</tbody>
							</table>";
				
				$html_code .= "\n<small>$item->hint</small>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
				}


				if($item->input_name == 'english_test'){
					$html_code .= "\n<tr>";
					$html_code .= "\n<td>";
					$html_code .= "\n<label class='form-label'>";
						if($item->label){ 
							$lbl = $item->label; 
						} else {
							$lbl = $item->title;
						}
						if($item->mandatory){
							$mend_sign = '*';
							$mend ='required';
						} else {
							$mend_sign = '';
							$mend ='';
						}
						
					$html_code .= "$lbl $mend_sign</label>";
					$html_code .= "\n</td>";
					$html_code .= "\n<td>";
					$html_code .= "\n <table class='table'>
										<thead>
											<tr>
												<th>Exam</th>
												<th>Overall Score</th>
												<th>Speaking</th>
												<th>Reading</th>
												<th>Listening</th>
												<th>Writing</th>
												<th>Score expiry Date</th>
											</tr>
									</thead>
									<tbody>";
									$languages = array('IELTS', 'TOEFL', 'PTE');
										for ($i = 0; $i < count($languages); $i++){
								$html_code .= "<tr>
												<td>";
													$html_code .= $languages[$i];
								$html_code .= "</td>
												<td>
													<input type='text' name='eng[$languages[$i]][overall_score]' class='form-control' value='' />
												</td>
												<td>
													<input type='text' name='eng[$languages[$i]][speaking]' class='form-control' value='' />
												</td>
												<td>
													<input type='text' name='eng[$languages[$i]][reading]' class='form-control' value='' />
												</td>
												<td>
													<input type='text' name='eng[$languages[$i]][listening]' class='form-control' value='' />
												</td>
												<td>
													<input type='text' name='eng[$languages[$i]][writing]' class='form-control' value='' />
												</td>
												<td>
													<input type='date' name='eng[$languages[$i]][expiry_date]' class='form-control mydatepicker' placeholder='dd-mm-yyyy' value='' style='min-width:100px;' />
												</td>
												</tr>";
										 }
					$html_code .= "</tbody>
								</table>";
					$html_code .= "<div>
                                <table class='table'>
                                    <thead>
                                        <tr>
                                            <th>Exam</th>
                                            <th>Overall Score</th>
                                            <th>Score expiry Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                       <tr>
                                            <td>DET</td>
                                            <td>
                                                <input type='text' name='det_overall_score' class='form-control' value='' />
                                            </td>
                                            <td>
                                                <input type='text' name='det_expiry_date' class='form-control mydatepicker' placeholder='dd-mm-yyyy' style='min-width:100px;' />
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
        					</div>";
					$html_code .= "<div>
							<table class='table'>
								<thead>
									<tr>
										<th>Exam</th>
										<th>Overall Score</th>
										<th>Math</th>
										<th>Reading</th>
										<th>Writing</th>
										<th>Science</th>
										<th>English</th>
										<th>Score expiry Date</th>
									</tr>
								</thead>
								<tbody>
								   <tr>
										<td>ACT</td>
										<td>
											<input type='text' name='act_overall_score' class='form-control' value='' />
										</td>
										<td>
											<input type='text' name='act_math' class='form-control' value='' />
										</td>
										<td>
											<input type='text' name='act_reading' class='form-control' value='' />
										</td>
										<td>
											<input type='text' name='act_writing' class='form-control' value='' />
										</td>
										<td>
											<input type='text' name='act_science' class='form-control' value='' />
										</td>
										<td>
											<input type='text' name='act_english' class='form-control' value='' />
										</td>
										<td>
											<input type='date' name='act_expiry_date' class='form-control mydatepicker' placeholder='dd-mm-yyyy' style='min-width:100px;' />
										</td>
									</tr>
								</tbody>
							</table>
						</div>";
		$html_code .= "<div>
						<table class='table'>
							<thead>
								<tr>
									<th>Exam</th>
									<th>Overall Score</th>
									<th>Math</th>
									<th>Reading</th>
									<th>Writing</th>
									<th>Essay</th>
									<th>Score expiry Date</th>
								</tr>
							</thead>
							<tbody>
							   <tr>
									<td>SAT</td>
									<td>
										<input type='text' name='sat_overall_score' class='form-control' value='' />
									</td>
									<td>
										<input type='text' name='sat_math' class='form-control' value='' />
									</td>
									<td>
										<input type='text' name='sat_reading' class='form-control' value='' />
									</td>
									<td>
										<input type='text' name='sat_writing' class='form-control' value='' />
									</td>
									<td>
										<input type='text' name='sat_essay' class='form-control' value='' />
									</td>
									<td>
										<input type='date' name='sat_expiry_date' class='form-control mydatepicker' placeholder='dd-mm-yyyy' style='min-width:100px;' />
									</td>
								</tr>
							</tbody>
						</table>
</div>
<label style='margin-bottom: 0.5rem;' class='fw-bold text-dark'>GRE/GMAT</label>
				<div>
					<table class='table'>
						<thead>
							<tr>
								<th>Exam</th>
								<th>Total Score</th>
								<th>Verbal Reasoning</th>
								<th>Quantitative</th>
								<th>Analytical</th>
								<th>Integrated</th>
								<th>Expiry Date</th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td>GRE</td>
								<td>
									<input type='text' name='exam[gre][total_score]' class='form-control' value='' onkeyup='validnum(this.value,'total_gre');' onkeypress='return onlyNumberKey(event)' autocomplete='off'/>
									<span id='total_gre_err' class='text-danger d-none' style='font-size: 10px;'>GRE Total score range is: 260 to 340</span>
								</td>
								<td>
									<input type='text' name='exam[gre][verbal]' class='form-control' value='' onkeyup='validnum(this.value,'verbal_gre');' onkeypress='return onlyNumberKey(event)' autocomplete='off'/>
									<span id='verbal_gre_err' class='text-danger d-none' style='font-size: 10px;'>GRE Verbal Reasoning range is: 130 to 170</span>
								</td>
								<td>
									<input type='text' name='exam[gre][quantitative]' class='form-control' value='' onkeyup='validnum(this.value,'quant_gre');' onkeypress='return onlyNumberKey(event)' autocomplete='off'/>
									<span id='quant_gre_err' class='text-danger d-none' style='font-size: 10px;'>GRE Quantitative range is: 130 to 170</span>
								</td>
								<td>
									<input type='text' name='exam[gre][analytical]' class='form-control' value='' onkeyup='validnum(this.value,'ana_gre');' onkeypress='return onlyNumberKey(event)' autocomplete='off'/>
									<span id='ana_gre_err' class='text-danger d-none' style='font-size: 10px;'>GRE Analytical score range is: 0 to 6</span>
								</td>
								<td>
									<input type='text' name='exam[gre][integrated]' class='form-control' value='' onkeyup='validnum(this.value,'inte_gre');' onkeypress='return onlyNumberKey(event)' autocomplete='off'/>
									<span id='inte_gre_err' class='text-danger d-none' style='font-size: 10px;'>GRE Integrated score range is: 260 to 340</span>
								</td>
								<td>
									<input type='text' name='exam[gre][expiry_date]' class='form-control mydatepicker' placeholder='dd-mm-yyyy' style='min-width:120px;' autocomplete='off'/>
								</td>

							</tr>
							<tr>
								<td>GMAT</td>
								<td>
									<input type='text' name='exam[gmat][total_score]' class='form-control' value='' onkeyup='validnum(this.value,'total_gmat');' onkeypress='return onlyNumberKey(event)' autocomplete='off'/>
									<span id='total_gmat_err' class='text-danger d-none' style='font-size: 10px;'>GMAT Total score range is: 200 to 800</span>
								</td>
								<td>
									<input type='text' name='exam[gmat][verbal]' class='form-control' value='' onkeyup='validnum(this.value,'verbal_gmat');' onkeypress='return onlyNumberKey(event)' autocomplete='off'/>
									<span id='verbal_gmat_err' class='text-danger d-none' style='font-size: 10px;'>GMAT Verbal Reasoning range is: 0 to 60</span>
								</td>
								<td>
									<input type='text' name='exam[gmat][quantitative]' class='form-control' value='' onkeyup='validnum(this.value,'quant_gmat');' onkeypress='return onlyNumberKey(event)' autocomplete='off'/>
									<span id='quant_gmat_err' class='text-danger d-none' style='font-size: 10px;'>GMAT Quantitative range is: 0 to 60</span>
								</td>
								<td>
									<input type='text' name='exam[gmat][analytical]' class='form-control' value='' onkeyup='validnum(this.value,'ana_gmat');' onkeypress='return onlyNumberKey(event)' autocomplete='off'/>
									<span id='ana_gmat_err' class='text-danger d-none' style='font-size: 10px;'>GMAT Analytical score range is: 0 to 6</span>
								</td>
								<td>
									<input type='text' name='exam[gmat][integrated]' class='form-control' value='' onkeyup='validnum(this.value,'inte_gmat');' onkeypress='return onlyNumberKey(event)' autocomplete='off'/>
									<span id='inte_gmat_err' class='text-danger d-none' style='font-size: 10px;'>GMAT Integrated score range is: 1 to 8</span>
								</td>
								<td>
									<input type='text' name='exam[gmat][expiry_date]' class='form-control mydatepicker' placeholder='dd-mm-yyyy' style='min-width:120px;' autocomplete='off'/>
								</td>
							</tr>

						</tbody>
					</table>
				</div>";
				$html_code .= "\n</td>";
				$html_code .= "\n</tr>";
			}	
			if($item->input_name == 'experience'){
				$html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label class='form-label'>";
					if($item->label){ 
						$lbl = $item->label; 
					} else {
						$lbl = $item->title;
					}
					if($item->mandatory){
						$mend_sign = '*';
						$mend ='required';
					} else {
						$mend_sign = '';
						$mend ='';
					}
				$html_code .= "$lbl $mend_sign</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n<input type='text' name='experience' id='experience' class='form-control' placeholder='$item->placeholder'";
				$html_code .= " $mend>";
				$html_code .= "\n<small>$item->hint</small>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
			}

			if($item->type == 'custom_attr'){
				$custom_attribute = get_attr_data($item->input_name);
				if($custom_attribute){
					if($item->placeholder){
						$placeholder = $item->placeholder;
					}else{
						$placeholder = $custom_attribute->placeholder;
					}
					if($custom_attribute->type == 'input'){
						
						$html_code .= "\n<tr>";
						$html_code .= "\n<td>";
						$html_code .= "\n<label class='form-label'>";
							if($item->label){ 
								$lbl = $item->label; 
							} else {
								$lbl = $item->title;
							}
							if($item->mandatory){
								$mend_sign = '*';
								$mend ='required';
							} else {
								$mend_sign = '';
								$mend ='';
							}
							if($custom_attribute->input_datatype == 'number' || $custom_attribute->input_datatype == 'decimal'){
								$data_type = 'number';
							}
							elseif($custom_attribute->input_datatype == 'date' || $custom_attribute->input_datatype == 'year' || $custom_attribute->input_datatype == 'phone'){
								$data_type = 'text';
							}
							else{
								$data_type = $custom_attribute->input_datatype;
							}
							if($custom_attribute->input_datatype == 'decimal'){
								 $steps = 'step=any';
							}else{
								$steps = '';
							}
							if($custom_attribute->input_datatype == 'number' || $custom_attribute->input_datatype == 'decimal'){
								$min = "min='$custom_attribute->input_min'";
								$max = "max='$custom_attribute->input_max'";
							}  
                            elseif($custom_attribute->input_datatype == 'date'){
								$min = '';
								$max = '';
							}
                            elseif($custom_attribute->input_datatype == 'year'){
									$validation = "onkeypress='return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))";
									$min = "minlength='4'";
									$max = "maxlength='4'";
							}   
                            elseif($custom_attribute->input_datatype == 'phone'){
                                $validation = "onkeypress='return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 58) || event.charCode==32 || event.charCode==44 || event.charCode==43 || event.charCode==45 || event.charCode==40 || event.charCode==41)'";
								$min = "minlength='10'";
								$max = "maxlength='18'";
							}
                            else{
                                $min = "minLength='$custom_attribute->input_min'";
								$max = "maxLength='$custom_attribute->input_max'";
								$validation ='';
							}

						$html_code .= "$lbl $mend_sign</label>";
						$html_code .= "\n</td>";
						$html_code .= "\n<td>";
						$html_code .= "\n<input type='$data_type' $steps $min $max $validation placeholder='$placeholder' autocomplete='off' class='form-control' name='$custom_attribute->attr_name' value=''";
						$html_code .= " $mend>";
						$html_code .= "\n<small>$item->hint</small>";
						$html_code .= "\n</td>";
						$html_code .= "\n</tr>";
					}
					if($custom_attribute->type == 'textarea'){
						$html_code .= "\n<tr>";
						$html_code .= "\n<td>";
						$html_code .= "\n<label class='form-label'>";
							if($item->label){ 
								$lbl = $item->label; 
							} else {
								$lbl = $item->title;
							}
							if($item->mandatory){
								$mend_sign = '*';
								$mend ='required';
							} else {
								$mend_sign = '';
								$mend ='';
							}
                            $min = "minLength='$custom_attribute->input_min'";
							$max = "maxLength='$custom_attribute->input_max'";
							

						$html_code .= "$lbl $mend_sign</label>";
						$html_code .= "\n</td>";
						$html_code .= "\n<td>";
						$html_code .= "\n<textarea $min $max placeholder='$placeholder' autocomplete='off' class='form-control' name='$custom_attribute->attr_name' value=''";
						$html_code .= " $mend></textarea>";
						$html_code .= "\n<small>$item->hint</small>";
						$html_code .= "\n</td>";
						$html_code .= "\n</tr>";
					}

					if($custom_attribute->type == 'select'){
						$is_multi = $select2 = "";
                        $select_vals = explode('|',$custom_attribute->selection_values);
                        if($custom_attribute->select_multiple){
                            $is_multi = "multiple";
                            $select2 = "select2";
                        }
						$html_code .= "\n<tr>";
						$html_code .= "\n<td>";
						$html_code .= "\n<label class='form-label'>";
							if($item->label){ 
								$lbl = $item->label; 
							} else {
								$lbl = $item->title;
							}
							if($item->mandatory){
								$mend_sign = '*';
								$mend ='required';
							} else {
								$mend_sign = '';
								$mend ='';
							}
                            $min = "minLength='$custom_attribute->input_min'";
							$max = "maxLength='$custom_attribute->input_max'";
							

						$html_code .= "$lbl $mend_sign</label>";
						$html_code .= "\n</td>";
						$html_code .= "\n<td>";
						$html_code .= "\n<select placeholder='$placeholder' class='form-select $select2' name='$custom_attribute->attr_name[]' $is_multi $mend>";
                                        if(!$is_multi){
                                        $html_code .= "<option value=''>$placeholder</option>";
										}
                                        foreach($select_vals as $sel_val){
                                        $html_code .= "<option value='$sel_val'>$sel_val</option>";
										}
						$html_code .= "</select>";
						$html_code .= "\n<small>$item->hint</small>";
						$html_code .= "\n</td>";
						$html_code .= "\n</tr>";
					}

					if($custom_attribute->type == 'checkbox'){
						$select_vals = explode('|',$custom_attribute->selection_values);

						$html_code .= "\n<tr>";
						$html_code .= "\n<td>";
						$html_code .= "\n<label class='form-label'>";
							if($item->label){ 
								$lbl = $item->label; 
							} else {
								$lbl = $item->title;
							}
							if($item->mandatory){
								$mend_sign = '*';
								$mend ='required';
							} else {
								$mend_sign = '';
								$mend ='';
							}
                            $min = "minLength='$custom_attribute->input_min'";
							$max = "maxLength='$custom_attribute->input_max'";
							if($item->mandatory){
								$chk_mend =  "onclick='chk_mend($custom_attribute->attr_name)";
							}else{
								$chk_mend =  '';
							}
							

						$html_code .= "$lbl $mend_sign</label>";
						$html_code .= "\n</td>";
						$html_code .= "\n<td>";
						foreach($select_vals as $sel_val){
							$html_code .= " <label><input style='position: inherit!important;left: 0px!important;opacity: 1!important;width: 15px;height: 15px;' class='dyna_chkbx $custom_attribute->attr_name' $chk_mend type='checkbox' name='$custom_attribute->attr_name[]' value='$sel_val' $mend> $sel_val </label> ";
						}
						$html_code .= "\n<small>$item->hint</small>";
						$html_code .= "\n</td>";
						$html_code .= "\n</tr>";
					}

					if($custom_attribute->type == 'radio'){
						$select_vals = explode('|',$custom_attribute->selection_values);

						$html_code .= "\n<tr>";
						$html_code .= "\n<td>";
						$html_code .= "\n<label class='form-label'>";
							if($item->label){ 
								$lbl = $item->label; 
							} else {
								$lbl = $item->title;
							}
							if($item->mandatory){
								$mend_sign = '*';
								$mend ='required';
							} else {
								$mend_sign = '';
								$mend ='';
							}
                            $min = "minLength='$custom_attribute->input_min'";
							$max = "maxLength='$custom_attribute->input_max'";
							if($item->mandatory){
								$chk_mend =  "onclick='chk_mend($custom_attribute->attr_name)";
							}else{
								$chk_mend =  '';
							}
							

						$html_code .= "$lbl $mend_sign</label>";
						$html_code .= "\n</td>";
						$html_code .= "\n<td>";
						foreach($select_vals as $sel_val){
							$html_code .= " <input style='position: inherit!important;left: 0px!important;opacity: 1!important;width: 15px;height: 15px;' class='radio-col-blue $custom_attribute->attr_name' $chk_mend type='radio' id='$sel_val' name='$custom_attribute->attr_name[]' value='$sel_val' $mend>
							 <label class='custom-control-label' for='$sel_val'> $sel_val</label> ";
						}
						$html_code .= "\n<small>$item->hint</small>";
						$html_code .= "\n</td>";
						$html_code .= "\n</tr>";
					}

					$html_code .= "<script>
                        function chk_mend(elClass) {
                            el = document.getElementsByClassName(elClass);
                            var atLeastOneChecked = false;
                            for (i = 0; i < el.length; i++) {
                              if (el[i].checked === true) {
                                atLeastOneChecked = true;
                              }
                            }
                          
                            if (atLeastOneChecked === true) {
                              for (i = 0; i < el.length; i++) {
                                el[i].required = false;
                              }
                            } else {
                              for (i = 0; i < el.length; i++) {
                                el[i].required = true;
                              }
                            }
                          }
                        </script>";

				}
			}

			if($item->input_name == 'enquiry'){
				$html_code .= "\n<tr>";
                $html_code .= "\n<td>";
                $html_code .= "\n<label class='form-label'>";
					if($item->label){ 
						$lbl = $item->label; 
					} else {
						$lbl = $item->title;
					}
					if($item->mandatory){
						$mend_sign = '*';
						$mend ='required';
					} else {
						$mend_sign = '';
						$mend ='';
					}
				$html_code .= "$lbl $mend_sign</label>";
                $html_code .= "\n</td>";
                $html_code .= "\n<td>";
                $html_code .= "\n<textarea name='notes' id='notes' class='form-control' placeholder='$item->placeholder'";
				$html_code .= " $mend></textarea>";
				$html_code .= "\n<small>$item->hint</small>";
                $html_code .= "\n</td>";
                $html_code .= "\n</tr>";
			}
		}
		$fetch_city_url = url('api/fetch-cities-by-country');
		$html_code .= "<script>
		function get_cities(country_id) {
                fetch('$fetch_city_url', {
				method: 'post',
				body: JSON.stringify({ country_id: country_id }),
				headers: {
					'Accept': 'application/json',
					'Content-Type': 'application/json'
				}
			}).then((response) => {
				return response.json()
			}).then((res) => {
				console.log(res);
				var city_select = document.getElementById('city-dd');
				for(var i = 0; i < res.cities.length; i++) {
					var opt = res.cities[i];
					var el = document.createElement('option');
					el.textContent = opt.name;
					el.value = opt.name;
					city_select.appendChild(el);
				}
			}).catch((error) => {
				console.log(error)
			})
		
		}
			window.onload = function() {
				var ctry_id = document.getElementById('country_of_citizenship').value;
				get_cities(ctry_id);
				console.log('Changed!');
			};

			function visaRefusal(condition) {
				var x = document.getElementById('select_visa_refusal_country');
				if (condition == 1) {
					x.style.display = 'block';
					document.getElementById('visa_refusal_country').setAttribute('required', '');
				} else {
					x.style.display = 'none';
					document.getElementById('visa_refusal_country').removeAttribute('required');
				}
			}
			
			function onlyNumberKey(evt) {
				var ASCIICode = (evt.which) ? evt.which : evt.keyCode
				if (ASCIICode > 31 && (ASCIICode < 48 || ASCIICode > 57))
					return false;
				return true;
			}

		</script>";

	if((isset($email_present) && !empty($email_present) && $email_unique) || (isset($mobile_present) && !empty($mobile_present) && $mobile_unique)){
		$fetch_valid_url = route('validate-email-mobile');
		$html_code .= "<script>
					function checkEmailMobile(){
						event.preventDefault();
						document.getElementById('invalid_email').value = '';
						document.getElementById('invalid_mobile').value = '';";
						
						if($mobile_unique){
							$html_code .= "const mobile = $('#mobile').val();";
						}else{
							$html_code .= "const mobile = '';";
						}
						if($email_unique){
							$html_code .= "const email = $('#email').val();";
						}else{
							$html_code .= "const email = '';";
						}
						$html_code .= "fetch('$fetch_valid_url', {
							method: 'post',
							body: JSON.stringify({ mobile: mobile,email:email }),
							headers: {
								'Accept': 'application/json',
								'Content-Type': 'application/json'
							}
						}).then((response) => {
							return response.json()
						}).then((result) => {
							console.log(result);
							if (result.email_err && result.mobile_err) {
								document.getElementById('invalid_email').innerHTML = result.email_err;
								document.getElementById('invalid_mobile').innerHTML = result.mobile_err;
								document.getElementById('invalid_email').style.color = 'red';
								document.getElementById('invalid_mobile').style.color = 'red';
								document.getElementById('mobile').focus();
								document.getElementById('email').focus();
								return false;
							}
							else if(result.email_err) {
								document.getElementById('invalid_email').innerHTML = result.email_err;
								document.getElementById('invalid_email').style.color = 'red';
								document.getElementById('email').focus();
								return false;
							}
							else if (result.mobile_err) {
								document.getElementById('invalid_mobile').innerHTML = result.mobile_err;
								document.getElementById('invalid_mobile').style.color = 'red';
								document.getElementById('mobile').focus();
								return false;
							}else{
								document.getElementById('invalid_email').innerHTML = '';
								document.getElementById('invalid_mobile').innerHTML = '';
								document.getElementById('form_builder_form').submit(); 
								return true;
							}
						}).catch((error) => {
							console.log(error)
						})
				}</script>";
    		}
			if(get_site_config('recaptcha_site_key')!="" && get_site_config('recaptcha_secret_key')!="" && get_site_config('web_to_lead_captcha')==1){
                $captchakey = get_site_config('recaptcha_site_key');
                $html_code .= "\n<tr >";
                $html_code .= "\n<td colspan='2'>";
                $html_code .= "\n<div class='g-recaptcha' data-sitekey='$captchakey'></div>";
                        if(isset($errors)){
                            if ($errors->has('g-recaptcha-response')){
                                $html_code .= "<span class='text-danger'>$errors->first(\"g-recaptcha-response\")</span>";
                            }
                        }
                $html_code .= "\n</td>";
                $html_code .= "\n</tr >";
            
            $html_code .= "\n<style>
                            #g-recaptcha-response {
                            display: block !important;
                            position: absolute;
                            margin: -78px 0 0 0 !important;
                            width: 302px !important;
                            height: 76px !important;
                            z-index: -999999;
                            opacity: 0;
                            }
                            </style>";
            $html_code .= "<script src='https://www.google.com/recaptcha/api.js' async defer></script>";
            $html_code .= "<script>
                window.addEventListener('load', () => {
                    const recaptcha = document.querySelector('#g-recaptcha-response');
                    if (recaptcha) {
                        recaptcha.setAttribute('required', 'required');
                    }
                })
            </script>";
            }
		$html_code .= "\n<tr>";
		$html_code .= "\n<td colspan='2'>";
		$html_code .= "\n<input type='submit' name='btnSubmit' class='btn btn-primary' value='Submit'>";
		$html_code .= "\n</td>";
		$html_code .= "\n</tr >";
		$html_code .= "\n</table>";
		$html_code .= "\n</form>";
	}
	
	return $html_code;
  }
}	